/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.GradleSettingsModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.utils.FileUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

public class BuildFileProcessor {
    @NotNull
    public static BuildFileProcessor getInstance() {
        return (BuildFileProcessor)ServiceManager.getService(BuildFileProcessor.class);
    }

    public void processRecursively(@NotNull Project project, @NotNull Processor<? super GradleBuildModel> processor) {
        ApplicationManager.getApplication().runReadAction(() -> {
            VirtualFile projectRootFolder = ProjectUtil.guessProjectDir((Project)project);
            if (projectRootFolder == null) {
                return;
            }
            ProjectBuildModel projectBuildModel2 = ProjectBuildModel.getOrLog(project);
            if (projectBuildModel2 == null) {
                return;
            }
            GradleSettingsModel settings = GradleBuildModel.tryOrLog(() -> projectBuildModel2.getProjectSettingsModel());
            if (settings == null) {
                return;
            }
            for (String path2 : settings.modulePaths()) {
                boolean continueProcessing;
                GradleBuildModel buildModel = GradleBuildModel.tryOrLog(() -> settings.moduleModel(path2));
                if (buildModel == null || (continueProcessing = processor.process((Object)buildModel))) continue;
                return;
            }
        });
    }

    @NotNull
    public static List<File> getCompositeBuildFolderPaths(@NotNull Project project) {
        String projectBasePath = project.getBasePath();
        if (StringUtil.isEmpty((String)projectBasePath)) {
            return Collections.emptyList();
        }
        GradleProjectSettings projectSettings = (GradleProjectSettings)GradleSettings.getInstance((Project)project).getLinkedProjectSettings(projectBasePath);
        if (projectSettings == null) {
            return Collections.emptyList();
        }
        GradleProjectSettings.CompositeBuild compositeBuild = projectSettings.getCompositeBuild();
        if (compositeBuild == null) {
            return Collections.emptyList();
        }
        return compositeBuild.getCompositeParticipants().stream().map(p -> new File(FileUtils.toSystemDependentPath((String)p.getRootPath()))).collect(Collectors.toList());
    }
}

