/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.task;

import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.task.GradleTaskManager;
import org.jetbrains.plugins.gradle.service.task.GradleTaskManagerExtension;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;

public class AndroidGradleTaskManager
implements GradleTaskManagerExtension {
    public boolean executeTasks(@NotNull ExternalSystemTaskId id, @NotNull List<String> taskNames, @NotNull String projectPath, @Nullable GradleExecutionSettings settings, @NotNull List<String> vmOptions, @NotNull List<String> scriptParameters, @Nullable String debuggerSetup, @NotNull ExternalSystemTaskNotificationListener listener2) throws ExternalSystemException {
        GradleExecutionSettings effectiveSettings = settings == null ? new GradleExecutionSettings(null, null, DistributionType.BUNDLED, false) : settings;
        effectiveSettings.withVmOptions(vmOptions).withArguments(scriptParameters);
        return this.executeTasks(id, taskNames, projectPath, effectiveSettings, debuggerSetup, listener2);
    }

    public boolean executeTasks(@NotNull ExternalSystemTaskId id, @NotNull List<String> taskNames, @NotNull String projectPath, @Nullable GradleExecutionSettings settings, @Nullable String jvmParametersSetup, @NotNull ExternalSystemTaskNotificationListener listener2) throws ExternalSystemException {
        GradleBuildInvoker gradleBuildInvoker = AndroidGradleTaskManager.findGradleInvoker(id, projectPath);
        if (gradleBuildInvoker != null) {
            GradleBuildInvoker.Request request = new GradleBuildInvoker.Request(gradleBuildInvoker.getProject(), new File(projectPath), taskNames, id);
            GradleExecutionSettings effectiveSettings = settings == null ? new GradleExecutionSettings(null, null, DistributionType.BUNDLED, false) : settings;
            GradleTaskManager.setupGradleScriptDebugging((GradleExecutionSettings)effectiveSettings);
            GradleTaskManager.setupDebuggerDispatchPort((GradleExecutionSettings)effectiveSettings);
            GradleTaskManager.appendInitScriptArgument(taskNames, (String)jvmParametersSetup, (GradleExecutionSettings)effectiveSettings);
            request.setJvmArguments(effectiveSettings.getJvmArguments()).setCommandLineArguments(effectiveSettings.getArguments()).withEnvironmentVariables(effectiveSettings.getEnv()).passParentEnvs(effectiveSettings.isPassParentEnvs()).setTaskListener(listener2).waitForCompletion();
            gradleBuildInvoker.executeTasks(request);
            return true;
        }
        return false;
    }

    public boolean cancelTask(@NotNull ExternalSystemTaskId id, @NotNull ExternalSystemTaskNotificationListener listener2) {
        Project project = id.findProject();
        if (project != null) {
            return GradleBuildInvoker.getInstance(project).stopBuild(id);
        }
        return false;
    }

    @Nullable
    private static GradleBuildInvoker findGradleInvoker(ExternalSystemTaskId id, String projectPath) {
        Project project = id.findProject();
        if (project != null) {
            ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
            for (Module module2 : moduleManager.getModules()) {
                if (!projectPath.equals(ExternalSystemApiUtil.getExternalProjectPath((Module)module2)) || !GradleProjects.isIdeaAndroidModule(module2)) continue;
                return GradleBuildInvoker.getInstance(project);
            }
        }
        return null;
    }
}

