/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.dependencies;

import com.android.tools.idea.gradle.structure.model.PsModelNameComparator;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.PsProject;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckboxTreeAdapter;
import com.intellij.ui.CheckboxTreeListener;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import kotlin.Unit;
import org.jdesktop.swingx.JXLabel;
import org.jetbrains.annotations.NotNull;

class ModuleDependenciesForm {
    @NotNull
    private final CheckboxTree myPossibleDependenciesTree;
    @NotNull
    private final Set<PsModule> mySelectedModules;
    private JPanel myMainPanel;
    private JBScrollPane myModulesScrollPane;
    private JXLabel myModulesLabel;

    ModuleDependenciesForm(@NotNull PsModule module2) {
        this.$$$setupUI$$$();
        this.mySelectedModules = Sets.newHashSet();
        this.myModulesLabel.setBorder((Border)BorderFactory.createCompoundBorder(UIUtil.getTextFieldBorder(), JBUI.Borders.empty((int)2)));
        this.myModulesLabel.setBackground(UIUtil.getTextFieldBackground());
        this.myModulesLabel.setText(" ");
        CheckboxTree.CheckboxTreeCellRenderer cellRenderer2 = new CheckboxTree.CheckboxTreeCellRenderer(){

            public void customizeRenderer(JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Object data;
                if (value2 instanceof DefaultMutableTreeNode && (data = ((DefaultMutableTreeNode)value2).getUserObject()) instanceof PsModule) {
                    PsModule m = (PsModule)data;
                    ColoredTreeCellRenderer textRenderer = this.getTextRenderer();
                    textRenderer.setIcon(m.getIcon());
                    textRenderer.append(m.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
            }
        };
        CheckedTreeNode root2 = new CheckedTreeNode(null);
        List<PsModule> modules = ModuleDependenciesForm.findAvailableModules(module2);
        Collections.sort(modules, new PsModelNameComparator());
        modules.forEach(m -> {
            CheckedTreeNode node2 = new CheckedTreeNode(m);
            node2.setChecked(false);
            root2.add((MutableTreeNode)node2);
        });
        this.myPossibleDependenciesTree = new CheckboxTree(cellRenderer2, root2);
        this.myPossibleDependenciesTree.addCheckboxTreeListener((CheckboxTreeListener)new CheckboxTreeAdapter(){

            public void nodeStateChanged(@NotNull CheckedTreeNode node2) {
                Object data = node2.getUserObject();
                if (data instanceof PsModule) {
                    PsModule m = (PsModule)data;
                    if (node2.isChecked()) {
                        ModuleDependenciesForm.this.mySelectedModules.add(m);
                    } else {
                        ModuleDependenciesForm.this.mySelectedModules.remove(m);
                    }
                    Object[] selectedModules = (PsModule[])ModuleDependenciesForm.this.myPossibleDependenciesTree.getCheckedNodes(PsModule.class, null);
                    Arrays.sort(selectedModules, new PsModelNameComparator());
                    String names = Joiner.on((String)", ").join(selectedModules);
                    if (names.isEmpty()) {
                        names = " ";
                    }
                    ModuleDependenciesForm.this.myModulesLabel.setText(names);
                }
            }
        });
        this.myModulesScrollPane.setViewportView((Component)this.myPossibleDependenciesTree);
    }

    @NotNull
    private static List<PsModule> findAvailableModules(@NotNull PsModule module2) {
        ArrayList modules = Lists.newArrayList();
        List<PsModule> dependencies2 = ModuleDependenciesForm.getModuleDependencies(module2);
        module2.getParent().forEachModule(m -> {
            if (module2 != m && !dependencies2.contains(m) && module2.canDependOn((PsModule)m)) {
                modules.add(m);
            }
        });
        return modules;
    }

    @NotNull
    private static List<PsModule> getModuleDependencies(@NotNull PsModule module2) {
        PsProject project = module2.getParent();
        ArrayList dependencies2 = Lists.newArrayList();
        if (module2 instanceof PsAndroidModule) {
            ((PsAndroidModule)module2).getDependencies().forEachModuleDependency(dependency -> {
                String name = dependency.getName();
                PsModule found = project.findModuleByName(name);
                if (found != null) {
                    dependencies2.add(found);
                }
                return Unit.INSTANCE;
            });
        }
        return dependencies2;
    }

    @NotNull
    JComponent getPreferredFocusedComponent() {
        return this.myPossibleDependenciesTree;
    }

    @NotNull
    JPanel getPanel() {
        return this.myMainPanel;
    }

    @NotNull
    List<PsModule> getSelectedModules() {
        return Lists.newArrayList(this.mySelectedModules);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JXLabel jXLabel;
        JBScrollPane jBScrollPane;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myModulesScrollPane = jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Modules:");
        jPanel.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myModulesLabel = jXLabel = new JXLabel();
        jPanel.add((Component)jXLabel, new GridConstraints(1, 1, 1, 1, 0, 1, 7, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

