/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure;

import com.android.ide.common.repository.GradleVersion;
import com.android.repository.api.Downloader;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressRunner;
import com.android.repository.api.RepoManager;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.idea.gradle.structure.NdkProjectStructureUtilKt;
import com.android.tools.idea.gradle.structure.ProjectConfigurationError;
import com.android.tools.idea.gradle.ui.LabelAndFileForLocation;
import com.android.tools.idea.gradle.ui.SdkUiStrings;
import com.android.tools.idea.gradle.ui.SdkUiUtils;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.io.FilePaths;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.SdkPaths;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.progress.StudioProgressRunner;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.ui.validation.validators.PathValidator;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.google.common.base.Strings;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.DetailsComponent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.KeyStrokeAdapter;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Function;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.JBUI;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeSdksConfigurable
implements Place.Navigator,
Configurable {
    @NonNls
    private static final String SDKS_PLACE = "sdks.place";
    @NonNls
    public static final String IDE_SDKS_LOCATION_VIEW = "IdeSdksView";
    private static final String CHOOSE_VALID_SDK_DIRECTORY_ERR = "Please choose a valid Android SDK directory.";
    private static final String CHOOSE_VALID_NDK_DIRECTORY_ERR = "Please choose a valid Android NDK directory.";
    private static final Logger LOG = Logger.getInstance(IdeSdksConfigurable.class);
    @Nullable
    private final Project myProject;
    @NotNull
    private final BiMap<String, Component> myComponentsById;
    @NotNull
    private String myUserSelectedJdkHomePath;
    @Nullable
    private String myOriginalNdkHomePath;
    @Nullable
    private String myOriginalSdkHomePath;
    @Nullable
    private String myOriginalJdkHomePath;
    private HyperlinkLabel myNdkDownloadHyperlinkLabel;
    private TextFieldWithBrowseButton mySdkLocationTextField;
    private JPanel myWholePanel;
    private JPanel myNdkDownloadPanel;
    private AsyncProcessIcon myNdkCheckProcessIcon;
    private ComboboxWithBrowseButton myJdkLocationComboBox;
    private ComboboxWithBrowseButton myNdkLocationComboBox;
    private JBLabel myJdkLocationHelp;
    private DetailsComponent myDetailsComponent;
    private History myHistory;
    private String mySelectedComponentId;
    private boolean mySdkLoadingRequested;
    private boolean myIsJavaHomeValid;

    public IdeSdksConfigurable(@Nullable Project project) {
        GradleVersion gradleModelNumber;
        this.$$$setupUI$$$();
        this.myComponentsById = HashBiMap.create();
        this.myUserSelectedJdkHomePath = "";
        this.mySdkLoadingRequested = false;
        this.myProject = project;
        this.myWholePanel.setPreferredSize((Dimension)JBUI.size((int)700, (int)500));
        this.myWholePanel.setName(IDE_SDKS_LOCATION_VIEW);
        this.myDetailsComponent = new DetailsComponent(false, false);
        this.myDetailsComponent.setContent((JComponent)this.myWholePanel);
        boolean supportsSideBySideNdk = true;
        if (this.myProject != null && (gradleModelNumber = GradleUtil.getAndroidGradleModelVersionInUse(project)) != null) {
            supportsSideBySideNdk = NdkProjectStructureUtilKt.supportsSideBySideNdk(gradleModelNumber);
        }
        this.myNdkLocationComboBox.setEnabled(!supportsSideBySideNdk);
        this.myNdkDownloadHyperlinkLabel.setEnabled(!supportsSideBySideNdk);
        if (!supportsSideBySideNdk && (this.myProject == null || this.myProject.isDefault())) {
            this.myNdkLocationComboBox.setEnabled(false);
        }
        if (!supportsSideBySideNdk) {
            this.adjustNdkQuickFixVisibility();
        }
        FocusAdapter historyUpdater = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (IdeSdksConfigurable.this.myHistory != null) {
                    String id = (String)IdeSdksConfigurable.this.myComponentsById.inverse().get((Object)e.getComponent());
                    IdeSdksConfigurable.this.mySelectedComponentId = id;
                    if (id != null) {
                        IdeSdksConfigurable.this.myHistory.pushQueryPlace();
                    }
                }
            }
        };
        this.addHistoryUpdater("mySdkLocationTextField", this.mySdkLocationTextField.getTextField(), historyUpdater);
        this.addHistoryUpdater("myJdkLocationComboBox", this.myJdkLocationComboBox.getComboBox(), historyUpdater);
        if (!supportsSideBySideNdk) {
            this.addHistoryUpdater("myNdkLocationComboBox", this.myNdkLocationComboBox.getComboBox(), historyUpdater);
        }
    }

    private void maybeLoadSdks(@Nullable Project project) {
        if (this.mySdkLoadingRequested) {
            return;
        }
        this.mySdkLoadingRequested = true;
        CardLayout layout2 = (CardLayout)this.myNdkDownloadPanel.getLayout();
        layout2.show(this.myNdkDownloadPanel, "loading");
        StudioLoggerProgressIndicator logger2 = new StudioLoggerProgressIndicator(this.getClass());
        RepoManager repoManager = AndroidSdks.getInstance().tryToChooseSdkHandler().getSdkManager((ProgressIndicator)logger2);
        StudioProgressRunner runner = new StudioProgressRunner(false, false, "Loading Remote SDK", project);
        RepoManager.RepoLoadedListener onComplete2 = packages -> ApplicationManager.getApplication().invokeLater(() -> {
            if (packages.getRemotePackages().get("ndk-bundle") != null) {
                layout2.show(this.myNdkDownloadPanel, "link");
            } else {
                this.myNdkDownloadPanel.setVisible(false);
            }
        }, ModalityState.any());
        Runnable onError2 = () -> ApplicationManager.getApplication().invokeLater(() -> this.myNdkDownloadPanel.setVisible(false), ModalityState.any());
        repoManager.load(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, null, (List)ImmutableList.of((Object)onComplete2), (List)ImmutableList.of((Object)onError2), (ProgressRunner)runner, (Downloader)new StudioDownloader(), StudioSettingsController.getInstance(), false);
    }

    private void addHistoryUpdater(@NotNull String id, @NotNull Component c, @NotNull FocusListener historyUpdater) {
        this.myComponentsById.put((Object)id, (Object)c);
        c.addFocusListener(historyUpdater);
    }

    public void disposeUIResources() {
        this.mySdkLoadingRequested = false;
    }

    public void reset() {
        this.myOriginalSdkHomePath = IdeSdksConfigurable.getIdeAndroidSdkPath();
        this.myOriginalNdkHomePath = this.getIdeNdkPath();
        this.myOriginalJdkHomePath = IdeSdksConfigurable.getIdeJdkPath();
        this.mySdkLocationTextField.setText(this.myOriginalSdkHomePath);
        this.myNdkLocationComboBox.getComboBox().setSelectedItem(this.myOriginalNdkHomePath);
        this.myJdkLocationComboBox.getComboBox().setSelectedItem(this.myOriginalJdkHomePath);
        this.myUserSelectedJdkHomePath = this.myOriginalJdkHomePath;
    }

    public void apply() throws ConfigurationException {
        if (!this.isModified()) {
            return;
        }
        if (this.validateJdkPath(this.getJdkLocation()) == null) {
            throw new ConfigurationException(SdkUiStrings.generateChooseValidJdkDirectoryError());
        }
        List<ProjectConfigurationError> errors2 = this.validateState();
        if (!errors2.isEmpty()) {
            throw new ConfigurationException(errors2.get(0).getDescription());
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            this.saveAndroidNdkPath();
            IdeSdks ideSdks = IdeSdks.getInstance();
            Sdk chosenJdk = ideSdks.setJdkPath(this.getJdkLocation());
            ideSdks.setAndroidSdkPath(this.getSdkLocation(), chosenJdk, this.myProject);
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                IdeSdks.updateWelcomeRunAndroidSdkAction();
            }
        });
    }

    private void saveAndroidNdkPath() {
        if (this.myProject == null || this.myProject.isDefault()) {
            return;
        }
        try {
            LocalProperties localProperties = new LocalProperties(this.myProject);
            localProperties.setAndroidNdkPath(this.getNdkLocation());
            localProperties.save();
        }
        catch (IOException e) {
            LOG.info(String.format("Unable to update local.properties file in project '%1$s'.", this.myProject.getName()), (Throwable)e);
            String cause = e.getMessage();
            if (Strings.isNullOrEmpty((String)cause)) {
                cause = "[Unknown]";
            }
            String msg = String.format("Unable to update local.properties file in project '%1$s'.\n\nCause: %2$s\n\nPlease manually update the file's '%3$s' property value to \n'%4$s'\nand sync the project with Gradle files.", this.myProject.getName(), cause, "ndk.dir", this.getNdkLocation().getPath());
            Messages.showErrorDialog((Project)this.myProject, (String)msg, (String)"Android Ndk Update");
        }
    }

    private void createUIComponents() {
        this.myNdkCheckProcessIcon = new AsyncProcessIcon("NDK check progress");
        this.createSdkLocationTextField();
        this.createNdkLocationComboBox();
        this.createNdkDownloadLink();
        this.createJdkLocationHelp();
        this.createJdkLocationComboBox();
    }

    private void createJdkLocationHelp() {
        this.myJdkLocationHelp = ContextHelpLabel.createWithLink(null, (String)"To share the same Gradle daemon between Android Studio and other external processes, create a JAVA_HOME environment variable with a valid JDK location and select it from the dropdown below.", (String)"Learn more", () -> BrowserUtil.browse((String)"https://docs.gradle.org/current/userguide/gradle_daemon.html#sec:why_is_there_more_than_one_daemon_process_on_my_machine"));
    }

    private void createNdkLocationComboBox() {
        FileChooserDescriptor descriptor2 = IdeSdksConfigurable.createSingleFolderDescriptor("Choose NDK Location", (Function<File, Void>)((Function)file2 -> {
            SdkPaths.ValidationResult validationResult = SdkPaths.validateAndroidNdk(file2, false);
            if (!validationResult.success) {
                this.adjustNdkQuickFixVisibility();
                String msg = validationResult.message;
                if (StringUtil.isEmpty((String)msg)) {
                    msg = CHOOSE_VALID_NDK_DIRECTORY_ERR;
                }
                throw new IllegalArgumentException(msg);
            }
            JComboBox comboBox = this.myNdkLocationComboBox.getComboBox();
            IdeSdksConfigurable.setComboBoxFile(comboBox, file2);
            return null;
        }));
        this.myNdkLocationComboBox = new ComboboxWithBrowseButton();
        this.myNdkLocationComboBox.addBrowseFolderListener(this.myProject, descriptor2);
        final JComboBox comboBox = this.myNdkLocationComboBox.getComboBox();
        File androidNdkPath = IdeSdks.getInstance().getAndroidNdkPath();
        if (androidNdkPath != null) {
            comboBox.addItem(new LabelAndFileForLocation("Default NDK (recommended)", androidNdkPath));
        }
        comboBox.setEditable(true);
        comboBox.setSelectedItem(IdeSdksConfigurable.getIdeAndroidSdkPath());
        comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                Object selectedItem;
                if (event.getStateChange() == 1 && (selectedItem = event.getItem()) instanceof LabelAndFileForLocation) {
                    ApplicationManager.getApplication().invokeLater(() -> IdeSdksConfigurable.setComboBoxFile(comboBox, ((LabelAndFileForLocation)selectedItem).getFile()));
                }
            }
        });
        IdeSdksConfigurable.addTootlTipListener(comboBox);
    }

    private void createJdkLocationComboBox() {
        String value2;
        File envVarPath;
        String javaHomePath;
        File validatedPath;
        FileChooserDescriptor descriptor2 = IdeSdksConfigurable.createSingleFolderDescriptor("Choose JDK Location", (Function<File, Void>)((Function)file2 -> {
            File validatedFile = this.validateJdkPath((File)file2);
            if (validatedFile == null) {
                throw new IllegalArgumentException(SdkUiStrings.generateChooseValidJdkDirectoryError());
            }
            this.setJdkLocationComboBox((File)file2);
            return null;
        }));
        this.myJdkLocationComboBox = new ComboboxWithBrowseButton();
        this.myJdkLocationComboBox.addBrowseFolderListener(this.myProject, descriptor2);
        JComboBox comboBox = this.myJdkLocationComboBox.getComboBox();
        IdeSdks ideSdks = IdeSdks.getInstance();
        File embeddedPath = ideSdks.getEmbeddedJdkPath();
        if (embeddedPath != null && (validatedPath = this.validateJdkPath(embeddedPath)) != null) {
            comboBox.addItem(new LabelAndFileForLocation("Embedded JDK", validatedPath));
        }
        if ((javaHomePath = IdeSdks.getJdkFromJavaHome()) != null) {
            File validatedPath2 = this.validateJdkPath(new File(javaHomePath));
            boolean bl = this.myIsJavaHomeValid = validatedPath2 != null;
            if (this.myIsJavaHomeValid) {
                comboBox.addItem(new LabelAndFileForLocation("JAVA_HOME", validatedPath2));
            }
        }
        if ((envVarPath = ideSdks.getEnvVariableJdkFile()) != null) {
            comboBox.addItem(new LabelAndFileForLocation("STUDIO_GRADLE_JDK", envVarPath));
        } else if (ideSdks.isJdkEnvVariableDefined() && (value2 = ideSdks.getEnvVariableJdkValue()) != null) {
            comboBox.addItem(new LabelAndPath("STUDIO_GRADLE_JDK", ideSdks.getEnvVariableJdkValue()));
        }
        comboBox.setEditable(true);
        IdeSdksConfigurable.setComboBoxFile(comboBox, this.getJdkLocation());
        comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (event.getStateChange() == 1) {
                    Object selectedItem = event.getItem();
                    if (selectedItem instanceof LabelAndFileForLocation) {
                        ApplicationManager.getApplication().invokeLater(() -> IdeSdksConfigurable.this.setJdkLocationComboBox(((LabelAndFileForLocation)selectedItem).getFile()));
                    } else if (selectedItem instanceof LabelAndPath) {
                        ApplicationManager.getApplication().invokeLater(() -> IdeSdksConfigurable.this.setJdkLocationComboBox(((LabelAndPath)selectedItem).getPath()));
                    }
                }
            }
        });
        IdeSdksConfigurable.addTootlTipListener(comboBox);
    }

    private static void addTootlTipListener(final @NotNull JComboBox comboBox) {
        Component component = comboBox.getEditor().getEditorComponent();
        component.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                super.mouseMoved(e);
                IdeSdksConfigurable.copyItemToToolTip(comboBox);
            }
        });
        component.addKeyListener((KeyListener)new KeyStrokeAdapter(){

            public void keyTyped(KeyEvent event) {
                super.keyTyped(event);
                IdeSdksConfigurable.copyItemToToolTip(comboBox);
            }
        });
        comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IdeSdksConfigurable.copyItemToToolTip(comboBox);
            }
        });
    }

    private static void copyItemToToolTip(@NotNull JComboBox comboBox) {
        Object item = comboBox.getEditor().getItem();
        if (item != null) {
            comboBox.setToolTipText(item.toString());
        } else {
            comboBox.setToolTipText("");
        }
    }

    private static void setComboBoxFile(@NotNull JComboBox comboBox, @NotNull File file2) {
        IdeSdksConfigurable.setComboBoxPath(comboBox, file2.getPath());
    }

    private static void setComboBoxPath(@NotNull JComboBox comboBox, @NotNull String path2) {
        comboBox.setSelectedItem(FileUtilRt.toSystemDependentName((String)path2));
    }

    private void createSdkLocationTextField() {
        FileChooserDescriptor descriptor2 = IdeSdksConfigurable.createSingleFolderDescriptor("Choose Android SDK Location", (Function<File, Void>)((Function)file2 -> {
            SdkPaths.ValidationResult validationResult = SdkPaths.validateAndroidSdk(file2, false);
            if (!validationResult.success) {
                String msg = validationResult.message;
                if (StringUtil.isEmpty((String)msg)) {
                    msg = CHOOSE_VALID_SDK_DIRECTORY_ERR;
                }
                throw new IllegalArgumentException(msg);
            }
            return null;
        }));
        final JTextField textField = new JTextField(10);
        this.mySdkLocationTextField = new TextFieldWithBrowseButton(textField, e -> {
            VirtualFile chosen;
            VirtualFile suggestedDir = null;
            File sdkLocation = this.getSdkLocation();
            if (sdkLocation.isDirectory()) {
                suggestedDir = VfsUtil.findFileByIoFile((File)sdkLocation, (boolean)false);
            }
            if ((chosen = FileChooser.chooseFile((FileChooserDescriptor)descriptor2, null, (VirtualFile)suggestedDir)) != null) {
                File f = VfsUtilCore.virtualToIoFile((VirtualFile)chosen);
                textField.setText(FileUtilRt.toSystemDependentName((String)f.getPath()));
            }
        });
        textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateToolTip();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateToolTip();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateToolTip();
            }

            private void updateToolTip() {
                textField.setToolTipText(textField.getText());
            }
        });
    }

    private void createNdkDownloadLink() {
        this.myNdkDownloadHyperlinkLabel = new HyperlinkLabel();
        this.myNdkDownloadHyperlinkLabel.setHyperlinkText("", "Download", " Android NDK.");
        this.myNdkDownloadHyperlinkLabel.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                if (IdeSdksConfigurable.this.validateAndroidSdkPath() != null) {
                    Messages.showErrorDialog((Component)IdeSdksConfigurable.this.getContentPanel(), (String)"Please select a valid SDK before downloading the NDK.");
                    return;
                }
                ImmutableList requested = ImmutableList.of((Object)"ndk-bundle");
                ModelWizardDialog dialog2 = SdkQuickfixUtils.createDialogForPaths(IdeSdksConfigurable.this.myWholePanel, (Collection<String>)requested, false);
                if (dialog2 != null && dialog2.showAndGet()) {
                    File ndk = IdeSdks.getInstance().getAndroidNdkPath();
                    if (ndk != null) {
                        IdeSdksConfigurable.this.myNdkLocationComboBox.getComboBox().setSelectedItem(FileUtilRt.toSystemDependentName((String)ndk.getPath()));
                    }
                    IdeSdksConfigurable.this.validateState();
                }
            }
        });
    }

    @NotNull
    private static FileChooserDescriptor createSingleFolderDescriptor(@NotNull String title, final @NotNull Function<File, Void> validation2) {
        FileChooserDescriptor descriptor2 = new FileChooserDescriptor(false, true, false, false, false, false){

            public void validateSelectedFiles(@NotNull VirtualFile[] files2) {
                for (VirtualFile virtualFile : files2) {
                    File file2 = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
                    validation2.fun((Object)file2);
                }
            }
        };
        if (SystemInfo.isMac) {
            descriptor2.withShowHiddenFiles(true);
        }
        descriptor2.setTitle(title);
        return descriptor2;
    }

    public String getDisplayName() {
        return "SDK Location";
    }

    public String getHelpTopic() {
        return null;
    }

    @Nullable
    public JComponent createComponent() {
        this.maybeLoadSdks(this.myProject);
        return this.myDetailsComponent.getComponent();
    }

    @NotNull
    public JComponent getContentPanel() {
        return this.myWholePanel;
    }

    public boolean isModified() {
        return !Objects.equals(this.myOriginalSdkHomePath, this.getSdkLocation().getPath()) || !Objects.equals(this.myOriginalNdkHomePath, this.getNdkLocation().getPath()) || !Objects.equals(this.myOriginalJdkHomePath, this.getJdkLocation().getPath());
    }

    @Nullable
    private static Sdk getFirstDefaultAndroidSdk() {
        IdeSdks ideSdks = IdeSdks.getInstance();
        List<Sdk> allAndroidSdks = ideSdks.getEligibleAndroidSdks();
        if (!allAndroidSdks.isEmpty()) {
            return allAndroidSdks.get(0);
        }
        AndroidSdkData sdkData = AndroidSdks.getInstance().tryToChooseAndroidSdk();
        if (sdkData == null) {
            return null;
        }
        List<Sdk> sdks = ideSdks.createAndroidSdkPerAndroidTarget(sdkData.getLocation());
        return !sdks.isEmpty() ? sdks.get(0) : null;
    }

    @NotNull
    private static String getIdeAndroidSdkPath() {
        String sdkHome;
        File path2 = IdeSdks.getInstance().getAndroidSdkPath();
        if (path2 != null) {
            return path2.getPath();
        }
        Sdk sdk = IdeSdksConfigurable.getFirstDefaultAndroidSdk();
        if (sdk != null && (sdkHome = sdk.getHomePath()) != null) {
            return FileUtilRt.toSystemDependentName((String)sdkHome);
        }
        return "";
    }

    @NotNull
    private String getIdeNdkPath() {
        if (this.myProject != null && !this.myProject.isDefault()) {
            try {
                File androidNdkPath = new LocalProperties(this.myProject).getAndroidNdkPath();
                if (androidNdkPath != null) {
                    return androidNdkPath.getPath();
                }
            }
            catch (IOException e) {
                LOG.info(String.format("Unable to read local.properties file in project '%1$s'.", this.myProject.getName()), (Throwable)e);
            }
        } else {
            File path2 = IdeSdks.getInstance().getAndroidNdkPath();
            if (path2 != null) {
                return path2.getPath();
            }
        }
        return "";
    }

    @NotNull
    private static String getIdeJdkPath() {
        File javaHome = IdeSdks.getInstance().getJdkPath();
        return javaHome != null ? javaHome.getPath() : "";
    }

    @NotNull
    private File getSdkLocation() {
        String sdkLocation = this.mySdkLocationTextField.getText();
        return FilePaths.toSystemDependentPath((String)sdkLocation);
    }

    @NotNull
    private File getNdkLocation() {
        return SdkUiUtils.getLocationFromComboBoxWithBrowseButton(this.myNdkLocationComboBox);
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        Component toFocus = (Component)this.myComponentsById.get((Object)this.mySelectedComponentId);
        return toFocus instanceof JComponent ? (JComponent)toFocus : this.mySdkLocationTextField.getTextField();
    }

    public boolean validate() throws ConfigurationException {
        String msg = this.validateAndroidSdkPath();
        if (msg != null) {
            throw new ConfigurationException(msg);
        }
        if (this.validateJdkPath(this.getJdkLocation()) == null) {
            throw new ConfigurationException(SdkUiStrings.generateChooseValidJdkDirectoryError());
        }
        msg = this.validateAndroidNdkPath();
        if (msg != null) {
            throw new ConfigurationException(msg);
        }
        return true;
    }

    @NotNull
    public List<ProjectConfigurationError> validateState() {
        ProjectConfigurationError error;
        ArrayList<ProjectConfigurationError> errors2 = new ArrayList<ProjectConfigurationError>();
        String msg = this.validateAndroidSdkPath();
        if (msg != null) {
            error = new ProjectConfigurationError(msg, this.mySdkLocationTextField.getTextField());
            errors2.add(error);
        }
        if (this.validateJdkPath(this.getJdkLocation()) == null) {
            error = new ProjectConfigurationError(SdkUiStrings.generateChooseValidJdkDirectoryError(), this.myJdkLocationComboBox.getComboBox());
            errors2.add(error);
        }
        if ((msg = this.validateAndroidNdkPath()) != null) {
            error = new ProjectConfigurationError(msg, this.myNdkLocationComboBox.getComboBox());
            errors2.add(error);
        }
        return errors2;
    }

    @Nullable
    private String validateAndroidSdkPath() {
        Validator.Result result2 = PathValidator.forAndroidSdkLocation().validate(this.getSdkLocation());
        Validator.Severity severity = result2.getSeverity();
        if (severity == Validator.Severity.ERROR) {
            return result2.getMessage();
        }
        SdkPaths.ValidationResult validationResult = SdkPaths.validateAndroidSdk(this.getSdkLocation(), false);
        if (!validationResult.success) {
            String msg = validationResult.message;
            if (StringUtil.isEmpty((String)msg)) {
                msg = CHOOSE_VALID_SDK_DIRECTORY_ERR;
            }
            return msg;
        }
        return null;
    }

    @Nullable
    private String validateAndroidNdkPath() {
        this.hideNdkQuickfixLink();
        Object selectedItem = this.myNdkLocationComboBox.getComboBox().getSelectedItem();
        String value2 = "";
        if (selectedItem != null) {
            value2 = selectedItem.toString();
        }
        if (!value2.isEmpty()) {
            SdkPaths.ValidationResult validationResult = SdkPaths.validateAndroidNdk(this.getNdkLocation(), false);
            if (!validationResult.success) {
                this.adjustNdkQuickFixVisibility();
                String msg = validationResult.message;
                if (StringUtil.isEmpty((String)msg)) {
                    msg = CHOOSE_VALID_NDK_DIRECTORY_ERR;
                }
                return msg;
            }
        } else if (this.myNdkLocationComboBox.isVisible()) {
            this.adjustNdkQuickFixVisibility();
        }
        return null;
    }

    private void adjustNdkQuickFixVisibility() {
        boolean hasNdk = IdeSdks.getInstance().getAndroidNdkPath() != null;
        this.myNdkDownloadPanel.setVisible(!hasNdk);
    }

    private void hideNdkQuickfixLink() {
        this.myNdkDownloadPanel.setVisible(false);
    }

    @NotNull
    private File getUserSelectedJdkLocation() {
        String jdkLocation = Strings.nullToEmpty((String)this.myUserSelectedJdkHomePath);
        return FilePaths.toSystemDependentPath((String)jdkLocation);
    }

    @NotNull
    private File getJdkLocation() {
        return SdkUiUtils.getLocationFromComboBoxWithBrowseButton(this.myJdkLocationComboBox);
    }

    @Nullable
    private File validateJdkPath(@NotNull File file2) {
        File possiblePath = IdeSdks.getInstance().validateJdkPath(file2);
        if (possiblePath != null) {
            this.setJdkLocationComboBox(possiblePath);
            return possiblePath;
        }
        return null;
    }

    private void setJdkLocationComboBox(@NotNull File file2) {
        this.setJdkLocationComboBox(file2.getPath());
    }

    private void setJdkLocationComboBox(@NotNull String path2) {
        IdeSdksConfigurable.setComboBoxPath(this.myJdkLocationComboBox.getComboBox(), path2);
    }

    public static boolean isNeeded() {
        String jdkPath = IdeSdksConfigurable.getIdeJdkPath();
        String sdkPath = IdeSdksConfigurable.getIdeAndroidSdkPath();
        IdeSdks ideSdks = IdeSdks.getInstance();
        boolean validJdk = ideSdks.isUsingEmbeddedJdk() || !jdkPath.isEmpty() && JdkUtil.checkForJdk((File)new File(jdkPath));
        boolean validSdk = !sdkPath.isEmpty() && ideSdks.isValidAndroidSdkPath(new File(sdkPath));
        return !validJdk || !validSdk;
    }

    public void setHistory(History history) {
        this.myHistory = history;
    }

    public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        Object path2;
        if (place != null && (path2 = place.getPath(SDKS_PLACE)) instanceof String) {
            Component c = (Component)this.myComponentsById.get(path2);
            if (requestFocus && c != null) {
                c.requestFocusInWindow();
            }
        }
        return ActionCallback.DONE;
    }

    public void queryPlace(@NotNull Place place) {
        place.putPath(SDKS_PLACE, (Object)this.mySelectedComponentId);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myWholePanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(24, 20, 0, 20), 0, 0, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), 0, 2, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 1, 1, 7, 3, null, null, null));
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.mySdkLocationTextField;
        jPanel3.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 0, 1, 1, 9, 0, 7, 3, new Dimension(518, -1), null, new Dimension(518, -1)));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 3, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("<html><b>Android SDK location</b><br> This location will be used for new projects and for existing projects that do not have a local.properties file with a sdk.dir property.</html>");
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 9, 0, 7, 3, null, null, new Dimension(518, -1)));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 7, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(34, 0, 0, 0), 0, 2, false, false));
        jPanel2.add((Component)jPanel5, new GridConstraints(1, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        ComboboxWithBrowseButton comboboxWithBrowseButton = this.myNdkLocationComboBox;
        jPanel5.add((Component)comboboxWithBrowseButton, new GridConstraints(1, 0, 1, 1, 9, 0, 7, 3, new Dimension(518, -1), null, new Dimension(518, -1)));
        this.myNdkDownloadPanel = jPanel = new JPanel();
        jPanel.setLayout(new CardLayout(0, 0));
        jPanel5.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        HyperlinkLabel hyperlinkLabel = this.myNdkDownloadHyperlinkLabel;
        jPanel.add((Component)hyperlinkLabel, "link");
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel6, "loading");
        AsyncProcessIcon asyncProcessIcon = this.myNdkCheckProcessIcon;
        jPanel6.add((Component)asyncProcessIcon, new GridConstraints(0, 0, 1, 1, 0, 0, 7, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel6.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Checking availability...");
        jPanel6.add((Component)jBLabel, new GridConstraints(0, 1, 1, 1, 0, 0, 7, 3, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 3, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("<html><b>Android NDK location</b><br> This location will be saved as ndk.dir property in the local.properties file.</html>");
        jPanel7.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 9, 0, 3, 3, new Dimension(518, -1), new Dimension(518, -1), new Dimension(518, -1)));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(34, 0, 0, 0), 0, 2, false, false));
        jPanel2.add((Component)jPanel8, new GridConstraints(2, 0, 1, 1, 1, 1, 7, 3, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 3, 0, 0), 0, -1, false, false));
        jPanel8.add((Component)jPanel9, new GridConstraints(0, 0, 1, 1, 9, 0, 3, 3, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("<html><b>JDK location</b><br>The Java Development Kit (JDK) you want Gradle to use when building your project.</html>");
        jPanel9.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 1, null, null, null));
        JBLabel jBLabel2 = this.myJdkLocationHelp;
        jPanel9.add((Component)jBLabel2, new GridConstraints(0, 1, 1, 1, 10, 0, 1, 1, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel9.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        ComboboxWithBrowseButton comboboxWithBrowseButton2 = this.myJdkLocationComboBox;
        jPanel8.add((Component)comboboxWithBrowseButton2, new GridConstraints(1, 0, 1, 1, 9, 0, 3, 3, new Dimension(518, -1), new Dimension(130, 27), new Dimension(518, -1)));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    public static class LabelAndPath {
        @NotNull
        private String myLabel;
        @NotNull
        private String myPath;

        public LabelAndPath(@NotNull String label, @NotNull String path2) {
            this.myLabel = label;
            this.myPath = path2;
        }

        @NotNull
        public String getLabel() {
            return this.myLabel;
        }

        @NotNull
        public String getPath() {
            return this.myPath;
        }

        public String toString() {
            return this.myLabel + ": " + this.myPath;
        }
    }
}

