/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.upgrade;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.gradle.project.sync.hyperlink.SearchInBuildFilesHyperlink;
import com.android.tools.idea.gradle.project.upgrade.AgpClasspathDependencyRefactoringProcessor;
import com.android.tools.idea.gradle.project.upgrade.AgpGradleVersionRefactoringProcessor;
import com.android.tools.idea.gradle.project.upgrade.GMavenRepositoryRefactoringProcessor;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidPluginVersionUpdater {
    @NotNull
    private final Project myProject;
    @NotNull
    private final TextSearch myTextSearch;

    @NotNull
    public static AndroidPluginVersionUpdater getInstance(@NotNull Project project) {
        return (AndroidPluginVersionUpdater)ServiceManager.getService((Project)project, AndroidPluginVersionUpdater.class);
    }

    public AndroidPluginVersionUpdater(@NotNull Project project) {
        this(project, new TextSearch(project));
    }

    @NonInjectable
    @VisibleForTesting
    AndroidPluginVersionUpdater(@NotNull Project project, @NotNull TextSearch textSearch) {
        this.myProject = project;
        this.myTextSearch = textSearch;
    }

    public boolean updatePluginVersion(@NotNull GradleVersion pluginVersion, @Nullable GradleVersion gradleVersion2) {
        UpdateResult result2 = this.updatePluginVersion(pluginVersion, gradleVersion2, null);
        return result2.isPluginVersionUpdated() || result2.isGradleVersionUpdated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateResult updatePluginVersion(@NotNull GradleVersion pluginVersion, @Nullable GradleVersion gradleVersion2, @Nullable GradleVersion oldPluginVersion) {
        String msg;
        UpdateResult result2 = new UpdateResult();
        Runnable updaterRunnable = () -> {
            this.updatePluginVersionWithResult(pluginVersion, gradleVersion2, oldPluginVersion, result2);
            UpdateResult updateResult = result2;
            synchronized (updateResult) {
                result2.complete = true;
                result2.notifyAll();
            }
        };
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            updaterRunnable.run();
        } else {
            DumbService.getInstance((Project)this.myProject).smartInvokeLater(updaterRunnable);
            try {
                UpdateResult updateResult = result2;
                synchronized (updateResult) {
                    while (!result2.complete) {
                        result2.wait();
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        Throwable pluginVersionUpdateError = result2.getPluginVersionUpdateError();
        Throwable gradleVersionUpdateError = result2.getGradleVersionUpdateError();
        if (pluginVersionUpdateError != null) {
            msg = String.format("Failed to update Android plugin to version '%1$s'", pluginVersion);
            AndroidPluginVersionUpdater.logUpdateError(msg, pluginVersionUpdateError);
        }
        if (gradleVersionUpdateError != null) {
            msg = String.format("Failed to update Gradle to version '%1$s'", gradleVersion2);
            AndroidPluginVersionUpdater.logUpdateError(msg, gradleVersionUpdateError);
        }
        if (result2.getPluginVersionUpdateError() != null) {
            this.myTextSearch.execute();
        }
        return result2;
    }

    private void updatePluginVersionWithResult(@NotNull GradleVersion pluginVersion, @Nullable GradleVersion gradleVersion2, @Nullable GradleVersion oldPluginVersion, UpdateResult result2) {
        if (oldPluginVersion == null) {
            oldPluginVersion = new GradleVersion(1, 0, 0);
        }
        AgpClasspathDependencyRefactoringProcessor rp1 = new AgpClasspathDependencyRefactoringProcessor(this.myProject, oldPluginVersion, pluginVersion);
        GMavenRepositoryRefactoringProcessor rp2 = new GMavenRepositoryRefactoringProcessor(this.myProject, oldPluginVersion, pluginVersion);
        try {
            rp1.run();
            if (!oldPluginVersion.isAtLeast(3, 0, 0)) {
                rp2.run();
            }
            if (rp1.getFoundUsages()) {
                result2.pluginVersionUpdated();
            }
        }
        catch (Throwable e) {
            result2.setPluginVersionUpdateError(e);
        }
        if (result2.isPluginVersionUpdated() && gradleVersion2 != null) {
            AgpGradleVersionRefactoringProcessor rp3 = new AgpGradleVersionRefactoringProcessor(this.myProject, oldPluginVersion, pluginVersion);
            try {
                rp3.run();
                result2.gradleVersionUpdated();
            }
            catch (Throwable e) {
                result2.setGradleVersionUpdateError(e);
            }
        }
    }

    private static void logUpdateError(@NotNull String msg, @NotNull Throwable error) {
        String cause = error.getMessage();
        if (StringUtil.isNotEmpty((String)cause)) {
            msg = msg + ": " + cause;
        }
        Logger.getInstance(AndroidPluginVersionUpdater.class).warn(msg);
    }

    @NotNull
    public static ThreeState isUpdatablePluginDependency(@NotNull GradleVersion toVersion, @NotNull ArtifactDependencyModel model2) {
        String groupId;
        String artifactId = model2.name().forceString();
        if (!AndroidPluginInfo.isAndroidPlugin(artifactId, groupId = model2.group().toString())) {
            return ThreeState.UNSURE;
        }
        String versionValue = model2.version().toString();
        return StringUtil.isEmpty((String)versionValue) || toVersion.compareTo(versionValue) != 0 ? ThreeState.YES : ThreeState.NO;
    }

    @NotNull
    public static ThreeState isUpdatablePluginRelatedDependency(@NotNull GradleVersion toVersion, @NotNull ArtifactDependencyModel model2) {
        String groupId;
        String artifactId = model2.name().forceString();
        if (!AndroidPluginInfo.isAndroidPluginOrApi(artifactId, groupId = model2.group().toString())) {
            return ThreeState.UNSURE;
        }
        String versionValue = model2.version().toString();
        return StringUtil.isEmpty((String)versionValue) || toVersion.compareTo(versionValue) != 0 ? ThreeState.YES : ThreeState.NO;
    }

    @VisibleForTesting
    static class TextSearch {
        @NotNull
        private final Project myProject;

        TextSearch(@NotNull Project project) {
            this.myProject = project;
        }

        void execute() {
            String msg = "Failed to update the version of the Android Gradle plugin.\n\nPlease click 'OK' to perform a textual search and then update the build files manually.";
            ApplicationManager.getApplication().invokeLater(() -> {
                Messages.showErrorDialog((Project)this.myProject, (String)msg, (String)"Unexpected Error");
                String textToFind = "com.android.tools.build:gradle";
                SearchInBuildFilesHyperlink.searchInBuildFiles(textToFind, this.myProject);
            });
        }
    }

    public static class UpdateResult {
        @Nullable
        private Throwable myPluginVersionUpdateError;
        @Nullable
        private Throwable myGradleVersionUpdateError;
        private boolean myPluginVersionUpdated;
        private boolean myGradleVersionUpdated;
        private boolean complete;

        @VisibleForTesting
        public UpdateResult() {
        }

        @Nullable
        public Throwable getPluginVersionUpdateError() {
            return this.myPluginVersionUpdateError;
        }

        void setPluginVersionUpdateError(@NotNull Throwable error) {
            this.myPluginVersionUpdateError = error;
        }

        @Nullable
        public Throwable getGradleVersionUpdateError() {
            return this.myGradleVersionUpdateError;
        }

        void setGradleVersionUpdateError(@NotNull Throwable error) {
            this.myGradleVersionUpdateError = error;
        }

        public boolean isPluginVersionUpdated() {
            return this.myPluginVersionUpdated;
        }

        void pluginVersionUpdated() {
            this.myPluginVersionUpdated = true;
        }

        public boolean isGradleVersionUpdated() {
            return this.myGradleVersionUpdated;
        }

        void gradleVersionUpdated() {
            this.myGradleVersionUpdated = true;
        }

        public boolean versionUpdateSuccess() {
            return (this.myPluginVersionUpdated || this.myGradleVersionUpdated) && this.myPluginVersionUpdateError == null && this.myGradleVersionUpdateError == null;
        }
    }
}

