/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.validation.android;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.hyperlink.FixAndroidGradlePluginVersionHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenUrlHyperlink;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.project.sync.validation.android.AndroidProjectValidationStrategy;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.project.messages.SyncMessage;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LayoutRenderingIssueValidationStrategy
extends AndroidProjectValidationStrategy {
    @Nullable
    private GradleVersion myModelVersion;

    LayoutRenderingIssueValidationStrategy(@NotNull Project project) {
        super(project);
    }

    @Override
    void validate(@NotNull Module module2, @NotNull AndroidModuleModel androidModel) {
        if (androidModel.getFeatures().isLayoutRenderingIssuePresent()) {
            this.myModelVersion = androidModel.getModelVersion();
        }
    }

    @Override
    void fixAndReportFoundIssues() {
        if (this.myModelVersion != null) {
            String text2 = String.format("Using an obsolete version of the Gradle plugin (%1$s);", this.myModelVersion);
            text2 = text2 + " this can lead to layouts not rendering correctly.";
            SyncMessage message2 = new SyncMessage("Gradle Sync Issues", MessageType.WARNING, text2);
            message2.add(Arrays.asList(new FixAndroidGradlePluginVersionHyperlink(), new OpenUrlHyperlink("https://code.google.com/p/android/issues/detail?id=170841", "More Info...")));
            GradleSyncMessages.getInstance(this.getProject()).report(message2);
        }
    }

    @VisibleForTesting
    @Nullable
    GradleVersion getModelVersion() {
        return this.myModelVersion;
    }

    @VisibleForTesting
    void setModelVersion(@Nullable GradleVersion modelVersion) {
        this.myModelVersion = modelVersion;
    }
}

