/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.validation.android;

import com.android.ide.common.gradle.model.IdeAndroidProject;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.android.AndroidModel;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.project.sync.validation.android.AndroidProjectValidationStrategy;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.project.messages.SyncMessage;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BuildTools23Rc1ValidationStrategy
extends AndroidProjectValidationStrategy {
    @NotNull
    private final BuildToolsVersionReader myBuildToolsVersionReader;
    @NotNull
    private final List<String> myModules = new ArrayList<String>();

    BuildTools23Rc1ValidationStrategy(@NotNull Project project) {
        this(project, module2 -> {
            GradleBuildModel buildModel = GradleBuildModel.get(module2);
            if (buildModel != null) {
                AndroidModel android = buildModel.android();
                return android.buildToolsVersion().toString();
            }
            return null;
        });
    }

    @VisibleForTesting
    BuildTools23Rc1ValidationStrategy(@NotNull Project project, @NotNull BuildToolsVersionReader buildToolsVersionReader) {
        super(project);
        this.myBuildToolsVersionReader = buildToolsVersionReader;
    }

    @Override
    void validate(@NotNull Module module2, @NotNull AndroidModuleModel androidModel) {
        String preview;
        List segments;
        GradleVersion parsed;
        String version2;
        if (!BuildTools23Rc1ValidationStrategy.isOneDotThreeOrNewer(androidModel.getAndroidProject()) && (version2 = this.myBuildToolsVersionReader.getBuildToolsVersion(module2)) != null && (parsed = GradleVersion.parse((String)((String)(segments = Splitter.on((char)' ').omitEmptyStrings().splitToList((CharSequence)version2)).get(0)))).getMajor() == 23 && parsed.getMinor() == 0 && parsed.getMicro() == 0 && ((preview = "rc1").equals(parsed.getPreviewType()) || segments.size() > 1 && preview.equals(segments.get(1)))) {
            this.myModules.add(module2.getName());
        }
    }

    private static boolean isOneDotThreeOrNewer(@NotNull IdeAndroidProject project) {
        String modelVersion = project.getModelVersion();
        return !modelVersion.startsWith("1.0") && !modelVersion.startsWith("1.1") && project.getApiVersion() >= 3;
    }

    @Override
    void fixAndReportFoundIssues() {
        if (!this.myModules.isEmpty()) {
            Collections.sort(this.myModules);
            StringBuilder msg = new StringBuilder();
            msg.append("Build Tools 23.0.0 rc1 is <b>deprecated</b>.<br>\n").append("Please update these modules to use Build Tools 23.0.0 rc2 (or newer) instead:");
            for (String module2 : this.myModules) {
                msg.append("<br>\n * ").append(module2);
            }
            msg.append("<br>\n<br>\nOtherwise the project won't build. ");
            Project project = this.getProject();
            SyncMessage message2 = new SyncMessage("Gradle Sync Issues", MessageType.WARNING, msg.toString());
            GradleSyncMessages.getInstance(project).report(message2);
        }
    }

    @VisibleForTesting
    @NotNull
    List<String> getModules() {
        return this.myModules;
    }

    @VisibleForTesting
    static interface BuildToolsVersionReader {
        @Nullable
        public String getBuildToolsVersion(@NotNull Module var1);
    }
}

