/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.dependency;

import com.android.tools.idea.gradle.project.sync.setup.module.dependency.Dependency;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.LibraryDependency;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.ModuleDependency;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.intellij.openapi.module.Module;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DependencySet {
    @NotNull
    public static final DependencySet EMPTY = new DependencySet(){

        @Override
        void add(@NotNull LibraryDependency dependency) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addAll(DependencySet other) {
            throw new UnsupportedOperationException();
        }

        @Override
        void add(@NotNull ModuleDependency dependency) {
            throw new UnsupportedOperationException();
        }
    };
    @NotNull
    public static final DependencySet THROWING = new DependencySet(){

        @Override
        void add(@NotNull LibraryDependency dependency) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addAll(DependencySet other) {
            throw new UnsupportedOperationException();
        }

        @Override
        void add(@NotNull ModuleDependency dependency) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public ImmutableCollection<LibraryDependency> onLibraries() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public ImmutableCollection<ModuleDependency> onModules() {
            throw new UnsupportedOperationException();
        }
    };
    private final Set<LibraryDependency> myDependencies = new LinkedHashSet<LibraryDependency>();
    private final Map<Module, ModuleDependency> myModuleDependenciesByModule = Maps.newLinkedHashMap();

    DependencySet() {
    }

    void add(@NotNull LibraryDependency dependency) {
        this.myDependencies.add(dependency);
    }

    public void addAll(DependencySet other) {
        for (LibraryDependency libraryDependency : other.onLibraries()) {
            this.add(libraryDependency);
        }
        for (ModuleDependency moduleDependency : other.onModules()) {
            this.add(moduleDependency);
        }
    }

    private static boolean areSameArtifact(@NotNull LibraryDependency d1, @NotNull LibraryDependency d2) {
        return Arrays.equals(d1.getBinaryPaths(), d2.getBinaryPaths());
    }

    void add(@NotNull ModuleDependency dependency) {
        Module module2 = dependency.getModule();
        Dependency storedDependency = this.myModuleDependenciesByModule.get(module2);
        if (storedDependency == null) {
            this.myModuleDependenciesByModule.put(module2, dependency);
        }
    }

    @NotNull
    public ImmutableCollection<LibraryDependency> onLibraries() {
        return ImmutableList.copyOf(this.myDependencies);
    }

    @NotNull
    public ImmutableCollection<ModuleDependency> onModules() {
        return ImmutableList.copyOf(this.myModuleDependenciesByModule.values());
    }
}

