/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.dependency;

import com.android.ide.common.gradle.model.IdeDependencies;
import com.android.ide.common.gradle.model.IdeLibrary;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.project.sync.setup.module.ModuleFinder;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.DependencySet;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.LibraryDependency;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.ModuleDependency;
import com.android.tools.idea.io.FilePaths;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class DependenciesExtractor {
    @NotNull
    public static DependenciesExtractor getInstance() {
        return (DependenciesExtractor)ServiceManager.getService(DependenciesExtractor.class);
    }

    @NotNull
    public DependencySet extractFrom(@NotNull IdeDependencies artifactDependencies, @NotNull ModuleFinder moduleFinder) {
        DependencySet dependencies2 = new DependencySet();
        DependenciesExtractor.populate(dependencies2, artifactDependencies, moduleFinder);
        return dependencies2;
    }

    private static void populate(@NotNull DependencySet dependencies2, @NotNull IdeDependencies artifactDependencies, @NotNull ModuleFinder moduleFinder) {
        for (IdeLibrary library : artifactDependencies.getJavaLibraries()) {
            LibraryDependency libraryDependency = LibraryDependency.create(library.getArtifact(), (Collection<File>)ImmutableList.of((Object)library.getArtifact()));
            dependencies2.add(libraryDependency);
        }
        for (IdeLibrary library : artifactDependencies.getAndroidLibraries()) {
            dependencies2.add(DependenciesExtractor.createLibraryDependencyFromAndroidLibrary(library));
        }
        for (IdeLibrary library : artifactDependencies.getModuleDependencies()) {
            Module module2;
            String gradlePath = library.getProjectPath();
            if (!StringUtil.isNotEmpty((String)gradlePath) || (module2 = moduleFinder.findModuleFromLibrary(library)) == null) continue;
            ModuleDependency dependency = new ModuleDependency(module2);
            dependencies2.add(dependency);
        }
    }

    @NotNull
    private static LibraryDependency createLibraryDependencyFromAndroidLibrary(@NotNull IdeLibrary library) {
        ImmutableList.Builder binaryPaths = new ImmutableList.Builder();
        binaryPaths.add((Object)FilePaths.toSystemDependentPath((String)library.getCompileJarFile()));
        binaryPaths.add((Object)FilePaths.toSystemDependentPath((String)library.getResFolder()));
        for (String localJar : library.getLocalJars()) {
            binaryPaths.add((Object)FilePaths.toSystemDependentPath((String)localJar));
        }
        return LibraryDependency.create(library.getArtifact(), (Collection<File>)binaryPaths.build());
    }

    @NotNull
    public static String getDependencyDisplayName(@NotNull IdeLibrary library) {
        String artifactAddress = library.getArtifactAddress();
        GradleCoordinate coordinates = GradleCoordinate.parseCoordinateString((String)artifactAddress);
        if (coordinates != null) {
            GradleVersion version2;
            int index2;
            String groupId;
            String groupSuffix;
            String name = coordinates.getArtifactId();
            if (!name.contains("-") && !(groupSuffix = (groupId = coordinates.getGroupId()).substring((index2 = groupId.lastIndexOf(46)) + 1)).equals(name)) {
                name = groupSuffix + ":" + name;
            }
            if ((version2 = coordinates.getVersion()) != null && !"unspecified".equals(version2.toString())) {
                name = name + ":" + version2;
            }
            return name;
        }
        return StringUtil.trimLeading((String)artifactAddress, (char)':');
    }
}

