/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.common;

import com.android.tools.idea.io.FilePaths;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import java.io.UncheckedIOException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public abstract class ModuleDependenciesSetup {
    private static final Logger LOG = Logger.getInstance(ModuleDependenciesSetup.class);

    protected void updateLibraryRootTypePaths(@NotNull Library library, @NotNull OrderRootType pathType, @NotNull IdeModifiableModelsProvider modelsProvider, File ... paths) {
        if (paths.length == 0) {
            return;
        }
        Library.ModifiableModel libraryModel = modelsProvider.getModifiableLibraryModel(library);
        for (File path2 : paths) {
            libraryModel.addRoot(FilePaths.pathToIdeaUrl((File)path2), pathType);
        }
    }

    protected void addLibraryAsDependency(@NotNull Library library, @NotNull String libraryName, @NotNull DependencyScope scope2, @NotNull Module module2, @NotNull IdeModifiableModelsProvider modelsProvider, boolean exported) {
        for (OrderEntry orderEntry : modelsProvider.getModifiableRootModel(module2).getOrderEntries()) {
            if (!(orderEntry instanceof LibraryOrderEntry)) continue;
            Library entryLibrary = ((LibraryOrderEntry)orderEntry).getLibrary();
            DependencyScope entryScope = ((LibraryOrderEntry)orderEntry).getScope();
            if (entryLibrary == null || !libraryName.equals(entryLibrary.getName()) || !scope2.equals((Object)entryScope)) continue;
            return;
        }
        LibraryOrderEntry orderEntry = modelsProvider.getModifiableRootModel(module2).addLibraryEntry(library);
        orderEntry.setScope(scope2);
        orderEntry.setExported(exported);
        ModuleDependenciesSetup.updateLibraryRootsInFileSystem(orderEntry);
    }

    private static void updateLibraryRootsInFileSystem(@NotNull LibraryOrderEntry orderEntry) {
        VirtualFileManager manager = VirtualFileManager.getInstance();
        for (OrderRootType type : OrderRootType.getAllTypes()) {
            for (String url : orderEntry.getUrls(type)) {
                VirtualFile file2 = manager.findFileByUrl(url);
                if (file2 == null) {
                    file2 = manager.refreshAndFindFileByUrl(url);
                }
                if (file2 != null || !LOG.isDebugEnabled()) continue;
                LOG.debug(String.format("Can't find %s of the library '%s' at path '%s'", type, orderEntry.getLibraryName(), url));
            }
        }
    }

    protected static boolean isLibraryValid(@NotNull Library.ModifiableModel library, @NotNull File[] binaryPaths) {
        if (library.isChanged()) {
            return true;
        }
        String[] cachedUrls = library.getUrls(OrderRootType.CLASSES);
        if (cachedUrls.length != binaryPaths.length) {
            return false;
        }
        if (binaryPaths.length == 0) {
            return true;
        }
        String newUrl = VfsUtil.getUrlForLibraryRoot((File)binaryPaths[0]);
        for (String url : cachedUrls) {
            try {
                if (!Objects.equals(url, newUrl)) continue;
                return true;
            }
            catch (UncheckedIOException ignored) {
                return false;
            }
        }
        return false;
    }
}

