/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues.processor;

import com.android.tools.idea.gradle.dsl.api.ExternalNativeBuildModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.api.android.AndroidModel;
import com.android.tools.idea.gradle.dsl.api.ext.ResolvedPropertyModel;
import com.android.tools.idea.gradle.dsl.model.GradleDslBlockModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001b\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\bH\u0016J\u001b\u0010\u0013\u001a\u00020\u00142\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016\u00a2\u0006\u0002\u0010\u0015R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/gradle/project/sync/issues/processor/FixNdkVersionProcessor;", "Lcom/intellij/refactoring/BaseRefactoringProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "buildFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "version", "", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Ljava/lang/String;)V", "createUsageViewDescriptor", "Lcom/intellij/usageView/UsageViewDescriptor;", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "([Lcom/intellij/usageView/UsageInfo;)Lcom/intellij/usageView/UsageViewDescriptor;", "findUsages", "()[Lcom/intellij/usageView/UsageInfo;", "getCommandName", "performRefactoring", "", "([Lcom/intellij/usageView/UsageInfo;)V", "intellij.android.core"})
public final class FixNdkVersionProcessor
extends BaseRefactoringProcessor {
    private final List<VirtualFile> buildFiles;
    private final String version;

    @NotNull
    public UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        return new UsageViewDescriptor(){

            @NotNull
            public String getCodeReferencesText(int usagesCount, int filesCount) {
                return "Values to update " + UsageViewBundle.getReferencesString((int)usagesCount, (int)filesCount);
            }

            @NotNull
            public PsiElement[] getElements() {
                return PsiElement.EMPTY_ARRAY;
            }

            @NotNull
            public String getProcessedElementsHeader() {
                return "Update Android NDK Versions";
            }
        };
    }

    @NotNull
    public UsageInfo[] findUsages() {
        ProjectBuildModel projectBuildModel2 = ProjectBuildModel.get(this.myProject);
        ArrayList<UsageInfo> usages = new ArrayList<UsageInfo>();
        for (VirtualFile file2 : this.buildFiles) {
            ResolvedPropertyModel ndkVersion2;
            if (!file2.isValid() || !file2.isWritable()) continue;
            AndroidModel android = projectBuildModel2.getModuleBuildModel(file2).android();
            ExternalNativeBuildModel externalNativeBuildModel = android.externalNativeBuild();
            if (externalNativeBuildModel == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.android.tools.idea.gradle.dsl.model.GradleDslBlockModel");
            }
            GradleDslBlockModel externalNativeBuild = (GradleDslBlockModel)((Object)externalNativeBuildModel);
            if (!externalNativeBuild.hasValidPsiElement() || Intrinsics.areEqual((Object)this.version, (Object)(ndkVersion2 = android.ndkVersion()).toString())) continue;
            PsiElement element2 = ndkVersion2.getFullExpressionPsiElement();
            if (element2 != null) {
                usages.add(new UsageInfo(element2));
                continue;
            }
            AndroidModel androidModel = android;
            if (androidModel == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.android.tools.idea.gradle.dsl.model.GradleDslBlockModel");
            }
            PsiElement psiElement = ((GradleDslBlockModel)((Object)androidModel)).getPsiElement();
            if (psiElement == null) {
                Intrinsics.throwNpe();
            }
            usages.add(new UsageInfo(psiElement));
        }
        Collection $this$toTypedArray$iv = usages;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        UsageInfo[] usageInfoArray = thisCollection$iv.toArray(new UsageInfo[0]);
        if (usageInfoArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return usageInfoArray;
    }

    public void performRefactoring(@NotNull UsageInfo[] usages) {
        ProjectBuildModel projectBuildModel2 = ProjectBuildModel.get(this.myProject);
        for (VirtualFile file2 : this.buildFiles) {
            AndroidModel android = projectBuildModel2.getModuleBuildModel(file2).android();
            ExternalNativeBuildModel externalNativeBuildModel = android.externalNativeBuild();
            if (externalNativeBuildModel == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.android.tools.idea.gradle.dsl.model.GradleDslBlockModel");
            }
            GradleDslBlockModel externalNativeBuild = (GradleDslBlockModel)((Object)externalNativeBuildModel);
            if (!externalNativeBuild.hasValidPsiElement()) continue;
            ResolvedPropertyModel ndkVersion2 = android.ndkVersion();
            ndkVersion2.setValue(this.version);
        }
        projectBuildModel2.applyChanges();
        GradleSyncInvoker.getInstance().requestProjectSync(this.myProject, GradleSyncStats.Trigger.TRIGGER_QF_NDK_INSTALLED);
    }

    @NotNull
    public String getCommandName() {
        return "Update Android NDK Version";
    }

    public FixNdkVersionProcessor(@NotNull Project project, @NotNull List<? extends VirtualFile> buildFiles, @NotNull String version2) {
        super(project);
        this.buildFiles = buildFiles;
        this.version = version2;
    }
}

