/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea;

import com.android.tools.idea.io.FilePaths;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;

public class ProjectFinder {
    @Nullable
    private Project findProject(@NotNull String projectPath) {
        if (StringUtil.isNotEmpty((String)projectPath)) {
            File projectFolderPath = FilePaths.toSystemDependentPath((String)projectPath);
            for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                if (!ProjectFinder.hasMatchingPath(project, projectFolderPath)) continue;
                return project;
            }
        }
        return null;
    }

    @Nullable
    Project findProject(@NotNull ProjectResolverContext context) {
        String projectPath = context.getProjectPath();
        return this.findProject(projectPath);
    }

    private static boolean hasMatchingPath(@NotNull Project project, @NotNull File path2) {
        File currentPath;
        String basePath = project.getBasePath();
        return basePath != null && FileUtil.filesEqual((File)path2, (File)(currentPath = new File(basePath)));
    }
}

