/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea;

import com.android.ide.common.gradle.model.IdeAndroidProject;
import com.android.ide.common.gradle.model.IdeBaseArtifact;
import com.android.ide.common.gradle.model.IdeVariant;
import com.android.ide.common.gradle.model.ndk.v1.IdeNativeVariantAbi;
import com.android.ide.common.repository.GradleVersion;
import com.android.ide.gradle.model.GradlePluginModel;
import com.android.ide.gradle.model.artifacts.AdditionalClassifierArtifacts;
import com.android.ide.gradle.model.artifacts.AdditionalClassifierArtifactsModel;
import com.android.repository.Revision;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.LibraryFilePaths;
import com.android.tools.idea.gradle.plugin.LatestKnownPluginVersionProvider;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.project.model.IdeaJavaModuleModelFactory;
import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.model.V1NdkModel;
import com.android.tools.idea.gradle.project.model.V2NdkModel;
import com.android.tools.idea.gradle.project.sync.AdditionalClassifierArtifactsActionOptions;
import com.android.tools.idea.gradle.project.sync.FullSyncActionOptions;
import com.android.tools.idea.gradle.project.sync.Modules;
import com.android.tools.idea.gradle.project.sync.NativeVariantsSyncActionOptions;
import com.android.tools.idea.gradle.project.sync.SdkSync;
import com.android.tools.idea.gradle.project.sync.SelectedVariantCollector;
import com.android.tools.idea.gradle.project.sync.SelectedVariants;
import com.android.tools.idea.gradle.project.sync.SimulatedSyncErrors;
import com.android.tools.idea.gradle.project.sync.SingleVariantSyncActionOptions;
import com.android.tools.idea.gradle.project.sync.SyncActionOptions;
import com.android.tools.idea.gradle.project.sync.common.CommandLineArgs;
import com.android.tools.idea.gradle.project.sync.errors.GradleDistributionInstallIssueCheckerKt;
import com.android.tools.idea.gradle.project.sync.idea.AdditionalArtifactsPaths;
import com.android.tools.idea.gradle.project.sync.idea.CompilerOutputUtilKt;
import com.android.tools.idea.gradle.project.sync.idea.ContentRootUtilKt;
import com.android.tools.idea.gradle.project.sync.idea.DependencyUtilKt;
import com.android.tools.idea.gradle.project.sync.idea.GradleSyncExecutor;
import com.android.tools.idea.gradle.project.sync.idea.HttpProxySettingsCleanUp;
import com.android.tools.idea.gradle.project.sync.idea.IdeAndroidNativeVariantsModelsWrapper;
import com.android.tools.idea.gradle.project.sync.idea.ProjectFinder;
import com.android.tools.idea.gradle.project.sync.idea.ProjectResolutionMode;
import com.android.tools.idea.gradle.project.sync.idea.SdkSyncUtil;
import com.android.tools.idea.gradle.project.sync.idea.TraceSyncUtil;
import com.android.tools.idea.gradle.project.sync.idea.data.model.ProjectCleanupModel;
import com.android.tools.idea.gradle.project.sync.idea.data.service.AndroidProjectKeys;
import com.android.tools.idea.gradle.project.sync.idea.issues.AgpUpgradeRequiredException;
import com.android.tools.idea.gradle.project.sync.idea.issues.GradleWrapperImportCheck;
import com.android.tools.idea.gradle.project.sync.idea.issues.JdkImportCheck;
import com.android.tools.idea.gradle.project.sync.idea.svs.AndroidExtraModelProvider;
import com.android.tools.idea.gradle.project.sync.idea.svs.CachedVariants;
import com.android.tools.idea.gradle.project.sync.idea.svs.IdeAndroidModels;
import com.android.tools.idea.gradle.project.sync.idea.svs.IdeAndroidModelsKt;
import com.android.tools.idea.gradle.project.sync.idea.svs.IdeAndroidNativeVariantsModels;
import com.android.tools.idea.gradle.project.sync.idea.svs.IdeAndroidSyncError;
import com.android.tools.idea.gradle.project.sync.issues.SyncIssueData;
import com.android.tools.idea.gradle.project.upgrade.GradlePluginUpgrade;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.gradle.variant.view.BuildVariantUpdater;
import com.android.tools.idea.io.FilePaths;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.stats.UsageTrackerUtils;
import com.android.utils.BuildScriptUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.externalSystem.JavaModuleData;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryLevel;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.kapt.idea.KaptGradleModel;
import org.jetbrains.kotlin.kapt.idea.KaptModelBuilderService;
import org.jetbrains.kotlin.kapt.idea.KaptSourceSetModel;
import org.jetbrains.plugins.gradle.model.BuildScriptClasspathModel;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalSourceSet;
import org.jetbrains.plugins.gradle.model.ProjectImportModelProvider;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.settings.GradleExecutionWorkspace;

@Order(value=1000)
public final class AndroidGradleProjectResolver
extends AbstractProjectResolverExtension {
    public static final GradleVersion MINIMUM_SUPPORTED_VERSION = GradleVersion.parse((String)"1.0.0");
    public static final String BUILD_SYNC_ORPHAN_MODULES_NOTIFICATION_GROUP_NAME = "Build sync orphan modules";
    private static final Key<Boolean> IS_ANDROID_PROJECT_KEY = Key.create((String)"IS_ANDROID_PROJECT_KEY");
    public static final Key<ProjectResolutionMode> REQUESTED_PROJECT_RESOLUTION_MODE_KEY = Key.create((String)"REQUESTED_PROJECT_RESOLUTION_MODE");
    static final Logger RESOLVER_LOG = Logger.getInstance(AndroidGradleProjectResolver.class);
    @NotNull
    private final CommandLineArgs myCommandLineArgs;
    @NotNull
    private final ProjectFinder myProjectFinder;
    @NotNull
    private final IdeaJavaModuleModelFactory myIdeaJavaModuleModelFactory;
    private boolean myShouldExportDependencies;

    public AndroidGradleProjectResolver() {
        this(new CommandLineArgs(), new ProjectFinder(), new IdeaJavaModuleModelFactory());
    }

    @NonInjectable
    @VisibleForTesting
    AndroidGradleProjectResolver(@NotNull CommandLineArgs commandLineArgs, @NotNull ProjectFinder projectFinder, @NotNull IdeaJavaModuleModelFactory ideaJavaModuleModelFactory) {
        this.myCommandLineArgs = commandLineArgs;
        this.myProjectFinder = projectFinder;
        this.myIdeaJavaModuleModelFactory = ideaJavaModuleModelFactory;
    }

    @Nullable
    public DataNode<ModuleData> createModule(@NotNull IdeaModule gradleModule, @NotNull DataNode<ProjectData> projectDataNode) {
        DataNode moduleDataNode2;
        if (!this.isAndroidGradleProject()) {
            return this.nextResolver.createModule(gradleModule, projectDataNode);
        }
        IdeAndroidModels androidModels = (IdeAndroidModels)this.resolverCtx.getExtraProject(gradleModule, IdeAndroidModels.class);
        if (androidModels != null) {
            String modelVersionString = androidModels.getAndroidProject().getModelVersion();
            this.validateModelVersion(modelVersionString);
        }
        if ((moduleDataNode2 = this.nextResolver.createModule(gradleModule, projectDataNode)) == null) {
            return null;
        }
        this.createAndAttachModelsToDataNode((DataNode<ModuleData>)moduleDataNode2, gradleModule, androidModels);
        if (androidModels != null) {
            CompilerOutputUtilKt.setupCompilerOutputPaths((DataNode<ModuleData>)moduleDataNode2);
        }
        this.patchLanguageLevels((DataNode<ModuleData>)moduleDataNode2, gradleModule, androidModels != null ? androidModels.getAndroidProject() : null);
        return moduleDataNode2;
    }

    private void patchLanguageLevels(DataNode<ModuleData> moduleDataNode2, @NotNull IdeaModule gradleModule, @Nullable IdeAndroidProject androidProject) {
        DataNode javaModuleData = ExternalSystemApiUtil.find(moduleDataNode2, (com.intellij.openapi.externalSystem.model.Key)JavaModuleData.KEY);
        if (javaModuleData == null) {
            return;
        }
        JavaModuleData moduleData = (JavaModuleData)javaModuleData.getData();
        if (androidProject != null) {
            LanguageLevel languageLevel = LanguageLevel.parse((String)androidProject.getJavaCompileOptions().getSourceCompatibility());
            moduleData.setLanguageLevel(languageLevel);
            moduleData.setTargetBytecodeVersion(androidProject.getJavaCompileOptions().getTargetCompatibility());
        } else {
            ExternalSourceSet externalSourceSet;
            ExternalProject externalProject = (ExternalProject)this.resolverCtx.getExtraProject(gradleModule, ExternalProject.class);
            if (externalProject != null && (externalSourceSet = (ExternalSourceSet)externalProject.getSourceSets().get("main")) != null) {
                LanguageLevel languageLevel = LanguageLevel.parse((String)externalSourceSet.getSourceCompatibility());
                moduleData.setLanguageLevel(languageLevel);
                moduleData.setTargetBytecodeVersion(externalSourceSet.getTargetCompatibility());
            }
        }
    }

    private void validateModelVersion(@NotNull String modelVersionString) {
        boolean result2;
        GradleVersion modelVersion = !Strings.isNullOrEmpty((String)modelVersionString) ? GradleVersion.tryParseAndroidGradlePluginVersion((String)modelVersionString) : null;
        boolean bl = result2 = modelVersion != null && modelVersion.compareTo(MINIMUM_SUPPORTED_VERSION) >= 0;
        if (!result2) {
            AndroidStudioEvent.Builder event = AndroidStudioEvent.newBuilder();
            event.setCategory(AndroidStudioEvent.EventCategory.GRADLE_SYNC).setKind(AndroidStudioEvent.EventKind.GRADLE_SYNC_FAILURE_DETAILS).setGradleSyncFailure(AndroidStudioEvent.GradleSyncFailure.UNSUPPORTED_ANDROID_MODEL_VERSION).setGradleVersion(modelVersionString);
            UsageTrackerUtils.withProjectId(event, this.myProjectFinder.findProject(this.resolverCtx));
            UsageTracker.log((AndroidStudioEvent.Builder)event);
            String msg = AndroidGradleProjectResolver.getUnsupportedModelVersionErrorMsg(modelVersion);
            throw new IllegalStateException(msg);
        }
        Project project = this.myProjectFinder.findProject(this.resolverCtx);
        GradleVersion currentAgpVersion = GradleVersion.tryParse((String)modelVersionString);
        GradleVersion latestVersion = GradleVersion.parse((String)LatestKnownPluginVersionProvider.INSTANCE.get());
        if (currentAgpVersion != null && GradlePluginUpgrade.shouldForcePluginUpgrade(project, currentAgpVersion, latestVersion)) {
            throw new AgpUpgradeRequiredException(project, currentAgpVersion);
        }
    }

    @NotNull
    public Set<Class<?>> getToolingExtensionsClasses() {
        return ImmutableSet.of(KaptModelBuilderService.class, Unit.class);
    }

    private void createAndAttachModelsToDataNode(@NotNull DataNode<ModuleData> moduleNode, @NotNull IdeaModule gradleModule, @Nullable IdeAndroidModels androidModels) {
        boolean hasArtifactsOrNoRootSettingsFile;
        String moduleName2 = ((ModuleData)moduleNode.getData()).getInternalName();
        File rootModulePath = FilePaths.toSystemDependentPath((String)((ModuleData)moduleNode.getData()).getLinkedExternalProjectPath());
        @NotNull CachedVariants cachedVariants = this.findCachedVariants(gradleModule);
        ExternalProject externalProject = (ExternalProject)this.resolverCtx.getExtraProject(gradleModule, ExternalProject.class);
        KaptGradleModel kaptGradleModel = (KaptGradleModel)this.resolverCtx.getExtraProject(gradleModule, KaptGradleModel.class);
        GradlePluginModel gradlePluginModel = (GradlePluginModel)this.resolverCtx.getExtraProject(gradleModule, GradlePluginModel.class);
        BuildScriptClasspathModel buildScriptClasspathModel = (BuildScriptClasspathModel)this.resolverCtx.getExtraProject(gradleModule, BuildScriptClasspathModel.class);
        AndroidModuleModel androidModel = null;
        JavaModuleModel javaModuleModel = null;
        NdkModuleModel ndkModuleModel = null;
        GradleModuleModel gradleModel = null;
        List<SyncIssueData> issueData = null;
        if (androidModels != null) {
            androidModel = AndroidGradleProjectResolver.createAndroidModuleModel(moduleName2, rootModulePath, androidModels, cachedVariants);
            issueData = androidModels.getSyncIssues();
            ndkModuleModel = AndroidGradleProjectResolver.maybeCreateNdkModuleModel(moduleName2, rootModulePath, androidModels, cachedVariants);
            this.myShouldExportDependencies |= androidModel.getFeatures().shouldExportDependencies();
        }
        Object gradlePluginList = gradlePluginModel == null ? ImmutableList.of() : gradlePluginModel.getGradlePluginList();
        File gradleSettingsFile = BuildScriptUtil.findGradleSettingsFile((File)rootModulePath);
        boolean bl = hasArtifactsOrNoRootSettingsFile = !gradleSettingsFile.isFile() || AndroidGradleProjectResolver.hasArtifacts(externalProject);
        if (hasArtifactsOrNoRootSettingsFile || androidModel != null) {
            gradleModel = AndroidGradleProjectResolver.createGradleModuleModel(moduleName2, gradleModule, androidModels == null ? null : androidModels.getAndroidProject().getModelVersion(), kaptGradleModel, buildScriptClasspathModel, (Collection<String>)gradlePluginList);
        }
        if (androidModel == null) {
            javaModuleModel = this.createJavaModuleModel(gradleModule, externalProject, (Collection<String>)gradlePluginList, hasArtifactsOrNoRootSettingsFile);
        }
        if (javaModuleModel != null) {
            moduleNode.createChild(AndroidProjectKeys.JAVA_MODULE_MODEL, javaModuleModel);
        }
        if (gradleModel != null) {
            moduleNode.createChild(AndroidProjectKeys.GRADLE_MODULE_MODEL, (Object)gradleModel);
        }
        if (androidModel != null) {
            moduleNode.createChild(AndroidProjectKeys.ANDROID_MODEL, (Object)androidModel);
        }
        if (ndkModuleModel != null) {
            moduleNode.createChild(AndroidProjectKeys.NDK_MODEL, (Object)ndkModuleModel);
        }
        if (issueData != null) {
            issueData.forEach(it -> moduleNode.createChild(AndroidProjectKeys.SYNC_ISSUE, it));
        }
        AndroidGradleProjectResolver.patchMissingKaptInformationOntoModelAndDataNode(androidModel, moduleNode, kaptGradleModel);
        this.populateAdditionalClassifierArtifactsModel(gradleModule);
    }

    @NotNull
    private JavaModuleModel createJavaModuleModel(@NotNull IdeaModule gradleModule, ExternalProject externalProject, Collection<String> gradlePluginList, boolean hasArtifactsOrNoRootSettingsFile) {
        boolean isBuildable = hasArtifactsOrNoRootSettingsFile && gradlePluginList.contains("org.gradle.api.plugins.JavaPlugin");
        return this.myIdeaJavaModuleModelFactory.create(gradleModule, externalProject, isBuildable);
    }

    @NotNull
    private static GradleModuleModel createGradleModuleModel(String moduleName2, @NotNull IdeaModule gradleModule, @Nullable String modelVersionString, KaptGradleModel kaptGradleModel, BuildScriptClasspathModel buildScriptClasspathModel, Collection<String> gradlePluginList) {
        File buildScriptPath;
        try {
            buildScriptPath = gradleModule.getGradleProject().getBuildScript().getSourceFile();
        }
        catch (UnsupportedOperationException e) {
            buildScriptPath = null;
        }
        return new GradleModuleModel(moduleName2, gradleModule.getGradleProject(), gradlePluginList, buildScriptPath, buildScriptClasspathModel == null ? null : buildScriptClasspathModel.getGradleVersion(), modelVersionString, kaptGradleModel);
    }

    @Nullable
    private static NdkModuleModel maybeCreateNdkModuleModel(@NotNull String moduleName2, @NotNull File rootModulePath, @NotNull IdeAndroidModels ideModels, @NotNull CachedVariants cachedVariants) {
        if (ideModels.getV2NativeModule() != null) {
            return new NdkModuleModel(moduleName2, rootModulePath, new V2NdkModel(ideModels.getAndroidProject().getModelVersion(), ideModels.getV2NativeModule()));
        }
        if (ideModels.getV1NativeProject() != null) {
            ArrayList<IdeNativeVariantAbi> ideNativeVariantAbis = new ArrayList<IdeNativeVariantAbi>();
            if (ideModels.getV1NativeVariantAbis() != null) {
                ideNativeVariantAbis.addAll(ideModels.getV1NativeVariantAbis());
            }
            ideNativeVariantAbis.addAll(cachedVariants.getNativeVariantsExcept(ideNativeVariantAbis));
            return new NdkModuleModel(moduleName2, rootModulePath, ideModels.getV1NativeProject(), ideNativeVariantAbis);
        }
        return null;
    }

    @NotNull
    private static AndroidModuleModel createAndroidModuleModel(String moduleName2, File rootModulePath, @NotNull IdeAndroidModels ideModels, @NotNull CachedVariants cachedVariants) {
        List<IdeVariant> filteredCachedVariants = cachedVariants.getVariantsExcept(ideModels.getFetchedVariants());
        List variants = ContainerUtil.concat(ideModels.getFetchedVariants(), filteredCachedVariants);
        return AndroidModuleModel.create(moduleName2, rootModulePath, ideModels.getAndroidProject(), variants, ideModels.getSelectedVariantName());
    }

    @NotNull
    private CachedVariants findCachedVariants(@NotNull IdeaModule ideaModule) {
        Project project = this.myProjectFinder.findProject(this.resolverCtx);
        if (project == null) {
            return CachedVariants.EMPTY;
        }
        Boolean useCachedVariants = (Boolean)project.getUserData(BuildVariantUpdater.USE_VARIANTS_FROM_PREVIOUS_GRADLE_SYNCS);
        if (useCachedVariants == null || !useCachedVariants.booleanValue()) {
            return CachedVariants.EMPTY;
        }
        String moduleId = Modules.createUniqueModuleId(ideaModule.getGradleProject());
        for (Module module2 : ModuleManager.getInstance((Project)project).getModules()) {
            NdkModel ndkModel;
            NdkModuleModel ndkModuleModel;
            if (!moduleId.equals(BuildVariantUpdater.getModuleIdForModule(module2))) continue;
            List cachedGradleVariants = Collections.emptyList();
            List<Object> cachedNativeVariants = Collections.emptyList();
            AndroidModuleModel androidModel = AndroidModuleModel.get(module2);
            if (androidModel != null) {
                cachedGradleVariants = androidModel.getVariants();
            }
            if ((ndkModuleModel = NdkModuleModel.get(module2)) != null && (ndkModel = ndkModuleModel.getNdkModel()) instanceof V1NdkModel) {
                cachedNativeVariants = ((V1NdkModel)ndkModel).getNativeVariantAbis();
            }
            return new CachedVariants(cachedGradleVariants, cachedNativeVariants);
        }
        return CachedVariants.EMPTY;
    }

    private static void patchMissingKaptInformationOntoModelAndDataNode(@Nullable AndroidModuleModel androidModel, @NotNull DataNode<ModuleData> moduleDataNode2, @Nullable KaptGradleModel kaptGradleModel) {
        if (kaptGradleModel == null || !kaptGradleModel.isEnabled()) {
            return;
        }
        HashSet generatedClassesDirs = new HashSet();
        kaptGradleModel.getSourceSets().forEach(sourceSet -> {
            File classesDirFile;
            IdeBaseArtifact artifact;
            File kotlinGenSourceDir = sourceSet.getGeneratedKotlinSourcesDirFile();
            if (androidModel != null && (artifact = AndroidGradleProjectResolver.findArtifact(sourceSet, androidModel)) != null && kotlinGenSourceDir != null) {
                artifact.addGeneratedSourceFolder(kotlinGenSourceDir);
            }
            if ((classesDirFile = sourceSet.getGeneratedClassesDirFile()) != null) {
                generatedClassesDirs.add(classesDirFile);
            }
        });
        LibraryData newLibrary = new LibraryData(GradleUtil.GRADLE_SYSTEM_ID, "kaptGeneratedClasses");
        LibraryData existingData = moduleDataNode2.getChildren().stream().map(node2 -> node2.getData()).filter(data -> data instanceof LibraryDependencyData && newLibrary.getExternalName().equals(((LibraryDependencyData)data).getExternalName())).map(data -> (LibraryData)((LibraryDependencyData)data).getTarget()).findFirst().orElse(null);
        if (existingData != null) {
            generatedClassesDirs.forEach(file2 -> existingData.addPath(LibraryPathType.BINARY, file2.getAbsolutePath()));
        } else {
            generatedClassesDirs.forEach(file2 -> newLibrary.addPath(LibraryPathType.BINARY, file2.getAbsolutePath()));
            LibraryDependencyData libraryDependencyData = new LibraryDependencyData((ModuleData)moduleDataNode2.getData(), newLibrary, LibraryLevel.MODULE);
            moduleDataNode2.createChild(ProjectKeys.LIBRARY_DEPENDENCY, (Object)libraryDependencyData);
        }
    }

    @Nullable
    private static IdeBaseArtifact findArtifact(@NotNull KaptSourceSetModel sourceSetModel, @NotNull AndroidModuleModel androidModel) {
        String sourceSetName = sourceSetModel.getSourceSetName();
        if (!sourceSetModel.isTest()) {
            IdeVariant variant2 = androidModel.findVariantByName(sourceSetName);
            return variant2 == null ? null : variant2.getMainArtifact();
        }
        String androidTestSuffix = "AndroidTest";
        if (sourceSetName.endsWith(androidTestSuffix)) {
            String variantName = sourceSetName.substring(0, sourceSetName.length() - androidTestSuffix.length());
            IdeVariant variant3 = androidModel.findVariantByName(variantName);
            return variant3 == null ? null : variant3.getAndroidTestArtifact();
        }
        String unitTestSuffix = "UnitTest";
        if (sourceSetName.endsWith(unitTestSuffix)) {
            String variantName = sourceSetName.substring(0, sourceSetName.length() - unitTestSuffix.length());
            IdeVariant variant4 = androidModel.findVariantByName(variantName);
            return variant4 == null ? null : variant4.getUnitTestArtifact();
        }
        return null;
    }

    private void populateAdditionalClassifierArtifactsModel(@NotNull IdeaModule gradleModule) {
        Project project = this.myProjectFinder.findProject(this.resolverCtx);
        AdditionalClassifierArtifactsModel artifacts = (AdditionalClassifierArtifactsModel)this.resolverCtx.getExtraProject(gradleModule, AdditionalClassifierArtifactsModel.class);
        if (artifacts != null && project != null) {
            LibraryFilePaths.getInstance(project).populate(artifacts);
        }
    }

    public void populateModuleContentRoots(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        this.nextResolver.populateModuleContentRoots(gradleModule, ideModule);
        ContentRootUtilKt.setupAndroidContentEntries(ideModule);
    }

    private static boolean hasArtifacts(@Nullable ExternalProject externalProject) {
        return externalProject != null && !externalProject.getArtifacts().isEmpty();
    }

    public void populateModuleCompileOutputSettings(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        if (!this.isAndroidGradleProject()) {
            this.nextResolver.populateModuleCompileOutputSettings(gradleModule, ideModule);
        }
    }

    public void populateModuleDependencies(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule, @NotNull DataNode<ProjectData> ideProject) {
        this.nextResolver.populateModuleDependencies(gradleModule, ideModule, ideProject);
        if (this.myShouldExportDependencies) {
            Collection libraryDataNodes = ExternalSystemApiUtil.findAll(ideModule, (com.intellij.openapi.externalSystem.model.Key)ProjectKeys.LIBRARY_DEPENDENCY);
            for (Object libraryDataNode : libraryDataNodes) {
                ((LibraryDependencyData)libraryDataNode.getData()).setExported(true);
            }
            Collection moduleDataNodes = ExternalSystemApiUtil.findAll(ideModule, (com.intellij.openapi.externalSystem.model.Key)ProjectKeys.MODULE_DEPENDENCY);
            for (DataNode moduleDataNode2 : moduleDataNodes) {
                ((ModuleDependencyData)moduleDataNode2.getData()).setExported(true);
            }
        }
        AdditionalClassifierArtifactsModel additionalArtifacts = (AdditionalClassifierArtifactsModel)this.resolverCtx.getExtraProject(gradleModule, AdditionalClassifierArtifactsModel.class);
        GradleExecutionSettings settings = this.resolverCtx.getSettings();
        GradleExecutionWorkspace workspace = settings == null ? null : settings.getExecutionWorkspace();
        Object additionalArtifactsMap = additionalArtifacts != null ? additionalArtifacts.getArtifacts().stream().collect(Collectors.toMap(k -> String.format("%s:%s:%s", k.getId().getGroupId(), k.getId().getArtifactId(), k.getId().getVersion()), k -> k)) : ImmutableMap.of();
        Project project = this.myProjectFinder.findProject(this.resolverCtx);
        LibraryFilePaths libraryFilePaths = project == null ? null : LibraryFilePaths.getInstance(project);
        DependencyUtilKt.setupAndroidDependenciesForModule(ideModule, (Function1<? super String, ? extends ModuleData>)((Function1)id -> {
            if (workspace != null) {
                return workspace.findModuleDataByModuleId(id);
            }
            return null;
        }), (Function2<? super String, ? super File, AdditionalArtifactsPaths>)((Function2)(arg_0, arg_1) -> AndroidGradleProjectResolver.lambda$populateModuleDependencies$10((Map)additionalArtifactsMap, libraryFilePaths, arg_0, arg_1)));
    }

    public void resolveFinished(@NotNull DataNode<ProjectData> projectDataNode) {
        AndroidGradleProjectResolver.disableOrphanModuleNotifications();
    }

    private static void disableOrphanModuleNotifications() {
        if (IdeInfo.getInstance().isAndroidStudio()) {
            NotificationsConfiguration.getNotificationsConfiguration().changeSettings(BUILD_SYNC_ORPHAN_MODULES_NOTIFICATION_GROUP_NAME, NotificationDisplayType.NONE, false, false);
        }
    }

    private boolean isAndroidGradleProject() {
        Boolean isAndroidGradleProject = (Boolean)this.resolverCtx.getUserData(IS_ANDROID_PROJECT_KEY);
        if (isAndroidGradleProject != null) {
            return isAndroidGradleProject;
        }
        isAndroidGradleProject = this.resolverCtx.hasModulesWithModel(IdeAndroidModels.class);
        return (Boolean)this.resolverCtx.putUserDataIfAbsent(IS_ANDROID_PROJECT_KEY, (Object)isAndroidGradleProject);
    }

    public void populateProjectExtraModels(@NotNull IdeaProject gradleProject, @NotNull DataNode<ProjectData> projectDataNode) {
        IdeAndroidSyncError syncError = (IdeAndroidSyncError)this.resolverCtx.getModels().getModel(IdeAndroidSyncError.class);
        if (syncError != null) {
            throw IdeAndroidModelsKt.ideAndroidSyncErrorToException(syncError);
        }
        for (IdeaModule gradleModule : gradleProject.getModules()) {
            IdeAndroidNativeVariantsModels nativeVariants = (IdeAndroidNativeVariantsModels)this.resolverCtx.getExtraProject(gradleModule, IdeAndroidNativeVariantsModels.class);
            if (nativeVariants == null) continue;
            projectDataNode.createChild(AndroidProjectKeys.NATIVE_VARIANTS, (Object)new IdeAndroidNativeVariantsModelsWrapper(GradleProjectResolverUtil.getModuleId((ProjectResolverContext)this.resolverCtx, (IdeaModule)gradleModule), nativeVariants));
        }
        if (this.isAndroidGradleProject()) {
            projectDataNode.createChild(AndroidProjectKeys.PROJECT_CLEANUP_MODEL, (Object)ProjectCleanupModel.getInstance());
        }
        super.populateProjectExtraModels(gradleProject, projectDataNode);
    }

    @NotNull
    public Set<Class<?>> getExtraProjectModelClasses() {
        throw new UnsupportedOperationException("getExtraProjectModelClasses() is not used when getModelProvider() is overridden.");
    }

    @NotNull
    public ProjectImportModelProvider getModelProvider() {
        return this.configureAndGetExtraModelProvider();
    }

    public void preImportCheck() {
        if (this.resolverCtx.getBuildSrcGroup() != null) {
            return;
        }
        SimulatedSyncErrors.simulateRegisteredSyncError();
        SdkSyncUtil.syncAndroidSdks(SdkSync.getInstance(), this.resolverCtx.getProjectPath());
        JdkImportCheck.validateJdk();
        GradleWrapperImportCheck.validateGradleWrapper(this.resolverCtx.getProjectPath());
        this.displayInternalWarningIfForcedUpgradesAreDisabled();
        GradlePluginUpgrade.expireProjectUpgradeNotifications(this.myProjectFinder.findProject(this.resolverCtx));
        this.cleanUpHttpProxySettings();
    }

    @NotNull
    public List<Pair<String, String>> getExtraJvmArgs() {
        if (ExternalSystemApiUtil.isInProcessMode((ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID)) {
            ArrayList<Pair<String, String>> args = new ArrayList<Pair<String, String>>();
            if (IdeInfo.getInstance().isAndroidStudio()) {
                TraceSyncUtil.addTraceJvmArgs(args);
            } else {
                File androidHomePath;
                LocalProperties localProperties = this.getLocalProperties();
                if (localProperties.getAndroidSdkPath() == null && (androidHomePath = IdeSdks.getInstance().getAndroidSdkPath()) != null) {
                    args.add((Pair<String, String>)Pair.create((Object)"android.home", (Object)androidHomePath.getPath()));
                }
            }
            return args;
        }
        return Collections.emptyList();
    }

    @NotNull
    private LocalProperties getLocalProperties() {
        File projectDir = FilePaths.toSystemDependentPath((String)this.resolverCtx.getProjectPath());
        try {
            return new LocalProperties(projectDir);
        }
        catch (IOException e) {
            String msg = String.format("Unable to read local.properties file in project '%1$s'", projectDir.getPath());
            throw new ExternalSystemException(msg, (Throwable)e, new String[0]);
        }
    }

    @NotNull
    public List<String> getExtraCommandLineArgs() {
        Project project = this.myProjectFinder.findProject(this.resolverCtx);
        return this.myCommandLineArgs.get(project);
    }

    @NotNull
    public ExternalSystemException getUserFriendlyError(@Nullable BuildEnvironment buildEnvironment, @NotNull Throwable error, @NotNull String projectPath, @Nullable String buildFilePath) {
        String msg = error.getMessage();
        if (msg != null && !msg.contains("The project is using an unsupported version of the Android Gradle plug-in")) {
            Throwable rootCause = ExceptionUtil.getRootCause((Throwable)error);
            if (rootCause instanceof ClassNotFoundException) {
                msg = rootCause.getMessage();
                if (AndroidGradleProjectResolver.isUsingUnsupportedGradleVersion(msg)) {
                    AndroidStudioEvent.Builder event = AndroidStudioEvent.newBuilder();
                    event.setCategory(AndroidStudioEvent.EventCategory.GRADLE_SYNC).setKind(AndroidStudioEvent.EventKind.GRADLE_SYNC_FAILURE_DETAILS).setGradleSyncFailure(AndroidStudioEvent.GradleSyncFailure.UNSUPPORTED_GRADLE_VERSION);
                    UsageTrackerUtils.withProjectId(event, this.myProjectFinder.findProject(this.resolverCtx));
                    UsageTracker.log((AndroidStudioEvent.Builder)event);
                    return new ExternalSystemException("The project is using an unsupported version of Gradle.");
                }
            } else if (rootCause instanceof ZipException && msg.startsWith(GradleDistributionInstallIssueCheckerKt.COULD_NOT_INSTALL_GRADLE_DISTRIBUTION_PREFIX)) {
                return new ExternalSystemException(msg);
            }
        }
        return super.getUserFriendlyError(buildEnvironment, error, projectPath, buildFilePath);
    }

    private static boolean isUsingUnsupportedGradleVersion(@Nullable String errorMessage) {
        return "org.gradle.api.artifacts.result.ResolvedComponentResult".equals(errorMessage) || "org.gradle.api.artifacts.result.ResolvedModuleVersionResult".equals(errorMessage);
    }

    @NotNull
    private static String getUnsupportedModelVersionErrorMsg(@Nullable GradleVersion modelVersion) {
        StringBuilder builder2 = new StringBuilder();
        builder2.append("The project is using an unsupported version of the Android Gradle plug-in");
        String recommendedVersion = String.format("The recommended version is %1$s.", LatestKnownPluginVersionProvider.INSTANCE.get());
        if (modelVersion != null) {
            builder2.append(String.format(" (%1$s).", modelVersion.toString())).append(" ").append(recommendedVersion);
            if (modelVersion.getMajor() == 0 && modelVersion.getMinor() <= 8) {
                builder2.append("\n\nStarting with version 0.9.0 incompatible changes were introduced in the build language.\n").append("Please read the migration guide").append(" to learn how to update your project.");
            }
        } else {
            builder2.append(". ").append(recommendedVersion);
        }
        return builder2.toString();
    }

    @NotNull
    private AndroidExtraModelProvider configureAndGetExtraModelProvider() {
        SyncActionOptions syncOptions;
        GradleExecutionSettings gradleExecutionSettings = this.resolverCtx.getSettings();
        ProjectResolutionMode projectResolutionMode = AndroidGradleProjectResolver.getRequestedSyncMode(gradleExecutionSettings);
        if (projectResolutionMode == ProjectResolutionMode.SyncProjectMode.INSTANCE) {
            boolean isSingleVariantSync;
            @Nullable Project project = this.myProjectFinder.findProject(this.resolverCtx);
            AdditionalClassifierArtifactsActionOptions additionalClassifierArtifactsAction = new AdditionalClassifierArtifactsActionOptions(project != null ? LibraryFilePaths.getInstance(project).retrieveCachedLibs() : Collections.emptySet(), (Boolean)StudioFlags.SAMPLES_SUPPORT_ENABLED.get());
            boolean bl = isSingleVariantSync = project != null && !AndroidGradleProjectResolver.shouldSyncAllVariants(project);
            if (isSingleVariantSync) {
                SelectedVariantCollector variantCollector = new SelectedVariantCollector(project);
                SelectedVariants selectedVariants = variantCollector.collectSelectedVariants();
                String moduleWithVariantSwitched = (String)project.getUserData(BuildVariantUpdater.MODULE_WITH_BUILD_VARIANT_SWITCHED_FROM_UI);
                project.putUserData(BuildVariantUpdater.MODULE_WITH_BUILD_VARIANT_SWITCHED_FROM_UI, null);
                syncOptions = new SingleVariantSyncActionOptions(selectedVariants, moduleWithVariantSwitched, additionalClassifierArtifactsAction);
            } else {
                syncOptions = new FullSyncActionOptions(additionalClassifierArtifactsAction);
            }
        } else if (projectResolutionMode instanceof ProjectResolutionMode.FetchNativeVariantsMode) {
            ProjectResolutionMode.FetchNativeVariantsMode fetchNativeVariantsMode = (ProjectResolutionMode.FetchNativeVariantsMode)projectResolutionMode;
            syncOptions = new NativeVariantsSyncActionOptions(fetchNativeVariantsMode.getModuleVariants(), fetchNativeVariantsMode.getRequestedAbis());
        } else {
            throw new IllegalStateException("Unknown FetchModelsMode class: " + projectResolutionMode.getClass().getName());
        }
        return new AndroidExtraModelProvider(syncOptions);
    }

    @NotNull
    private static ProjectResolutionMode getRequestedSyncMode(GradleExecutionSettings gradleExecutionSettings) {
        ProjectResolutionMode projectResolutionMode = gradleExecutionSettings != null ? (ProjectResolutionMode)gradleExecutionSettings.getUserData(REQUESTED_PROJECT_RESOLUTION_MODE_KEY) : null;
        return projectResolutionMode != null ? projectResolutionMode : ProjectResolutionMode.SyncProjectMode.INSTANCE;
    }

    private static boolean shouldSyncAllVariants(@NotNull Project project) {
        Boolean shouldSyncAllVariants = (Boolean)project.getUserData(GradleSyncExecutor.FULL_SYNC_KEY);
        return shouldSyncAllVariants != null && shouldSyncAllVariants != false;
    }

    private void displayInternalWarningIfForcedUpgradesAreDisabled() {
        Project project;
        if (((Boolean)StudioFlags.DISABLE_FORCED_UPGRADES.get()).booleanValue() && (project = this.myProjectFinder.findProject(this.resolverCtx)) != null) {
            GradlePluginUpgrade.displayForceUpdatesDisabledMessage(project);
        }
    }

    private void cleanUpHttpProxySettings() {
        Project project = this.myProjectFinder.findProject(this.resolverCtx);
        if (project != null) {
            ApplicationManager.getApplication().invokeAndWait(() -> HttpProxySettingsCleanUp.cleanUp(project));
        }
    }

    public void enhanceRemoteProcessing(@NotNull SimpleJavaParameters parameters2) {
        PathsList classPath = parameters2.getClassPath();
        classPath.add(PathUtil.getJarPathForClass(((Object)((Object)this)).getClass()));
        classPath.add(PathUtil.getJarPathForClass(Revision.class));
        classPath.add(PathUtil.getJarPathForClass(AndroidGradleSettings.class));
    }

    private static /* synthetic */ AdditionalArtifactsPaths lambda$populateModuleDependencies$10(Map additionalArtifactsMap, LibraryFilePaths libraryFilePaths, String artifactId, File artifactPath) {
        LibraryFilePaths.ArtifactPaths cachedPaths;
        AdditionalClassifierArtifacts artifacts = (AdditionalClassifierArtifacts)additionalArtifactsMap.get(artifactId);
        if (artifacts != null) {
            new AdditionalArtifactsPaths(artifacts.getSources(), artifacts.getJavadoc(), artifacts.getSampleSources());
        }
        if (libraryFilePaths != null && (cachedPaths = libraryFilePaths.getCachedPathsForArtifact(artifactId)) != null) {
            return new AdditionalArtifactsPaths(cachedPaths.sources, cachedPaths.javaDoc, cachedPaths.sampleSource);
        }
        return null;
    }
}

