/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.hyperlink;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.plugin.LatestKnownPluginVersionProvider;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.upgrade.AndroidPluginVersionUpdater;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FixAndroidGradlePluginVersionHyperlink
extends NotificationHyperlink {
    @NotNull
    private final GradleVersion myPluginVersion;
    @Nullable
    private final GradleVersion myGradleVersion;

    public FixAndroidGradlePluginVersionHyperlink() {
        this(GradleVersion.parse((String)LatestKnownPluginVersionProvider.INSTANCE.get()), GradleVersion.parse((String)"6.7.1"));
    }

    public FixAndroidGradlePluginVersionHyperlink(@NotNull GradleVersion pluginVersion, @Nullable GradleVersion gradleVersion2) {
        this("Upgrade plugin to version " + pluginVersion + " and sync project", pluginVersion, gradleVersion2);
    }

    public FixAndroidGradlePluginVersionHyperlink(@NotNull String text2, @NotNull GradleVersion pluginVersion, @Nullable GradleVersion gradleVersion2) {
        super("fixGradleElements", text2);
        this.myPluginVersion = pluginVersion;
        this.myGradleVersion = gradleVersion2;
    }

    @Override
    public void execute(@NotNull Project project) {
        AndroidPluginVersionUpdater updater = AndroidPluginVersionUpdater.getInstance(project);
        if (updater.updatePluginVersion(this.myPluginVersion, this.myGradleVersion)) {
            GradleSyncInvoker.Request request = new GradleSyncInvoker.Request(GradleSyncStats.Trigger.TRIGGER_AGP_VERSION_UPDATED);
            GradleSyncInvoker.getInstance().requestProjectSync(project, request);
        }
    }

    @VisibleForTesting
    @NotNull
    public GradleVersion getPluginVersion() {
        return this.myPluginVersion;
    }

    @VisibleForTesting
    @Nullable
    public GradleVersion getGradleVersion() {
        return this.myGradleVersion;
    }
}

