/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.invoker.messages;

import com.android.tools.idea.gradle.project.build.invoker.messages.GradleBuildTreeViewConfiguration;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.intellij.ide.errorTreeView.ErrorTreeElement;
import com.intellij.ide.errorTreeView.ErrorTreeElementKind;
import com.intellij.ide.errorTreeView.ErrorViewStructure;
import com.intellij.ide.errorTreeView.GroupingElement;
import com.intellij.ide.errorTreeView.NavigatableMessageElement;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.ide.errorTreeView.SimpleMessageElement;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleBuildTreeStructure
extends ErrorViewStructure {
    private final List<ErrorTreeElement> myMessages = Lists.newCopyOnWriteArrayList();
    private final ListMultimap<ErrorTreeElementKind, ErrorTreeElement> myMessagesByType = ArrayListMultimap.create();
    private final ListMultimap<String, NavigatableMessageElement> myGroupNameToMessagesMap = ArrayListMultimap.create();
    @NotNull
    private final Project myProject;
    @NotNull
    private final GradleBuildTreeViewConfiguration myConfiguration;

    GradleBuildTreeStructure(@NotNull Project project, @NotNull GradleBuildTreeViewConfiguration configuration) {
        super(project, false);
        this.myProject = project;
        this.myConfiguration = configuration;
    }

    @Nullable
    public ErrorTreeElement getFirstMessage(@NotNull ErrorTreeElementKind kind) {
        List elements = this.myMessagesByType.get((Object)kind);
        return elements.isEmpty() ? null : (ErrorTreeElement)elements.get(0);
    }

    public int getChildCount(GroupingElement groupingElement) {
        return this.myGroupNameToMessagesMap.get((Object)groupingElement.getName()).size();
    }

    @NotNull
    public ErrorTreeElement[] getChildElements(@NotNull Object element2) {
        if (element2 instanceof ErrorTreeElement && element2.getClass().getName().contains("MyRootElement")) {
            ArrayList messages = Lists.newArrayListWithExpectedSize((int)this.myMessages.size());
            for (ErrorTreeElement message2 : this.myMessages) {
                if (!this.canShow(message2)) continue;
                messages.add(message2);
            }
            return messages.toArray(ErrorTreeElement.EMPTY_ARRAY);
        }
        if (element2 instanceof GroupingElement) {
            List children = this.myGroupNameToMessagesMap.get((Object)((GroupingElement)element2).getName());
            ArrayList messages = Lists.newArrayListWithExpectedSize((int)children.size());
            for (NavigatableMessageElement message3 : children) {
                if (!this.canShow((ErrorTreeElement)message3)) continue;
                messages.add(message3);
            }
            return messages.toArray(ErrorTreeElement.EMPTY_ARRAY);
        }
        return ErrorTreeElement.EMPTY_ARRAY;
    }

    private boolean canShow(@NotNull ErrorTreeElement element2) {
        if (element2 instanceof GroupingElement) {
            List children = this.myGroupNameToMessagesMap.get((Object)((GroupingElement)element2).getName());
            for (NavigatableMessageElement child : children) {
                if (!this.canShow((ErrorTreeElement)child)) continue;
                return true;
            }
            return false;
        }
        return this.myConfiguration.canShow(element2.getKind());
    }

    public ErrorTreeElement addMessage(@NotNull ErrorTreeElementKind kind, @NotNull String[] text2, @Nullable VirtualFile underFileGroup, @Nullable VirtualFile file2, int line2, int column, @Nullable Object data) {
        if (underFileGroup != null || file2 != null) {
            if (file2 == null) {
                column = -1;
                line2 = -1;
            }
            int uiLine = line2 < 0 ? -1 : line2 + 1;
            int uiColumn = column < 0 ? -1 : column + 1;
            VirtualFile group2 = underFileGroup != null ? underFileGroup : file2;
            VirtualFile nav = file2 != null ? file2 : underFileGroup;
            return this.addNavigatableMessage(group2.getPresentableUrl(), (Navigatable)new OpenFileDescriptor(this.myProject, nav, line2, column), kind, text2, data, NewErrorTreeViewPanel.createExportPrefix((int)uiLine), NewErrorTreeViewPanel.createRendererPrefix((int)uiLine, (int)uiColumn), group2);
        }
        return this.addSimpleMessage(kind, text2, data);
    }

    public ErrorTreeElement addNavigatableMessage(@Nullable String groupName, @Nullable Navigatable navigatable, @NotNull ErrorTreeElementKind kind, @NotNull String[] message2, @Nullable Object data, @NotNull String exportText, @NotNull String rendererTextPrefix, @Nullable VirtualFile file2) {
        if (groupName != null) {
            GroupingElement grouping = this.getGroupingElement(groupName, data, file2);
            NavigatableMessageElement e = new NavigatableMessageElement(kind, grouping, message2, navigatable, exportText, rendererTextPrefix);
            this.myMessagesByType.put((Object)kind, (Object)e);
            this.myGroupNameToMessagesMap.put((Object)groupName, (Object)e);
            this.myMessages.add((ErrorTreeElement)grouping);
            return e;
        }
        NavigatableMessageElement e = new NavigatableMessageElement(kind, null, message2, navigatable, exportText, rendererTextPrefix);
        this.myMessages.add((ErrorTreeElement)e);
        return e;
    }

    private SimpleMessageElement addSimpleMessage(@NotNull ErrorTreeElementKind kind, @NotNull String[] text2, @Nullable Object data) {
        SimpleMessageElement element2 = new SimpleMessageElement(kind, text2, data);
        this.myMessagesByType.put((Object)kind, (Object)element2);
        this.myMessages.add((ErrorTreeElement)element2);
        return element2;
    }
}

