/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.invoker;

import com.android.tools.idea.Projects;
import com.android.tools.idea.gradle.filters.AndroidReRunBuildFilter;
import com.android.tools.idea.gradle.project.BuildSettings;
import com.android.tools.idea.gradle.project.build.attribution.BuildAttributionOutputLinkFilter;
import com.android.tools.idea.gradle.project.build.attribution.BuildAttributionUtil;
import com.android.tools.idea.gradle.project.build.invoker.BuildStopper;
import com.android.tools.idea.gradle.project.build.invoker.GradleInvocationResult;
import com.android.tools.idea.gradle.project.build.invoker.GradleRootPathFinder;
import com.android.tools.idea.gradle.project.build.invoker.GradleTaskFinder;
import com.android.tools.idea.gradle.project.build.invoker.GradleTasksExecutor;
import com.android.tools.idea.gradle.project.build.invoker.GradleTasksExecutorFactory;
import com.android.tools.idea.gradle.project.build.invoker.NativeDebugSessionFinder;
import com.android.tools.idea.gradle.project.build.invoker.TestCompileType;
import com.android.tools.idea.gradle.project.build.output.BuildOutputParserManager;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.tracer.Trace;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.intellij.build.AbstractViewManager;
import com.intellij.build.BuildConsoleUtils;
import com.intellij.build.BuildDescriptor;
import com.intellij.build.BuildEventDispatcher;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.BuildViewManager;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.impl.FailureResultImpl;
import com.intellij.build.events.impl.FinishBuildEventImpl;
import com.intellij.build.events.impl.SkippedResultImpl;
import com.intellij.build.events.impl.StartBuildEventImpl;
import com.intellij.build.events.impl.SuccessResultImpl;
import com.intellij.execution.filters.Filter;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemBuildEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemTaskExecutionEvent;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemEventDispatcher;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.xdebugger.XDebugSession;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.gradle.tooling.BuildAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleBuildInvoker {
    @NotNull
    private final Project myProject;
    @NotNull
    private final FileDocumentManager myDocumentManager;
    @NotNull
    private final GradleTasksExecutorFactory myTaskExecutorFactory;
    @NotNull
    private final Set<AfterGradleInvocationTask> myAfterTasks = new LinkedHashSet<AfterGradleInvocationTask>();
    @NotNull
    private final List<String> myOneTimeGradleOptions = new ArrayList<String>();
    @NotNull
    private final Multimap<String, String> myLastBuildTasks = ArrayListMultimap.create();
    @NotNull
    private final BuildStopper myBuildStopper = new BuildStopper();
    @NotNull
    private final NativeDebugSessionFinder myNativeDebugSessionFinder;

    @NotNull
    public static GradleBuildInvoker getInstance(@NotNull Project project) {
        return (GradleBuildInvoker)ServiceManager.getService((Project)project, GradleBuildInvoker.class);
    }

    public GradleBuildInvoker(@NotNull Project project) {
        this(project, FileDocumentManager.getInstance());
    }

    @NonInjectable
    @VisibleForTesting
    public GradleBuildInvoker(@NotNull Project project, @NotNull FileDocumentManager documentManager) {
        this(project, documentManager, new GradleTasksExecutorFactory(), new NativeDebugSessionFinder(project));
    }

    @NonInjectable
    @VisibleForTesting
    protected GradleBuildInvoker(@NotNull Project project, @NotNull FileDocumentManager documentManager, @NotNull GradleTasksExecutorFactory tasksExecutorFactory, @NotNull NativeDebugSessionFinder nativeDebugSessionFinder) {
        this.myProject = project;
        this.myDocumentManager = documentManager;
        this.myTaskExecutorFactory = tasksExecutorFactory;
        this.myNativeDebugSessionFinder = nativeDebugSessionFinder;
    }

    public void cleanProject() {
        if (this.stopNativeDebugSessionOrStopBuild()) {
            return;
        }
        this.setProjectBuildMode(BuildMode.CLEAN);
        GradleRootPathFinder pathFinder = new GradleRootPathFinder();
        Set projectRootPaths = Arrays.stream(ModuleManager.getInstance((Project)this.getProject()).getModules()).map(module2 -> pathFinder.getProjectRootPath((Module)module2).toFile()).collect(Collectors.toSet());
        for (File projectRootPath : projectRootPaths) {
            this.executeTasks(projectRootPath, Collections.singletonList("clean"));
        }
    }

    public void generateSources() {
        this.generateSources(false, ModuleManager.getInstance((Project)this.myProject).getModules());
    }

    public void generateSourcesForModules(@NotNull Module[] modules) {
        this.generateSources(false, modules);
    }

    private void generateSources(boolean cleanProject, @NotNull Module[] modules) {
        BuildMode buildMode = BuildMode.SOURCE_GEN;
        this.setProjectBuildMode(buildMode);
        GradleTaskFinder gradleTaskFinder = GradleTaskFinder.getInstance();
        ListMultimap<Path, String> tasks = gradleTaskFinder.findTasksToExecute(modules, buildMode, TestCompileType.NONE);
        if (cleanProject) {
            if (this.stopNativeDebugSessionOrStopBuild()) {
                return;
            }
            tasks.keys().elementSet().forEach(key -> tasks.get(key).add(0, "clean"));
        }
        for (Path rootPath : tasks.keySet()) {
            this.executeTasks(rootPath.toFile(), tasks.get((Object)rootPath), Collections.singletonList(GradleBuildInvoker.createGenerateSourcesOnlyProperty()));
        }
    }

    private boolean stopNativeDebugSessionOrStopBuild() {
        XDebugSession nativeDebugSession = this.myNativeDebugSessionFinder.findNativeDebugSession();
        if (nativeDebugSession != null) {
            Ref yesNoCancelRef = new Ref();
            Application application = ApplicationManager.getApplication();
            application.invokeAndWait(() -> yesNoCancelRef.set((Object)this.promptUserToStopNativeDebugSession()), ModalityState.NON_MODAL);
            int yesNoCancel = (Integer)yesNoCancelRef.get();
            switch (yesNoCancel) {
                case 0: {
                    nativeDebugSession.stop();
                    break;
                }
                case 2: {
                    return true;
                }
            }
        }
        return false;
    }

    @Messages.YesNoCancelResult
    private int promptUserToStopNativeDebugSession() {
        final String propKey = "gradle.project.build.invoker.clean-terminates-debugger";
        String value2 = PropertiesComponent.getInstance().getValue(propKey);
        if (value2 == null) {
            Ref yesNoCancelRef = new Ref();
            ApplicationManager.getApplication().invokeAndWait(() -> {
                String message2 = "Cleaning or rebuilding your project while debugging can lead to unexpected behavior.\nYou can choose to either terminate the debugger before cleaning your project or keep debugging while cleaning.\nClicking \"Cancel\" stops Gradle from cleaning or rebuilding your project, and preserves your debug process.";
                MessageDialogBuilder.YesNoCancel dialogBuilder = MessageDialogBuilder.yesNoCancel((String)"Terminate debugging", (String)message2);
                int answer = ((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)dialogBuilder.project(this.myProject)).yesText("Terminate")).noText("Do not terminate")).cancelText("Cancel").doNotAsk((DialogWrapper.DoNotAskOption)new DialogWrapper.DoNotAskOption.Adapter(){

                    public void rememberChoice(boolean isSelected, int exitCode) {
                        if (isSelected) {
                            PropertiesComponent.getInstance().setValue(propKey, Boolean.toString(exitCode == 0));
                        }
                    }
                })).show();
                yesNoCancelRef.set((Object)answer);
            }, ModalityState.NON_MODAL);
            int answer = (Integer)yesNoCancelRef.get();
            return answer;
        }
        GradleBuildInvoker.getLogger().debug(propKey + ": " + value2);
        return value2.equals("true") ? 0 : 1;
    }

    @NotNull
    private static String createGenerateSourcesOnlyProperty() {
        return AndroidGradleSettings.createProjectProperty((String)"android.injected.generateSourcesOnly", (boolean)true);
    }

    public void compileJava(@NotNull Module[] modules, @NotNull TestCompileType testCompileType) {
        BuildMode buildMode = BuildMode.COMPILE_JAVA;
        this.setProjectBuildMode(buildMode);
        ListMultimap<Path, String> tasks = GradleTaskFinder.getInstance().findTasksToExecute(modules, buildMode, testCompileType);
        for (Path rootPath : tasks.keySet()) {
            this.executeTasks(rootPath.toFile(), tasks.get((Object)rootPath));
        }
    }

    public void assemble(@NotNull Module[] modules, @NotNull TestCompileType testCompileType) {
        this.assemble(modules, testCompileType, null);
    }

    public void assemble(@NotNull Module[] modules, @NotNull TestCompileType testCompileType, @Nullable BuildAction<?> buildAction) {
        BuildMode buildMode = BuildMode.ASSEMBLE;
        this.setProjectBuildMode(buildMode);
        ListMultimap<Path, String> tasks = GradleTaskFinder.getInstance().findTasksToExecute(modules, buildMode, testCompileType);
        for (Path rootPath : tasks.keySet()) {
            this.executeTasks(rootPath.toFile(), tasks.get((Object)rootPath), Collections.emptyList(), buildAction);
        }
    }

    public void bundle(@NotNull Module[] modules, @Nullable BuildAction<?> buildAction) {
        BuildMode buildMode = BuildMode.BUNDLE;
        this.setProjectBuildMode(buildMode);
        ListMultimap<Path, String> tasks = GradleTaskFinder.getInstance().findTasksToExecute(modules, buildMode, TestCompileType.NONE);
        for (Path rootPath : tasks.keySet()) {
            this.executeTasks(rootPath.toFile(), tasks.get((Object)rootPath), Collections.emptyList(), buildAction);
        }
    }

    public void rebuild() {
        BuildMode buildMode = BuildMode.REBUILD;
        this.setProjectBuildMode(buildMode);
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        ListMultimap<Path, String> tasks = GradleTaskFinder.getInstance().findTasksToExecute(moduleManager.getModules(), buildMode, TestCompileType.NONE);
        for (Path rootPath : tasks.keySet()) {
            this.executeTasks(rootPath.toFile(), tasks.get((Object)rootPath));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildWithTempOptions(@NotNull File buildFilePath, @NotNull List<String> options2) {
        this.myOneTimeGradleOptions.addAll(options2);
        try {
            Collection tasks = this.myLastBuildTasks.get((Object)buildFilePath.getPath());
            if (tasks.isEmpty()) {
                this.rebuild();
            } else {
                ArrayList<String> tasksFromLastBuild = new ArrayList<String>(tasks);
                this.executeTasks(buildFilePath, tasksFromLastBuild);
            }
        }
        finally {
            this.myOneTimeGradleOptions.clear();
        }
    }

    private void setProjectBuildMode(@NotNull BuildMode buildMode) {
        BuildSettings.getInstance(this.myProject).setBuildMode(buildMode);
    }

    @Deprecated
    public void executeTasks(@NotNull List<String> gradleTasks) {
        File path2 = Projects.getBaseDirPath((Project)this.myProject);
        this.executeTasks(path2, gradleTasks, this.myOneTimeGradleOptions);
    }

    public void executeTasks(@NotNull File buildFilePath, @NotNull List<String> gradleTasks) {
        this.executeTasks(buildFilePath, gradleTasks, this.myOneTimeGradleOptions);
    }

    public void executeTasks(@NotNull ListMultimap<Path, String> tasks, @Nullable BuildMode buildMode, @NotNull List<String> commandLineArguments, @Nullable BuildAction buildAction) {
        if (buildMode != null) {
            this.setProjectBuildMode(buildMode);
        }
        tasks.keys().elementSet().forEach(path2 -> this.executeTasks(path2.toFile(), tasks.get(path2), commandLineArguments, buildAction));
    }

    public void executeTasks(@NotNull File buildFilePath, @NotNull List<String> gradleTasks, @NotNull List<String> commandLineArguments) {
        this.executeTasks(buildFilePath, gradleTasks, commandLineArguments, null);
    }

    public void executeTasks(@NotNull File buildFilePath, @NotNull List<String> gradleTasks, @NotNull List<String> commandLineArguments, @Nullable BuildAction buildAction) {
        ArrayList<String> jvmArguments = new ArrayList<String>();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            File androidHomePath;
            LocalProperties localProperties;
            try {
                localProperties = new LocalProperties(this.myProject);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (localProperties.getAndroidSdkPath() == null && (androidHomePath = IdeSdks.getInstance().getAndroidSdkPath()) != null) {
                jvmArguments.add(AndroidGradleSettings.createAndroidHomeJvmArg((String)androidHomePath.getPath()));
            }
        }
        Trace.addVmArgs(jvmArguments);
        Request request = new Request(this.myProject, buildFilePath, gradleTasks);
        ExternalSystemTaskNotificationListener buildTaskListener = this.createBuildTaskListener(request, "Build");
        request.setJvmArguments(jvmArguments).setCommandLineArguments(commandLineArguments).setBuildAction(buildAction).setTaskListener(buildTaskListener);
        this.executeTasks(request);
    }

    @NotNull
    public ExternalSystemTaskNotificationListener createBuildTaskListener(@NotNull Request request, String executionName) {
        BuildViewManager buildViewManager = (BuildViewManager)ServiceManager.getService((Project)this.myProject, BuildViewManager.class);
        ExternalSystemEventDispatcher eventDispatcher = new ExternalSystemEventDispatcher(request.myTaskId, (BuildProgressListener)buildViewManager);
        try {
            return new ExternalSystemTaskNotificationListenerAdapter((BuildEventDispatcher)eventDispatcher, request, buildViewManager, executionName){
                @NotNull
                private BuildEventDispatcher myBuildEventDispatcher;
                private boolean myBuildFailed;
                final /* synthetic */ BuildEventDispatcher val$eventDispatcher;
                final /* synthetic */ Request val$request;
                final /* synthetic */ BuildViewManager val$buildViewManager;
                final /* synthetic */ String val$executionName;
                {
                    this.val$eventDispatcher = buildEventDispatcher;
                    this.val$request = request;
                    this.val$buildViewManager = buildViewManager;
                    this.val$executionName = string;
                    this.myBuildEventDispatcher = this.val$eventDispatcher;
                    this.myBuildFailed = false;
                }

                public void onStart(final @NotNull ExternalSystemTaskId id, String workingDir) {
                    AnAction restartAction = new AnAction(){

                        public void update(@NotNull AnActionEvent e) {
                            e.getPresentation().setEnabled(!GradleBuildInvoker.this.myBuildStopper.contains(id));
                        }

                        public void actionPerformed(@NotNull AnActionEvent e) {
                            myBuildFailed = false;
                            myBuildEventDispatcher.close();
                            myBuildEventDispatcher = (BuildEventDispatcher)new ExternalSystemEventDispatcher(val$request.myTaskId, (BuildProgressListener)val$buildViewManager);
                            GradleBuildInvoker.this.executeTasks(val$request);
                        }
                    };
                    this.myBuildFailed = false;
                    Presentation presentation = restartAction.getTemplatePresentation();
                    presentation.setText("Restart");
                    presentation.setDescription("Restart");
                    presentation.setIcon(AllIcons.Actions.Compile);
                    long eventTime = System.currentTimeMillis();
                    StartBuildEventImpl event = new StartBuildEventImpl((BuildDescriptor)new DefaultBuildDescriptor((Object)id, this.val$executionName, workingDir, eventTime), "running...");
                    event.withRestartAction(restartAction).withExecutionFilter((Filter)new AndroidReRunBuildFilter(workingDir));
                    if (BuildAttributionUtil.isBuildAttributionEnabledForProject(GradleBuildInvoker.this.myProject)) {
                        event.withExecutionFilter((Filter)new BuildAttributionOutputLinkFilter());
                    }
                    this.myBuildEventDispatcher.onEvent((Object)id, (BuildEvent)event);
                }

                public void onStatusChange(@NotNull ExternalSystemTaskNotificationEvent event) {
                    if (event instanceof ExternalSystemBuildEvent) {
                        BuildEvent buildEvent = ((ExternalSystemBuildEvent)event).getBuildEvent();
                        this.myBuildEventDispatcher.onEvent((Object)event.getId(), buildEvent);
                    } else if (event instanceof ExternalSystemTaskExecutionEvent) {
                        BuildEvent buildEvent = ExternalSystemUtil.convert((ExternalSystemTaskExecutionEvent)((ExternalSystemTaskExecutionEvent)event));
                        this.myBuildEventDispatcher.onEvent((Object)event.getId(), buildEvent);
                    }
                }

                public void onTaskOutput(@NotNull ExternalSystemTaskId id, @NotNull String text2, boolean stdOut) {
                    this.myBuildEventDispatcher.setStdOut(stdOut);
                    this.myBuildEventDispatcher.append((CharSequence)text2);
                }

                public void onEnd(@NotNull ExternalSystemTaskId id) {
                    CountDownLatch eventDispatcherFinished = new CountDownLatch(1);
                    this.myBuildEventDispatcher.invokeOnCompletion(t -> {
                        if (this.myBuildFailed) {
                            ((BuildOutputParserManager)ServiceManager.getService((Project)GradleBuildInvoker.this.myProject, BuildOutputParserManager.class)).sendBuildFailureMetrics();
                        }
                        eventDispatcherFinished.countDown();
                    });
                    this.myBuildEventDispatcher.close();
                    if (ApplicationManager.getApplication().isUnitTestMode()) {
                        try {
                            eventDispatcherFinished.await(10L, TimeUnit.SECONDS);
                        }
                        catch (InterruptedException ex) {
                            throw new RuntimeException("Timeout waiting for event dispatcher to finish.", ex);
                        }
                    }
                }

                public void onSuccess(@NotNull ExternalSystemTaskId id) {
                    this.addBuildAttributionLinkToTheOutput(id);
                    FinishBuildEventImpl event = new FinishBuildEventImpl((Object)id, null, System.currentTimeMillis(), "finished", (EventResult)new SuccessResultImpl());
                    this.myBuildEventDispatcher.onEvent((Object)id, (BuildEvent)event);
                }

                private void addBuildAttributionLinkToTheOutput(@NotNull ExternalSystemTaskId id) {
                    if (BuildAttributionUtil.isBuildAttributionEnabledForProject(GradleBuildInvoker.this.myProject)) {
                        String buildAttributionTabLinkLine = BuildAttributionUtil.buildOutputLine();
                        this.onTaskOutput(id, "\n" + buildAttributionTabLinkLine, true);
                    }
                }

                public void onFailure(@NotNull ExternalSystemTaskId id, @NotNull Exception e) {
                    this.myBuildFailed = true;
                    String title = this.val$executionName + " failed";
                    DataProvider dataProvider = BuildConsoleUtils.getDataProvider((Object)id, (AbstractViewManager)this.val$buildViewManager);
                    FailureResultImpl failureResult = ExternalSystemUtil.createFailureResult((String)title, (Exception)e, (ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID, (Project)GradleBuildInvoker.this.myProject, (DataProvider)dataProvider);
                    this.myBuildEventDispatcher.onEvent((Object)id, (BuildEvent)new FinishBuildEventImpl((Object)id, null, System.currentTimeMillis(), "failed", (EventResult)failureResult));
                }

                public void onCancel(@NotNull ExternalSystemTaskId id) {
                    super.onCancel(id);
                    FinishBuildEventImpl event = new FinishBuildEventImpl((Object)id, null, System.currentTimeMillis(), "cancelled", (EventResult)new SkippedResultImpl());
                    this.myBuildEventDispatcher.onEvent((Object)id, (BuildEvent)event);
                    this.myBuildEventDispatcher.close();
                }
            };
        }
        catch (Exception exception) {
            eventDispatcher.close();
            throw exception;
        }
    }

    public void executeTasks(@NotNull Request request) {
        String buildFilePath = request.getBuildFilePath().getPath();
        this.myLastBuildTasks.removeAll((Object)buildFilePath);
        List<String> gradleTasks = request.getGradleTasks();
        this.myLastBuildTasks.putAll((Object)buildFilePath, gradleTasks);
        GradleBuildInvoker.getLogger().info("About to execute Gradle tasks: " + gradleTasks);
        if (gradleTasks.isEmpty()) {
            return;
        }
        GradleTasksExecutor executor = this.myTaskExecutorFactory.create(request, this.myBuildStopper);
        if (ApplicationManager.getApplication().isDispatchThread()) {
            this.myDocumentManager.saveAllDocuments();
            executor.queue();
        } else if (request.isWaitForCompletion()) {
            ApplicationManager.getApplication().invokeAndWait(() -> ((FileDocumentManager)this.myDocumentManager).saveAllDocuments());
            executor.queueAndWaitForCompletion();
        } else {
            TransactionGuard.getInstance().submitTransactionAndWait(() -> {
                this.myDocumentManager.saveAllDocuments();
                executor.queue();
            });
        }
    }

    @NotNull
    private static Logger getLogger() {
        return Logger.getInstance(GradleBuildInvoker.class);
    }

    public boolean stopBuild(@NotNull ExternalSystemTaskId id) {
        if (this.myBuildStopper.contains(id)) {
            this.myBuildStopper.attemptToStopBuild(id, null);
            return true;
        }
        return false;
    }

    public void add(@NotNull AfterGradleInvocationTask task2) {
        this.myAfterTasks.add(task2);
    }

    @VisibleForTesting
    @NotNull
    protected AfterGradleInvocationTask[] getAfterInvocationTasks() {
        return this.myAfterTasks.toArray(new AfterGradleInvocationTask[0]);
    }

    public void remove(@NotNull AfterGradleInvocationTask task2) {
        this.myAfterTasks.remove(task2);
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    public static class Request {
        @NotNull
        private final Project myProject;
        @NotNull
        private final File myBuildFilePath;
        @NotNull
        private final List<String> myGradleTasks;
        @NotNull
        private final List<String> myJvmArguments;
        @NotNull
        private final List<String> myCommandLineArguments;
        @NotNull
        private final Map<String, String> myEnv;
        private boolean myPassParentEnvs = true;
        @NotNull
        private final ExternalSystemTaskId myTaskId;
        @Nullable
        private ExternalSystemTaskNotificationListener myTaskListener;
        @Nullable
        private BuildAction myBuildAction;
        private boolean myWaitForCompletion;

        public Request(@NotNull Project project, @NotNull File buildFilePath, String ... gradleTasks) {
            this(project, buildFilePath, Arrays.asList(gradleTasks));
        }

        public Request(@NotNull Project project, @NotNull File buildFilePath, @NotNull List<String> gradleTasks) {
            this(project, buildFilePath, gradleTasks, ExternalSystemTaskId.create((ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID, (ExternalSystemTaskType)ExternalSystemTaskType.EXECUTE_TASK, (Project)project));
        }

        public Request(@NotNull Project project, @NotNull File buildFilePath, @NotNull List<String> gradleTasks, @NotNull ExternalSystemTaskId taskId) {
            this.myProject = project;
            this.myBuildFilePath = buildFilePath;
            this.myGradleTasks = new ArrayList<String>(gradleTasks);
            this.myJvmArguments = new ArrayList<String>();
            this.myCommandLineArguments = new ArrayList<String>();
            this.myTaskId = taskId;
            this.myEnv = new LinkedHashMap<String, String>();
        }

        @NotNull
        Project getProject() {
            return this.myProject;
        }

        @NotNull
        List<String> getGradleTasks() {
            return this.myGradleTasks;
        }

        @NotNull
        List<String> getJvmArguments() {
            return this.myJvmArguments;
        }

        @NotNull
        public Request setJvmArguments(@NotNull List<String> jvmArguments) {
            this.myJvmArguments.clear();
            this.myJvmArguments.addAll(jvmArguments);
            return this;
        }

        @NotNull
        List<String> getCommandLineArguments() {
            return this.myCommandLineArguments;
        }

        @NotNull
        public Request setCommandLineArguments(@NotNull List<String> commandLineArguments) {
            this.myCommandLineArguments.clear();
            this.myCommandLineArguments.addAll(commandLineArguments);
            return this;
        }

        public Request withEnvironmentVariables(Map<String, String> envs) {
            this.myEnv.putAll(envs);
            return this;
        }

        public Map<String, String> getEnv() {
            return Collections.unmodifiableMap(this.myEnv);
        }

        public Request passParentEnvs(boolean passParentEnvs) {
            this.myPassParentEnvs = passParentEnvs;
            return this;
        }

        public boolean isPassParentEnvs() {
            return this.myPassParentEnvs;
        }

        @Nullable
        public ExternalSystemTaskNotificationListener getTaskListener() {
            return this.myTaskListener;
        }

        @NotNull
        public Request setTaskListener(@Nullable ExternalSystemTaskNotificationListener taskListener) {
            this.myTaskListener = taskListener;
            return this;
        }

        @NotNull
        ExternalSystemTaskId getTaskId() {
            return this.myTaskId;
        }

        @NotNull
        File getBuildFilePath() {
            return this.myBuildFilePath;
        }

        boolean isWaitForCompletion() {
            return this.myWaitForCompletion;
        }

        @NotNull
        public Request waitForCompletion() {
            this.myWaitForCompletion = true;
            return this;
        }

        @Nullable
        public BuildAction getBuildAction() {
            return this.myBuildAction;
        }

        @NotNull
        public Request setBuildAction(@Nullable BuildAction buildAction) {
            this.myBuildAction = buildAction;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request that = (Request)o;
            return Objects.equals(this.myBuildFilePath, that.myBuildFilePath) && Objects.equals(this.myGradleTasks, that.myGradleTasks) && Objects.equals(this.myJvmArguments, that.myJvmArguments) && Objects.equals(this.myCommandLineArguments, that.myCommandLineArguments);
        }

        public int hashCode() {
            return Objects.hash(this.myBuildFilePath, this.myGradleTasks, this.myJvmArguments, this.myCommandLineArguments);
        }

        public String toString() {
            return "RequestSettings{myBuildFilePath=" + this.myBuildFilePath + ", myGradleTasks=" + this.myGradleTasks + ", myJvmArguments=" + this.myJvmArguments + ", myCommandLineArguments=" + this.myCommandLineArguments + ", myBuildAction=" + this.myBuildAction + '}';
        }
    }

    public static interface AfterGradleInvocationTask {
        public void execute(@NotNull GradleInvocationResult var1);
    }
}

