/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.attribution;

import com.android.tools.idea.gradle.project.build.attribution.BuildAttributionManager;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class BuildAttributionOutputLinkFilter
implements Filter {
    public static final String LINK_TEXT = "Build Analyzer";
    public static final String INSIGHTS_AVAILABLE_LINE = "Build Analyzer results available";

    public Filter.Result applyFilter(@NotNull String line2, int entireLength) {
        int index2;
        int lineStart = entireLength - line2.length();
        if (line2.contains(INSIGHTS_AVAILABLE_LINE) && (index2 = line2.indexOf(LINK_TEXT)) != -1) {
            return new Filter.Result(Collections.singletonList(BuildAttributionOutputLinkFilter.createLink(lineStart + index2, lineStart + index2 + LINK_TEXT.length())));
        }
        return null;
    }

    @NotNull
    private static Filter.ResultItem createLink(int start2, int end) {
        return new Filter.ResultItem(start2, end, BuildAttributionOutputLinkFilter.getHyperLinkInfo());
    }

    @NotNull
    private static HyperlinkInfo getHyperLinkInfo() {
        return new HyperlinkInfo(){

            public void navigate(Project project) {
                ((BuildAttributionManager)ServiceManager.getService((Project)project, BuildAttributionManager.class)).openResultsTab();
            }
        };
    }
}

