/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.model.java;

import com.android.tools.idea.gradle.project.sync.Modules;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.serialization.PropertyMapping;
import java.io.File;
import java.io.Serializable;
import java.util.Objects;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.gradle.tooling.model.idea.IdeaDependencyScope;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaModuleDependency;
import org.gradle.tooling.model.idea.IdeaProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaModuleDependency
implements Serializable {
    private static final long serialVersionUID = 3L;
    @NotNull
    private final String myModuleName;
    @NotNull
    private final String myModuleId;
    @Nullable
    private final String myScope;
    private final boolean myExported;

    @Nullable
    public static JavaModuleDependency copy(IdeaProject project, IdeaModuleDependency original) {
        IdeaModule targetModule = null;
        for (IdeaModule module2 : project.getModules()) {
            if (!module2.getName().equals(original.getTargetModuleName())) continue;
            targetModule = module2;
        }
        if (targetModule != null && StringUtil.isNotEmpty((String)targetModule.getName())) {
            File projectFolder;
            String scope2 = null;
            IdeaDependencyScope originalScope = original.getScope();
            if (originalScope != null) {
                scope2 = originalScope.getScope();
            }
            GradleProject gradleProject = targetModule.getGradleProject();
            try {
                projectFolder = gradleProject.getProjectIdentifier().getBuildIdentifier().getRootDir();
            }
            catch (UnsupportedMethodException ex) {
                GradleProject rootGradleProject = gradleProject;
                while (rootGradleProject.getParent() != null) {
                    rootGradleProject = rootGradleProject.getParent();
                }
                projectFolder = rootGradleProject.getProjectDirectory();
            }
            String moduleId = Modules.createUniqueModuleId(projectFolder, gradleProject.getPath());
            return new JavaModuleDependency(targetModule.getName(), moduleId, scope2, original.getExported());
        }
        return null;
    }

    @PropertyMapping(value={"myModuleName", "myModuleId", "myScope", "myExported"})
    public JavaModuleDependency(@NotNull String moduleName2, @NotNull String moduleId, @Nullable String scope2, boolean exported) {
        this.myModuleName = moduleName2;
        this.myModuleId = moduleId;
        this.myScope = scope2;
        this.myExported = exported;
    }

    @NotNull
    public String getModuleName() {
        return this.myModuleName;
    }

    @NotNull
    public String getModuleId() {
        return this.myModuleId;
    }

    @Nullable
    public String getScope() {
        return this.myScope;
    }

    public boolean isExported() {
        return this.myExported;
    }

    public int hashCode() {
        return Objects.hash(this.myModuleName, this.myModuleId, this.myScope, this.myExported);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JavaModuleDependency)) {
            return false;
        }
        JavaModuleDependency dependency = (JavaModuleDependency)obj;
        return Objects.equals(this.myModuleName, dependency.myModuleName) && Objects.equals(this.myModuleId, dependency.myModuleId) && Objects.equals(this.myScope, dependency.myScope) && Objects.equals(this.myExported, dependency.myExported);
    }
}

