/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.repositories;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.dsl.api.repositories.RepositoriesModel;
import com.android.tools.idea.gradle.dsl.api.repositories.RepositoryModel;
import com.android.tools.idea.gradle.dsl.model.GradleDslBlockModel;
import com.android.tools.idea.gradle.dsl.model.repositories.FlatDirRepositoryModel;
import com.android.tools.idea.gradle.dsl.model.repositories.GoogleDefaultRepositoryModelImpl;
import com.android.tools.idea.gradle.dsl.model.repositories.JCenterRepositoryModel;
import com.android.tools.idea.gradle.dsl.model.repositories.MavenCentralRepositoryModel;
import com.android.tools.idea.gradle.dsl.model.repositories.MavenRepositoryModelImpl;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.repositories.FlatDirRepositoryDslElement;
import com.android.tools.idea.gradle.dsl.parser.repositories.MavenRepositoryDslElement;
import com.android.tools.idea.gradle.dsl.parser.repositories.RepositoriesDslElement;
import com.android.tools.idea.gradle.dsl.parser.semantics.PropertiesElementDescription;
import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RepositoriesModelImpl
extends GradleDslBlockModel
implements RepositoriesModel {
    public RepositoriesModelImpl(@NotNull RepositoriesDslElement dslElement) {
        super(dslElement);
    }

    @Override
    @NotNull
    public List<RepositoryModel> repositories() {
        ArrayList result2 = Lists.newArrayList();
        for (GradleDslElement element2 : this.myDslElement.getAllPropertyElements()) {
            if (element2 instanceof GradleDslMethodCall) {
                String methodName = ((GradleDslMethodCall)element2).getMethodName();
                assert (!Arrays.asList("mavenCentral", MavenRepositoryDslElement.JCENTER.name, "google").contains(methodName));
                continue;
            }
            if (element2 instanceof MavenRepositoryDslElement) {
                if (MavenRepositoryDslElement.MAVEN.name.equals(element2.getName())) {
                    result2.add(new MavenRepositoryModelImpl(this.myDslElement, (MavenRepositoryDslElement)element2));
                    continue;
                }
                if (MavenRepositoryDslElement.JCENTER.name.equals(element2.getName())) {
                    result2.add(new JCenterRepositoryModel(this.myDslElement, (MavenRepositoryDslElement)element2));
                    continue;
                }
                if (MavenRepositoryDslElement.GOOGLE.name.equals(element2.getName())) {
                    result2.add(new GoogleDefaultRepositoryModelImpl(this.myDslElement, (MavenRepositoryDslElement)element2));
                    continue;
                }
                if (!MavenRepositoryDslElement.MAVEN_CENTRAL.name.equals(element2.getName())) continue;
                result2.add(new MavenCentralRepositoryModel(this.myDslElement, (MavenRepositoryDslElement)element2));
                continue;
            }
            if (element2 instanceof FlatDirRepositoryDslElement) {
                result2.add(new FlatDirRepositoryModel(this.myDslElement, (FlatDirRepositoryDslElement)element2));
                continue;
            }
            if (!(element2 instanceof GradleDslExpressionMap)) continue;
            if ("mavenCentral".equals(element2.getName())) {
                result2.add(new MavenCentralRepositoryModel(this.myDslElement, (GradleDslExpressionMap)element2));
                continue;
            }
            if (!"flatDir".equals(element2.getName())) continue;
            result2.add(new FlatDirRepositoryModel(this.myDslElement, (GradleDslExpressionMap)element2));
        }
        return result2;
    }

    @Override
    public void addRepositoryByMethodName(@NotNull String methodName) {
        if (this.containsMethodCall(methodName)) {
            return;
        }
        PropertiesElementDescription description2 = this.myDslElement.getChildPropertiesElementDescription(methodName);
        if (description2 != null) {
            this.myDslElement.setNewElement((GradleDslElement)description2.constructor.construct(this.myDslElement, GradleNameElement.fake(methodName)));
        }
    }

    @Override
    public void addFlatDirRepository(@NotNull String dirName) {
        List<FlatDirRepositoryDslElement> flatDirElements = this.myDslElement.getPropertyElements(FlatDirRepositoryDslElement.class);
        if (!flatDirElements.isEmpty()) {
            new FlatDirRepositoryModel(this.myDslElement, flatDirElements.get(0)).dirs().addListValue().setValue(dirName);
        } else {
            FlatDirRepositoryDslElement gradleDslElement = new FlatDirRepositoryDslElement(this.myDslElement, GradleNameElement.fake(FlatDirRepositoryDslElement.FLAT_DIR.name));
            this.myDslElement.setNewElement(gradleDslElement);
            new FlatDirRepositoryModel(this.myDslElement, gradleDslElement).dirs().addListValue().setValue(dirName);
        }
    }

    @Override
    public boolean containsMethodCall(@NotNull String methodName) {
        List<MavenRepositoryDslElement> elements = this.myDslElement.getPropertyElements(MavenRepositoryDslElement.class);
        for (MavenRepositoryDslElement element2 : elements) {
            if (!methodName.equals(element2.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addMavenRepositoryByUrl(@NotNull String url, @NotNull String name) {
        if (this.containsMavenRepositoryByUrl(url)) {
            return;
        }
        GradleNameElement nameElement = GradleNameElement.fake(MavenRepositoryDslElement.MAVEN.name);
        MavenRepositoryDslElement newElement = new MavenRepositoryDslElement(this.myDslElement, nameElement);
        this.myDslElement.setNewElement(newElement);
        MavenRepositoryModelImpl model2 = new MavenRepositoryModelImpl(this.myDslElement, newElement);
        model2.url().setValue(url);
        model2.name().setValue(name);
    }

    @Override
    public void removeRepository(@NotNull RepositoryModel repository) {
        this.myDslElement.removeProperty(repository.getDslElement());
    }

    @Override
    public boolean containsMavenRepositoryByUrl(@NotNull String repositoryUrl) {
        List<MavenRepositoryDslElement> elements = this.myDslElement.getPropertyElements(MavenRepositoryDslElement.class);
        for (MavenRepositoryDslElement element2 : elements) {
            String urlElement = element2.getLiteral("url", String.class);
            if (!repositoryUrl.equals(urlElement)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasGoogleMavenRepository() {
        PsiElement psiElement = this.getPsiElement();
        if (psiElement == null) {
            return false;
        }
        if (this.containsMethodCall("google")) {
            return true;
        }
        return this.containsMavenRepositoryByUrl("https://maven.google.com/");
    }

    @Override
    public void addGoogleMavenRepository(@NotNull GradleVersion gradleVersion2) {
        if (gradleVersion2.compareIgnoringQualifiers("4.0") >= 0) {
            this.addRepositoryByMethodName("google");
        } else {
            this.addMavenRepositoryByUrl("https://maven.google.com/", "Google");
        }
    }
}

