/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.api;

import com.android.tools.idea.gradle.dsl.api.BuildScriptModel;
import com.android.tools.idea.gradle.dsl.api.GradleFileModel;
import com.android.tools.idea.gradle.dsl.api.GradleModelProvider;
import com.android.tools.idea.gradle.dsl.api.PluginModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.api.android.AndroidModel;
import com.android.tools.idea.gradle.dsl.api.configurations.ConfigurationsModel;
import com.android.tools.idea.gradle.dsl.api.crashlytics.CrashlyticsModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.dsl.api.ext.ExtModel;
import com.android.tools.idea.gradle.dsl.api.java.JavaModel;
import com.android.tools.idea.gradle.dsl.api.repositories.RepositoriesModel;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface GradleBuildModel
extends GradleFileModel {
    @Nullable
    public static <T> T tryOrLog(@NotNull Supplier<T> supplier2) {
        try {
            return supplier2.get();
        }
        catch (Exception e) {
            if (e instanceof ControlFlowException) {
                return null;
            }
            Logger logger2 = Logger.getInstance(ProjectBuildModel.class);
            logger2.error((Throwable)e);
            return null;
        }
    }

    @Deprecated
    @Nullable
    public static GradleBuildModel get(@NotNull Project project) {
        return GradleBuildModel.tryOrLog(() -> GradleModelProvider.getInstance().getBuildModel(project));
    }

    @Deprecated
    @Nullable
    public static GradleBuildModel get(@NotNull Module module2) {
        return GradleBuildModel.tryOrLog(() -> GradleModelProvider.getInstance().getBuildModel(module2));
    }

    @Deprecated
    @NotNull
    public static GradleBuildModel parseBuildFile(@NotNull VirtualFile file2, @NotNull Project project) {
        return GradleModelProvider.getInstance().parseBuildFile(file2, project);
    }

    @NotNull
    public List<PluginModel> plugins();

    @NotNull
    public PluginModel applyPlugin(@NotNull String var1);

    public void removePlugin(@NotNull String var1);

    @Nullable
    public PsiElement getPluginsPsiElement();

    @NotNull
    public AndroidModel android();

    @NotNull
    public BuildScriptModel buildscript();

    @NotNull
    public ConfigurationsModel configurations();

    @NotNull
    public CrashlyticsModel crashlytics();

    @NotNull
    public DependenciesModel dependencies();

    @NotNull
    public ExtModel ext();

    @NotNull
    public JavaModel java();

    @NotNull
    public RepositoriesModel repositories();

    @NotNull
    public Set<GradleFileModel> getInvolvedFiles();

    @NotNull
    public File getModuleRootDirectory();

    public void removeRepositoriesBlocks();
}

