/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.actions;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.actions.AndroidStudioGradleAction;
import com.android.tools.idea.gradle.actions.LinkExternalCppProjectDialog;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LinkExternalCppProjectAction
extends AndroidStudioGradleAction {
    public LinkExternalCppProjectAction() {
        super("Link C++ Project with Gradle", "Link an external C/C++ project (cmake or ndk-build) with Gradle", null);
    }

    @Override
    protected void doUpdate(@NotNull AnActionEvent e, @NotNull Project project) {
        DataContext dataContext = e.getDataContext();
        boolean enable = LinkExternalCppProjectAction.isValidAndroidGradleModuleSelected(dataContext) && (Boolean)StudioFlags.NPW_NEW_NATIVE_MODULE.get() == false;
        Presentation presentation = e.getPresentation();
        presentation.setEnabledAndVisible(enable);
    }

    @Override
    protected void doPerform(@NotNull AnActionEvent e, @NotNull Project project) {
        DataContext dataContext = e.getDataContext();
        Module module2 = LinkExternalCppProjectAction.getSelectedModule(dataContext);
        assert (module2 != null);
        new LinkExternalCppProjectDialog(module2).show();
    }

    private static boolean isValidAndroidGradleModuleSelected(@NotNull DataContext dataContext) {
        Module module2 = LinkExternalCppProjectAction.getSelectedModule(dataContext);
        if (module2 == null) {
            return false;
        }
        AndroidModuleModel androidModel = AndroidModuleModel.get(module2);
        if (androidModel == null || !androidModel.getFeatures().isExternalBuildSupported()) {
            return false;
        }
        NdkModuleModel ndkModuleModel = NdkModuleModel.get(module2);
        if (ndkModuleModel != null) {
            return false;
        }
        return GradleBuildModel.get(module2) != null;
    }

    @Nullable
    private static Module getSelectedModule(@NotNull DataContext dataContext) {
        Module[] modules = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(dataContext);
        if (modules != null && modules.length == 1) {
            return modules[0];
        }
        return (Module)LangDataKeys.MODULE.getData(dataContext);
    }
}

