/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.actions;

import com.android.tools.idea.gradle.actions.BuildsToPathsMapper;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.project.build.invoker.GradleInvocationResult;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterators;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoToBundleLocationTask
implements GradleBuildInvoker.AfterGradleInvocationTask {
    public static final String ANALYZE_URL_PREFIX = "analyze:";
    public static final String LOCATE_URL_PREFIX = "module:";
    public static final String LOCATE_KEY_URL_PREFIX = "key:";
    @NotNull
    private final Project myProject;
    @NotNull
    private final String myNotificationTitle;
    @NotNull
    private final Collection<Module> myModules;
    @Nullable
    private final File myExportedKeyFile;
    @NotNull
    private final List<String> myBuildVariants;
    @Nullable
    private final String mySignedBundlePath;

    public GoToBundleLocationTask(@NotNull Project project, @NotNull Collection<Module> modules, @NotNull String notificationTitle) {
        this(project, modules, notificationTitle, Collections.emptyList(), null, null);
    }

    public GoToBundleLocationTask(@NotNull Project project, @NotNull Collection<Module> modules, @NotNull String notificationTitle, @NotNull List<String> buildVariants, @Nullable File exportedKeyFile, @Nullable String signedBundlePath) {
        this.myProject = project;
        this.myNotificationTitle = notificationTitle;
        this.myModules = modules;
        this.myExportedKeyFile = exportedKeyFile;
        this.myBuildVariants = buildVariants;
        this.mySignedBundlePath = signedBundlePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(@NotNull GradleInvocationResult result2) {
        try {
            BuildsToPathsMapper buildsToPathsMapper = BuildsToPathsMapper.getInstance(this.myProject);
            Map<String, File> bundleBuildsToPath = buildsToPathsMapper.getBuildsToPaths(result2.getModel(), this.myBuildVariants, this.myModules, true, this.mySignedBundlePath);
            this.showNotification(result2, bundleBuildsToPath);
        }
        finally {
            GradleBuildInvoker.getInstance(this.myProject).remove(this);
        }
    }

    private void showNotification(@NotNull GradleInvocationResult result2, @NotNull Map<String, File> buildsAndBundlePaths) {
        AndroidNotification notification = AndroidNotification.getInstance(this.myProject);
        if (result2.isBuildSuccessful()) {
            this.notifySuccess(notification, buildsAndBundlePaths);
        } else if (result2.isBuildCancelled()) {
            notification.showBalloon(this.myNotificationTitle, "Build cancelled.", NotificationType.INFORMATION);
        } else {
            String msg = "Errors while building Bundle file. You can find the errors in the 'Messages' view.";
            notification.showBalloon(this.myNotificationTitle, msg, NotificationType.ERROR);
        }
    }

    private void notifySuccess(@NotNull AndroidNotification notification, @NotNull Map<String, File> bundleBuildsToPath) {
        boolean isSigned = !this.myBuildVariants.isEmpty();
        StringBuilder builder2 = new StringBuilder();
        int count = bundleBuildsToPath.size();
        builder2.append("App bundle(s) generated successfully for ");
        if (isSigned) {
            String moduleName2 = ((Module)Iterators.getOnlyElement(this.myModules.iterator())).getName();
            builder2.append("module '").append(moduleName2).append("' with ").append(count).append(count == 1 ? " build variant" : " build variants");
        } else {
            builder2.append(count).append(count == 1 ? " module" : " modules");
        }
        builder2.append(":<br/>");
        if (this.isShowFilePathActionSupported()) {
            Iterator<String> iterator = bundleBuildsToPath.keySet().iterator();
            while (iterator.hasNext()) {
                String moduleOrBuildVariant = iterator.next();
                if (isSigned) {
                    builder2.append("Build variant '");
                } else {
                    builder2.append("Module '");
                }
                builder2.append(moduleOrBuildVariant).append("': ");
                builder2.append("<a href=\"").append(LOCATE_URL_PREFIX).append(moduleOrBuildVariant).append("\">locate</a> or ");
                builder2.append("<a href=\"").append(ANALYZE_URL_PREFIX).append(moduleOrBuildVariant).append("\">analyze</a> the app bundle.");
                if (!iterator.hasNext()) continue;
                builder2.append("<br/>");
            }
            if (this.myExportedKeyFile != null) {
                builder2.append("<br/>");
                builder2.append("<a href=\"").append(LOCATE_KEY_URL_PREFIX).append("\">Locate</a> exported key file.");
            }
            String text2 = builder2.toString();
            notification.showBalloon(this.myNotificationTitle, text2, NotificationType.INFORMATION, (NotificationListener)new OpenFolderNotificationListener(this.myProject, bundleBuildsToPath, this.myExportedKeyFile));
        } else {
            builder2.append(bundleBuildsToPath.entrySet().stream().map(entry -> String.format(" - %s: %s", entry.getKey(), ((File)entry.getValue()).getPath())).collect(Collectors.joining("\n")));
            StringBuilder balloonBuilder = new StringBuilder();
            balloonBuilder.append("App bundle(s) generated successfully for ");
            if (isSigned) {
                String moduleName3 = ((Module)Iterators.getOnlyElement(this.myModules.iterator())).getName();
                balloonBuilder.append("module '").append(moduleName3).append("' with ").append(count).append(count == 1 ? " build variant" : " build variants");
            } else {
                balloonBuilder.append(count).append(count == 1 ? " module" : " modules");
            }
            notification.showBalloon(this.myNotificationTitle, balloonBuilder.toString(), NotificationType.INFORMATION, new OpenEventLogHyperlink());
            notification.addLogEvent(this.myNotificationTitle, builder2.toString(), NotificationType.INFORMATION);
        }
    }

    @VisibleForTesting
    boolean isShowFilePathActionSupported() {
        return RevealFileAction.isSupported();
    }

    private static Logger getLog() {
        return Logger.getInstance(GoToBundleLocationTask.class);
    }

    @VisibleForTesting
    static class OpenEventLogHyperlink
    extends NotificationHyperlink {
        OpenEventLogHyperlink() {
            super("open.event.log", "Show app bundle path(s) in the 'Event Log' view");
        }

        @Override
        protected void execute(@NotNull Project project) {
            ToolWindow tw = ToolWindowManager.getInstance((Project)project).getToolWindow("Event Log");
            if (tw != null) {
                tw.activate(null, false);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }
    }

    @VisibleForTesting
    static class OpenFolderNotificationListener
    extends NotificationListener.Adapter {
        @NotNull
        private final Project myProject;
        @NotNull
        private final Map<String, File> myBundlePathsPerModule;
        @Nullable
        private final File myExportedKeyFile;

        OpenFolderNotificationListener(@NotNull Project project, @NotNull Map<String, File> myBuildsAndBundlePaths, @Nullable File exportedKeyFile) {
            this.myProject = project;
            this.myBundlePathsPerModule = myBuildsAndBundlePaths;
            this.myExportedKeyFile = exportedKeyFile;
        }

        protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
            if (this.myProject.isDisposed()) {
                return;
            }
            String description2 = e.getDescription();
            if (description2.startsWith(GoToBundleLocationTask.ANALYZE_URL_PREFIX)) {
                this.openBundleAnalyzer(description2.substring(GoToBundleLocationTask.ANALYZE_URL_PREFIX.length()));
            } else if (description2.startsWith(GoToBundleLocationTask.LOCATE_URL_PREFIX)) {
                this.openBundleDirectory(description2.substring(GoToBundleLocationTask.LOCATE_URL_PREFIX.length()));
            } else if (description2.startsWith(GoToBundleLocationTask.LOCATE_KEY_URL_PREFIX)) {
                this.openKeyDirectory();
            }
        }

        private void openBundleAnalyzer(@NotNull String bundlePath) {
            VirtualFile virtualFile;
            File bundleFile = this.myBundlePathsPerModule.get(bundlePath);
            if (bundleFile == null) {
                GoToBundleLocationTask.getLog().warn(String.format("Error finding bundle file \"%s\"", bundlePath));
                return;
            }
            VirtualFile virtualFile2 = virtualFile = !bundleFile.isFile() ? this.askUserForBundleFile(bundleFile) : LocalFileSystem.getInstance().findFileByIoFile(bundleFile);
            if (virtualFile == null) {
                GoToBundleLocationTask.getLog().warn(String.format("Bundle file not found in virtual file system \"%s\"", bundlePath));
                return;
            }
            OpenFileDescriptor fd = new OpenFileDescriptor(this.myProject, virtualFile);
            List editors = FileEditorManager.getInstance((Project)this.myProject).openEditor(fd, true);
            if (editors.isEmpty()) {
                GoToBundleLocationTask.getLog().warn(String.format("Could not open editor for bundle file \"%s\"", bundlePath));
            }
        }

        @Nullable
        VirtualFile askUserForBundleFile(@NotNull File bundleFile) {
            FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFileDescriptor().withDescription("Select Bundle file to analyze").withFileFilter(file2 -> "aab".equalsIgnoreCase(file2.getExtension()));
            return FileChooser.chooseFile((FileChooserDescriptor)descriptor2, (Project)this.myProject, (VirtualFile)LocalFileSystem.getInstance().findFileByIoFile(bundleFile));
        }

        private void openBundleDirectory(String path2) {
            OpenFolderNotificationListener.showFileOrDirectory(this.myBundlePathsPerModule.get(path2));
        }

        private void openKeyDirectory() {
            assert (this.myExportedKeyFile != null);
            OpenFolderNotificationListener.showFileOrDirectory(this.myExportedKeyFile);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            OpenFolderNotificationListener listener2 = (OpenFolderNotificationListener)((Object)o);
            return Objects.equals(this.myBundlePathsPerModule, listener2.myBundlePathsPerModule);
        }

        public int hashCode() {
            return Objects.hash(this.myBundlePathsPerModule);
        }

        private static void showFileOrDirectory(@NotNull File file2) {
            if (file2.isFile()) {
                file2 = file2.getParentFile();
            }
            RevealFileAction.openDirectory((File)file2);
        }
    }
}

