/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.flags;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.GradleExperimentalSettings;
import com.android.tools.idea.gradle.project.sync.idea.TraceSyncUtil;
import com.android.tools.idea.rendering.RenderSettings;
import com.android.tools.idea.ui.LayoutEditorSettingsKt;
import com.android.tools.idea.ui.LayoutInspectorSettingsKt;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.LayoutEditorEvent;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExperimentalSettingsConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    @NotNull
    private final GradleExperimentalSettings mySettings;
    @NotNull
    private final RenderSettings myRenderSettings;
    private JPanel myPanel;
    private JCheckBox myUseL2DependenciesCheckBox;
    private JSlider myLayoutEditorQualitySlider;
    private JCheckBox myLayoutInspectorCheckbox;
    private JCheckBox myAtfCheckBox;
    private TitledSeparator myLayoutInspectorSeparator;
    private JCheckBox mySkipGradleTasksList;
    private JCheckBox myUseLayoutlibNative;
    private JCheckBox myTraceGradleSyncCheckBox;
    private JComboBox<TraceProfileItem> myTraceProfileComboBox;
    private TextFieldWithBrowseButton myTraceProfilePathField;
    private Runnable myRestartCallback;

    public ExperimentalSettingsConfigurable(@NotNull Project project) {
        this(GradleExperimentalSettings.getInstance(), RenderSettings.getProjectSettings(project));
    }

    @VisibleForTesting
    ExperimentalSettingsConfigurable(@NotNull GradleExperimentalSettings settings, @NotNull RenderSettings renderSettings) {
        this.mySettings = settings;
        this.myRenderSettings = renderSettings;
        this.$$$setupUI$$$();
        this.myUseL2DependenciesCheckBox.setVisible(false);
        Hashtable<Integer, JLabel> qualityLabels = new Hashtable<Integer, JLabel>();
        qualityLabels.put(new Integer(0), new JLabel("Fastest"));
        qualityLabels.put(new Integer(100), new JLabel("Slowest"));
        this.myLayoutEditorQualitySlider.setLabelTable(qualityLabels);
        this.myLayoutEditorQualitySlider.setPaintLabels(true);
        this.myLayoutEditorQualitySlider.setPaintTicks(true);
        this.myLayoutEditorQualitySlider.setMajorTickSpacing(25);
        boolean showLayoutInspectorSettings = (Boolean)StudioFlags.DYNAMIC_LAYOUT_INSPECTOR_ENABLED.get();
        this.myLayoutInspectorSeparator.setVisible(showLayoutInspectorSettings);
        this.myLayoutInspectorCheckbox.setVisible(showLayoutInspectorSettings);
        this.myAtfCheckBox.setVisible((Boolean)StudioFlags.NELE_LAYOUT_SCANNER_IN_EDITOR.get());
        this.initTraceComponents();
        this.reset();
    }

    @NotNull
    public String getId() {
        return "gradle.experimental";
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    @Nls
    public String getDisplayName() {
        return "Experimental";
    }

    @Nullable
    public String getHelpTopic() {
        return null;
    }

    @NotNull
    public JComponent createComponent() {
        return this.myPanel;
    }

    public boolean isModified() {
        return this.mySettings.USE_L2_DEPENDENCIES_ON_SYNC != this.isUseL2DependenciesInSync() || this.mySettings.SKIP_GRADLE_TASKS_LIST != this.skipGradleTasksList() || this.mySettings.TRACE_GRADLE_SYNC != this.traceGradleSync() || this.mySettings.TRACE_PROFILE_SELECTION != this.getTraceProfileSelection() || !this.mySettings.TRACE_PROFILE_LOCATION.equals(this.getTraceProfileLocation()) || (int)(this.myRenderSettings.getQuality() * 100.0f) != this.getQualitySetting() || this.myLayoutInspectorCheckbox.isSelected() != LayoutInspectorSettingsKt.getEnableLiveLayoutInspector() || this.myUseLayoutlibNative.isSelected() == PluginManagerCore.isDisabled((String)"com.android.layoutlib.native") || this.myAtfCheckBox.isSelected() != LayoutEditorSettingsKt.getAlwaysEnableLayoutScanner();
    }

    private int getQualitySetting() {
        return this.myLayoutEditorQualitySlider.getValue();
    }

    public void apply() throws ConfigurationException {
        this.mySettings.USE_L2_DEPENDENCIES_ON_SYNC = this.isUseL2DependenciesInSync();
        this.mySettings.SKIP_GRADLE_TASKS_LIST = this.skipGradleTasksList();
        this.myRenderSettings.setQuality((float)this.getQualitySetting() / 100.0f);
        LayoutInspectorSettingsKt.setEnableLiveLayoutInspector(this.myLayoutInspectorCheckbox.isSelected());
        LayoutEditorSettingsKt.setAlwaysEnableLayoutScanner(this.myAtfCheckBox.isSelected());
        if (this.myUseLayoutlibNative.isSelected() == PluginManagerCore.isDisabled((String)"com.android.layoutlib.native")) {
            this.myRestartCallback = () -> ApplicationManager.getApplication().invokeLater(() -> PluginManagerConfigurable.shutdownOrRestartApp());
            LayoutEditorEvent.Builder eventBuilder = LayoutEditorEvent.newBuilder();
            if (this.myUseLayoutlibNative.isSelected()) {
                eventBuilder.setType(LayoutEditorEvent.LayoutEditorEventType.ENABLE_LAYOUTLIB_NATIVE);
                PluginManagerCore.enablePlugin((String)"com.android.layoutlib.native");
            } else {
                eventBuilder.setType(LayoutEditorEvent.LayoutEditorEventType.DISABLE_LAYOUTLIB_NATIVE);
                PluginManagerCore.disablePlugin((String)"com.android.layoutlib.native");
                PluginManagerCore.enablePlugin((String)"com.android.layoutlib.standard");
            }
            AndroidStudioEvent.Builder studioEvent = AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.LAYOUT_EDITOR).setKind(AndroidStudioEvent.EventKind.LAYOUT_EDITOR_EVENT).setLayoutEditorEvent(eventBuilder.build());
            UsageTracker.log((AndroidStudioEvent.Builder)studioEvent);
        }
        this.applyTraceSettings();
    }

    public void disposeUIResources() {
        if (this.myRestartCallback != null) {
            this.myRestartCallback.run();
            this.myRestartCallback = null;
        }
    }

    @VisibleForTesting
    boolean isUseL2DependenciesInSync() {
        return this.myUseL2DependenciesCheckBox.isSelected();
    }

    void setUseL2DependenciesInSync(boolean value2) {
        this.myUseL2DependenciesCheckBox.setSelected(value2);
    }

    boolean skipGradleTasksList() {
        return this.mySkipGradleTasksList.isSelected();
    }

    void setSkipGradleTasksList(boolean value2) {
        this.mySkipGradleTasksList.setSelected(value2);
    }

    boolean traceGradleSync() {
        return this.myTraceGradleSyncCheckBox.isSelected();
    }

    void setTraceGradleSync(boolean value2) {
        this.myTraceGradleSyncCheckBox.setSelected(value2);
    }

    @Nullable
    TraceProfileItem getTraceProfileSelection() {
        return (TraceProfileItem)((Object)this.myTraceProfileComboBox.getSelectedItem());
    }

    void setTraceProfileSelection(@NotNull TraceProfileItem value2) {
        this.myTraceProfileComboBox.setSelectedItem((Object)value2);
    }

    @NotNull
    String getTraceProfileLocation() {
        return this.myTraceProfilePathField.getText();
    }

    void setTraceProfileLocation(@NotNull String value2) {
        this.myTraceProfilePathField.setText(value2);
    }

    private void initTraceComponents() {
        this.myTraceGradleSyncCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExperimentalSettingsConfigurable.this.updateTraceComponents();
            }
        });
        this.myTraceProfileComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExperimentalSettingsConfigurable.this.myTraceProfilePathField.setEnabled(TraceProfileItem.SPECIFIED_LOCATION.equals(ExperimentalSettingsConfigurable.this.myTraceProfileComboBox.getSelectedItem()));
                if (ExperimentalSettingsConfigurable.this.isTraceProfileInvalid()) {
                    ExternalSystemUiUtil.showBalloon((JComponent)ExperimentalSettingsConfigurable.this.myTraceProfilePathField, (MessageType)MessageType.WARNING, (String)"Invalid profile location");
                }
            }
        });
        this.myTraceProfilePathField.addBrowseFolderListener("Trace Profile", "Please select trace profile", null, FileChooserDescriptorFactory.createSingleFileDescriptor((String)"profile"));
        this.myTraceProfileComboBox.addItem(TraceProfileItem.DEFAULT);
        this.myTraceProfileComboBox.addItem(TraceProfileItem.SPECIFIED_LOCATION);
    }

    private void updateTraceComponents() {
        this.myTraceProfileComboBox.setEnabled(this.myTraceGradleSyncCheckBox.isSelected());
        this.myTraceProfilePathField.setEnabled(this.myTraceGradleSyncCheckBox.isSelected() && TraceProfileItem.SPECIFIED_LOCATION.equals(this.myTraceProfileComboBox.getSelectedItem()));
        if (this.isTraceProfileInvalid()) {
            ExternalSystemUiUtil.showBalloon((JComponent)this.myTraceProfilePathField, (MessageType)MessageType.WARNING, (String)"Invalid profile location");
        }
    }

    private void applyTraceSettings() {
        boolean canRestart;
        String okText;
        String message2;
        int result2;
        if (this.isTraceProfileInvalid()) {
            ExternalSystemUiUtil.showBalloon((JComponent)this.myTraceProfilePathField, (MessageType)MessageType.WARNING, (String)"Invalid profile location");
            return;
        }
        Application app = ApplicationManager.getApplication();
        if (app.isUnitTestMode()) {
            this.saveTraceSettings();
            return;
        }
        if (!(this.mySettings.TRACE_GRADLE_SYNC == this.traceGradleSync() && this.mySettings.TRACE_PROFILE_SELECTION == this.getTraceProfileSelection() && this.mySettings.TRACE_PROFILE_LOCATION.equals(this.getTraceProfileLocation()) || (result2 = Messages.showOkCancelDialog((String)(message2 = "A restart of Android Studio is required to apply changes related to tracing.\n\nDo you want to proceed?"), (String)"Restart", (String)(okText = (canRestart = app.isRestartCapable()) ? "Restart" : "Exit"), (String)"Cancel", (Icon)Messages.getQuestionIcon())) != 0)) {
            this.saveTraceSettings();
            TraceSyncUtil.updateTraceArgsInFile();
            app.exit(false, true, true);
        }
    }

    private void saveTraceSettings() {
        this.mySettings.TRACE_GRADLE_SYNC = this.traceGradleSync();
        this.mySettings.TRACE_PROFILE_SELECTION = this.getTraceProfileSelection();
        this.mySettings.TRACE_PROFILE_LOCATION = this.getTraceProfileLocation();
    }

    @VisibleForTesting
    boolean isTraceProfileInvalid() {
        if (this.traceGradleSync() && this.getTraceProfileSelection() == TraceProfileItem.SPECIFIED_LOCATION) {
            File selectedFile = new File(this.getTraceProfileLocation());
            return !selectedFile.isFile() || !selectedFile.getName().endsWith(".profile");
        }
        return false;
    }

    public void reset() {
        this.myUseL2DependenciesCheckBox.setSelected(this.mySettings.USE_L2_DEPENDENCIES_ON_SYNC);
        this.mySkipGradleTasksList.setSelected(this.mySettings.SKIP_GRADLE_TASKS_LIST);
        this.myLayoutEditorQualitySlider.setValue((int)(this.myRenderSettings.getQuality() * 100.0f));
        this.myLayoutInspectorCheckbox.setSelected(LayoutInspectorSettingsKt.getEnableLiveLayoutInspector());
        this.myUseLayoutlibNative.setSelected(!PluginManagerCore.isDisabled((String)"com.android.layoutlib.native"));
        this.myTraceGradleSyncCheckBox.setSelected(this.mySettings.TRACE_GRADLE_SYNC);
        this.myTraceProfileComboBox.setSelectedItem((Object)this.mySettings.TRACE_PROFILE_SELECTION);
        this.myTraceProfilePathField.setText(this.mySettings.TRACE_PROFILE_LOCATION);
        this.myAtfCheckBox.setSelected(LayoutEditorSettingsKt.getAlwaysEnableLayoutScanner());
        this.updateTraceComponents();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        TitledSeparator titledSeparator;
        JSlider jSlider;
        JCheckBox jCheckBox6;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(13, 8, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("<html><b>Note:</b> These settings are for features that are considered <b>experimental</b>.</html>");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 8, 0, 1, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(12, 4, 1, 4, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("<html><br></html>");
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 6, 0, 0, 0, 0, null, null, null));
        this.myUseL2DependenciesCheckBox = jCheckBox6 = new JCheckBox();
        jCheckBox6.setText("Use new dependency mechanism during Gradle sync");
        jPanel.add((Component)jCheckBox6, new GridConstraints(3, 0, 1, 6, 8, 0, 3, 0, null, null, null));
        TitledSeparator titledSeparator2 = new TitledSeparator();
        titledSeparator2.setText("Gradle");
        jPanel.add((Component)titledSeparator2, new GridConstraints(2, 0, 1, 8, 0, 1, 3, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Quality Setting");
        jPanel.add((Component)jBLabel3, new GridConstraints(7, 0, 1, 5, 8, 0, 0, 0, null, null, null));
        this.myLayoutEditorQualitySlider = jSlider = new JSlider();
        jPanel.add((Component)jSlider, new GridConstraints(7, 6, 1, 1, 0, 1, 0, 0, new Dimension(150, -1), new Dimension(90, -1), null));
        TitledSeparator titledSeparator3 = new TitledSeparator();
        titledSeparator3.setText("Layout Editor");
        jPanel.add((Component)titledSeparator3, new GridConstraints(6, 0, 1, 8, 0, 1, 3, 0, null, null, null));
        this.myLayoutInspectorSeparator = titledSeparator = new TitledSeparator();
        titledSeparator.setText("Layout Inspector");
        jPanel.add((Component)titledSeparator, new GridConstraints(10, 0, 1, 8, 0, 1, 3, 0, null, null, null));
        this.myLayoutInspectorCheckbox = jCheckBox5 = new JCheckBox();
        jCheckBox5.setText("Enable Live Layout Inspector");
        jPanel.add((Component)jCheckBox5, new GridConstraints(11, 0, 1, 6, 8, 0, 3, 0, null, null, null));
        this.mySkipGradleTasksList = jCheckBox4 = new JCheckBox();
        jCheckBox4.setText("Do not build Gradle task list during Gradle sync");
        jPanel.add((Component)jCheckBox4, new GridConstraints(4, 0, 1, 7, 8, 0, 3, 0, null, null, null));
        this.myUseLayoutlibNative = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Use new Layout Rendering Engine");
        jPanel.add((Component)jCheckBox3, new GridConstraints(9, 0, 1, 7, 8, 0, 3, 0, null, null, null));
        this.myTraceGradleSyncCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Trace Gradle import with profile:");
        jPanel.add((Component)jCheckBox2, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myTraceProfileComboBox = jComboBox;
        jPanel.add(jComboBox, new GridConstraints(5, 1, 1, 5, 8, 1, 2, 0, null, null, null));
        this.myTraceProfilePathField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(5, 6, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myAtfCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Use new Accessibility Testing Framework");
        jPanel.add((Component)jCheckBox, new GridConstraints(8, 0, 1, 6, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    public static enum TraceProfileItem {
        DEFAULT("Default profile"),
        SPECIFIED_LOCATION("Specified location");

        private String displayValue;

        private TraceProfileItem(String value2) {
            this.displayValue = value2;
        }

        public String toString() {
            return this.displayValue;
        }
    }
}

