/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.explorer.options;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.explorer.options.DeviceFileExplorerSettings;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DeviceFileExplorerConfigurable
implements SearchableConfigurable {
    private JPanel myContentPanel;
    private TextFieldWithBrowseButton myDownloadLocation;

    DeviceFileExplorerConfigurable() {
        this.$$$setupUI$$$();
        this.myDownloadLocation.addBrowseFolderListener("Device File Explorer Download Location", null, null, new FileChooserDescriptor(false, true, false, false, false, false));
    }

    @NotNull
    public String getId() {
        return "device.file.explorer";
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    @Nullable
    public JComponent createComponent() {
        return this.myContentPanel;
    }

    public boolean isModified() {
        return !DeviceFileExplorerSettings.getInstance().getDownloadLocation().equals(this.myDownloadLocation.getText());
    }

    public void apply() throws ConfigurationException {
        Path path2 = Paths.get(this.getDownloadLocation(), new String[0]);
        if (!Files.isDirectory(path2, new LinkOption[0])) {
            throw new ConfigurationException("Path must be an existing directory", "Invalid Path");
        }
        DeviceFileExplorerSettings.getInstance().setDownloadLocation(path2.toString());
    }

    public void reset() {
        this.myDownloadLocation.setText(DeviceFileExplorerSettings.getInstance().getDownloadLocation());
    }

    public void disposeUIResources() {
    }

    @Nls
    public String getDisplayName() {
        if (IdeInfo.getInstance().isAndroidStudio()) {
            return "Device File Explorer";
        }
        return "Android Device File Explorer";
    }

    @NotNull
    private String getDownloadLocation() {
        return this.myDownloadLocation.getText();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.myContentPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myDownloadLocation = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setText("");
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Download location");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }
}

