/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.explorer.adbimpl;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.SyncService;
import com.android.tools.idea.concurrency.FutureCallbackExecutor;
import com.android.tools.idea.explorer.adbimpl.AdbFileListingEntry;
import com.android.tools.idea.explorer.adbimpl.AdbFileOperations;
import com.android.tools.idea.explorer.fs.FileTransferProgress;
import com.android.tools.idea.explorer.fs.ThrottledProgress;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Locale;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdbFileTransfer {
    @NotNull
    private static Logger LOGGER = Logger.getInstance(AdbFileTransfer.class);
    @NotNull
    private final IDevice myDevice;
    @NotNull
    private final AdbFileOperations myFileOperations;
    @NotNull
    private final FutureCallbackExecutor myProgressExecutor;
    @NotNull
    private final FutureCallbackExecutor myTaskExecutor;

    public AdbFileTransfer(@NotNull IDevice device, @NotNull AdbFileOperations fileOperations, @NotNull Executor progressExecutor, @NotNull Executor taskExecutor2) {
        this.myDevice = device;
        this.myFileOperations = fileOperations;
        this.myProgressExecutor = FutureCallbackExecutor.wrap((Executor)progressExecutor);
        this.myTaskExecutor = FutureCallbackExecutor.wrap((Executor)taskExecutor2);
    }

    @NotNull
    public ListenableFuture<Void> downloadFile(@NotNull AdbFileListingEntry remoteFileEntry, @NotNull Path localPath, @NotNull FileTransferProgress progress) {
        return this.downloadFileWorker(remoteFileEntry.getFullPath(), remoteFileEntry.getSize(), localPath, progress);
    }

    @NotNull
    public ListenableFuture<Void> downloadFile(@NotNull String remotePath, long remotePathSize, @NotNull Path localPath, @NotNull FileTransferProgress progress) {
        return this.downloadFileWorker(remotePath, remotePathSize, localPath, progress);
    }

    @NotNull
    public ListenableFuture<Void> downloadFileViaTempLocation(@NotNull String remotePath, long remotePathSize, @NotNull Path localPath, @NotNull FileTransferProgress progress, @Nullable String runAs) {
        ListenableFuture<String> futureTempFile = this.myFileOperations.createTempFile("/data/local/tmp");
        return this.myTaskExecutor.transformAsync(futureTempFile, tempFile -> {
            assert (tempFile != null);
            ListenableFuture<Void> futureCopy = this.myFileOperations.copyFileRunAs(remotePath, (String)tempFile, runAs);
            ListenableFuture futureDownload = this.myTaskExecutor.transformAsync(futureCopy, aVoid -> this.downloadFile((String)tempFile, remotePathSize, localPath, progress));
            return this.myTaskExecutor.finallyAsync(futureDownload, () -> this.myFileOperations.deleteFile((String)tempFile));
        });
    }

    @NotNull
    public ListenableFuture<Void> uploadFile(@NotNull Path localPath, @NotNull String remotePath, @NotNull FileTransferProgress progress) {
        return this.uploadFileWorker(localPath, remotePath, progress);
    }

    public ListenableFuture<Void> uploadFileViaTempLocation(@NotNull Path localPath, @NotNull String remotePath, @NotNull FileTransferProgress progress, @Nullable String runAs) {
        ListenableFuture<String> futureTempFile = this.myFileOperations.createTempFile("/data/local/tmp");
        return this.myTaskExecutor.transformAsync(futureTempFile, tempFile -> {
            assert (tempFile != null);
            ListenableFuture<Void> futureUpload = this.uploadFile(localPath, (String)tempFile, progress);
            ListenableFuture futureCopy = this.myTaskExecutor.transformAsync(futureUpload, aVoid -> this.myFileOperations.copyFileRunAs((String)tempFile, remotePath, runAs));
            return this.myTaskExecutor.finallyAsync(futureCopy, () -> this.myFileOperations.deleteFile((String)tempFile));
        });
    }

    @NotNull
    private ListenableFuture<Void> downloadFileWorker(@NotNull String remotePath, long remotePathSize, @NotNull Path localPath, @NotNull FileTransferProgress progress) {
        ListenableFuture<SyncService> futureSyncService = this.getSyncService();
        ListenableFuture futurePull = this.myTaskExecutor.transform(futureSyncService, syncService -> {
            assert (syncService != null);
            try {
                long startTime = System.nanoTime();
                syncService.pullFile(remotePath, localPath.toString(), (SyncService.ISyncProgressMonitor)new SingleFileProgressMonitor((Executor)this.myProgressExecutor, progress, remotePathSize));
                long endTime = System.nanoTime();
                LOGGER.info(String.format(Locale.US, "Pull file took %,d ms to execute: \"%s\" -> \"%s\"", (endTime - startTime) / 1000000L, remotePath, localPath));
                Void void_ = null;
                return void_;
            }
            finally {
                syncService.close();
            }
        });
        return this.myTaskExecutor.catchingAsync(futurePull, SyncException.class, syncError -> {
            assert (syncError != null);
            if (syncError.wasCanceled()) {
                return Futures.immediateCancelledFuture();
            }
            LOGGER.info(String.format("Error pulling file from \"%s\" to \"%s\"", remotePath, localPath), (Throwable)syncError);
            return Futures.immediateFailedFuture((Throwable)syncError);
        });
    }

    @NotNull
    private ListenableFuture<Void> uploadFileWorker(@NotNull Path localPath, @NotNull String remotePath, @NotNull FileTransferProgress progress) {
        ListenableFuture<SyncService> futureSyncService = this.getSyncService();
        ListenableFuture futurePush = this.myTaskExecutor.transform(futureSyncService, syncService -> {
            assert (syncService != null);
            try {
                long fileLength = localPath.toFile().length();
                long startTime = System.nanoTime();
                syncService.pushFile(localPath.toString(), remotePath, (SyncService.ISyncProgressMonitor)new SingleFileProgressMonitor((Executor)this.myProgressExecutor, progress, fileLength));
                long endTime = System.nanoTime();
                LOGGER.info(String.format(Locale.US, "Push file took %,d ms to execute: \"%s\" -> \"%s\"", (endTime - startTime) / 1000000L, localPath, remotePath));
                Void void_ = null;
                return void_;
            }
            finally {
                syncService.close();
            }
        });
        return this.myTaskExecutor.catchingAsync(futurePush, SyncException.class, syncError -> {
            assert (syncError != null);
            if (syncError.wasCanceled()) {
                return Futures.immediateCancelledFuture();
            }
            LOGGER.info(String.format("Error pushing file from \"%s\" to \"%s\"", localPath, remotePath), (Throwable)syncError);
            return Futures.immediateFailedFuture((Throwable)syncError);
        });
    }

    @NotNull
    private ListenableFuture<SyncService> getSyncService() {
        return this.myTaskExecutor.executeAsync(() -> {
            SyncService sync = this.myDevice.getSyncService();
            if (sync == null) {
                throw new IOException("Unable to open synchronization service to device");
            }
            return sync;
        });
    }

    private static class SingleFileProgressMonitor
    implements SyncService.ISyncProgressMonitor {
        private static final int PROGRESS_REPORT_INTERVAL_MILLIS = 50;
        @NotNull
        private final Executor myCallbackExecutor;
        @NotNull
        private final FileTransferProgress myProgress;
        @NotNull
        private final ThrottledProgress myThrottledProgress;
        private final long myTotalBytes;
        private long myCurrentBytes;

        public SingleFileProgressMonitor(@NotNull Executor callbackExecutor, @NotNull FileTransferProgress progress, long totalBytes) {
            this.myCallbackExecutor = callbackExecutor;
            this.myProgress = progress;
            this.myTotalBytes = totalBytes;
            this.myThrottledProgress = new ThrottledProgress(50L);
        }

        public void start(int totalWork) {
            this.myCallbackExecutor.execute(() -> this.myProgress.progress(0L, this.myTotalBytes));
        }

        public void stop() {
            this.myCallbackExecutor.execute(() -> this.myProgress.progress(this.myTotalBytes, this.myTotalBytes));
        }

        public boolean isCanceled() {
            return this.myProgress.isCancelled();
        }

        public void startSubTask(String name) {
            assert (false) : "A single file sync should not have multiple tasks";
        }

        public void advance(int work) {
            this.myCurrentBytes += (long)work;
            if (this.myThrottledProgress.check()) {
                long currentBytes = this.myCurrentBytes;
                this.myCallbackExecutor.execute(() -> this.myProgress.progress(currentBytes, this.myTotalBytes));
            }
        }
    }
}

