/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.explorer.adbimpl;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.TimeoutException;
import com.android.tools.idea.explorer.adbimpl.AdbDeviceDefaultFileEntry;
import com.android.tools.idea.explorer.adbimpl.AdbDeviceFileEntry;
import com.android.tools.idea.explorer.adbimpl.AdbDeviceFileSystem;
import com.android.tools.idea.explorer.adbimpl.AdbFileListingEntry;
import com.android.tools.idea.explorer.adbimpl.AdbPathUtil;
import com.android.tools.idea.explorer.adbimpl.AdbShellCommandException;
import com.android.tools.idea.explorer.fs.DeviceFileEntry;
import com.android.tools.idea.explorer.fs.FileTransferProgress;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdbDeviceDirectFileEntry
extends AdbDeviceFileEntry {
    @Nullable
    private final String myRunAs;

    public AdbDeviceDirectFileEntry(@NotNull AdbDeviceFileSystem device, @NotNull AdbFileListingEntry entry, @Nullable AdbDeviceFileEntry parent, @Nullable String runAs) {
        super(device, entry, parent);
        this.myRunAs = runAs;
    }

    @Override
    @NotNull
    public ListenableFuture<List<DeviceFileEntry>> getEntries() {
        ListenableFuture<List<AdbFileListingEntry>> children = this.myDevice.getAdbFileListing().getChildrenRunAs(this.myEntry, this.myRunAs);
        return this.myDevice.getTaskExecutor().transform(children, result2 -> {
            assert (result2 != null);
            return result2.stream().map(listingEntry -> new AdbDeviceDefaultFileEntry(this.myDevice, (AdbFileListingEntry)listingEntry, this)).collect(Collectors.toList());
        });
    }

    @Override
    @NotNull
    public ListenableFuture<Void> delete() {
        if (this.isDirectory()) {
            return this.myDevice.getAdbFileOperations().deleteRecursiveRunAs(this.getFullPath(), this.myRunAs);
        }
        return this.myDevice.getAdbFileOperations().deleteFileRunAs(this.getFullPath(), this.myRunAs);
    }

    @Override
    @NotNull
    public ListenableFuture<Void> createNewFile(@NotNull String fileName) {
        return this.myDevice.getAdbFileOperations().createNewFileRunAs(this.getFullPath(), fileName, this.myRunAs);
    }

    @Override
    @NotNull
    public ListenableFuture<Void> createNewDirectory(@NotNull String directoryName) {
        return this.myDevice.getAdbFileOperations().createNewDirectoryRunAs(this.getFullPath(), directoryName, this.myRunAs);
    }

    @Override
    @NotNull
    public ListenableFuture<Boolean> isSymbolicLinkToDirectory() {
        return this.myDevice.getAdbFileListing().isDirectoryLinkRunAs(this.myEntry, this.myRunAs);
    }

    @Override
    @NotNull
    public ListenableFuture<Void> downloadFile(@NotNull Path localPath, @NotNull FileTransferProgress progress) {
        ListenableFuture<Void> futureDownload = this.myDevice.getAdbFileTransfer().downloadFile(this.myEntry, localPath, progress);
        return this.myDevice.getTaskExecutor().catchingAsync(futureDownload, SyncException.class, syncException -> {
            assert (syncException != null);
            if (AdbDeviceDirectFileEntry.isSyncPermissionError(syncException) && this.isDeviceSuAndNotRoot()) {
                return this.myDevice.getAdbFileTransfer().downloadFileViaTempLocation(this.getFullPath(), this.getSize(), localPath, progress, null);
            }
            return Futures.immediateFailedFuture((Throwable)syncException);
        });
    }

    @Override
    @NotNull
    public ListenableFuture<Void> uploadFile(@NotNull Path localPath, @NotNull String fileName, @NotNull FileTransferProgress progress) {
        String remotePath = AdbPathUtil.resolve(this.myEntry.getFullPath(), fileName);
        ListenableFuture futureShouldCreateRemote = this.myDevice.getTaskExecutor().executeAsync(this::isDeviceSuAndNotRoot);
        return this.myDevice.getTaskExecutor().transformAsync(futureShouldCreateRemote, shouldCreateRemote -> {
            assert (shouldCreateRemote != null);
            if (shouldCreateRemote.booleanValue()) {
                ListenableFuture<Void> futureTouchFile = this.myDevice.getAdbFileOperations().touchFileAsDefaultUser(remotePath);
                ListenableFuture futureUpload = this.myDevice.getTaskExecutor().transformAsync(futureTouchFile, aVoid -> this.myDevice.getAdbFileTransfer().uploadFile(localPath, remotePath, progress));
                return this.myDevice.getTaskExecutor().catchingAsync(futureUpload, AdbShellCommandException.class, error -> this.myDevice.getAdbFileTransfer().uploadFileViaTempLocation(localPath, remotePath, progress, null));
            }
            return this.myDevice.getAdbFileTransfer().uploadFile(localPath, remotePath, progress);
        });
    }

    private static boolean isSyncPermissionError(@NotNull SyncException pullError) {
        return pullError.getErrorCode() == SyncException.SyncError.NO_REMOTE_OBJECT || pullError.getErrorCode() == SyncException.SyncError.TRANSFER_PROTOCOL_ERROR;
    }

    private boolean isDeviceSuAndNotRoot() throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        return this.myDevice.getCapabilities().supportsSuRootCommand() && !this.myDevice.getCapabilities().isRoot();
    }
}

