/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.explorer;

import com.android.tools.idea.explorer.DeviceExplorer;
import com.android.tools.idea.explorer.DeviceExplorerController;
import com.android.tools.idea.explorer.DeviceExplorerFileManager;
import com.android.tools.idea.explorer.DeviceExplorerModel;
import com.android.tools.idea.explorer.adbimpl.AdbDeviceFileSystemRendererFactory;
import com.android.tools.idea.explorer.adbimpl.AdbDeviceFileSystemService;
import com.android.tools.idea.explorer.ui.DeviceExplorerViewImpl;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.concurrency.EdtExecutorService;
import icons.StudioIcons;
import java.nio.file.Path;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.PooledThreadExecutor;

public class DeviceExplorerToolWindowFactory
implements DumbAware,
ToolWindowFactory {
    public static final String TOOL_WINDOW_ID = "Device File Explorer";

    public boolean isApplicable(@NotNull Project project) {
        return DeviceExplorer.isFeatureEnabled();
    }

    public void createToolWindowContent(final @NotNull Project project, @NotNull ToolWindow toolWindow) {
        toolWindow.setIcon(StudioIcons.Shell.ToolWindows.DEVICE_EXPLORER);
        toolWindow.setAvailable(true);
        toolWindow.setToHideOnEmptyContent(true);
        toolWindow.setTitle(TOOL_WINDOW_ID);
        EdtExecutorService edtExecutor2 = EdtExecutorService.getInstance();
        ExecutorService taskExecutor2 = PooledThreadExecutor.INSTANCE;
        AdbDeviceFileSystemService adbService2 = (AdbDeviceFileSystemService)ServiceManager.getService((Project)project, AdbDeviceFileSystemService.class);
        DeviceExplorerFileManager fileManager = (DeviceExplorerFileManager)ServiceManager.getService((Project)project, DeviceExplorerFileManager.class);
        AdbDeviceFileSystemRendererFactory deviceFileSystemRendererFactory = new AdbDeviceFileSystemRendererFactory(adbService2);
        DeviceExplorerModel model2 = new DeviceExplorerModel();
        DeviceExplorerViewImpl view = new DeviceExplorerViewImpl(project, deviceFileSystemRendererFactory, model2);
        DeviceExplorerController.FileOpener fileOpener = new DeviceExplorerController.FileOpener(){

            @Override
            public void openFile(@NotNull Path localPath) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
                    OpenFileAction.openFile((String)localPath.toString(), (Project)project);
                }, project.getDisposed());
            }

            @Override
            public void openFile(@NotNull VirtualFile virtualFile) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
                    OpenFileAction.openFile((VirtualFile)virtualFile, (Project)project);
                }, project.getDisposed());
            }
        };
        DeviceExplorerController controller2 = new DeviceExplorerController(project, model2, view, adbService2, fileManager, fileOpener, (Executor)edtExecutor2, taskExecutor2);
        controller2.setup();
        ContentManager contentManager = toolWindow.getContentManager();
        Content toolWindowContent = contentManager.getFactory().createContent(view.getComponent(), "", true);
        contentManager.addContent(toolWindowContent);
    }
}

