/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.explorer;

import com.android.tools.idea.concurrency.FutureCallbackExecutor;
import com.android.tools.idea.device.fs.DeviceFileId;
import com.android.tools.idea.device.fs.DownloadProgress;
import com.android.tools.idea.explorer.DeviceExplorerFileManager;
import com.android.tools.idea.explorer.DeviceExplorerFilesUtils;
import com.android.tools.idea.explorer.fs.DeviceFileEntry;
import com.android.tools.idea.explorer.fs.DeviceFileSystem;
import com.android.tools.idea.explorer.fs.FileTransferProgress;
import com.android.tools.idea.explorer.options.DeviceFileExplorerSettings;
import com.android.utils.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.PathUtilRt;
import com.intellij.util.concurrency.EdtExecutorService;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.PooledThreadExecutor;

public class DeviceExplorerFileManagerImpl
implements DeviceExplorerFileManager {
    private static final Logger LOGGER = Logger.getInstance(DeviceExplorerFileManagerImpl.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final FutureCallbackExecutor myEdtExecutor;
    @NotNull
    private final FutureCallbackExecutor myTaskExecutor;
    @NotNull
    private Supplier<Path> myDefaultDownloadPath;

    private DeviceExplorerFileManagerImpl(@NotNull Project project) {
        this(project, (Executor)new FutureCallbackExecutor((Executor)EdtExecutorService.getInstance()), (Executor)new FutureCallbackExecutor((Executor)PooledThreadExecutor.INSTANCE), () -> Paths.get(DeviceFileExplorerSettings.getInstance().getDownloadLocation(), new String[0]));
    }

    @NonInjectable
    @VisibleForTesting
    public DeviceExplorerFileManagerImpl(@NotNull Project project, @NotNull Executor edtExecutor2, @NotNull Executor taskExecutor2, @NotNull Supplier<Path> downloadPathSupplier) {
        this.myProject = project;
        this.myProject.getMessageBus().connect().subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                if (VfsUtilCore.isAncestor((File)DeviceExplorerFileManagerImpl.this.getDefaultDownloadPath().toFile(), (File)VfsUtilCore.virtualToIoFile((VirtualFile)file2), (boolean)true)) {
                    Path localPath = Paths.get(file2.getPath(), new String[0]);
                    DeviceExplorerFileManagerImpl.deleteTemporaryFile(localPath);
                }
            }
        });
        this.myEdtExecutor = new FutureCallbackExecutor(edtExecutor2);
        this.myTaskExecutor = new FutureCallbackExecutor(taskExecutor2);
        this.myDefaultDownloadPath = downloadPathSupplier;
    }

    @NotNull
    public Path getDefaultLocalPathForDevice(@NotNull DeviceFileSystem device) {
        Path rootPath = this.getDefaultDownloadPath();
        return rootPath.resolve(DeviceExplorerFileManagerImpl.mapName(device.getName()));
    }

    @Override
    @NotNull
    public Path getDefaultLocalPathForEntry(@NotNull DeviceFileEntry entry) {
        Path devicePath = this.getDefaultLocalPathForDevice(entry.getFileSystem());
        return this.getPathForEntry(entry, devicePath);
    }

    @Override
    @NotNull
    public ListenableFuture<VirtualFile> downloadFileEntry(@NotNull DeviceFileEntry entry, @NotNull Path localPath, @NotNull DownloadProgress progress) {
        final SettableFuture futureResult = SettableFuture.create();
        FileUtils.mkdirs((File)localPath.getParent().toFile());
        ApplicationManager.getApplication().invokeLater(() -> ApplicationManager.getApplication().runWriteAction(() -> {
            VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)localPath.toFile(), (boolean)true);
            if (virtualFile != null) {
                try {
                    this.deleteVirtualFile(virtualFile);
                }
                catch (Throwable exception) {
                    futureResult.setException(exception);
                    return;
                }
            }
            this.myTaskExecutor.addCallback(this.downloadFile(entry, localPath, progress), (FutureCallback)new FutureCallback<VirtualFile>(){

                public void onSuccess(VirtualFile result2) {
                    futureResult.set((Object)result2);
                }

                public void onFailure(@NotNull Throwable throwable) {
                    futureResult.setException(throwable);
                }
            });
        }), this.myProject.getDisposed());
        return futureResult;
    }

    @Override
    public ListenableFuture<Void> deleteFile(@NotNull VirtualFile virtualFile) {
        SettableFuture futureResult = SettableFuture.create();
        ApplicationManager.getApplication().invokeLater(() -> ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                this.deleteVirtualFile(virtualFile);
                futureResult.set(null);
            }
            catch (Throwable exception) {
                futureResult.setException(exception);
            }
        }), this.myProject.getDisposed());
        return futureResult;
    }

    private void deleteVirtualFile(@NotNull VirtualFile virtualFile) throws IOException {
        ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
        virtualFile.delete((Object)this);
    }

    @NotNull
    private ListenableFuture<VirtualFile> downloadFile(final @NotNull DeviceFileEntry entry, final @NotNull Path localPath, final @NotNull DownloadProgress progress) {
        FileTransferProgress fileTransferProgress = this.createFileTransferProgress(entry, progress);
        progress.onStarting(entry.getFullPath());
        ListenableFuture<Void> downloadFileFuture = entry.downloadFile(localPath, fileTransferProgress);
        ListenableFuture getVirtualFile = this.myTaskExecutor.transformAsync(downloadFileFuture, aVoid -> DeviceExplorerFilesUtils.findFile(localPath));
        this.myEdtExecutor.addCallback(getVirtualFile, (FutureCallback)new FutureCallback<VirtualFile>(){

            public void onSuccess(VirtualFile virtualFile) {
                DeviceFileId fileInfo = new DeviceFileId(entry.getFileSystem().getName(), entry.getFullPath());
                fileInfo.storeInVirtualFile(virtualFile);
                progress.onCompleted(entry.getFullPath());
            }

            public void onFailure(@NotNull Throwable t) {
                progress.onCompleted(entry.getFullPath());
                DeviceExplorerFileManagerImpl.deleteTemporaryFile(localPath);
            }
        });
        return getVirtualFile;
    }

    private FileTransferProgress createFileTransferProgress(final @NotNull DeviceFileEntry entry, final @NotNull DownloadProgress progress) {
        return new FileTransferProgress(){

            @Override
            public void progress(long currentBytes, long totalBytes) {
                progress.onProgress(entry.getFullPath(), currentBytes, totalBytes);
            }

            @Override
            public boolean isCancelled() {
                return progress.isCancelled();
            }
        };
    }

    @NotNull
    private ListenableFuture<List<DeviceFileEntry>> mapPathsToEntries(@NotNull DeviceFileSystem fileSystem, @NotNull List<String> paths) {
        ArrayList entries = new ArrayList();
        ListenableFuture allDone = this.myTaskExecutor.executeFuturesInSequence(paths.iterator(), path2 -> {
            ListenableFuture<DeviceFileEntry> futureEntry = fileSystem.getEntry((String)path2);
            return this.myTaskExecutor.transform(futureEntry, entry -> {
                entries.add(entry);
                return null;
            });
        });
        return this.myTaskExecutor.transform(allDone, aVoid -> entries);
    }

    @NotNull
    private Path getDefaultDownloadPath() {
        return this.myDefaultDownloadPath.get();
    }

    @NotNull
    private static String mapName(String name) {
        return PathUtilRt.suggestFileName((String)name, (boolean)true, (boolean)true);
    }

    @Override
    @NotNull
    public Path getPathForEntry(@NotNull DeviceFileEntry file2, @NotNull Path destinationPath) {
        ArrayList<String> entryPathComponents = new ArrayList<String>();
        for (DeviceFileEntry entry = file2; entry != null; entry = entry.getParent()) {
            entryPathComponents.add(DeviceExplorerFileManagerImpl.mapName(entry.getName()));
        }
        Collections.reverse(entryPathComponents);
        Path entryDestinationPath = destinationPath;
        for (String name : entryPathComponents) {
            entryDestinationPath = entryDestinationPath.resolve(name);
        }
        return entryDestinationPath;
    }

    private static void deleteTemporaryFile(@NotNull Path localPath) {
        try {
            Files.deleteIfExists(localPath);
        }
        catch (IOException e) {
            LOGGER.warn(String.format("Error deleting device file from local file system \"%s\"", localPath), (Throwable)e);
        }
    }
}

