/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.experimental.codeanalysis.utils;

import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.tree.java.PsiReferenceExpressionImpl;
import java.util.logging.Logger;

public class PsiCFGDebugUtil {
    public static final Logger LOG = Logger.getLogger(PsiCFGDebugUtil.class.getSimpleName());

    public static void debugOutputPsiElement(PsiElement e) {
        StringBuilder sb = new StringBuilder();
        sb.append("PsiElement Debug>> Type: " + e.getClass().getSimpleName() + " HashCode " + e.hashCode());
        sb.append("\n");
        if (e instanceof PsiAnonymousClass) {
            PsiCFGDebugUtil.debugOutputPsiAnonymousClass(sb, (PsiAnonymousClass)e);
        } else if (e instanceof PsiClass) {
            PsiCFGDebugUtil.debugOutputPsiClass(sb, (PsiClass)e);
        } else if (e instanceof PsiMethod) {
            PsiCFGDebugUtil.debugOutputPsiMethod(sb, (PsiMethod)e);
        } else if (e instanceof PsiParameter) {
            PsiCFGDebugUtil.debugOutputPsiParameter(sb, (PsiParameter)e);
        } else if (e instanceof PsiJavaFile) {
            PsiCFGDebugUtil.debugOutputPsiJavaFile(sb, (PsiJavaFile)e);
        } else if (!(e instanceof PsiModifier) && !(e instanceof PsiModifierList)) {
            if (e instanceof PsiField) {
                PsiCFGDebugUtil.debugOutputPsiField(sb, (PsiField)e);
            } else if (e instanceof PsiReferenceExpression) {
                PsiCFGDebugUtil.debugOutputPsiReferenceExpression(sb, (PsiReferenceExpression)e);
            } else if (e instanceof PsiThisExpression) {
                PsiCFGDebugUtil.debugOutputPsiThisExpression(sb, (PsiThisExpression)e);
            }
        }
        LOG.info(sb.toString());
    }

    private static void debugOutputPsiParameter(StringBuilder sb, PsiParameter e) {
        sb.append("PsiParameter: " + e.getName() + "\n");
        sb.append("Type: " + e.getType().getCanonicalText() + "\n");
        sb.append("\n");
    }

    private static void debugOutputPsiJavaFile(StringBuilder sb, PsiJavaFile e) {
        PsiClass[] allClasses;
        sb.append("JavaFile: " + e.getName() + "\n");
        for (PsiClass mClass : allClasses = e.getClasses()) {
            sb.append("Class in file: " + mClass.getQualifiedName() + "\n");
        }
        sb.append("\n");
    }

    private static void debugOutputPsiAnonymousClass(StringBuilder sb, PsiAnonymousClass psiClass) {
        sb.append("AnonymousClass: ");
        sb.append(psiClass.getName() == null ? "null" : psiClass.getName());
        sb.append("\n");
        sb.append("Identifier: ");
        PsiIdentifier psiIdentifier = psiClass.getNameIdentifier();
        sb.append(psiIdentifier == null ? "null" : psiIdentifier.getText());
        sb.append("\n");
        String qualifiedName = psiClass.getQualifiedName();
        sb.append("Qualified Name: " + qualifiedName == null ? "null" : qualifiedName + "\n");
        sb.append("Inner Classes Count: " + psiClass.getInnerClasses().length + "\n");
        sb.append("All Inner Classes Count: " + psiClass.getAllInnerClasses().length + "\n");
        PsiClassInitializer[] allInitalizers = psiClass.getInitializers();
        sb.append("Initializer count: " + allInitalizers.length);
        PsiMethod[] methods2 = psiClass.getMethods();
        sb.append("Methods count: " + methods2.length + "\n");
    }

    private static void debugOutputPsiMethod(StringBuilder sb, PsiMethod method2) {
        sb.append("Method: " + method2.getName() + "\n");
        sb.append("Declaring Class: " + method2.getContainingClass().getName() + "\n");
    }

    private static void debugOutputPsiField(StringBuilder sb, PsiField psiField) {
        sb.append("Field: " + psiField.getName() + "\n");
        sb.append("Class: " + psiField.getContainingClass().getQualifiedName() + "\n");
        sb.append("Type: " + psiField.getType().getCanonicalText() + "\n");
    }

    private static void debugOutputPsiClass(StringBuilder sb, PsiClass psiClass) {
        sb.append("Class: ");
        sb.append(psiClass.getName());
        sb.append("\n");
        sb.append("Identifier: ");
        sb.append(psiClass.getNameIdentifier().getText());
        sb.append("\n");
        sb.append("Qualified Name: " + psiClass.getQualifiedName() + "\n");
        sb.append("Inner Classes Count: " + psiClass.getInnerClasses().length + "\n");
        sb.append("All Inner Classes Count: " + psiClass.getAllInnerClasses().length + "\n");
        PsiClassInitializer[] allInitalizers = psiClass.getInitializers();
        sb.append("Initializer count: " + allInitalizers.length);
    }

    private static void debugOutputPsiReferenceExpression(StringBuilder sb, PsiReferenceExpression psiElement) {
        sb.append("PsiReferenceExpression: " + psiElement.hashCode() + "\n");
        PsiElement e = psiElement.resolve();
        sb.append("ResolveType: " + e.getClass().getSimpleName() + " " + e.hashCode() + "\n");
        PsiExpression expr = psiElement.getQualifierExpression();
        if (expr == null) {
            sb.append("Qualifier Expression: null \n");
        } else {
            sb.append("Qualifier Expression: " + expr.getClass().getSimpleName() + "\n");
            sb.append("Qualifier Expression Text: " + expr.getText() + "\n");
        }
        PsiReferenceExpressionImpl results = psiElement.multiResolve(false);
        sb.append("MultiResolveResults: " + ((JavaResolveResult[])results).length + "\n");
        for (JavaResolveResult curRes : results) {
            sb.append("Result: " + curRes.getElement().getClass().getSimpleName() + "\t" + curRes.getElement().getText() + "\n");
        }
        sb.append("\n");
        if (psiElement instanceof PsiReferenceExpressionImpl) {
            PsiReferenceExpressionImpl psiReferenceExpressionImpl = (PsiReferenceExpressionImpl)psiElement;
        }
    }

    private static void debugOutputPsiThisExpression(StringBuilder sb, PsiThisExpression thisExpr) {
        sb.append("PsiThisExpression: " + thisExpr.hashCode() + "\n");
        PsiType type = thisExpr.getType();
        sb.append("Type: " + type.getCanonicalText() + "\n");
    }
}

