/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.emulator;

import com.android.annotations.concurrency.AnyThread;
import com.android.tools.idea.concurrency.AndroidIoManager;
import com.android.tools.idea.emulator.CommandLineDecoderUtils;
import com.android.tools.idea.emulator.EmulatorController;
import com.android.tools.idea.emulator.EmulatorId;
import com.android.tools.idea.flags.StudioFlags;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Alarm;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 62\u00020\u0001:\u000267B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00162\u0006\u0010%\u001a\u00020&H\u0007J\b\u0010'\u001a\u00020#H\u0016J\b\u0010(\u001a\u00020#H\u0016J\b\u0010)\u001a\u00020\u0012H\u0002J\u0010\u0010*\u001a\u00020#2\b\u0010+\u001a\u0004\u0018\u00010\u001cJ\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00152\u0006\u0010+\u001a\u00020\u001cH\u0002J\u0012\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u00020\u001cH\u0002J\u0010\u00100\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0016H\u0007J\b\u00101\u001a\u00020#H\u0002J\u0010\u00101\u001a\u00020#2\u0006\u00102\u001a\u00020\u0012H\u0002J\b\u00103\u001a\u00020#H\u0002J\u0012\u00104\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u000605R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0018\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u001a0\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00160\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/android/tools/idea/emulator/RunningEmulatorCatalog;", "Lcom/intellij/openapi/Disposable$Parent;", "()V", "alarm", "Lcom/intellij/util/Alarm;", "emulators", "", "Lcom/android/tools/idea/emulator/EmulatorController;", "getEmulators", "()Ljava/util/Set;", "setEmulators", "(Ljava/util/Set;)V", "fileNamePattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "isDisposing", "", "lastUpdateDuration", "", "lastUpdateStartTime", "listeners", "", "Lcom/android/tools/idea/emulator/RunningEmulatorCatalog$Listener;", "nextScheduledUpdateTime", "pendingFutures", "", "Lcom/google/common/util/concurrent/SettableFuture;", "registrationDirectory", "Ljava/nio/file/Path;", "updateInterval", "updateIntervalsByListener", "Lit/unimi/dsi/fastutil/objects/Object2LongOpenHashMap;", "updateLock", "Ljava/lang/Object;", "addListener", "", "listener", "updateIntervalMillis", "", "beforeTreeDispose", "dispose", "getUpdateInterval", "overrideRegistrationDirectory", "directory", "readDirectoryContents", "readEmulatorInfo", "Lcom/android/tools/idea/emulator/EmulatorId;", "file", "removeListener", "scheduleUpdate", "delay", "update", "updateNow", "Lcom/google/common/util/concurrent/ListenableFuture;", "Companion", "Listener", "intellij.android.emulator"})
public final class RunningEmulatorCatalog
implements Disposable.Parent {
    @NotNull
    private volatile Set<EmulatorController> emulators = (Set)ImmutableSet.of();
    private final Pattern fileNamePattern = Pattern.compile("pid_\\d+.ini");
    private final Alarm alarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
    private volatile boolean isDisposing;
    private final Object updateLock = new Object();
    private long lastUpdateStartTime;
    private long lastUpdateDuration;
    private long nextScheduledUpdateTime = Long.MAX_VALUE;
    private List<? extends Listener> listeners = CollectionsKt.emptyList();
    private final Object2LongOpenHashMap<Listener> updateIntervalsByListener = new Object2LongOpenHashMap();
    private long updateInterval = Long.MAX_VALUE;
    private List<SettableFuture<Set<EmulatorController>>> pendingFutures;
    private Path registrationDirectory;
    private static final String REGISTRATION_DIRECTORY_RELATIVE_PATH = "avd/running";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Set<EmulatorController> getEmulators() {
        return this.emulators;
    }

    public final void setEmulators(@NotNull Set<EmulatorController> set) {
        this.emulators = set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    public final void addListener(@NotNull Listener listener2, int updateIntervalMillis) {
        boolean bl = updateIntervalMillis > 0;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Object object = this.updateLock;
        bl2 = false;
        bl3 = false;
        synchronized (object) {
            boolean bl6 = false;
            this.listeners = CollectionsKt.plus((Collection)this.listeners, (Object)listener2);
            this.updateIntervalsByListener.put((Object)listener2, this.updateInterval);
            if ((long)updateIntervalMillis < this.updateInterval) {
                this.updateInterval = updateIntervalMillis;
            }
            this.scheduleUpdate(this.updateInterval);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    public final void removeListener(@NotNull Listener listener2) {
        Object object = this.updateLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            this.listeners = CollectionsKt.minus((Iterable)this.listeners, (Object)listener2);
            long interval = this.updateIntervalsByListener.removeLong((Object)listener2);
            if (interval == this.updateInterval) {
                this.updateInterval = -1L;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void scheduleUpdate(long delay) {
        Object object = this.updateLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            long updateTime = System.currentTimeMillis() + delay;
            if (this.nextScheduledUpdateTime > updateTime) {
                if (this.nextScheduledUpdateTime != Long.MAX_VALUE) {
                    this.alarm.cancelAllRequests();
                }
                this.nextScheduledUpdateTime = updateTime;
                this.alarm.addRequest(new Runnable(this, delay){
                    final /* synthetic */ RunningEmulatorCatalog this$0;
                    final /* synthetic */ long $delay$inlined;
                    {
                        this.this$0 = runningEmulatorCatalog;
                        this.$delay$inlined = l;
                    }

                    public final void run() {
                        RunningEmulatorCatalog.access$update(this.this$0);
                    }
                }, delay);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void scheduleUpdate() {
        long delay = this.getUpdateInterval();
        if (delay != Long.MAX_VALUE) {
            long l = this.lastUpdateDuration * (long)2;
            long l2 = 1000L;
            boolean bl = false;
            l = Math.min(l, l2);
            boolean bl2 = false;
            this.scheduleUpdate(Math.max(delay, l));
        }
    }

    private final long getUpdateInterval() {
        if (this.updateInterval < 0L) {
            long value2 = Long.MAX_VALUE;
            LongIterator iter = ((LongCollection)this.updateIntervalsByListener.values()).iterator();
            while (iter.hasNext()) {
                value2 = RangesKt.coerceAtMost((long)value2, (long)iter.nextLong());
            }
            this.updateInterval = value2;
        }
        return this.updateInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ListenableFuture<Set<EmulatorController>> updateNow() {
        Object object = this.updateLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            SettableFuture future2 = SettableFuture.create();
            this.pendingFutures.add((SettableFuture<Set<EmulatorController>>)future2);
            this.scheduleUpdate(0L);
            ListenableFuture listenableFuture = (ListenableFuture)future2;
            return listenableFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void update() {
        if (this.isDisposing) {
            return;
        }
        List<SettableFuture<Set<EmulatorController>>> futures2 = null;
        Path directory = null;
        Object object = this.updateLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            this.nextScheduledUpdateTime = Long.MAX_VALUE;
            if (this.pendingFutures.isEmpty()) {
                futures2 = CollectionsKt.emptyList();
            } else {
                futures2 = this.pendingFutures;
                boolean bl4 = false;
                this.pendingFutures = new ArrayList();
            }
            Path path2 = this.registrationDirectory;
            if (path2 == null) {
                return;
            }
            directory = path2;
            Unit unit = Unit.INSTANCE;
        }
        try {
            void $this$associateByTo$iv$iv;
            long start2 = System.currentTimeMillis();
            List<Path> files2 = this.readDirectoryContents(directory);
            Iterable $this$associateBy$iv = this.emulators;
            boolean $i$f$associateBy232 = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Object destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                EmulatorController emulatorController = (EmulatorController)element$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl3 = false;
                EmulatorId emulatorId = it.getEmulatorId();
                map2.put(emulatorId, element$iv$iv);
            }
            Map oldEmulators = destination$iv$iv;
            ConcurrentHashMap newEmulators = new ConcurrentHashMap();
            Collection $i$f$associateBy232 = files2;
            capacity$iv = 0;
            if (!$i$f$associateBy232.isEmpty() && !this.isDisposing) {
                CountDownLatch latch = new CountDownLatch(files2.size());
                ExecutorService executor = AndroidIoManager.Companion.getInstance().getBackgroundDiskIoExecutor();
                for (Path file2 : files2) {
                    executor.submit(new Runnable(this, file2, oldEmulators, newEmulators, latch){
                        final /* synthetic */ RunningEmulatorCatalog this$0;
                        final /* synthetic */ Path $file;
                        final /* synthetic */ Map $oldEmulators;
                        final /* synthetic */ ConcurrentHashMap $newEmulators;
                        final /* synthetic */ CountDownLatch $latch;

                        public final void run() {
                            EmulatorId emulatorId;
                            EmulatorController emulator = null;
                            boolean created = false;
                            if (!RunningEmulatorCatalog.access$isDisposing$p(this.this$0) && (emulatorId = RunningEmulatorCatalog.access$readEmulatorInfo(this.this$0, this.$file)) != null) {
                                emulator = (EmulatorController)this.$oldEmulators.get(emulatorId);
                                if (emulator == null) {
                                    if (((Boolean)StudioFlags.EMBEDDED_EMULATOR_TRACE_DISCOVERY.get()).booleanValue()) {
                                        RunningEmulatorCatalog $this$logger$iv = this.this$0;
                                        boolean $i$f$getLogger = false;
                                        Logger.getInstance(RunningEmulatorCatalog.class).info("Discovered emulator " + emulatorId);
                                    }
                                    emulator = new EmulatorController(emulatorId, (Disposable)this.this$0);
                                    created = true;
                                }
                                if (!RunningEmulatorCatalog.access$isDisposing$p(this.this$0)) {
                                    ((Map)this.$newEmulators).put(emulator.getEmulatorId(), emulator);
                                }
                            }
                            this.$latch.countDown();
                            if (emulator != null && created && emulator.getEmulatorId().isEmbedded()) {
                                emulator.connect();
                            }
                        }
                        {
                            this.this$0 = runningEmulatorCatalog;
                            this.$file = path2;
                            this.$oldEmulators = map2;
                            this.$newEmulators = concurrentHashMap;
                            this.$latch = countDownLatch;
                        }
                    });
                }
                latch.await();
            }
            Collection removedEmulators = MapsKt.minus((Map)oldEmulators, (Iterable)newEmulators.keySet()).values();
            Collection addedEmulators = MapsKt.minus((Map)newEmulators, (Iterable)oldEmulators.keySet()).values();
            List<? extends Listener> listenersSnapshot = null;
            destination$iv$iv = this.updateLock;
            boolean bl6 = false;
            boolean bl7 = false;
            synchronized (destination$iv$iv) {
                boolean bl8 = false;
                if (this.isDisposing) {
                    return;
                }
                this.lastUpdateStartTime = start2;
                this.lastUpdateDuration = System.currentTimeMillis() - start2;
                this.emulators = (Set)ImmutableSet.copyOf(newEmulators.values());
                listenersSnapshot = this.listeners;
                for (SettableFuture settableFuture : futures2) {
                    settableFuture.set(this.emulators);
                }
                if (!this.isDisposing) {
                    this.scheduleUpdate();
                }
                Unit unit = Unit.INSTANCE;
            }
            destination$iv$iv = listenersSnapshot;
            bl6 = false;
            if (!destination$iv$iv.isEmpty()) {
                block14: for (EmulatorController emulator : removedEmulators) {
                    if (((Boolean)StudioFlags.EMBEDDED_EMULATOR_TRACE_DISCOVERY.get()).booleanValue()) {
                        RunningEmulatorCatalog runningEmulatorCatalog = this;
                        boolean $i$f$getLogger = false;
                        Logger.getInstance(RunningEmulatorCatalog.class).info("Emulator " + emulator.getEmulatorId() + " stopped");
                    }
                    for (Listener listener2 : listenersSnapshot) {
                        if (this.isDisposing) continue block14;
                        listener2.emulatorRemoved(emulator);
                    }
                }
                block16: for (EmulatorController emulator : addedEmulators) {
                    for (Listener listener3 : listenersSnapshot) {
                        if (this.isDisposing) continue block16;
                        listener3.emulatorAdded(emulator);
                    }
                }
            }
            for (EmulatorController emulator : removedEmulators) {
                Disposer.dispose((Disposable)emulator);
            }
        }
        catch (IOException e) {
            RunningEmulatorCatalog $this$logger$iv = this;
            boolean $i$f$getLogger = false;
            Logger.getInstance(RunningEmulatorCatalog.class).error("Running Emulator detection failed", (Throwable)e);
            Object object2 = this.updateLock;
            boolean bl9 = false;
            boolean bl10 = false;
            synchronized (object2) {
                boolean bl11 = false;
                for (SettableFuture<Set<EmulatorController>> future3 : futures2) {
                    future3.setException((Throwable)e);
                }
                if (!this.isDisposing) {
                    this.scheduleUpdate();
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<Path> readDirectoryContents(Path directory) {
        Object object;
        try {
            List list;
            object = Files.list(directory);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                Stream it = (Stream)object;
                boolean bl3 = false;
                list = StreamsKt.toList(it.filter((Predicate)new Predicate<Path>(this){
                    final /* synthetic */ RunningEmulatorCatalog this$0;
                    {
                        this.this$0 = runningEmulatorCatalog;
                    }

                    public final boolean test(Path it) {
                        return RunningEmulatorCatalog.access$getFileNamePattern$p(this.this$0).matcher(((Object)it.getFileName()).toString()).matches();
                    }
                }));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
            }
            object = list;
        }
        catch (NoSuchFileException e) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private final EmulatorId readEmulatorInfo(Path file2) {
        int grpcPort = 0;
        String grpcCertificate = null;
        String grpcToken = null;
        String avdId = null;
        String avdName = null;
        Path avdFolder = null;
        int serialPort = 0;
        int adbPort = 0;
        List<String> commandLine = CollectionsKt.emptyList();
        try {
            for (String line2 : Files.readAllLines(file2)) {
                boolean bl;
                int n;
                String string;
                if (StringsKt.startsWith$default((String)line2, (String)"grpc.port=", (boolean)false, (int)2, null)) {
                    string = line2;
                    n = "grpc.port=".length();
                    bl = false;
                    String string2 = string;
                    if (string2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string3 = string2.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                    grpcPort = StringUtil.parseInt((String)string3, (int)0);
                    continue;
                }
                if (StringsKt.startsWith$default((String)line2, (String)"grpc.certificate=", (boolean)false, (int)2, null)) {
                    string = line2;
                    n = "grpc.certificate=".length();
                    bl = false;
                    String string4 = string;
                    if (string4 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)string4.substring(n), (String)"(this as java.lang.String).substring(startIndex)");
                    continue;
                }
                if (StringsKt.startsWith$default((String)line2, (String)"grpc.token=", (boolean)false, (int)2, null)) {
                    string = line2;
                    n = "grpc.token=".length();
                    bl = false;
                    String string5 = string;
                    if (string5 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)string5.substring(n), (String)"(this as java.lang.String).substring(startIndex)");
                    continue;
                }
                if (StringsKt.startsWith$default((String)line2, (String)"avd.id=", (boolean)false, (int)2, null)) {
                    string = line2;
                    n = "add.id=".length();
                    bl = false;
                    String string6 = string;
                    if (string6 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)string6.substring(n), (String)"(this as java.lang.String).substring(startIndex)");
                    continue;
                }
                if (StringsKt.startsWith$default((String)line2, (String)"avd.name=", (boolean)false, (int)2, null)) {
                    string = line2;
                    n = "avd.name=".length();
                    bl = false;
                    String string7 = string;
                    if (string7 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string8 = string7.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"(this as java.lang.String).substring(startIndex)");
                    avdName = StringsKt.replace$default((String)string8, (char)'_', (char)' ', (boolean)false, (int)4, null);
                    continue;
                }
                if (StringsKt.startsWith$default((String)line2, (String)"avd.dir=", (boolean)false, (int)2, null)) {
                    string = line2;
                    n = "add.dir=".length();
                    bl = false;
                    String string9 = string;
                    if (string9 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string10 = string9.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"(this as java.lang.String).substring(startIndex)");
                    avdFolder = Paths.get(string10, new String[0]);
                    continue;
                }
                if (StringsKt.startsWith$default((String)line2, (String)"port.serial=", (boolean)false, (int)2, null)) {
                    string = line2;
                    n = "port.serial=".length();
                    bl = false;
                    String string11 = string;
                    if (string11 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string12 = string11.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"(this as java.lang.String).substring(startIndex)");
                    serialPort = StringUtil.parseInt((String)string12, (int)0);
                    continue;
                }
                if (StringsKt.startsWith$default((String)line2, (String)"port.adb=", (boolean)false, (int)2, null)) {
                    string = line2;
                    n = "port.adb=".length();
                    bl = false;
                    String string13 = string;
                    if (string13 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string14 = string13.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string14, (String)"(this as java.lang.String).substring(startIndex)");
                    adbPort = StringUtil.parseInt((String)string14, (int)0);
                    continue;
                }
                if (!StringsKt.startsWith$default((String)line2, (String)"cmdline=", (boolean)false, (int)2, null)) continue;
                string = line2;
                n = "cmdline=".length();
                bl = false;
                String string15 = string;
                if (string15 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string16 = string15.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string16, (String)"(this as java.lang.String).substring(startIndex)");
                commandLine = CommandLineDecoderUtils.decodeCommandLine(string16);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (grpcPort <= 0 || avdId == null || avdName == null || avdFolder == null || serialPort <= 0 && adbPort <= 0 || commandLine.isEmpty()) {
            return null;
        }
        return new EmulatorId(grpcPort, grpcCertificate, grpcToken, avdId, avdName, avdFolder, serialPort, adbPort, commandLine, ((Object)file2.getFileName()).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeTreeDispose() {
        this.isDisposing = true;
        Object object = this.updateLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            for (EmulatorController emulator : this.emulators) {
                if (!emulator.getEmulatorId().isEmbedded()) continue;
                emulator.shutdown();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void overrideRegistrationDirectory(@Nullable Path directory) {
        Object object = this.updateLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            this.listeners = CollectionsKt.emptyList();
            this.updateIntervalsByListener.clear();
            this.emulators = SetsKt.emptySet();
            Path path2 = directory;
            if (path2 == null) {
                path2 = RunningEmulatorCatalog.Companion.computeRegistrationDirectory();
            }
            this.registrationDirectory = path2;
            Unit unit = Unit.INSTANCE;
        }
    }

    public RunningEmulatorCatalog() {
        boolean bl = false;
        this.pendingFutures = new ArrayList();
        this.registrationDirectory = RunningEmulatorCatalog.Companion.computeRegistrationDirectory();
    }

    public static final /* synthetic */ void access$update(RunningEmulatorCatalog $this) {
        $this.update();
    }

    public static final /* synthetic */ boolean access$isDisposing$p(RunningEmulatorCatalog $this) {
        return $this.isDisposing;
    }

    public static final /* synthetic */ void access$setDisposing$p(RunningEmulatorCatalog $this, boolean bl) {
        $this.isDisposing = bl;
    }

    public static final /* synthetic */ EmulatorId access$readEmulatorInfo(RunningEmulatorCatalog $this, Path file2) {
        return $this.readEmulatorInfo(file2);
    }

    public static final /* synthetic */ Pattern access$getFileNamePattern$p(RunningEmulatorCatalog $this) {
        return $this.fileNamePattern;
    }

    @JvmStatic
    @NotNull
    public static final RunningEmulatorCatalog getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    private static final Path computeRegistrationDirectory() {
        return RunningEmulatorCatalog.Companion.computeRegistrationDirectory();
    }

    @JvmStatic
    private static final Path computeRegistrationDirectoryContainer() {
        return RunningEmulatorCatalog.Companion.computeRegistrationDirectoryContainer();
    }

    @JvmStatic
    private static final Path resolvePath(String pattern) {
        return RunningEmulatorCatalog.Companion.resolvePath(pattern);
    }

    @JvmStatic
    private static final String getEnvironmentVariable(String name) {
        return RunningEmulatorCatalog.Companion.getEnvironmentVariable(name);
    }

    @JvmStatic
    private static final String getUid() {
        return RunningEmulatorCatalog.Companion.getUid();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H'J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H'\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/emulator/RunningEmulatorCatalog$Listener;", "", "emulatorAdded", "", "emulator", "Lcom/android/tools/idea/emulator/EmulatorController;", "emulatorRemoved", "intellij.android.emulator"})
    public static interface Listener {
        @AnyThread
        public void emulatorAdded(@NotNull EmulatorController var1);

        @AnyThread
        public void emulatorRemoved(@NotNull EmulatorController var1);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0003J\n\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0003J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0003J\b\u0010\n\u001a\u00020\u000bH\u0007J\n\u0010\f\u001a\u0004\u0018\u00010\u0004H\u0003J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u0004H\u0003R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/emulator/RunningEmulatorCatalog$Companion;", "", "()V", "REGISTRATION_DIRECTORY_RELATIVE_PATH", "", "computeRegistrationDirectory", "Ljava/nio/file/Path;", "computeRegistrationDirectoryContainer", "getEnvironmentVariable", "name", "getInstance", "Lcom/android/tools/idea/emulator/RunningEmulatorCatalog;", "getUid", "resolvePath", "pattern", "intellij.android.emulator"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final RunningEmulatorCatalog getInstance() {
            return (RunningEmulatorCatalog)ServiceManager.getService(RunningEmulatorCatalog.class);
        }

        @JvmStatic
        private final Path computeRegistrationDirectory() {
            Path container = this.computeRegistrationDirectoryContainer();
            if (container == null) {
                Companion $this$logger$iv = this;
                boolean $i$f$getLogger = false;
                Logger.getInstance(Companion.class).error("Unable to determine Emulator registration directory");
            }
            Path path2 = container;
            return path2 != null ? path2.resolve(RunningEmulatorCatalog.REGISTRATION_DIRECTORY_RELATIVE_PATH) : null;
        }

        @JvmStatic
        private final Path computeRegistrationDirectoryContainer() {
            if (SystemInfo.isMac) {
                return this.resolvePath("{HOME}/Library/Caches/TemporaryItems");
            }
            if (SystemInfo.isWindows) {
                return this.resolvePath("{LOCALAPPDATA}/Temp");
            }
            for (String pattern : new String[]{"{XDG_RUNTIME_DIR}", "/run/user/{UID}", "{HOME}/.android"}) {
                Path dir;
                if (this.resolvePath(pattern) == null) {
                    continue;
                }
                if (!Files.isDirectory(dir, new LinkOption[0])) continue;
                return dir;
            }
            return this.resolvePath(FileUtil.getTempDirectory() + "/android-{USER}");
        }

        @JvmStatic
        private final Path resolvePath(String pattern) {
            StringBuilder result2 = new StringBuilder();
            StringBuilder name = new StringBuilder();
            int braceDepth = 0;
            String string = pattern;
            int n = string.length();
            for (int j = 0; j < n; ++j) {
                char c = string.charAt(j);
                if (c == '{') {
                    ++braceDepth;
                    continue;
                }
                if (c == '}') {
                    if (--braceDepth != 0) continue;
                    CharSequence charSequence = name;
                    boolean bl = false;
                    if (!(charSequence.length() > 0)) continue;
                    String value2 = this.getEnvironmentVariable(name.toString());
                    result2.append(value2);
                    StringsKt.clear((StringBuilder)name);
                    continue;
                }
                if (braceDepth > 0) {
                    name.append(c);
                    continue;
                }
                result2.append(c);
            }
            return Paths.get(result2.toString(), new String[0]);
        }

        @JvmStatic
        private final String getEnvironmentVariable(String name) {
            String value2 = System.getenv(name);
            if (value2 == null && Intrinsics.areEqual((Object)name, (Object)"UID")) {
                return this.getUid();
            }
            return value2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        private final String getUid() {
            try {
                String userName = System.getProperty("user.name");
                String command = "id -u " + userName;
                Process process = Runtime.getRuntime().exec(command);
                Closeable closeable = process.getInputStream();
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    InputStream it = (InputStream)closeable;
                    boolean bl3 = false;
                    Object object = ByteStreamsKt.readBytes((InputStream)it);
                    Charset charset = StandardCharsets.UTF_8;
                    boolean bl4 = false;
                    object = new String((byte[])object, charset);
                    boolean bl5 = false;
                    String result2 = ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString();
                    object = result2;
                    bl5 = false;
                    if (object.length() == 0) {
                        String string = null;
                        return string;
                    }
                    String string = result2;
                    return string;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (IOException e) {
                return null;
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

