/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.layoutInspector.ui;

import com.android.tools.adtui.workbench.ToolContent;
import com.android.tools.idea.editors.layoutInspector.LayoutInspectorContext;
import com.android.tools.property.ptable.PTable;
import com.android.tools.property.ptable.PTableGroupItem;
import com.android.tools.property.ptable.PTableItem;
import com.android.tools.property.ptable.PTableModel;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.SpeedSearchComparator;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.RowFilter;
import javax.swing.table.TableRowSorter;
import org.jetbrains.annotations.NotNull;

public class PropertiesTablePanel
extends JScrollPane
implements ToolContent<LayoutInspectorContext> {
    public static final JBColor GROUP_BACKGROUND_COLOR = new JBColor((Color)Gray._242, new Color(60, 63, 65));
    public static final JBColor ITEM_BACKGROUND_COLOR = new JBColor((Color)Gray._252, new Color(49, 52, 53));
    private PTable myTable;
    private TableRowSorter<PTableModel> myRowSorter;
    private MyFilter myFilter = new MyFilter();
    private PTableModel myModel;

    public PropertiesTablePanel(@NotNull Disposable parentDisposable) {
        this.myRowSorter = new TableRowSorter();
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    public void dispose() {
    }

    public void setToolContext(LayoutInspectorContext toolContext) {
        if (toolContext != null) {
            this.myModel = toolContext.getTableModel();
            this.myTable = toolContext.getPropertiesTable();
            this.setViewportView((Component)((Object)this.myTable));
        }
    }

    @NotNull
    PTable getTable() {
        return this.myTable;
    }

    @NotNull
    public JComponent getComponent() {
        return this;
    }

    public boolean supportsFiltering() {
        return true;
    }

    public void setFilter(@NotNull String filter2) {
        int selectedRow = this.myTable.getSelectedRow();
        PTableItem selectedItem = this.myTable.getSelectedItem();
        if (filter2.isEmpty()) {
            this.myTable.setRowSorter(null);
        } else {
            this.myFilter.setPattern(filter2);
            this.myRowSorter.setModel(this.myModel);
            this.myRowSorter.setRowFilter(this.myFilter);
            this.myRowSorter.setSortKeys(null);
            this.myTable.setRowSorter(this.myRowSorter);
        }
        this.myTable.restoreSelection(selectedRow, selectedItem);
    }

    static class MyFilter
    extends RowFilter<PTableModel, Integer> {
        private final SpeedSearchComparator myComparator = new SpeedSearchComparator(false);
        private String myPattern = "";

        MyFilter() {
        }

        @VisibleForTesting
        void setPattern(@NotNull String pattern) {
            this.myPattern = pattern;
        }

        @Override
        public boolean include(RowFilter.Entry<? extends PTableModel, ? extends Integer> entry) {
            PTableItem item = (PTableItem)entry.getValue(0);
            if (this.isMatch(item.getName())) {
                return true;
            }
            if (item.getParent() != null && this.isMatch(item.getParent().getName())) {
                return true;
            }
            if (!(item instanceof PTableGroupItem)) {
                return false;
            }
            PTableGroupItem group2 = (PTableGroupItem)item;
            for (PTableItem child : group2.getChildren()) {
                if (!this.isMatch(child.getName())) continue;
                return true;
            }
            return false;
        }

        private boolean isMatch(@NotNull String text2) {
            return this.myComparator.matchingFragments(this.myPattern, text2) != null;
        }
    }
}

