/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.layoutInspector.ptable;

import com.android.tools.idea.editors.layoutInspector.ptable.LIEditableItemCellRenderer;
import com.android.tools.idea.editors.layoutInspector.ptable.LITableNameRenderer;
import com.android.tools.idea.editors.layoutInspector.ui.PropertiesTablePanel;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.property.ptable.PNameRenderer;
import com.android.tools.property.ptable.PTable;
import com.android.tools.property.ptable.PTableCellRenderer;
import com.android.tools.property.ptable.PTableCellRendererProvider;
import com.android.tools.property.ptable.PTableItem;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;

public class LITableRendererProvider
implements PTableCellRendererProvider {
    private static LITableRendererProvider ourInstance = new LITableRendererProvider();
    private final LITableNameRenderer myNameRenderer = new LITableNameRenderer();
    private final LIItemCellRenderer myItemCellRenderer = new LIItemCellRenderer();
    private final TableCellRenderer myEditableItemCellRenderer = (Boolean)StudioFlags.LAYOUT_INSPECTOR_EDITING_ENABLED.get() != false ? new LIEditableItemCellRenderer() : this.myItemCellRenderer;

    public static LITableRendererProvider getInstance() {
        if (ourInstance == null) {
            ourInstance = new LITableRendererProvider();
        }
        return ourInstance;
    }

    private LITableRendererProvider() {
    }

    @Override
    @NotNull
    public PNameRenderer getNameCellRenderer(@NotNull PTableItem item) {
        return this.myNameRenderer;
    }

    @Override
    @NotNull
    public TableCellRenderer getValueCellRenderer(@NotNull PTableItem item) {
        if (item.hasChildren()) {
            return LITableRendererProvider.createGroupTableCellRenderer();
        }
        if (item.isEditable(item.getColumnToEdit())) {
            return this.myEditableItemCellRenderer;
        }
        return this.myItemCellRenderer;
    }

    private static ColoredTableCellRenderer createGroupTableCellRenderer() {
        return new ColoredTableCellRenderer(){

            protected void customizeCellRenderer(JTable table2, Object value2, boolean selected, boolean hasFocus, int row, int column) {
                this.setBackground(selected ? UIUtil.getTableSelectionBackground((boolean)true) : PropertiesTablePanel.GROUP_BACKGROUND_COLOR);
            }
        };
    }

    private static class LIItemCellRenderer
    extends PTableCellRenderer {
        private final JPanel myPanel = new JPanel(new BorderLayout(SystemInfo.isMac ? 0 : 2, 0));

        public LIItemCellRenderer() {
            this.myPanel.add((Component)((Object)this), "Center");
        }

        @Override
        public Component getTableCellRendererComponent(@NotNull JTable table2, @NotNull Object value2, boolean isSelected, boolean hasFocus, int row, int col) {
            super.getTableCellRendererComponent(table2, value2, isSelected, hasFocus, row, col);
            this.myPanel.setForeground(this.getForeground());
            this.myPanel.setBackground(this.getBackground());
            if (!isSelected) {
                this.myPanel.setBackground((Color)PropertiesTablePanel.ITEM_BACKGROUND_COLOR);
            }
            return this.myPanel;
        }

        @Override
        public void customizeCellRenderer(@NotNull PTable table2, @NotNull PTableItem item, boolean selected, boolean hasFocus, int row, int col) {
            this.appendValue(item);
        }

        private void appendValue(PTableItem item) {
            String value2 = item.getValue();
            String text2 = StringUtil.notNullize((String)value2);
            if (!item.isDefaultValue(value2)) {
                this.setForeground((Color)JBColor.BLUE);
            }
            this.append(text2, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            this.setToolTipText(text2);
        }
    }
}

