/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.layoutInspector;

import com.android.ddmlib.Client;
import com.android.layoutinspector.LayoutInspectorBridge;
import com.android.layoutinspector.LayoutInspectorCaptureOptions;
import com.android.layoutinspector.LayoutInspectorResult;
import com.android.layoutinspector.ProtocolVersion;
import com.android.layoutinspector.model.ClientWindow;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.editors.layoutInspector.LayoutInspectorCaptureType;
import com.android.tools.idea.editors.layoutInspector.LayoutInspectorEditor;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.profiling.capture.Capture;
import com.android.tools.idea.profiling.capture.CaptureService;
import com.android.tools.idea.stats.AndroidStudioUsageTracker;
import com.android.tools.idea.stats.UsageTrackerUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.LayoutInspectorEvent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.UIUtil;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LayoutInspectorCaptureTask
extends Task.Backgroundable {
    private static final String TITLE = "Capture View Hierarchy";
    @NotNull
    private final Client myClient;
    @NotNull
    private final ClientWindow myWindow;
    private String myError;
    private byte[] myData;

    public LayoutInspectorCaptureTask(@NotNull Project project, @NotNull Client client, @NotNull ClientWindow window2) {
        super(project, "Capturing View Hierarchy");
        this.myClient = client;
        this.myWindow = window2;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        LayoutInspectorCaptureOptions options2 = new LayoutInspectorCaptureOptions();
        options2.setTitle(this.myWindow.getDisplayName());
        ProtocolVersion version2 = LayoutInspectorCaptureTask.determineProtocolVersion(this.myClient.getDevice().getVersion().getApiLevel(), (Boolean)StudioFlags.LAYOUT_INSPECTOR_V2_PROTOCOL_ENABLED.get());
        options2.setVersion(version2);
        indicator.setText("Capturing View Hierarchy");
        indicator.setIndeterminate(false);
        long startTimeMs = System.currentTimeMillis();
        LayoutInspectorResult result2 = LayoutInspectorBridge.captureView((ClientWindow)this.myWindow, (LayoutInspectorCaptureOptions)options2);
        long captureDurationMs = System.currentTimeMillis() - startTimeMs;
        UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId(AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.LAYOUT_INSPECTOR_EVENT).setDeviceInfo(AndroidStudioUsageTracker.deviceToDeviceInfo(this.myClient.getDevice())).setLayoutInspectorEvent(LayoutInspectorEvent.newBuilder().setType(LayoutInspectorEvent.LayoutInspectorEventType.CAPTURE).setDurationInMs(captureDurationMs).setDataSize(result2.getError().isEmpty() ? (long)result2.getData().length : 0L)), this.myProject));
        UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId(AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.LAYOUT_INSPECTOR_EVENT).setDeviceInfo(AndroidStudioUsageTracker.deviceToDeviceInfo(this.myClient.getDevice())).setLayoutInspectorEvent(LayoutInspectorEvent.newBuilder().setType(LayoutInspectorEvent.LayoutInspectorEventType.CAPTURE).setDurationInMs(captureDurationMs).setVersion(version2.ordinal() + 1).setDataSize(result2.getError().isEmpty() ? (long)result2.getData().length : 0L)), this.myProject));
        if (!result2.getError().isEmpty()) {
            this.myError = result2.getError();
            return;
        }
        this.myData = result2.getData();
    }

    @VisibleForTesting
    static ProtocolVersion determineProtocolVersion(int apiVersion, boolean v2Enabled) {
        return apiVersion >= LayoutInspectorBridge.getV2_MIN_API() && v2Enabled ? ProtocolVersion.Version2 : ProtocolVersion.Version1;
    }

    public void onSuccess() {
        if (this.myError != null) {
            Messages.showErrorDialog((String)("Error obtaining view hierarchy: " + StringUtil.notNullize((String)this.myError)), (String)TITLE);
            return;
        }
        CaptureService service = CaptureService.getInstance(this.myProject);
        try {
            Capture capture2 = service.createCapture(LayoutInspectorCaptureType.class, this.myData, service.getSuggestedName(this.myClient));
            VirtualFile file2 = capture2.getFile();
            file2.refresh(true, false, () -> UIUtil.invokeLaterIfNeeded(() -> {
                OpenFileDescriptor descriptor2 = new OpenFileDescriptor(this.myProject, file2);
                List editors = FileEditorManager.getInstance((Project)this.myProject).openEditor(descriptor2, true);
                editors.stream().filter(e -> e instanceof LayoutInspectorEditor).findFirst().ifPresent(editor2 -> ((LayoutInspectorEditor)((Object)((Object)((Object)editor2)))).setSources(this.myClient, this.myWindow));
            }));
        }
        catch (IOException e) {
            Messages.showErrorDialog((String)("Error creating hierarchy view capture: " + e), (String)TITLE);
        }
    }
}

