/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.windows;

import com.android.tools.idea.diagnostics.windows.VirusCheckerStatusProvider;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinReg;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class WindowsDefenderRegistryStatusProvider
implements VirusCheckerStatusProvider {
    public static final String LOCAL_EXCLUDED_PATHS_KEY = "SOFTWARE\\Microsoft\\Windows Defender\\Exclusions\\Paths";
    public static final String POLICY_EXCLUDED_PATHS_KEY = "SOFTWARE\\Policies\\Microsoft\\Windows Defender\\exclusions\\paths";
    public static final String POLICY_SCANNING_STATUS_KEY = "SOFTWARE\\Policies\\Microsoft\\Windows Defender\\Real-Time Protection";
    public static final String LOCAL_SCANNING_STATUS_KEY = "SOFTWARE\\Microsoft\\Windows Defender\\Real-Time Protection";
    public static final String DISABLE_MONITORING_VALUE_NAME = "DisableRealtimeMonitoring";

    @Override
    @NotNull
    public List<String> getExcludedPaths() throws IOException {
        ArrayList<String> excludedPaths = new ArrayList<String>();
        excludedPaths.addAll(WindowsDefenderRegistryStatusProvider.readExcludedPaths(LOCAL_EXCLUDED_PATHS_KEY));
        excludedPaths.addAll(WindowsDefenderRegistryStatusProvider.readExcludedPaths(POLICY_EXCLUDED_PATHS_KEY));
        return excludedPaths;
    }

    @NotNull
    private static Collection<String> readExcludedPaths(@NotNull String key) throws IOException {
        try {
            return new HashSet<String>(Advapi32Util.registryGetValues((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)key).keySet());
        }
        catch (Win32Exception exception) {
            if (exception.getErrorCode() != 2) {
                throw new IOException("Error code " + exception.getErrorCode() + ": " + exception.getMessage(), exception);
            }
            return new HashSet<String>();
        }
    }

    @Override
    @NotNull
    public VirusCheckerStatusProvider.RealtimeScanningStatus getRealtimeScanningStatus() throws IOException {
        Optional<Boolean> isMonitoringDisabled = WindowsDefenderRegistryStatusProvider.readMonitoringDisabled(POLICY_SCANNING_STATUS_KEY);
        if (!isMonitoringDisabled.isPresent()) {
            isMonitoringDisabled = WindowsDefenderRegistryStatusProvider.readMonitoringDisabled(LOCAL_SCANNING_STATUS_KEY);
        }
        return isMonitoringDisabled.orElse(false) != false ? VirusCheckerStatusProvider.RealtimeScanningStatus.SCANNING_DISABLED : VirusCheckerStatusProvider.RealtimeScanningStatus.SCANNING_ENABLED;
    }

    @NotNull
    private static Optional<Boolean> readMonitoringDisabled(@NotNull String key) throws IOException {
        try {
            boolean policyValueExists = Advapi32Util.registryValueExists((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)key, (String)DISABLE_MONITORING_VALUE_NAME);
            if (policyValueExists) {
                int policyDisableRealtimeValue = Advapi32Util.registryGetIntValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)key, (String)DISABLE_MONITORING_VALUE_NAME);
                return Optional.of(policyDisableRealtimeValue != 0);
            }
            return Optional.empty();
        }
        catch (Win32Exception exception) {
            if (exception.getErrorCode() != 2) {
                throw new IOException("Error code " + exception.getErrorCode() + ": " + exception.getMessage(), exception);
            }
            return Optional.empty();
        }
    }
}

