/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.windows;

import com.android.tools.idea.diagnostics.windows.VirusCheckerStatusProvider;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class WindowsDefenderPowerShellStatusProvider
implements VirusCheckerStatusProvider {
    private static final int POWERSHELL_COMMAND_TIMEOUT_MS = 10000;
    private static final int MAX_POWERSHELL_STDERR_LENGTH = 500;

    @Override
    @NotNull
    public List<String> getExcludedPaths() throws IOException {
        try {
            ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)new GeneralCommandLine(new String[]{"powershell", "-inputformat", "none", "-outputformat", "text", "-NonInteractive", "-Command", "Get-MpPreference | select -ExpandProperty \"ExclusionPath\""}), (int)10000);
            if (output.getExitCode() == 0) {
                return output.getStdoutLines(true);
            }
            throw new IOException("Windows Defender exclusion path check exited with status " + output.getExitCode() + ": " + StringUtil.first((String)output.getStderr(), (int)500, (boolean)false));
        }
        catch (ExecutionException e) {
            throw e.toIOException();
        }
    }

    @Override
    @NotNull
    public VirusCheckerStatusProvider.RealtimeScanningStatus getRealtimeScanningStatus() throws IOException {
        try {
            ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)new GeneralCommandLine(new String[]{"powershell", "-inputformat", "none", "-outputformat", "text", "-NonInteractive", "-Command", "Get-MpPreference | select -ExpandProperty \"DisableRealtimeMonitoring\""}), (int)10000);
            if (output.getExitCode() == 0) {
                if (output.getStdout().startsWith("False")) {
                    return VirusCheckerStatusProvider.RealtimeScanningStatus.SCANNING_ENABLED;
                }
                return VirusCheckerStatusProvider.RealtimeScanningStatus.SCANNING_DISABLED;
            }
            throw new IOException("Windows Defender realtime scanning status check exited with status " + output.getExitCode() + ": " + StringUtil.first((String)output.getStderr(), (int)500, (boolean)false));
        }
        catch (ExecutionException e) {
            throw e.toIOException();
        }
    }
}

