/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.hprof.util;

import com.android.tools.idea.diagnostics.hprof.parser.HProfEventBasedParser;
import com.android.tools.idea.diagnostics.hprof.util.AbstractHProfNavigatorReadBuffer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfoRt;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\n\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000  2\u00020\u0001:\u0001 B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\b\u0010\u0016\u001a\u00020\nH\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\bH\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\nH\u0016J\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\nH\u0016J\u0010\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\nH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/util/HProfReadBufferSlidingWindow;", "Lcom/android/tools/idea/diagnostics/hprof/util/AbstractHProfNavigatorReadBuffer;", "channel", "Ljava/nio/channels/FileChannel;", "parser", "Lcom/android/tools/idea/diagnostics/hprof/parser/HProfEventBasedParser;", "(Ljava/nio/channels/FileChannel;Lcom/android/tools/idea/diagnostics/hprof/parser/HProfEventBasedParser;)V", "buffer", "Ljava/nio/ByteBuffer;", "bufferOffset", "", "bufferSize", "size", "close", "", "get", "", "bytes", "", "getByteBuffer", "", "getInt", "getLong", "getShort", "", "invokeCleaner", "byteBuffer", "isEof", "", "position", "newPosition", "remapBuffer", "Companion", "intellij.android.core"})
public final class HProfReadBufferSlidingWindow
extends AbstractHProfNavigatorReadBuffer {
    private final long bufferSize;
    private final long size;
    private ByteBuffer buffer;
    private long bufferOffset;
    private final FileChannel channel;
    private static final Logger LOG;
    public static final Companion Companion;

    @Override
    public void close() {
        this.invokeCleaner(this.buffer);
    }

    private final void invokeCleaner(ByteBuffer byteBuffer) {
        block9: {
            try {
                DirectBuffer directBuffer;
                if (SystemInfoRt.IS_AT_LEAST_JAVA9) {
                    Field theUnsafeField;
                    Field field2;
                    boolean bl;
                    Field[] fieldArray;
                    Method invokeCleanerMethod;
                    Class<Unsafe> unsafeClass;
                    block8: {
                        unsafeClass = Unsafe.class;
                        invokeCleanerMethod = unsafeClass.getMethod("invokeCleaner", ByteBuffer.class);
                        fieldArray = unsafeClass.getDeclaredFields();
                        bl = false;
                        Field[] fieldArray2 = fieldArray;
                        boolean bl2 = false;
                        Field[] fieldArray3 = fieldArray2;
                        int n = fieldArray3.length;
                        for (int j = 0; j < n; ++j) {
                            Field field3;
                            Field f = field3 = fieldArray3[j];
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)f.getName(), (Object)"theUnsafe")) continue;
                            field2 = field3;
                            break block8;
                        }
                        field2 = null;
                    }
                    Field field4 = theUnsafeField = field2;
                    if (field4 != null) {
                        fieldArray = field4;
                        bl = false;
                        boolean bl4 = false;
                        Field[] it = fieldArray;
                        boolean bl5 = false;
                        it.setAccessible(true);
                        Object object = it.get(unsafeClass);
                        if (object == null) {
                            throw new TypeCastException("null cannot be cast to non-null type sun.misc.Unsafe");
                        }
                        Unsafe unsafe = (Unsafe)object;
                        invokeCleanerMethod.invoke((Object)unsafe, byteBuffer);
                    }
                    break block9;
                }
                ByteBuffer byteBuffer2 = byteBuffer;
                if (!(byteBuffer2 instanceof DirectBuffer)) {
                    byteBuffer2 = null;
                }
                if ((directBuffer = (DirectBuffer)((Object)byteBuffer2)) != null && (directBuffer = directBuffer.cleaner()) != null) {
                    directBuffer.clean();
                }
            }
            catch (Throwable t) {
                LOG.error(t);
            }
        }
    }

    @Override
    public void position(long newPosition) {
        if (newPosition >= this.bufferOffset && newPosition <= this.bufferOffset + this.bufferSize) {
            this.buffer.position((int)(newPosition - this.bufferOffset));
        } else {
            this.remapBuffer(newPosition);
        }
    }

    private final void remapBuffer(long newPosition) {
        ByteBuffer oldBuffer = this.buffer;
        this.buffer = this.channel.map(FileChannel.MapMode.READ_ONLY, newPosition, Math.min(this.bufferSize, this.size - newPosition));
        this.bufferOffset = newPosition;
        this.invokeCleaner(oldBuffer);
    }

    @Override
    public boolean isEof() {
        return this.position() == this.size;
    }

    @Override
    public long position() {
        return this.bufferOffset + (long)this.buffer.position();
    }

    @Override
    public void get(@NotNull byte[] bytes) {
        if (bytes.length <= this.buffer.remaining()) {
            this.buffer.get(bytes);
        } else {
            int remaining = bytes.length;
            int offset2 = 0;
            while (remaining > 0) {
                this.remapBuffer(this.position());
                int bytesToFetch = Math.min(remaining, (int)this.bufferSize);
                this.buffer.get(bytes, offset2, bytesToFetch);
                remaining -= bytesToFetch;
                offset2 += bytesToFetch;
            }
        }
    }

    @Override
    @NotNull
    public ByteBuffer getByteBuffer(int size) {
        boolean useSlice = false;
        if (size < this.buffer.remaining()) {
            useSlice = true;
        } else if ((long)size < this.bufferSize) {
            this.remapBuffer(this.position());
            useSlice = true;
        }
        if (useSlice) {
            ByteBuffer slicedBuffer = this.buffer.slice();
            slicedBuffer.limit(size);
            this.skip(size);
            return slicedBuffer.asReadOnlyBuffer();
        }
        byte[] bytes = new byte[size];
        this.get(bytes);
        return ByteBuffer.wrap(bytes);
    }

    @Override
    public byte get() {
        if (this.buffer.remaining() < 1) {
            this.remapBuffer(this.position());
        }
        return this.buffer.get();
    }

    @Override
    public short getShort() {
        if (this.buffer.remaining() < 2) {
            this.remapBuffer(this.position());
        }
        return this.buffer.getShort();
    }

    @Override
    public int getInt() {
        if (this.buffer.remaining() < 4) {
            this.remapBuffer(this.position());
        }
        return this.buffer.getInt();
    }

    @Override
    public long getLong() {
        if (this.buffer.remaining() < 8) {
            this.remapBuffer(this.position());
        }
        return this.buffer.getLong();
    }

    public HProfReadBufferSlidingWindow(@NotNull FileChannel channel, @NotNull HProfEventBasedParser parser) {
        super(parser);
        this.channel = channel;
        this.bufferSize = 10000000L;
        this.size = this.channel.size();
        this.buffer = this.channel.map(FileChannel.MapMode.READ_ONLY, this.bufferOffset, Math.min(this.bufferSize, this.size));
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance(HProfReadBufferSlidingWindow.class);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/util/HProfReadBufferSlidingWindow$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

