/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.actions;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.ddmlib.ScreenRecorderOptions;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.prefs.AndroidLocation;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.ddms.actions.AbstractDeviceAction;
import com.android.tools.idea.ddms.actions.CachedFeatures;
import com.android.tools.idea.ddms.actions.Features;
import com.android.tools.idea.ddms.actions.ScreenRecorderTask;
import com.android.tools.idea.ddms.screenrecord.ScreenRecorderOptionsDialog;
import com.android.tools.idea.log.LogWrapper;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.utils.ILogger;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import icons.StudioIcons;
import java.awt.EventQueue;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ScreenRecorderAction
extends AbstractDeviceAction {
    static final String REMOTE_PATH = "/sdcard/ddmsrec.mp4";
    static final String TITLE = "Screen Recorder";
    private static final String EMU_TMP_FILENAME = "tmp.webm";
    private final Features myFeatures;
    private final Project myProject;
    private boolean myRecordingInProgress;

    public ScreenRecorderAction(@NotNull Project project, @NotNull DeviceContext context) {
        this(project, context, new CachedFeatures((Disposable)project));
    }

    @VisibleForTesting
    ScreenRecorderAction(@NotNull Project project, @NotNull DeviceContext context, @NotNull Features features) {
        super(context, AndroidBundle.message("android.ddms.actions.screenrecord", new Object[0]), AndroidBundle.message("android.ddms.actions.screenrecord.description", new Object[0]), StudioIcons.Logcat.VIDEO_CAPTURE);
        this.myFeatures = features;
        this.myProject = project;
    }

    @Override
    public void update(@NotNull AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        if (!this.isEnabled()) {
            presentation.setEnabled(false);
            presentation.setText(AndroidBundle.message("android.ddms.actions.screenrecord", new Object[0]));
            return;
        }
        IDevice device = this.myDeviceContext.getSelectedDevice();
        if (this.myFeatures.watch(device)) {
            presentation.setEnabled(false);
            presentation.setText("Screen Record Is Unavailable for Wear OS");
            return;
        }
        presentation.setEnabled(this.myFeatures.screenRecord(device));
        presentation.setText(AndroidBundle.message("android.ddms.actions.screenrecord", new Object[0]));
    }

    @Override
    protected boolean isEnabled() {
        return super.isEnabled() && !this.myRecordingInProgress;
    }

    @Override
    protected void performAction(final @NotNull IDevice device) {
        final ScreenRecorderOptionsDialog dialog2 = new ScreenRecorderOptionsDialog(this.myProject);
        if (!dialog2.showAndGet()) {
            return;
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, "Starting screen recording..."){
            private boolean myShowTouchEnabled;

            public void run(@NotNull ProgressIndicator indicator) {
                this.myShowTouchEnabled = ScreenRecorderAction.isShowTouchEnabled(device);
            }

            public void onSuccess() {
                ScreenRecorderAction.this.startRecordingAsync(dialog2.getOptions(), device, this.myShowTouchEnabled);
            }
        });
    }

    private void startRecordingAsync(@NotNull ScreenRecorderOptions options2, @NotNull IDevice device, boolean showTouchEnabled) {
        AvdManager manager = ScreenRecorderAction.getVirtualDeviceManager();
        Path hostRecordingFile = manager == null ? null : this.getTemporaryVideoPathForVirtualDevice(device, manager);
        this.myRecordingInProgress = true;
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (options2.showTouches != showTouchEnabled) {
                ScreenRecorderAction.setShowTouch(device, options2.showTouches);
            }
            try {
                ScreenRecorderTask task2 = new ScreenRecorderTask(this.myProject, device, hostRecordingFile, options2);
                task2.run();
            }
            finally {
                if (options2.showTouches != showTouchEnabled) {
                    ScreenRecorderAction.setShowTouch(device, showTouchEnabled);
                }
                EventQueue.invokeLater(() -> {
                    this.myRecordingInProgress = false;
                });
            }
        });
    }

    @Nullable
    private static AvdManager getVirtualDeviceManager() {
        Logger logger2 = Logger.getInstance(ScreenRecorderAction.class);
        try {
            return AvdManager.getInstance((AndroidSdkHandler)AndroidSdks.getInstance().tryToChooseSdkHandler(), (ILogger)new LogWrapper(logger2));
        }
        catch (AndroidLocation.AndroidLocationException exception) {
            logger2.warn((Throwable)exception);
            return null;
        }
    }

    @Nullable
    @VisibleForTesting
    Path getTemporaryVideoPathForVirtualDevice(@NotNull IDevice device, @NotNull AvdManager manager) {
        if (!this.myFeatures.screenRecord(device)) {
            return null;
        }
        AvdInfo virtualDevice = manager.getAvd(device.getAvdName(), true);
        if (virtualDevice == null) {
            return null;
        }
        return Paths.get(virtualDevice.getDataFolderPath(), EMU_TMP_FILENAME);
    }

    private static void setShowTouch(@NotNull IDevice device, boolean isEnabled) {
        int value2 = isEnabled ? 1 : 0;
        try {
            device.executeShellCommand("settings put system show_touches " + value2, (IShellOutputReceiver)new NullOutputReceiver());
        }
        catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | TimeoutException | IOException e) {
            Logger.getInstance(ScreenRecorderAction.class).warn("Failed to set show taps to " + isEnabled, e);
        }
    }

    private static boolean isShowTouchEnabled(@NotNull IDevice device) {
        CollectingOutputReceiver receiver = new CollectingOutputReceiver();
        try {
            device.executeShellCommand("settings get system show_touches", (IShellOutputReceiver)receiver);
            String output = receiver.getOutput();
            return output.equals("1");
        }
        catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | TimeoutException | IOException e) {
            Logger.getInstance(ScreenRecorderAction.class).warn("Failed to retrieve setting", e);
            return false;
        }
    }

    static void showError(@Nullable Project project, @NotNull String message2, @Nullable Throwable throwable) {
        ApplicationManager.getApplication().invokeLater(() -> {
            String msg = message2;
            if (throwable != null) {
                msg = msg + (throwable.getLocalizedMessage() != null ? ": " + throwable.getLocalizedMessage() : "");
            }
            Messages.showErrorDialog((Project)project, (String)msg, (String)TITLE);
        });
    }
}

