/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding.util;

import com.android.tools.idea.databinding.DataBindingMode;
import com.android.tools.idea.databinding.LayoutBindingSupport;
import com.android.tools.idea.databinding.index.BindingXmlData;
import com.android.tools.idea.databinding.index.BindingXmlIndex;
import com.android.tools.idea.databinding.index.ImportData;
import com.android.tools.idea.lang.databinding.DataBindingExpressionSupport;
import com.android.tools.idea.lang.databinding.DataBindingExpressionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.List;
import org.jetbrains.android.dom.layout.Import;
import org.jetbrains.android.dom.manifest.AndroidManifestUtils;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DataBindingUtil {
    public static final String BR = "BR";

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(DataBindingUtil.class);
    }

    @Nullable
    private static LayoutBindingSupport getBindingSupport() {
        List extensionList = LayoutBindingSupport.EP_NAME.getExtensionList();
        return extensionList.isEmpty() ? null : (LayoutBindingSupport)extensionList.get(0);
    }

    public static boolean isDataBindingEnabled(@NotNull AndroidFacet facet2) {
        return DataBindingUtil.getDataBindingMode(facet2) != DataBindingMode.NONE;
    }

    @NotNull
    public static DataBindingMode getDataBindingMode(@NotNull AndroidFacet facet2) {
        LayoutBindingSupport support = DataBindingUtil.getBindingSupport();
        return support == null ? DataBindingMode.NONE : support.getDataBindingMode(facet2);
    }

    @NotNull
    public static ModificationTracker getDataBindingEnabledTracker() {
        LayoutBindingSupport support = DataBindingUtil.getBindingSupport();
        return support == null ? () -> 0L : support.getDataBindingEnabledTracker();
    }

    @Nullable
    public static String getQualifiedBindingName(@NotNull AndroidFacet facet2, @NotNull BindingXmlIndex.Entry bindingIndexEntry) {
        String modulePackage = AndroidManifestUtils.getPackageName(facet2);
        if (modulePackage == null) {
            return null;
        }
        String customBindingName = bindingIndexEntry.getData().getCustomBindingName();
        if (customBindingName == null || customBindingName.isEmpty()) {
            return modulePackage + ".databinding." + DataBindingUtil.convertFileNameToJavaClassName(bindingIndexEntry.getFile().getName()) + "Binding";
        }
        int firstDotIndex = customBindingName.indexOf(46);
        if (firstDotIndex < 0) {
            return modulePackage + ".databinding." + customBindingName;
        }
        int lastDotIndex = customBindingName.lastIndexOf(46);
        String packageName = firstDotIndex == 0 ? modulePackage + customBindingName.substring(0, lastDotIndex) : customBindingName.substring(0, lastDotIndex);
        String simpleClassName = customBindingName.substring(lastDotIndex + 1);
        return packageName + "." + simpleClassName;
    }

    @NotNull
    public static String convertFileNameToJavaClassName(@NotNull String name) {
        int dotIndex = name.indexOf(46);
        if (dotIndex >= 0) {
            name = name.substring(0, dotIndex);
        }
        String[] split = name.split("[_-]");
        StringBuilder out = new StringBuilder();
        for (String section : split) {
            out.append(StringUtil.capitalize((String)section));
        }
        return out.toString();
    }

    public static String convertAndroidIdToJavaFieldName(@NotNull String name) {
        return DataBindingUtil.convertVariableNameToJavaFieldName(name.replace('.', '_'));
    }

    @NotNull
    public static String convertVariableNameToJavaFieldName(@NotNull String name) {
        String[] split = name.split("[^a-zA-Z0-9]");
        StringBuilder out = new StringBuilder();
        boolean first = true;
        for (String section : split) {
            if (section.isEmpty()) continue;
            if (first) {
                first = false;
                out.append(section);
                continue;
            }
            out.append(StringUtil.capitalize((String)section));
        }
        return out.toString();
    }

    public static boolean isGetter(@NotNull PsiMethod psiMethod) {
        PsiType returnType = psiMethod.getReturnType();
        if (returnType == null) {
            return false;
        }
        return !returnType.equals(PsiType.VOID) && psiMethod.getParameterList().getParametersCount() == 0 && DataBindingUtil.isPrefixedJavaIdentifier(psiMethod.getName(), "get");
    }

    public static boolean isBooleanGetter(@NotNull PsiMethod psiMethod) {
        PsiType returnType = psiMethod.getReturnType();
        if (returnType == null) {
            return false;
        }
        return returnType.equals(PsiType.BOOLEAN) && psiMethod.getParameterList().getParametersCount() == 0 && DataBindingUtil.isPrefixedJavaIdentifier(psiMethod.getName(), "is");
    }

    public static boolean isSetter(@NotNull PsiMethod psiMethod) {
        PsiType returnType = psiMethod.getReturnType();
        if (returnType == null) {
            return false;
        }
        return returnType.equals(PsiType.VOID) && psiMethod.getParameterList().getParametersCount() == 1 && DataBindingUtil.isPrefixedJavaIdentifier(psiMethod.getName(), "set");
    }

    private static boolean isPrefixedJavaIdentifier(@NotNull String name, @NotNull String prefix) {
        return DataBindingUtil.isPrefix(name, prefix) && Character.isJavaIdentifierStart(name.charAt(prefix.length()));
    }

    @NotNull
    public static String stripPrefixFromMethod(@NotNull PsiMethod method2) {
        String methodName = method2.getName();
        if (DataBindingUtil.isGetter(method2)) {
            return StringUtil.decapitalize((String)methodName.substring("get".length()));
        }
        if (DataBindingUtil.isBooleanGetter(method2)) {
            return StringUtil.decapitalize((String)methodName.substring("is".length()));
        }
        if (DataBindingUtil.isSetter(method2)) {
            return StringUtil.decapitalize((String)methodName.substring("set".length()));
        }
        return methodName;
    }

    @NotNull
    public static String stripPrefixFromField(@NotNull PsiField psiField) {
        String fieldName = psiField.getName();
        assert (fieldName != null);
        return DataBindingUtil.stripPrefixFromField(fieldName);
    }

    private static boolean isPrefix(@NotNull CharSequence sequence, @NotNull String prefix) {
        boolean prefixes = false;
        if (sequence.length() > prefix.length()) {
            int count = prefix.length();
            prefixes = true;
            for (int i2 = 0; i2 < count; ++i2) {
                if (sequence.charAt(i2) == prefix.charAt(i2)) continue;
                prefixes = false;
                break;
            }
        }
        return prefixes;
    }

    @NotNull
    private static String stripPrefixFromField(@NotNull String name) {
        if (name.length() >= 2) {
            char firstChar = name.charAt(0);
            char secondChar = name.charAt(1);
            if (name.length() > 2 && firstChar == 'm' && secondChar == '_') {
                char thirdChar = name.charAt(2);
                if (Character.isJavaIdentifierStart(thirdChar)) {
                    return String.valueOf(Character.toLowerCase(thirdChar)) + name.subSequence(3, name.length());
                }
            } else if (firstChar == 'm' && Character.isUpperCase(secondChar) || firstChar == '_' && Character.isJavaIdentifierStart(secondChar)) {
                return String.valueOf(Character.toLowerCase(secondChar)) + name.subSequence(2, name.length());
            }
        }
        return name;
    }

    @Nullable
    public static String getBrQualifiedName(@NotNull AndroidFacet facet2) {
        String packageName = DataBindingUtil.getGeneratedPackageName(facet2);
        return packageName == null ? null : packageName + "." + BR;
    }

    @Nullable
    public static String getGeneratedPackageName(@NotNull AndroidFacet facet2) {
        return AndroidManifestUtils.getPackageName(facet2);
    }

    @Nullable
    public static String getBindingExprDefault(@NotNull XmlAttribute psiAttribute) {
        DataBindingExpressionSupport expressionSupport = DataBindingExpressionUtil.getDataBindingExpressionSupport();
        if (expressionSupport != null) {
            return expressionSupport.getBindingExprDefault(psiAttribute);
        }
        return null;
    }

    @Nullable
    public static String getBindingExprDefault(@NotNull String expression2) {
        DataBindingExpressionSupport expressionSupport = DataBindingExpressionUtil.getDataBindingExpressionSupport();
        if (expressionSupport != null) {
            return expressionSupport.getBindingExprDefault(expression2);
        }
        return null;
    }

    public static boolean isBindingExpression(@NotNull String string) {
        return string.startsWith("@{") || string.startsWith("@={");
    }

    public static boolean isTwoWayBindingExpression(@NotNull String string) {
        return string.startsWith("@={");
    }

    @Nullable
    public static String getAlias(@NotNull Import anImport) {
        XmlAttributeValue value2;
        GenericAttributeValue<PsiElement> type;
        String aliasValue = null;
        String typeValue = null;
        GenericAttributeValue<String> alias = anImport.getAlias();
        if (alias != null && alias.getXmlAttributeValue() != null) {
            aliasValue = alias.getXmlAttributeValue().getValue();
        }
        if ((type = anImport.getType()) != null && (value2 = type.getXmlAttributeValue()) != null) {
            typeValue = value2.getValue();
        }
        return DataBindingUtil.getAlias(typeValue, aliasValue);
    }

    @Nullable
    private static String getAlias(@Nullable String type, @Nullable String alias) {
        if (alias != null || type == null) {
            return alias;
        }
        int i2 = type.lastIndexOf(46);
        int d = type.lastIndexOf(36);
        if ((i2 = Math.max(i2, d)) < 0) {
            return type;
        }
        return type.length() > i2 + 1 ? type.substring(i2 + 1) : null;
    }

    @Nullable
    public static String getQualifiedType(@NotNull Project project, final @NotNull String nameOrAlias, final @NotNull BindingXmlData bindingData, final boolean qualifyJavaLang) {
        class UnresolvedClassNameException
        extends RuntimeException {
            UnresolvedClassNameException() {
            }
        }
        PsiType psiType;
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        final PsiJavaParserFacade parser = psiFacade.getParserFacade();
        try {
            psiType = parser.createTypeFromText(nameOrAlias, null);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
        if (psiType instanceof PsiPrimitiveType) {
            return nameOrAlias;
        }
        final StringBuilder result2 = new StringBuilder();
        final int[] offset2 = new int[1];
        try {
            psiType.accept((PsiTypeVisitor)new ClassReferenceVisitor(){

                @Override
                public void visitClassReference(@NotNull PsiClassReferenceType classReference) {
                    String className2;
                    PsiJavaCodeReferenceElement reference2 = classReference.getReference();
                    int nameOffset = reference2.getTextRange().getStartOffset();
                    while (offset2[0] < nameOffset) {
                        int n = offset2[0];
                        offset2[0] = n + 1;
                        result2.append(nameOrAlias.charAt(n));
                    }
                    String string = className2 = reference2.isQualified() ? reference2.getQualifiedName() : reference2.getReferenceName();
                    if (className2 != null) {
                        int nameLength = className2.length();
                        className2 = DataBindingUtil.resolveImport(className2, bindingData);
                        if (qualifyJavaLang && className2.indexOf(46) < 0 && (className2 = DataBindingUtil.qualifyClassName(className2, parser)) == null) {
                            throw new UnresolvedClassNameException();
                        }
                        result2.append(className2);
                        offset2[0] = offset2[0] + nameLength;
                    }
                }
            });
        }
        catch (UnresolvedClassNameException e) {
            return null;
        }
        while (offset2[0] < nameOrAlias.length()) {
            int n = offset2[0];
            offset2[0] = n + 1;
            result2.append(nameOrAlias.charAt(n));
        }
        return result2.toString();
    }

    @Nullable
    private static String qualifyClassName(@NotNull String className2, @NotNull PsiJavaParserFacade parser) {
        PsiType psiType = parser.createTypeFromText(className2, null);
        if (psiType instanceof PsiClassType) {
            PsiClass psiClass = ((PsiClassType)psiType).resolve();
            if (psiClass == null) {
                return null;
            }
            String name = psiClass.getQualifiedName();
            if (name != null) {
                return name;
            }
        }
        return className2;
    }

    @NotNull
    public static String resolveImport(@NotNull String className2, @NotNull BindingXmlData bindingData) {
        String importedType;
        int dotOffset = className2.indexOf(46);
        String firstSegment = dotOffset >= 0 ? className2.substring(0, dotOffset) : className2;
        ImportData anImport = bindingData.findImport(firstSegment);
        String string = importedType = anImport != null ? anImport.getType() : null;
        if (importedType == null) {
            return className2;
        }
        return dotOffset >= 0 ? importedType + className2.substring(dotOffset) : importedType;
    }

    @Nullable
    public static XmlFile findXmlFile(@NotNull Project project, @NotNull VirtualFile layoutFile) {
        if (!layoutFile.isValid()) {
            DataBindingUtil.getLog().info("findXmlFile aborted for invalid file: " + layoutFile);
            return null;
        }
        return (XmlFile)PsiManager.getInstance((Project)project).findFile(layoutFile);
    }

    public static abstract class ClassReferenceVisitor
    extends PsiTypeVisitor<Void> {
        @Nullable
        public final Void visitClassType(@NotNull PsiClassType classType) {
            PsiType[] parameters2;
            if (classType instanceof PsiClassReferenceType) {
                this.visitClassReference((PsiClassReferenceType)classType);
            }
            for (PsiType parameter : parameters2 = classType.getParameters()) {
                parameter.accept((PsiTypeVisitor)this);
            }
            return null;
        }

        @Nullable
        public final Void visitArrayType(@NotNull PsiArrayType arrayType) {
            PsiType type = arrayType.getComponentType();
            type.accept((PsiTypeVisitor)this);
            return null;
        }

        public abstract void visitClassReference(@NotNull PsiClassReferenceType var1);
    }
}

