/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.connection.assistant.actions;

import com.android.ddmlib.AdbDevice;
import com.android.ddmlib.IDevice;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.assistant.AssistActionState;
import com.android.tools.idea.assistant.AssistActionStateManager;
import com.android.tools.idea.assistant.datamodel.ActionData;
import com.android.tools.idea.assistant.datamodel.DefaultActionState;
import com.android.tools.idea.assistant.view.StatefulButtonMessage;
import com.android.tools.idea.assistant.view.UIUtils;
import com.android.tools.idea.connection.assistant.actions.ButtonMessage;
import com.android.tools.idea.connection.assistant.actions.ConnectionAssistantSection;
import com.android.tools.idea.connection.assistant.actions.CustomSuccessState;
import com.android.tools.idea.connection.assistant.actions.DeviceCrossReference;
import com.android.tools.idea.connection.assistant.actions.DeviceCrossReferenceKt;
import com.android.tools.idea.connection.assistant.actions.DeviceSummary;
import com.android.tools.idea.connection.assistant.actions.DeviceSummaryKt;
import com.android.tools.idea.connection.assistant.actions.ListUsbDevicesAction;
import com.android.tools.idea.connection.assistant.actions.ListUsbDevicesActionStateManager;
import com.android.tools.idea.stats.UsageTrackerUtils;
import com.android.tools.usb.Platform;
import com.android.tools.usb.UsbDevice;
import com.android.tools.usb.UsbDeviceCollector;
import com.android.tools.usb.UsbDeviceCollectorImpl;
import com.android.utils.HtmlBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.ConnectionAssistantEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.EdtInvocationManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 &2\u00020\u00012\u00020\u0002:\u0001&B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\u0006H\u0002J\u0014\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00060\u000fH\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J$\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010\"\u001a\u0004\u0018\u00010\u001aH\u0016J\u0018\u0010#\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016JN\u0010#\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u00122\u0018\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00060\u000f0\u00052\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005H\u0007J\u0006\u0010%\u001a\u00020\u0014R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082.\u00a2\u0006\u0002\n\u0000RJ\u0010\b\u001a>\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\n \u000b*\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u00060\u0006 \u000b*\u001e\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\n \u000b*\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u00060\u0006\u0018\u00010\t0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00060\u000f0\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/android/tools/idea/connection/assistant/actions/ListUsbDevicesActionStateManager;", "Lcom/android/tools/idea/assistant/AssistActionStateManager;", "Lcom/intellij/openapi/Disposable;", "()V", "deviceFunction", "Lkotlin/Function0;", "", "Lcom/android/ddmlib/IDevice;", "myDevicesFuture", "Ljava/util/concurrent/CompletableFuture;", "Lcom/android/tools/idea/connection/assistant/actions/DeviceCrossReference;", "kotlin.jvm.PlatformType", "myProject", "Lcom/intellij/openapi/project/Project;", "rawDeviceFunction", "Ljava/util/concurrent/CompletionStage;", "Lcom/android/ddmlib/AdbDevice;", "usbDeviceCollector", "Lcom/android/tools/usb/UsbDeviceCollector;", "dispose", "", "generateMessage", "Lcom/android/tools/idea/connection/assistant/actions/ButtonMessage;", "getAllDevices", "getDevices", "getId", "", "getState", "Lcom/android/tools/idea/assistant/AssistActionState;", "project", "actionData", "Lcom/android/tools/idea/assistant/datamodel/ActionData;", "getStateDisplay", "Lcom/android/tools/idea/assistant/view/StatefulButtonMessage;", "message", "init", "deviceCollector", "refresh", "Companion", "connection-assistant"})
public final class ListUsbDevicesActionStateManager
extends AssistActionStateManager
implements Disposable {
    private UsbDeviceCollector usbDeviceCollector;
    private Project myProject;
    private CompletableFuture<List<DeviceCrossReference>> myDevicesFuture = CompletableFuture.completedFuture(CollectionsKt.emptyList());
    private Function0<? extends CompletionStage<List<AdbDevice>>> rawDeviceFunction;
    private Function0<? extends List<? extends IDevice>> deviceFunction;
    private static ListUsbDevicesActionStateManager myInstance;
    public static final Companion Companion;

    @Override
    public void init(@NotNull Project project, @NotNull ActionData actionData) {
        this.init(project, actionData, (UsbDeviceCollector)new UsbDeviceCollectorImpl(), (Function0<? extends CompletionStage<List<AdbDevice>>>)((Function0)init.1.INSTANCE), (Function0<? extends List<? extends IDevice>>)((Function0)init.2.INSTANCE));
    }

    @VisibleForTesting
    public final void init(@NotNull Project project, @NotNull ActionData actionData, @NotNull UsbDeviceCollector deviceCollector, @NotNull Function0<? extends CompletionStage<List<AdbDevice>>> rawDeviceFunction, @NotNull Function0<? extends List<? extends IDevice>> deviceFunction) {
        this.myProject = project;
        this.usbDeviceCollector = deviceCollector;
        myInstance = this;
        this.rawDeviceFunction = rawDeviceFunction;
        this.deviceFunction = deviceFunction;
        this.refresh();
        Disposer.register((Disposable)((Disposable)project), (Disposable)this);
    }

    private final CompletionStage<List<DeviceCrossReference>> getDevices() {
        return this.myDevicesFuture;
    }

    public final void refresh() {
        UsbDeviceCollector usbDeviceCollector = this.usbDeviceCollector;
        if (usbDeviceCollector == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"usbDeviceCollector");
        }
        CompletableFuture completableFuture = usbDeviceCollector.listUsbDevices();
        Function0<? extends CompletionStage<List<AdbDevice>>> function0 = this.rawDeviceFunction;
        if (function0 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rawDeviceFunction");
        }
        this.myDevicesFuture = ((CompletableFuture)completableFuture.thenCombine((CompletionStage)function0.invoke(), new BiFunction<List<? extends UsbDevice>, List<? extends AdbDevice>, List<? extends DeviceCrossReference>>(this){
            final /* synthetic */ ListUsbDevicesActionStateManager this$0;

            public final List<DeviceCrossReference> apply(List<UsbDevice> a, List<AdbDevice> b) {
                return DeviceCrossReferenceKt.crossReference((Collection<UsbDevice>)a, (Collection)ListUsbDevicesActionStateManager.access$getDeviceFunction$p(this.this$0).invoke(), (Collection<AdbDevice>)b);
            }
            {
                this.this$0 = listUsbDevicesActionStateManager;
            }
        })).exceptionally((Function)refresh.2.INSTANCE);
        this.myDevicesFuture.thenAccept(new Consumer<List<? extends DeviceCrossReference>>(this){
            final /* synthetic */ ListUsbDevicesActionStateManager this$0;

            public final void accept(List<DeviceCrossReference> it) {
                EdtInvocationManager.getInstance().invokeLater(new Runnable(this, it){
                    final /* synthetic */ refresh.3 this$0;
                    final /* synthetic */ List $it;

                    public final void run() {
                        Project project = ListUsbDevicesActionStateManager.access$getMyProject$p(this.this$0.this$0);
                        if (project == null) {
                            Intrinsics.throwNpe();
                        }
                        if (!project.isDisposed()) {
                            UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId(AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.CONNECTION_ASSISTANT_EVENT).setConnectionAssistantEvent(ConnectionAssistantEvent.newBuilder().setType(ConnectionAssistantEvent.ConnectionAssistantEventType.USB_DEVICES_DETECTED).setUsbDevicesDetected(this.$it.size())), ListUsbDevicesActionStateManager.access$getMyProject$p(this.this$0.this$0)));
                            ListUsbDevicesActionStateManager listUsbDevicesActionStateManager = this.this$0.this$0;
                            Project project2 = ListUsbDevicesActionStateManager.access$getMyProject$p(this.this$0.this$0);
                            if (project2 == null) {
                                Intrinsics.throwNpe();
                            }
                            listUsbDevicesActionStateManager.refreshDependencyState(project2);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$it = list;
                    }
                });
            }
            {
                this.this$0 = listUsbDevicesActionStateManager;
            }
        });
    }

    public void dispose() {
        this.myDevicesFuture.cancel(true);
        this.myProject = null;
    }

    @Override
    @NotNull
    public AssistActionState getState(@NotNull Project project, @NotNull ActionData actionData) {
        if (!this.myDevicesFuture.isDone()) {
            return DefaultActionState.IN_PROGRESS;
        }
        return this.myDevicesFuture.get().isEmpty() ? (AssistActionState)DefaultActionState.ERROR_RETRY : (AssistActionState)CustomSuccessState.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public StatefulButtonMessage getStateDisplay(@NotNull Project project, @NotNull ActionData actionData, @Nullable String message2) {
        void title;
        ButtonMessage buttonMessage = this.generateMessage();
        String string = buttonMessage.component1();
        String body = buttonMessage.component2();
        return new StatefulButtonMessage((String)title, this.getState(project, actionData), body);
    }

    @Override
    @NotNull
    public String getId() {
        return ListUsbDevicesAction.Companion.getACTION_ID();
    }

    private final List<DeviceCrossReference> getAllDevices() {
        return this.myDevicesFuture.get();
    }

    /*
     * WARNING - void declaration
     */
    private final ButtonMessage generateMessage() {
        DeviceSummary device;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        void $this$filterTo$iv$iv4;
        void $this$filterTo$iv$iv2;
        void $this$filterTo$iv$iv3;
        void $this$mapTo$iv$iv2;
        if (!this.myDevicesFuture.isDone()) {
            return new ButtonMessage("Loading...", null, 2, null);
        }
        Iterable $this$map$iv = this.getAllDevices();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            Iterator it;
            DeviceCrossReference deviceCrossReference = (DeviceCrossReference)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            DeviceSummary deviceSummary = DeviceSummaryKt.summarize((DeviceCrossReference)((Object)it));
            collection2.add(deviceSummary);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy22 = false;
        boolean $this$mapTo$iv$iv2 = false;
        List devices2 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                DeviceSummary it = (DeviceSummary)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)it.getLabel());
                it = (DeviceSummary)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string = it.getLabel();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        });
        HtmlBuilder titleHtmlBuilder = new HtmlBuilder().openHtmlBody();
        Collection $i$f$sortedBy22 = devices2;
        $this$mapTo$iv$iv2 = false;
        if (!$i$f$sortedBy22.isEmpty()) {
            titleHtmlBuilder.beginSpan("color: " + UIUtils.getCssColor(UIUtils.getSuccessColor())).add("Android Studio detected " + devices2.size() + " device(s).").endSpan();
        } else {
            titleHtmlBuilder.beginSpan("color: " + UIUtils.getCssColor(UIUtils.getFailureColor())).add(AndroidBundle.message("connection.assistant.usb.no_devices.title", new Object[0])).endSpan();
        }
        Iterable $this$filter$iv = devices2;
        boolean $i$f$filter = false;
        Iterable $i$f$mapTo22 = $this$filter$iv;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv3) {
            DeviceSummary it = (DeviceSummary)element$iv$iv;
            boolean bl = false;
            if (!(it.getSection() == ConnectionAssistantSection.WORKING)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List workingDevices = (List)destination$iv$iv2;
        Iterable $this$filter$iv2 = devices2;
        boolean $i$f$filter2 = false;
        destination$iv$iv2 = $this$filter$iv2;
        Iterable destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            DeviceSummary it = (DeviceSummary)element$iv$iv;
            boolean bl = false;
            if (!(it.getSection() == ConnectionAssistantSection.POSSIBLE_PROBLEM)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        List problemDevices = (List)destination$iv$iv3;
        Iterable $this$filter$iv3 = devices2;
        boolean $i$f$filter222 = false;
        destination$iv$iv3 = $this$filter$iv3;
        Object destination$iv$iv4 = new ArrayList();
        boolean $i$f$filterTo3 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv4) {
            DeviceSummary it = (DeviceSummary)element$iv$iv;
            boolean bl = false;
            if (!(it.getSection() == ConnectionAssistantSection.OTHER_USB)) continue;
            destination$iv$iv4.add(element$iv$iv);
        }
        List usbDevices = (List)destination$iv$iv4;
        HtmlBuilder bodyHtmlBuilder = new HtmlBuilder().openHtmlBody();
        bodyHtmlBuilder.newline();
        Collection $i$f$filter222 = workingDevices;
        boolean $this$filterTo$iv$iv4 = false;
        if (!$i$f$filter222.isEmpty()) {
            bodyHtmlBuilder.addHeading("Found " + workingDevices.size() + " Android device(s) ready for debugging:", "black");
            $this$forEach$iv = workingDevices;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                device = (DeviceSummary)element$iv;
                boolean bl = false;
                String name = device.getLabel();
                bodyHtmlBuilder.beginParagraph().add(name);
                bodyHtmlBuilder.newlineIfNecessary().endParagraph();
            }
            bodyHtmlBuilder.beginParagraph().endParagraph();
        }
        $this$forEach$iv = problemDevices;
        $i$f$forEach = false;
        if (!$this$forEach$iv.isEmpty()) {
            bodyHtmlBuilder.addHeading("Found " + problemDevices.size() + " Android device(s) with possible problems:", "black");
            $this$forEach$iv = problemDevices;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                device = (DeviceSummary)element$iv;
                boolean bl = false;
                String name = device.getLabel();
                bodyHtmlBuilder.beginParagraph().add(name).endParagraph();
                if (device.getErrorMessage() == null) continue;
                bodyHtmlBuilder.beginList().listItem().add(device.getErrorMessage()).endList();
            }
            bodyHtmlBuilder.beginParagraph().endParagraph();
        }
        $this$forEach$iv = usbDevices;
        $i$f$forEach = false;
        if (!$this$forEach$iv.isEmpty()) {
            void $this$groupByTo$iv$iv;
            bodyHtmlBuilder.addHeading("Found " + usbDevices.size() + " USB device(s) not recognized as Android devices:", "black");
            Iterable $this$groupBy$iv = usbDevices;
            boolean $i$f$groupBy = false;
            destination$iv$iv4 = $this$groupBy$iv;
            Map destination$iv$iv5 = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                DeviceSummary usbDevice = (DeviceSummary)element$iv$iv;
                boolean bl = false;
                DeviceSummary key$iv$iv = usbDevice;
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv5;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            destination$iv$iv5.forEach((BiConsumer)new BiConsumer<DeviceSummary, List<? extends DeviceSummary>>(bodyHtmlBuilder){
                final /* synthetic */ HtmlBuilder $bodyHtmlBuilder;

                public final void accept(@NotNull DeviceSummary $noName_0, @NotNull List<DeviceSummary> deviceList) {
                    DeviceSummary device = (DeviceSummary)CollectionsKt.first(deviceList);
                    String name = device.getLabel();
                    this.$bodyHtmlBuilder.beginParagraph().add(name);
                    if (deviceList.size() > 1) {
                        this.$bodyHtmlBuilder.addNbsp().add("" + '(' + deviceList.size() + "x)");
                    }
                    this.$bodyHtmlBuilder.newlineIfNecessary().endParagraph();
                }
                {
                    this.$bodyHtmlBuilder = htmlBuilder;
                }
            });
            bodyHtmlBuilder.beginParagraph().endParagraph();
        }
        if (devices2.isEmpty()) {
            bodyHtmlBuilder.beginParagraph().add(AndroidBundle.message("connection.assistant.usb.no_devices.body", new Object[0])).endParagraph().newlineIfNecessary();
        }
        UsbDeviceCollector usbDeviceCollector = this.usbDeviceCollector;
        if (usbDeviceCollector == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"usbDeviceCollector");
        }
        if (usbDeviceCollector.getPlatform() == Platform.Windows) {
            bodyHtmlBuilder.beginParagraph().addBold("Install device drivers.").add(" If you want to connect a device for testing, then you need to install the appropriate USB drivers. For more information, read the ").addLink("online documentation", "https://developer.android.com/studio/run/oem-usb.html").add(".").endParagraph();
        }
        return new ButtonMessage(titleHtmlBuilder.closeHtmlBody().getHtml(), bodyHtmlBuilder.closeHtmlBody().getHtml());
    }

    static {
        Companion = new Companion(null);
    }

    public static final /* synthetic */ Function0 access$getDeviceFunction$p(ListUsbDevicesActionStateManager $this) {
        Function0<? extends List<? extends IDevice>> function0 = $this.deviceFunction;
        if (function0 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"deviceFunction");
        }
        return function0;
    }

    public static final /* synthetic */ void access$setDeviceFunction$p(ListUsbDevicesActionStateManager $this, Function0 function0) {
        $this.deviceFunction = function0;
    }

    public static final /* synthetic */ Project access$getMyProject$p(ListUsbDevicesActionStateManager $this) {
        return $this.myProject;
    }

    public static final /* synthetic */ void access$setMyProject$p(ListUsbDevicesActionStateManager $this, Project project) {
        $this.myProject = project;
    }

    public static final /* synthetic */ void access$setMyInstance$cp(ListUsbDevicesActionStateManager listUsbDevicesActionStateManager) {
        myInstance = listUsbDevicesActionStateManager;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/connection/assistant/actions/ListUsbDevicesActionStateManager$Companion;", "", "()V", "myInstance", "Lcom/android/tools/idea/connection/assistant/actions/ListUsbDevicesActionStateManager;", "getInstance", "connection-assistant"})
    public static final class Companion {
        @NotNull
        public final ListUsbDevicesActionStateManager getInstance() {
            ListUsbDevicesActionStateManager listUsbDevicesActionStateManager = myInstance;
            if (listUsbDevicesActionStateManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myInstance");
            }
            return listUsbDevicesActionStateManager;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

