/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ThemeSelectionPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.DoubleClickListener;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThemeSelectionDialog
extends DialogWrapper {
    @NotNull
    private final ThemeSelectionPanel myPanel;

    public ThemeSelectionDialog(@NotNull Configuration configuration) {
        this(configuration, Collections.emptySet());
    }

    public ThemeSelectionDialog(@NotNull Configuration configuration, @NotNull Set<String> excludedThemes) {
        super(configuration.getModule().getProject());
        this.myPanel = new ThemeSelectionPanel(this, configuration, excludedThemes);
        this.setTitle("Select Theme");
        this.init();
    }

    public void setThemeChangedListener(@NotNull ThemeSelectionPanel.ThemeChangedListener themeChangedListener) {
        this.myPanel.setThemeChangedListener(themeChangedListener);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel contentPanel2 = this.myPanel.getContentPanel();
        contentPanel2.setPreferredSize((Dimension)JBUI.size((int)800, (int)500));
        this.myPanel.installDoubleClickListener(new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent event) {
                ThemeSelectionDialog.this.close(0);
                return true;
            }
        });
        return contentPanel2;
    }

    protected void doOKAction() {
        super.doOKAction();
    }

    protected String getDimensionServiceKey() {
        return "AndroidThemeDialog";
    }

    @Nullable
    public String getTheme() {
        return this.myPanel.getTheme();
    }

    public void checkValidation() {
        this.initValidation();
    }

    @Nullable
    protected ValidationInfo doValidate() {
        String theme = this.myPanel.getTheme();
        if (theme == null) {
            return new ValidationInfo("Select a theme");
        }
        return null;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPanel.getPreferredFocusedComponent();
    }
}

