/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.ide.common.resources.LocaleManager;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceRepositoryUtil;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.tools.adtui.actions.DropDownAction;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationAction;
import com.android.tools.idea.configurations.ConfigurationHolder;
import com.android.tools.idea.configurations.ConfigurationMatcher;
import com.android.tools.idea.configurations.RtlAction;
import com.android.tools.idea.editors.strings.StringResourceEditorProvider;
import com.android.tools.idea.layoutlib.LayoutLibrary;
import com.android.tools.idea.rendering.FlagManager;
import com.android.tools.idea.rendering.Locale;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import icons.StudioIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocaleMenuAction
extends DropDownAction {
    private static final String DEFAULT_LOCALE_LABEL = "Default (en-us)";
    private final ConfigurationHolder myRenderContext;

    public LocaleMenuAction(@NotNull ConfigurationHolder renderContext) {
        super("Locale for Preview", "Locale for Preview", null);
        this.myRenderContext = renderContext;
        Presentation presentation = this.getTemplatePresentation();
        this.updatePresentation(presentation);
    }

    public boolean displayTextInToolbar() {
        return true;
    }

    protected boolean updateActions(@NotNull DataContext context) {
        this.removeAll();
        Configuration conf = this.myRenderContext.getConfiguration();
        String currentLocalLabel = LocaleMenuAction.getLocaleLabel(conf == null ? Locale.ANY : conf.getLocale(), false);
        List<Locale> locales = this.getRelevantLocales();
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration != null && !locales.isEmpty()) {
            String title = LocaleMenuAction.getLocaleLabel(Locale.ANY, false);
            this.add(new SetLocaleAction(this.myRenderContext, title, Locale.ANY, currentLocalLabel.equals(title)));
            this.addSeparator();
            Collections.sort(locales, Locale.LANGUAGE_CODE_COMPARATOR);
            for (Locale locale : locales) {
                title = LocaleMenuAction.getLocaleLabel(locale, false);
                VirtualFile better = ConfigurationMatcher.getBetterMatch(configuration, null, null, locale, null);
                if (better != null) {
                    title = ConfigurationAction.getBetterMatchLabel(LocaleMenuAction.getLocaleLabel(locale, true), better, configuration.getFile());
                }
                this.add(new SetLocaleAction(this.myRenderContext, title, locale, currentLocalLabel.equals(title)));
            }
            this.addSeparator();
        }
        this.add(new EditTranslationAction());
        if (configuration != null && !LocaleMenuAction.hasAnyRtlLocales(configuration, locales)) {
            this.add((AnAction)new RtlAction(this.myRenderContext));
        }
        return true;
    }

    private static boolean hasAnyRtlLocales(@NotNull Configuration configuration, @NotNull List<Locale> locales) {
        LayoutLibrary layoutlib = RenderService.getLayoutLibrary(configuration.getModule(), configuration.getTarget());
        if (layoutlib == null) {
            return false;
        }
        return locales.stream().anyMatch(locale -> layoutlib.isRtl(locale.toLocaleId()));
    }

    @NotNull
    private List<Locale> getRelevantLocales() {
        LocalResourceRepository projectResources;
        ArrayList<Locale> locales = new ArrayList<Locale>();
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration == null) {
            return Collections.emptyList();
        }
        Module module2 = configuration.getConfigurationManager().getModule();
        LocaleQualifier specificLocale = configuration.getEditedConfig().getLocaleQualifier();
        if (specificLocale != null) {
            List<VirtualFile> variations = IdeResourcesUtil.getResourceVariations(configuration.getFile(), false);
            for (VirtualFile variation : variations) {
                FolderConfiguration config = FolderConfiguration.getConfigForFolder((String)variation.getParent().getName());
                if (config == null || config.getLocaleQualifier() != null) continue;
                specificLocale = null;
                break;
            }
        }
        SortedSet languages2 = (projectResources = ResourceRepositoryManager.getProjectResources(module2)) != null ? ResourceRepositoryUtil.getLocales((ResourceRepository)projectResources) : Collections.emptySet();
        for (LocaleQualifier l : languages2) {
            if (specificLocale != null && !specificLocale.isMatchFor((ResourceQualifier)l)) continue;
            locales.add(Locale.create(l));
        }
        return locales;
    }

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        this.updatePresentation(e.getPresentation());
    }

    private void updatePresentation(Presentation presentation) {
        boolean visible;
        Configuration configuration = this.myRenderContext.getConfiguration();
        boolean bl = visible = configuration != null;
        if (visible) {
            Locale locale = configuration.getLocale();
            presentation.setIcon(locale != Locale.ANY && FlagManager.showFlagsForLanguages() ? locale.getFlagImage() : StudioIcons.LayoutEditor.Toolbar.LANGUAGE);
            String brief = LocaleMenuAction.getLocaleLabel(locale, true);
            presentation.setText(brief);
        } else {
            presentation.setIcon(StudioIcons.LayoutEditor.Toolbar.LANGUAGE);
        }
        if (visible != presentation.isVisible()) {
            presentation.setVisible(visible);
        }
    }

    public static String getLocaleLabel(@Nullable Locale locale, boolean brief) {
        if (locale == null || !locale.hasLanguage()) {
            return DEFAULT_LOCALE_LABEL;
        }
        String languageCode = locale.qualifier.getLanguage();
        assert (languageCode != null);
        String languageName = LocaleManager.getLanguageName((String)languageCode);
        if (!locale.hasRegion()) {
            if (languageName != null) {
                return String.format("%1$s (%2$s)", languageName, languageCode);
            }
            return languageCode;
        }
        String regionCode = locale.qualifier.getRegion();
        assert (regionCode != null) : locale.qualifier;
        if (!brief && languageName != null) {
            String regionName = LocaleManager.getRegionName((String)regionCode);
            if (regionName != null) {
                return String.format("%1$s (%2$s) in %3$s (%4$s)", languageName, languageCode, regionName, regionCode);
            }
            return String.format("%1$s (%2$s) in %3$s", languageName, languageCode, regionCode);
        }
        return String.format("%1$s (%2$s / %3$s)", languageName, languageCode, regionCode);
    }

    private class EditTranslationAction
    extends AnAction {
        public EditTranslationAction() {
            super("Edit Translations...", null, null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Configuration configuration = LocaleMenuAction.this.myRenderContext.getConfiguration();
            if (configuration != null) {
                Module module2 = configuration.getConfigurationManager().getModule();
                StringResourceEditorProvider.openEditor(module2);
            }
        }
    }

    private class SetLocaleAction
    extends ConfigurationAction {
        private final Locale myLocale;

        public SetLocaleAction(ConfigurationHolder renderContext, @NotNull String title, Locale locale, boolean isCurrentLocale) {
            super(renderContext, title);
            this.myLocale = locale;
            if (isCurrentLocale) {
                this.getTemplatePresentation().putClientProperty("selected", (Object)true);
            } else if (FlagManager.showFlagsForLanguages() && locale != Locale.ANY) {
                this.getTemplatePresentation().setIcon(locale.getFlagImage());
            }
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            super.actionPerformed(e);
            LocaleMenuAction.this.updateActions(e.getDataContext());
        }

        @Override
        protected void updateConfiguration(@NotNull Configuration configuration, boolean commit) {
            if (commit) {
                this.setProjectWideLocale();
            } else {
                configuration.getEditedConfig().setLayoutDirectionQualifier(null);
                configuration.setLocale(this.myLocale);
            }
        }

        @Override
        protected void pickedBetterMatch(@NotNull VirtualFile file2, @NotNull VirtualFile old2) {
            super.pickedBetterMatch(file2, old2);
            Configuration configuration = this.myRenderContext.getConfiguration();
            if (configuration != null) {
                this.setProjectWideLocale();
            }
        }

        private void setProjectWideLocale() {
            Configuration configuration = this.myRenderContext.getConfiguration();
            if (configuration != null) {
                configuration.getConfigurationManager().setLocale(this.myLocale);
            }
        }
    }
}

