/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.compose.preview.animation;

import androidx.compose.animation.tooling.ComposeAnimatedProperty;
import androidx.compose.animation.tooling.ComposeAnimation;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.actions.DropDownAction;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.util.ControllableTicker;
import com.android.tools.idea.compose.preview.ComposePreviewBundle;
import com.android.tools.idea.compose.preview.analytics.AnimationToolingEvent;
import com.android.tools.idea.compose.preview.analytics.AnimationToolingUsageTracker;
import com.android.tools.idea.compose.preview.animation.AnimationClock;
import com.android.tools.idea.compose.preview.animation.AnimationInspectorPanel;
import com.android.tools.idea.compose.preview.animation.AnimationInspectorPanelKt;
import com.android.tools.idea.compose.preview.util.RenderKt;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.android.utils.HtmlBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.ComposeAnimationToolingEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.JBTabsPaneImpl;
import com.intellij.ui.TabbedPane;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.StudioIcons;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.time.Duration;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicSliderUI;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u00012\u00020\u0002:\u0006:;<=>?B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0015\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b)J\b\u0010*\u001a\u00020'H\u0016J\r\u0010+\u001a\u00020'H\u0000\u00a2\u0006\u0002\b,J\u0010\u0010-\u001a\u00020'2\u0006\u0010.\u001a\u00020/H\u0002J\u0015\u00100\u001a\u00020'2\u0006\u0010(\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b1J\b\u00102\u001a\u00020'H\u0002J\u001c\u00103\u001a\u00020'2\u0006\u0010(\u001a\u00020\u000e2\f\u00104\u001a\b\u0012\u0004\u0012\u00020605J\u001a\u00107\u001a\u00020'*\u0002082\f\u00109\u001a\b\u0018\u00010\u000fR\u00020\u0000H\u0002R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR2\u0010\f\u001a&\u0012\u0004\u0012\u00020\u000e\u0012\b\u0012\u00060\u000fR\u00020\u00000\rj\u0012\u0012\u0004\u0012\u00020\u000e\u0012\b\u0012\u00060\u000fR\u00020\u0000`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u00060\u0014R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R*\u0010\u0017\u001a\u001e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\rj\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0019`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001a\u001a\u00020\u001b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\u0012\u0010 \u001a\u00060!R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\"\u001a\u00060#R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010$\u001a\u00060%R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/android/tools/idea/compose/preview/animation/AnimationInspectorPanel;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/Disposable;", "surface", "Lcom/android/tools/idea/common/surface/DesignSurface;", "(Lcom/android/tools/idea/common/surface/DesignSurface;)V", "animationClock", "Lcom/android/tools/idea/compose/preview/animation/AnimationClock;", "getAnimationClock$intellij_android_compose_designer", "()Lcom/android/tools/idea/compose/preview/animation/AnimationClock;", "setAnimationClock$intellij_android_compose_designer", "(Lcom/android/tools/idea/compose/preview/animation/AnimationClock;)V", "animationTabs", "Ljava/util/HashMap;", "Landroidx/compose/animation/tooling/ComposeAnimation;", "Lcom/android/tools/idea/compose/preview/animation/AnimationInspectorPanel$AnimationTab;", "Lkotlin/collections/HashMap;", "noAnimationsPanel", "Lcom/intellij/ui/components/JBLoadingPanel;", "playPauseAction", "Lcom/android/tools/idea/compose/preview/animation/AnimationInspectorPanel$PlayPauseAction;", "getSurface$intellij_android_compose_designer", "()Lcom/android/tools/idea/common/surface/DesignSurface;", "tabNamesCount", "", "", "tabbedPane", "Lcom/intellij/ui/JBTabsPaneImpl;", "getTabbedPane$annotations", "()V", "getTabbedPane", "()Lcom/intellij/ui/JBTabsPaneImpl;", "timeline", "Lcom/android/tools/idea/compose/preview/animation/AnimationInspectorPanel$TransitionDurationTimeline;", "timelineLoopAction", "Lcom/android/tools/idea/compose/preview/animation/AnimationInspectorPanel$TimelineLoopAction;", "timelineSpeedAction", "Lcom/android/tools/idea/compose/preview/animation/AnimationInspectorPanel$TimelineSpeedAction;", "addTab", "", "animation", "addTab$intellij_android_compose_designer", "dispose", "invalidatePanel", "invalidatePanel$intellij_android_compose_designer", "logAnimationInspectorEvent", "type", "Lcom/google/wireless/android/sdk/stats/ComposeAnimationToolingEvent$ComposeAnimationToolingEventType;", "removeTab", "removeTab$intellij_android_compose_designer", "showNoAnimationsPanel", "updateTransitionStates", "states", "", "", "remove", "Lcom/intellij/ui/TabbedPane;", "animationTab", "AnimationTab", "PlayPauseAction", "TimelineLoopAction", "TimelineSpeed", "TimelineSpeedAction", "TransitionDurationTimeline", "intellij.android.compose-designer"})
public final class AnimationInspectorPanel
extends JPanel
implements Disposable {
    @NotNull
    private final JBTabsPaneImpl tabbedPane;
    private final HashMap<ComposeAnimation, AnimationTab> animationTabs;
    private final HashMap<String, Integer> tabNamesCount;
    private final JBLoadingPanel noAnimationsPanel;
    private final TransitionDurationTimeline timeline;
    private final PlayPauseAction playPauseAction;
    private final TimelineSpeedAction timelineSpeedAction;
    private final TimelineLoopAction timelineLoopAction;
    @Nullable
    private AnimationClock animationClock;
    @NotNull
    private final DesignSurface surface;

    @VisibleForTesting
    public static /* synthetic */ void getTabbedPane$annotations() {
    }

    @NotNull
    public final JBTabsPaneImpl getTabbedPane() {
        return this.tabbedPane;
    }

    @Nullable
    public final AnimationClock getAnimationClock$intellij_android_compose_designer() {
        return this.animationClock;
    }

    public final void setAnimationClock$intellij_android_compose_designer(@Nullable AnimationClock animationClock) {
        this.animationClock = animationClock;
    }

    public final void updateTransitionStates(@NotNull ComposeAnimation animation, @NotNull Set<? extends Object> states) {
        AnimationTab animationTab = this.animationTabs.get(animation);
        if (animationTab != null) {
            AnimationTab animationTab2 = animationTab;
            boolean bl = false;
            boolean bl2 = false;
            AnimationTab tab = animationTab2;
            boolean bl3 = false;
            tab.setUpdatingAnimationStates(true);
            Collection $this$toTypedArray$iv = states;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
            if (objectArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            tab.updateStateComboboxes(objectArray);
            tab.updateSeekableAnimation();
            tab.getEndStateComboBox().setSelectedIndex(RangesKt.coerceIn((int)1, (int)0, (int)tab.getEndStateComboBox().getItemCount()));
            tab.setUpdatingAnimationStates(false);
        }
        this.timeline.jumpToStart();
        this.timeline.setClockTime(0);
    }

    public final void invalidatePanel$intellij_android_compose_designer() {
        this.tabbedPane.removeAll();
        this.animationTabs.clear();
        this.showNoAnimationsPanel();
    }

    private final void showNoAnimationsPanel() {
        this.remove(this.tabbedPane.getComponent());
        this.noAnimationsPanel.startLoading();
        this.add((Component)this.noAnimationsPanel, new TabularLayout.Constraint(1, 0, 2));
        this.tabNamesCount.clear();
    }

    public final void addTab$intellij_android_compose_designer(@NotNull ComposeAnimation animation) {
        if (this.tabbedPane.getTabCount() == 0) {
            this.noAnimationsPanel.stopLoading();
            this.remove((Component)this.noAnimationsPanel);
            this.add((Component)this.tabbedPane.getComponent(), new TabularLayout.Constraint(1, 0, 2));
        }
        AnimationTab animationTab = new AnimationTab(animation);
        ((Map)this.animationTabs).put(animation, animationTab);
        String string = animation.getLabel();
        if (string == null) {
            string = ComposePreviewBundle.message("animation.inspector.tab.default.title", new Object[0]);
        }
        String tabName = string;
        ((Map)this.tabNamesCount).put(tabName, ((Number)this.tabNamesCount.getOrDefault(tabName, 0)).intValue() + 1);
        this.tabbedPane.insertTab(tabName + " #" + this.tabNamesCount.get(tabName), null, (Component)animationTab, null, this.tabbedPane.getTabCount());
    }

    public final void removeTab$intellij_android_compose_designer(@NotNull ComposeAnimation animation) {
        this.remove((TabbedPane)this.tabbedPane, this.animationTabs.get(animation));
        this.animationTabs.remove(animation);
        if (this.tabbedPane.getTabCount() == 0) {
            this.showNoAnimationsPanel();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void remove(TabbedPane $this$remove, AnimationTab animationTab) {
        if (animationTab == null) {
            return;
        }
        int n = 0;
        int n2 = $this$remove.getTabCount();
        while (n < n2) {
            void i2;
            if (animationTab == $this$remove.getComponentAt((int)i2)) {
                $this$remove.removeTabAt((int)i2);
                return;
            }
            ++i2;
        }
    }

    public void dispose() {
        this.playPauseAction.dispose();
        this.animationTabs.clear();
        this.tabNamesCount.clear();
    }

    private final void logAnimationInspectorEvent(ComposeAnimationToolingEvent.ComposeAnimationToolingEventType type) {
        AnimationToolingUsageTracker.Companion.getInstance(this.surface).logEvent(new AnimationToolingEvent(type));
    }

    @NotNull
    public final DesignSurface getSurface$intellij_android_compose_designer() {
        return this.surface;
    }

    public AnimationInspectorPanel(@NotNull DesignSurface surface2) {
        super((LayoutManager)new TabularLayout("Fit,*", "Fit,*"));
        JBTabsPaneImpl $this$apply;
        this.surface = surface2;
        JBTabsPaneImpl jBTabsPaneImpl = new JBTabsPaneImpl(this.surface.getProject(), 1, (Disposable)this);
        boolean bl = false;
        boolean bl2 = false;
        JBTabsPaneImpl jBTabsPaneImpl2 = jBTabsPaneImpl;
        AnimationInspectorPanel animationInspectorPanel = this;
        boolean bl3 = false;
        $this$apply.addChangeListener(new ChangeListener($this$apply, this){
            final /* synthetic */ JBTabsPaneImpl $this_apply;
            final /* synthetic */ AnimationInspectorPanel this$0;
            {
                this.$this_apply = jBTabsPaneImpl;
                this.this$0 = animationInspectorPanel;
            }

            public final void stateChanged(ChangeEvent it) {
                block2: {
                    if (this.$this_apply.getSelectedIndex() < 0) {
                        return;
                    }
                    Component component = this.$this_apply.getComponentAt(this.$this_apply.getSelectedIndex());
                    if (!(component instanceof AnimationTab)) {
                        component = null;
                    }
                    AnimationTab animationTab = (AnimationTab)component;
                    if (animationTab == null) break block2;
                    AnimationTab animationTab2 = animationTab;
                    boolean bl = false;
                    boolean bl2 = false;
                    AnimationTab tab = animationTab2;
                    boolean bl3 = false;
                    tab.addTimeline();
                    AnimationInspectorPanel.access$getTimeline$p(this.this$0).setSelectedTab(tab);
                }
            }
        });
        Unit unit = Unit.INSTANCE;
        animationInspectorPanel.tabbedPane = jBTabsPaneImpl;
        this.animationTabs = new HashMap();
        this.tabNamesCount = new HashMap();
        jBTabsPaneImpl = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this);
        bl = false;
        bl2 = false;
        $this$apply = jBTabsPaneImpl;
        animationInspectorPanel = this;
        boolean bl4 = false;
        $this$apply.setName("Loading Animations Panel");
        $this$apply.setLoadingText(ComposePreviewBundle.message("animation.inspector.loading.animations.panel.message", new Object[0]));
        unit = Unit.INSTANCE;
        animationInspectorPanel.noAnimationsPanel = jBTabsPaneImpl;
        this.timeline = new TransitionDurationTimeline();
        this.playPauseAction = new PlayPauseAction();
        this.timelineSpeedAction = new TimelineSpeedAction();
        this.timelineLoopAction = new TimelineLoopAction();
        this.setName("Animation Preview");
        this.setBorder(new MatteBorder(0, 0, 1, 0, JBColor.border()));
        this.noAnimationsPanel.startLoading();
        this.add((Component)this.noAnimationsPanel, new TabularLayout.Constraint(1, 0, 2));
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0007*\u0002\u000b\u001c\b\u0082\u0004\u0018\u00002\u00020\u0001:\u0004-./0B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010 \u001a\u00020!J\b\u0010\"\u001a\u00020\u0001H\u0002J\b\u0010#\u001a\u00020$H\u0002J\b\u0010%\u001a\u00020$H\u0002J\u0006\u0010&\u001a\u00020!J\u0006\u0010'\u001a\u00020!J\u0019\u0010(\u001a\u00020!2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000f0*\u00a2\u0006\u0002\u0010+J\u0006\u0010,\u001a\u00020!R\u0016\u0010\u0005\u001a\n0\u0006R\u00060\u0000R\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u001f\u0010\r\u001a\u0010\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u001c\u0010\u001e\u001a\u0010\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/android/tools/idea/compose/preview/animation/AnimationInspectorPanel$AnimationTab;", "Ljavax/swing/JPanel;", "animation", "Landroidx/compose/animation/tooling/ComposeAnimation;", "(Lcom/android/tools/idea/compose/preview/animation/AnimationInspectorPanel;Landroidx/compose/animation/tooling/ComposeAnimation;)V", "animatedPropertiesPanel", "Lcom/android/tools/idea/compose/preview/animation/AnimationInspectorPanel$AnimationTab$AnimatedPropertiesPanel;", "Lcom/android/tools/idea/compose/preview/animation/AnimationInspectorPanel;", "getAnimation", "()Landroidx/compose/animation/tooling/ComposeAnimation;", "endStateChangeListener", "com/android/tools/idea/compose/preview/animation/AnimationInspectorPanel$AnimationTab$endStateChangeListener$1", "Lcom/android/tools/idea/compose/preview/animation/AnimationInspectorPanel$AnimationTab$endStateChangeListener$1;", "endStateComboBox", "Lcom/intellij/openapi/ui/ComboBox;", "", "kotlin.jvm.PlatformType", "getEndStateComboBox", "()Lcom/intellij/openapi/ui/ComboBox;", "isSwappingStates", "", "isUpdatingAnimationStates", "()Z", "setUpdatingAnimationStates", "(Z)V", "propertiesTimelineSplitter", "Lcom/intellij/ui/JBSplitter;", "startStateChangeListener", "com/android/tools/idea/compose/preview/animation/AnimationInspectorPanel$AnimationTab$startStateChangeListener$1", "Lcom/android/tools/idea/compose/preview/animation/AnimationInspectorPanel$AnimationTab$startStateChangeListener$1;", "startStateComboBox", "timelinePanel", "addTimeline", "", "createAnimatedPropertiesPanel", "createAnimationStateComboboxes", "Ljavax/swing/JComponent;", "createPlaybackControllers", "updateProperties", "updateSeekableAnimation", "updateStateComboboxes", "states", "", "([Ljava/lang/Object;)V", "updateTimelineWindowSize", "AnimatedPropertiesPanel", "GoToEndAction", "GoToStartAction", "SwapStartEndStatesAction", "intellij.android.compose-designer"})
    private final class AnimationTab
    extends JPanel {
        private final startStateChangeListener.1 startStateChangeListener;
        private final endStateChangeListener.1 endStateChangeListener;
        private final ComboBox<Object> startStateComboBox;
        @NotNull
        private final ComboBox<Object> endStateComboBox;
        private boolean isSwappingStates;
        private boolean isUpdatingAnimationStates;
        private final AnimatedPropertiesPanel animatedPropertiesPanel;
        private final JPanel timelinePanel;
        private final JBSplitter propertiesTimelineSplitter;
        @NotNull
        private final ComposeAnimation animation;

        @NotNull
        public final ComboBox<Object> getEndStateComboBox() {
            return this.endStateComboBox;
        }

        public final boolean isUpdatingAnimationStates() {
            return this.isUpdatingAnimationStates;
        }

        public final void setUpdatingAnimationStates(boolean bl) {
            this.isUpdatingAnimationStates = bl;
        }

        public final void updateSeekableAnimation() {
            AnimationClock animationClock = AnimationInspectorPanel.this.getAnimationClock$intellij_android_compose_designer();
            if (animationClock == null) {
                return;
            }
            AnimationClock clock = animationClock;
            Object startState = this.startStateComboBox.getSelectedItem();
            Object toState = this.endStateComboBox.getSelectedItem();
            clock.getUpdateSeekableAnimationFunction().invoke(clock.getClock(), this.animation, startState, toState);
            LayoutlibSceneManager layoutlibSceneManager = (LayoutlibSceneManager)SequencesKt.singleOrNull(RenderKt.getLayoutlibSceneManagers(AnimationInspectorPanel.this.getSurface$intellij_android_compose_designer()));
            if (layoutlibSceneManager != null) {
                layoutlibSceneManager.executeCallbacksAndRequestRender(new Runnable(clock){
                    final /* synthetic */ AnimationClock $clock;

                    public final void run() {
                        this.$clock.getUpdateAnimationStatesFunction().invoke(this.$clock.getClock(), new Object[0]);
                    }
                    {
                        this.$clock = animationClock;
                    }
                });
            }
            AnimationInspectorPanel.this.timeline.jumpToStart();
            AnimationInspectorPanel.this.timeline.setClockTime(0);
            this.updateTimelineWindowSize();
        }

        public final void updateTimelineWindowSize() {
            long l;
            AnimationClock animationClock = AnimationInspectorPanel.this.getAnimationClock$intellij_android_compose_designer();
            if (animationClock == null) {
                return;
            }
            AnimationClock clock = animationClock;
            Object object = clock.getGetMaxDurationPerIteration().invoke(clock.getClock(), new Object[0]);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Long");
            }
            long maxDurationPerIteration = (Long)object;
            AnimationInspectorPanel.this.timeline.updateMaxDuration(maxDurationPerIteration);
            Object object2 = clock.getGetMaxDurationFunction().invoke(clock.getClock(), new Object[0]);
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Long");
            }
            long maxDuration = (Long)object2;
            TransitionDurationTimeline transitionDurationTimeline = AnimationInspectorPanel.this.timeline;
            if (maxDuration > maxDurationPerIteration) {
                double d = (double)maxDuration / (double)maxDurationPerIteration;
                boolean bl = false;
                l = (long)Math.ceil(d);
            } else {
                l = 1L;
            }
            transitionDurationTimeline.setMaxLoopCount(l);
        }

        private final JComponent createPlaybackControllers() {
            return ActionManager.getInstance().createActionToolbar("Animation Preview", (ActionGroup)new DefaultActionGroup(CollectionsKt.listOf((Object[])new AnAction[]{(AnAction)AnimationInspectorPanel.this.timelineLoopAction, (AnAction)new GoToStartAction(), (AnAction)AnimationInspectorPanel.this.playPauseAction, (AnAction)new GoToEndAction(), (AnAction)AnimationInspectorPanel.this.timelineSpeedAction})), true).getComponent();
        }

        private final JComponent createAnimationStateComboboxes() {
            String[] states = new String[]{ComposePreviewBundle.message("animation.inspector.states.combobox.placeholder.message", new Object[0])};
            JPanel statesToolbar = new JPanel((LayoutManager)new TabularLayout("Fit,Fit,Fit,Fit"));
            this.startStateComboBox.setModel((ComboBoxModel)new DefaultComboBoxModel<String>(states));
            this.endStateComboBox.setModel((ComboBoxModel)new DefaultComboBoxModel<String>(states));
            ActionToolbarImpl swapStatesActionToolbar2 = new ActionToolbarImpl(this, "Swap States", (ActionGroup)new DefaultActionGroup(new AnAction[]{(AnAction)new SwapStartEndStatesAction()}), true){
                final /* synthetic */ AnimationTab this$0;

                @NotNull
                public JBDimension getPreferredSize() {
                    return JBUI.size((int)30, (int)30);
                }
                {
                    this.this$0 = this$0;
                    super($super_call_param$1, $super_call_param$2, $super_call_param$3);
                }
            };
            statesToolbar.add((Component)swapStatesActionToolbar2, new TabularLayout.Constraint(0, 0, 0, 4, null));
            statesToolbar.add((Component)this.startStateComboBox, new TabularLayout.Constraint(0, 1, 0, 4, null));
            statesToolbar.add((Component)new JBLabel(ComposePreviewBundle.message("animation.inspector.state.to.label", new Object[0])), new TabularLayout.Constraint(0, 2, 0, 4, null));
            statesToolbar.add((Component)this.endStateComboBox, new TabularLayout.Constraint(0, 3, 0, 4, null));
            return statesToolbar;
        }

        public final void updateStateComboboxes(@NotNull Object[] states) {
            this.startStateComboBox.setModel((ComboBoxModel)new DefaultComboBoxModel<Object>(states));
            this.endStateComboBox.setModel((ComboBoxModel)new DefaultComboBoxModel<Object>(states));
        }

        /*
         * WARNING - void declaration
         */
        private final JPanel createAnimatedPropertiesPanel() {
            void $this$apply;
            JPanel jPanel = new JPanel((LayoutManager)new TabularLayout("*", "25px,*"));
            boolean bl = false;
            boolean bl2 = false;
            JPanel $this$apply2 = jPanel;
            boolean bl3 = false;
            $this$apply2.setPreferredSize((Dimension)new JBDimension(200, 200));
            JPanel jPanel2 = new JPanel((LayoutManager)new TabularLayout("*", "*"));
            boolean bl4 = false;
            boolean bl5 = false;
            JPanel $this$apply3 = jPanel2;
            boolean bl6 = false;
            $this$apply3.setBorder(new MatteBorder(0, 0, 1, 0, JBColor.border()));
            $this$apply3.setBackground(UIUtil.getTextFieldBackground());
            JBLabel jBLabel = new JBLabel(ComposePreviewBundle.message("animation.inspector.prop.keys.title", new Object[0]));
            boolean bl7 = false;
            boolean bl8 = false;
            JBLabel jBLabel2 = jBLabel;
            JPanel jPanel3 = $this$apply3;
            boolean bl9 = false;
            $this$apply.setBorder((Border)JBUI.Borders.empty((int)0, (int)5));
            Unit unit = Unit.INSTANCE;
            jPanel3.add((Component)jBLabel, new TabularLayout.Constraint(0, 0, 0, 4, null));
            JPanel propKeysTitlePanel = jPanel2;
            $this$apply2.add((Component)propKeysTitlePanel, new TabularLayout.Constraint(0, 0, 0, 4, null));
            $this$apply2.add((Component)new JBScrollPane((Component)this.animatedPropertiesPanel), new TabularLayout.Constraint(1, 0, 0, 4, null));
            return jPanel;
        }

        public final void addTimeline() {
            this.timelinePanel.add((Component)AnimationInspectorPanel.this.timeline, "Center");
        }

        public final void updateProperties() {
            AnimationClock animationClock = AnimationInspectorPanel.this.getAnimationClock$intellij_android_compose_designer();
            if (animationClock == null) {
                return;
            }
            AnimationClock animClock = animationClock;
            try {
                Object object = animClock.getGetAnimatedPropertiesFunction().invoke(animClock.getClock(), this.animation);
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<androidx.compose.animation.tooling.ComposeAnimatedProperty>");
                }
                List animatedPropKeys = (List)object;
                this.animatedPropertiesPanel.updateProperties(animatedPropKeys);
            }
            catch (Exception e) {
                AnimationInspectorPanelKt.access$getLOG$p().warn("Failed to get the Compose Animation properties", (Throwable)e);
            }
        }

        @NotNull
        public final ComposeAnimation getAnimation() {
            return this.animation;
        }

        /*
         * WARNING - void declaration
         */
        public AnimationTab(ComposeAnimation animation) {
            void $this$apply;
            super((LayoutManager)new TabularLayout("Fit,*,Fit", "Fit,*"));
            this.animation = animation;
            this.startStateChangeListener = new ActionListener(this){
                final /* synthetic */ AnimationTab this$0;

                public void actionPerformed(@Nullable ActionEvent e) {
                    if (AnimationTab.access$isSwappingStates$p(this.this$0)) {
                        return;
                    }
                    if (!this.this$0.isUpdatingAnimationStates()) {
                        AnimationInspectorPanel.access$logAnimationInspectorEvent(this.this$0.AnimationInspectorPanel.this, ComposeAnimationToolingEvent.ComposeAnimationToolingEventType.CHANGE_START_STATE);
                    }
                    this.this$0.updateSeekableAnimation();
                }
                {
                    this.this$0 = this$0;
                }
            };
            this.endStateChangeListener = new ActionListener(this){
                final /* synthetic */ AnimationTab this$0;

                public void actionPerformed(@Nullable ActionEvent e) {
                    if (!this.this$0.isUpdatingAnimationStates() && !AnimationTab.access$isSwappingStates$p(this.this$0)) {
                        AnimationInspectorPanel.access$logAnimationInspectorEvent(this.this$0.AnimationInspectorPanel.this, ComposeAnimationToolingEvent.ComposeAnimationToolingEventType.CHANGE_END_STATE);
                    }
                    this.this$0.updateSeekableAnimation();
                }
                {
                    this.this$0 = this$0;
                }
            };
            this.startStateComboBox = new ComboBox((ComboBoxModel)new DefaultComboBoxModel<Object>(new Object[0]));
            this.endStateComboBox = new ComboBox((ComboBoxModel)new DefaultComboBoxModel<Object>(new Object[0]));
            this.animatedPropertiesPanel = new AnimatedPropertiesPanel();
            this.timelinePanel = new JPanel(new BorderLayout());
            JBSplitter jBSplitter = new JBSplitter(0.2f);
            boolean bl = false;
            boolean bl2 = false;
            JBSplitter jBSplitter2 = jBSplitter;
            AnimationTab animationTab = this;
            boolean bl3 = false;
            $this$apply.setFirstComponent((JComponent)this.createAnimatedPropertiesPanel());
            $this$apply.setSecondComponent((JComponent)this.timelinePanel);
            $this$apply.setDividerWidth(1);
            Unit unit = Unit.INSTANCE;
            animationTab.propertiesTimelineSplitter = jBSplitter;
            this.startStateComboBox.addActionListener((ActionListener)this.startStateChangeListener);
            this.endStateComboBox.addActionListener((ActionListener)this.endStateChangeListener);
            this.add((Component)this.createPlaybackControllers(), new TabularLayout.Constraint(0, 0, 0, 4, null));
            this.add((Component)this.createAnimationStateComboboxes(), new TabularLayout.Constraint(0, 2, 0, 4, null));
            JPanel jPanel = new JPanel(new BorderLayout());
            bl2 = false;
            boolean bl4 = false;
            JPanel $this$apply2 = jPanel;
            boolean bl5 = false;
            $this$apply2.setBorder(new MatteBorder(1, 0, 0, 0, JBColor.border()));
            JPanel splitterWrapper = jPanel;
            splitterWrapper.add((Component)this.propertiesTimelineSplitter, "Center");
            this.add((Component)splitterWrapper, new TabularLayout.Constraint(1, 0, 3));
        }

        public static final /* synthetic */ boolean access$isSwappingStates$p(AnimationTab $this) {
            return $this.isSwappingStates;
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004H\u0002J\u0014\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\f\u0010\u000b\u001a\u00020\u0004*\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/compose/preview/animation/AnimationInspectorPanel$AnimationTab$AnimatedPropertiesPanel;", "Ljavax/swing/JEditorPane;", "(Lcom/android/tools/idea/compose/preview/animation/AnimationInspectorPanel$AnimationTab;)V", "createNoPropertiesPanel", "", "kotlin.jvm.PlatformType", "updateProperties", "", "animatedPropKeys", "", "Landroidx/compose/animation/tooling/ComposeAnimatedProperty;", "toCss", "Ljava/awt/Color;", "intellij.android.compose-designer"})
        private final class AnimatedPropertiesPanel
        extends JEditorPane {
            private final String createNoPropertiesPanel() {
                return new HtmlBuilder().openHtmlBody().add(ComposePreviewBundle.message("animation.inspector.no.properties.message", new Object[0])).closeHtmlBody().getHtml();
            }

            /*
             * WARNING - void declaration
             */
            public final void updateProperties(@NotNull List<ComposeAnimatedProperty> animatedPropKeys) {
                String string;
                AnimatedPropertiesPanel animatedPropertiesPanel = this;
                if (animatedPropKeys.isEmpty()) {
                    string = this.createNoPropertiesPanel();
                } else {
                    void $this$forEachIndexed$iv;
                    HtmlBuilder htmlBuilder = new HtmlBuilder().openHtmlBody().beginDiv("white-space: nowrap");
                    Iterable iterable = animatedPropKeys;
                    AnimatedPropertiesPanel animatedPropertiesPanel2 = animatedPropertiesPanel;
                    boolean $i$f$forEachIndexed = false;
                    int index$iv = 0;
                    for (Object item$iv : $this$forEachIndexed$iv) {
                        void property2;
                        int n = index$iv++;
                        boolean bl = false;
                        if (n < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        ComposeAnimatedProperty composeAnimatedProperty = (ComposeAnimatedProperty)item$iv;
                        int index2 = n;
                        boolean bl2 = false;
                        if (index2 > 0) {
                            htmlBuilder.newline().newline();
                        }
                        htmlBuilder.beginSpan("color: " + this.toCss(UIUtil.getLabelForeground())).add(property2.getLabel()).endSpan().newline().beginSpan("color: " + this.toCss(UIUtil.getLabelDisabledForeground())).add(property2.getValue().toString()).endSpan();
                    }
                    animatedPropertiesPanel = animatedPropertiesPanel2;
                    string = htmlBuilder.endDiv().closeHtmlBody().getHtml();
                }
                animatedPropertiesPanel.setText(string);
            }

            private final String toCss(Color $this$toCss) {
                return "rgb(" + $this$toCss.getRed() + ", " + $this$toCss.getGreen() + ", " + $this$toCss.getBlue() + ')';
            }

            public AnimatedPropertiesPanel() {
                this.setMargin((Insets)JBUI.insets((int)5));
                this.setEditorKit(UIUtil.getHTMLEditorKit());
                this.setEditable(false);
                this.setText(this.createNoPropertiesPanel());
                Caret caret = this.getCaret();
                if (caret == null) {
                    throw new TypeCastException("null cannot be cast to non-null type javax.swing.text.DefaultCaret");
                }
                ((DefaultCaret)caret).setUpdatePolicy(1);
            }
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/compose/preview/animation/AnimationInspectorPanel$AnimationTab$SwapStartEndStatesAction;", "Lcom/intellij/ui/AnActionButton;", "(Lcom/android/tools/idea/compose/preview/animation/AnimationInspectorPanel$AnimationTab;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "updateButton", "intellij.android.compose-designer"})
        private final class SwapStartEndStatesAction
        extends AnActionButton {
            public void actionPerformed(@NotNull AnActionEvent e) {
                AnimationTab.this.isSwappingStates = true;
                Object startState = AnimationTab.this.startStateComboBox.getSelectedItem();
                AnimationTab.this.startStateComboBox.setSelectedItem(AnimationTab.this.getEndStateComboBox().getSelectedItem());
                AnimationTab.this.getEndStateComboBox().setSelectedItem(startState);
                AnimationTab.this.isSwappingStates = false;
                AnimationInspectorPanel.this.logAnimationInspectorEvent(ComposeAnimationToolingEvent.ComposeAnimationToolingEventType.TRIGGER_SWAP_STATES_ACTION);
            }

            public void updateButton(@NotNull AnActionEvent e) {
                super.updateButton(e);
                e.getPresentation().setEnabled(true);
            }

            public SwapStartEndStatesAction() {
                super(ComposePreviewBundle.message("animation.inspector.action.swap.states", new Object[0]), StudioIcons.LayoutEditor.Motion.PLAY_YOYO);
            }
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/compose/preview/animation/AnimationInspectorPanel$AnimationTab$GoToStartAction;", "Lcom/intellij/ui/AnActionButton;", "(Lcom/android/tools/idea/compose/preview/animation/AnimationInspectorPanel$AnimationTab;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "updateButton", "intellij.android.compose-designer"})
        private final class GoToStartAction
        extends AnActionButton {
            public void actionPerformed(@NotNull AnActionEvent e) {
                AnimationInspectorPanel.this.timeline.jumpToStart();
                AnimationInspectorPanel.this.logAnimationInspectorEvent(ComposeAnimationToolingEvent.ComposeAnimationToolingEventType.TRIGGER_JUMP_TO_START_ACTION);
            }

            public void updateButton(@NotNull AnActionEvent e) {
                super.updateButton(e);
                e.getPresentation().setEnabled(!AnimationInspectorPanel.this.timeline.isAtStart());
            }

            public GoToStartAction() {
                super(ComposePreviewBundle.message("animation.inspector.action.go.to.start", new Object[0]), StudioIcons.LayoutEditor.Motion.GO_TO_START);
            }
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/compose/preview/animation/AnimationInspectorPanel$AnimationTab$GoToEndAction;", "Lcom/intellij/ui/AnActionButton;", "(Lcom/android/tools/idea/compose/preview/animation/AnimationInspectorPanel$AnimationTab;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "updateButton", "intellij.android.compose-designer"})
        private final class GoToEndAction
        extends AnActionButton {
            public void actionPerformed(@NotNull AnActionEvent e) {
                AnimationInspectorPanel.this.timeline.jumpToEnd();
                AnimationInspectorPanel.this.logAnimationInspectorEvent(ComposeAnimationToolingEvent.ComposeAnimationToolingEventType.TRIGGER_JUMP_TO_END_ACTION);
            }

            public void updateButton(@NotNull AnActionEvent e) {
                super.updateButton(e);
                e.getPresentation().setEnabled(!AnimationInspectorPanel.this.timeline.isAtEnd());
            }

            public GoToEndAction() {
                super(ComposePreviewBundle.message("animation.inspector.action.go.to.end", new Object[0]), StudioIcons.LayoutEditor.Motion.GO_TO_END);
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0006\u0010\u000e\u001a\u00020\u000bJ\b\u0010\u000f\u001a\u00020\u000bH\u0002J\b\u0010\u0010\u001a\u00020\u000bH\u0002J\b\u0010\u0011\u001a\u00020\u000bH\u0002J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/compose/preview/animation/AnimationInspectorPanel$PlayPauseAction;", "Lcom/intellij/ui/AnActionButton;", "(Lcom/android/tools/idea/compose/preview/animation/AnimationInspectorPanel;)V", "isPlaying", "", "tickPeriod", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "ticker", "Lcom/android/tools/idea/common/util/ControllableTicker;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "dispose", "handleLoopEnd", "pause", "play", "updateButton", "intellij.android.compose-designer"})
    private final class PlayPauseAction
    extends AnActionButton {
        private final Duration tickPeriod;
        private final ControllableTicker ticker;
        private boolean isPlaying;

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (this.isPlaying) {
                this.pause();
                AnimationInspectorPanel.this.logAnimationInspectorEvent(ComposeAnimationToolingEvent.ComposeAnimationToolingEventType.TRIGGER_PAUSE_ACTION);
            } else {
                this.play();
                AnimationInspectorPanel.this.logAnimationInspectorEvent(ComposeAnimationToolingEvent.ComposeAnimationToolingEventType.TRIGGER_PLAY_ACTION);
            }
        }

        public void updateButton(@NotNull AnActionEvent e) {
            super.updateButton(e);
            e.getPresentation().setEnabled(true);
            Presentation presentation = e.getPresentation();
            boolean bl = false;
            boolean bl2 = false;
            Presentation $this$apply = presentation;
            boolean bl3 = false;
            if (this.isPlaying) {
                $this$apply.setIcon(StudioIcons.LayoutEditor.Motion.PAUSE);
                $this$apply.setText(ComposePreviewBundle.message("animation.inspector.action.pause", new Object[0]));
            } else {
                $this$apply.setIcon(StudioIcons.LayoutEditor.Motion.PLAY);
                $this$apply.setText(ComposePreviewBundle.message("animation.inspector.action.play", new Object[0]));
            }
        }

        private final void play() {
            if (AnimationInspectorPanel.this.timeline.isAtEnd()) {
                AnimationInspectorPanel.this.timeline.jumpToStart();
            }
            this.isPlaying = true;
            this.ticker.start();
        }

        private final void pause() {
            this.isPlaying = false;
            this.ticker.stop();
        }

        private final void handleLoopEnd() {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(this){
                final /* synthetic */ PlayPauseAction this$0;

                public final void run() {
                    AnimationInspectorPanel.access$getTimeline$p(this.this$0.AnimationInspectorPanel.this).jumpToStart();
                }
                {
                    this.this$0 = playPauseAction;
                }
            });
            TransitionDurationTimeline transitionDurationTimeline = AnimationInspectorPanel.this.timeline;
            long l = transitionDurationTimeline.getLoopCount();
            transitionDurationTimeline.setLoopCount(l + 1L);
            if (AnimationInspectorPanel.this.timeline.getLoopCount() == AnimationInspectorPanel.this.timeline.getMaxLoopCount()) {
                AnimationInspectorPanel.this.timeline.setLoopCount(0L);
            }
        }

        public final void dispose() {
            this.ticker.dispose();
        }

        public PlayPauseAction() {
            super(ComposePreviewBundle.message("animation.inspector.action.play", new Object[0]), StudioIcons.LayoutEditor.Motion.PLAY);
            this.tickPeriod = Duration.ofMillis(30L);
            this.ticker = new ControllableTicker((Function0)new Function0<Unit>(this){
                final /* synthetic */ PlayPauseAction this$0;

                public final void invoke() {
                    if (PlayPauseAction.access$isPlaying$p(this.this$0)) {
                        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(this){
                            final /* synthetic */ ticker.1 this$0;

                            public final void run() {
                                AnimationInspectorPanel.access$getTimeline$p(this.this$0.this$0.AnimationInspectorPanel.this).incrementClockBy((int)PlayPauseAction.access$getTickPeriod$p(this.this$0.this$0).toMillis());
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                        if (AnimationInspectorPanel.access$getTimeline$p(this.this$0.AnimationInspectorPanel.this).isAtEnd()) {
                            if (AnimationInspectorPanel.access$getTimeline$p(this.this$0.AnimationInspectorPanel.this).getPlayInLoop()) {
                                PlayPauseAction.access$handleLoopEnd(this.this$0);
                            } else {
                                PlayPauseAction.access$pause(this.this$0);
                            }
                        }
                    }
                }
                {
                    this.this$0 = playPauseAction;
                    super(0);
                }
            }, this.tickPeriod, null, 4, null);
        }

        public static final /* synthetic */ boolean access$isPlaying$p(PlayPauseAction $this) {
            return $this.isPlaying;
        }

        public static final /* synthetic */ void access$setPlaying$p(PlayPauseAction $this, boolean bl) {
            $this.isPlaying = bl;
        }

        public static final /* synthetic */ Duration access$getTickPeriod$p(PlayPauseAction $this) {
            return $this.tickPeriod;
        }

        public static final /* synthetic */ void access$handleLoopEnd(PlayPauseAction $this) {
            $this.handleLoopEnd();
        }

        public static final /* synthetic */ void access$pause(PlayPauseAction $this) {
            $this.pause();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000f\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/compose/preview/animation/AnimationInspectorPanel$TimelineSpeed;", "", "speedMultiplier", "", "displayText", "", "(Ljava/lang/String;IFLjava/lang/String;)V", "getDisplayText", "()Ljava/lang/String;", "getSpeedMultiplier", "()F", "X_0_25", "X_0_5", "X_1", "X_1_5", "X_2", "intellij.android.compose-designer"})
    private static final class TimelineSpeed
    extends Enum<TimelineSpeed> {
        public static final /* enum */ TimelineSpeed X_0_25;
        public static final /* enum */ TimelineSpeed X_0_5;
        public static final /* enum */ TimelineSpeed X_1;
        public static final /* enum */ TimelineSpeed X_1_5;
        public static final /* enum */ TimelineSpeed X_2;
        private static final /* synthetic */ TimelineSpeed[] $VALUES;
        private final float speedMultiplier;
        @NotNull
        private final String displayText;

        static {
            TimelineSpeed[] timelineSpeedArray = new TimelineSpeed[5];
            TimelineSpeed[] timelineSpeedArray2 = timelineSpeedArray;
            timelineSpeedArray[0] = X_0_25 = new TimelineSpeed(0.25f, "0.25x");
            timelineSpeedArray[1] = X_0_5 = new TimelineSpeed(0.5f, "0.5x");
            timelineSpeedArray[2] = X_1 = new TimelineSpeed(1.0f, "1x");
            timelineSpeedArray[3] = X_1_5 = new TimelineSpeed(1.5f, "1.5x");
            timelineSpeedArray[4] = X_2 = new TimelineSpeed(2.0f, "2x");
            $VALUES = timelineSpeedArray;
        }

        public final float getSpeedMultiplier() {
            return this.speedMultiplier;
        }

        @NotNull
        public final String getDisplayText() {
            return this.displayText;
        }

        private TimelineSpeed(float speedMultiplier, String displayText) {
            this.speedMultiplier = speedMultiplier;
            this.displayText = displayText;
        }

        public static TimelineSpeed[] values() {
            return (TimelineSpeed[])$VALUES.clone();
        }

        public static TimelineSpeed valueOf(String string) {
            return Enum.valueOf(TimelineSpeed.class, string);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/compose/preview/animation/AnimationInspectorPanel$TimelineSpeedAction;", "Lcom/android/tools/adtui/actions/DropDownAction;", "(Lcom/android/tools/idea/compose/preview/animation/AnimationInspectorPanel;)V", "displayTextInToolbar", "", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "SpeedAction", "intellij.android.compose-designer"})
    private final class TimelineSpeedAction
    extends DropDownAction {
        public void update(@NotNull AnActionEvent e) {
            e.getPresentation().setText(AnimationInspectorPanel.this.timeline.getSpeed().getDisplayText());
        }

        public boolean displayTextInToolbar() {
            return true;
        }

        public TimelineSpeedAction() {
            super(ComposePreviewBundle.message("animation.inspector.action.speed", new Object[0]), ComposePreviewBundle.message("animation.inspector.action.speed", new Object[0]), null);
            TimelineSpeed[] $this$forEach$iv = TimelineSpeed.values();
            boolean $i$f$forEach = false;
            TimelineSpeed[] timelineSpeedArray = $this$forEach$iv;
            int n = timelineSpeedArray.length;
            for (int j = 0; j < n; ++j) {
                TimelineSpeed element$iv;
                TimelineSpeed it = element$iv = timelineSpeedArray[j];
                boolean bl = false;
                this.addAction((AnAction)new SpeedAction(it));
            }
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/compose/preview/animation/AnimationInspectorPanel$TimelineSpeedAction$SpeedAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "speed", "Lcom/android/tools/idea/compose/preview/animation/AnimationInspectorPanel$TimelineSpeed;", "(Lcom/android/tools/idea/compose/preview/animation/AnimationInspectorPanel$TimelineSpeedAction;Lcom/android/tools/idea/compose/preview/animation/AnimationInspectorPanel$TimelineSpeed;)V", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "intellij.android.compose-designer"})
        private final class SpeedAction
        extends ToggleAction {
            private final TimelineSpeed speed;

            public boolean isSelected(@NotNull AnActionEvent e) {
                return AnimationInspectorPanel.this.timeline.getSpeed() == this.speed;
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                AnimationInspectorPanel.this.timeline.setSpeed(this.speed);
                AnimationToolingEvent changeSpeedEvent = new AnimationToolingEvent(ComposeAnimationToolingEvent.ComposeAnimationToolingEventType.CHANGE_ANIMATION_SPEED).withAnimationMultiplier(this.speed.getSpeedMultiplier());
                AnimationToolingUsageTracker.Companion.getInstance(AnimationInspectorPanel.this.getSurface$intellij_android_compose_designer()).logEvent(changeSpeedEvent);
            }

            public SpeedAction(TimelineSpeed speed) {
                super(String.valueOf(speed.getDisplayText()), String.valueOf(speed.getDisplayText()), null);
                this.speed = speed;
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0004H\u0016\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/compose/preview/animation/AnimationInspectorPanel$TimelineLoopAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "(Lcom/android/tools/idea/compose/preview/animation/AnimationInspectorPanel;)V", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "intellij.android.compose-designer"})
    private final class TimelineLoopAction
    extends ToggleAction {
        public boolean isSelected(@NotNull AnActionEvent e) {
            return AnimationInspectorPanel.this.timeline.getPlayInLoop();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            AnimationInspectorPanel.this.timeline.setPlayInLoop(state);
            if (!state) {
                AnimationInspectorPanel.this.timeline.setLoopCount(0L);
            }
            AnimationInspectorPanel.this.logAnimationInspectorEvent(state ? ComposeAnimationToolingEvent.ComposeAnimationToolingEventType.ENABLE_LOOP_ACTION : ComposeAnimationToolingEvent.ComposeAnimationToolingEventType.DISABLE_LOOP_ACTION);
        }

        public TimelineLoopAction() {
            super(ComposePreviewBundle.message("animation.inspector.action.loop", new Object[0]), ComposePreviewBundle.message("animation.inspector.action.loop", new Object[0]), StudioIcons.LayoutEditor.Motion.LOOP);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000[\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b*\u0001!\b\u0082\u0004\u0018\u00002\u00020\u0001:\u0001:B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010)\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020,0*2\u000e\u0010-\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030.H\u0002J\u000e\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u0004J\u0006\u00102\u001a\u00020\u0013J\u0006\u00103\u001a\u00020\u0013J\u0006\u00104\u001a\u000200J\u0006\u00105\u001a\u000200J\u000e\u00106\u001a\u0002002\u0006\u00107\u001a\u00020\u0004J\u000e\u00108\u001a\u0002002\u0006\u00109\u001a\u00020\nR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R0\u0010\u001b\u001a\b\u0018\u00010\u0019R\u00020\u001a2\f\u0010\u0018\u001a\b\u0018\u00010\u0019R\u00020\u001a@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0010\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\"R\u001a\u0010#\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(\u00a8\u0006;"}, d2={"Lcom/android/tools/idea/compose/preview/animation/AnimationInspectorPanel$TransitionDurationTimeline;", "Ljavax/swing/JPanel;", "(Lcom/android/tools/idea/compose/preview/animation/AnimationInspectorPanel;)V", "cachedVal", "", "getCachedVal", "()I", "setCachedVal", "(I)V", "loopCount", "", "getLoopCount", "()J", "setLoopCount", "(J)V", "maxLoopCount", "getMaxLoopCount", "setMaxLoopCount", "playInLoop", "", "getPlayInLoop", "()Z", "setPlayInLoop", "(Z)V", "value", "Lcom/android/tools/idea/compose/preview/animation/AnimationInspectorPanel$AnimationTab;", "Lcom/android/tools/idea/compose/preview/animation/AnimationInspectorPanel;", "selectedTab", "getSelectedTab", "()Lcom/android/tools/idea/compose/preview/animation/AnimationInspectorPanel$AnimationTab;", "setSelectedTab", "(Lcom/android/tools/idea/compose/preview/animation/AnimationInspectorPanel$AnimationTab;)V", "slider", "com/android/tools/idea/compose/preview/animation/AnimationInspectorPanel$TransitionDurationTimeline$slider$1", "Lcom/android/tools/idea/compose/preview/animation/AnimationInspectorPanel$TransitionDurationTimeline$slider$1;", "speed", "Lcom/android/tools/idea/compose/preview/animation/AnimationInspectorPanel$TimelineSpeed;", "getSpeed", "()Lcom/android/tools/idea/compose/preview/animation/AnimationInspectorPanel$TimelineSpeed;", "setSpeed", "(Lcom/android/tools/idea/compose/preview/animation/AnimationInspectorPanel$TimelineSpeed;)V", "createMsLabelTable", "Ljava/util/Hashtable;", "", "Lcom/intellij/ui/components/JBLabel;", "table", "Ljava/util/Dictionary;", "incrementClockBy", "", "increment", "isAtEnd", "isAtStart", "jumpToEnd", "jumpToStart", "setClockTime", "newValue", "updateMaxDuration", "durationMs", "TimelineSliderUI", "intellij.android.compose-designer"})
    private final class TransitionDurationTimeline
    extends JPanel {
        @Nullable
        private AnimationTab selectedTab;
        private int cachedVal;
        @NotNull
        private TimelineSpeed speed;
        private boolean playInLoop;
        private long loopCount;
        private long maxLoopCount;
        private final slider.1 slider;

        @Nullable
        public final AnimationTab getSelectedTab() {
            return this.selectedTab;
        }

        public final void setSelectedTab(@Nullable AnimationTab value2) {
            this.selectedTab = value2;
            this.setClockTime(this.slider.getValue());
        }

        public final int getCachedVal() {
            return this.cachedVal;
        }

        public final void setCachedVal(int n) {
            this.cachedVal = n;
        }

        @NotNull
        public final TimelineSpeed getSpeed() {
            return this.speed;
        }

        public final void setSpeed(@NotNull TimelineSpeed timelineSpeed) {
            this.speed = timelineSpeed;
        }

        public final boolean getPlayInLoop() {
            return this.playInLoop;
        }

        public final void setPlayInLoop(boolean bl) {
            this.playInLoop = bl;
        }

        public final long getLoopCount() {
            return this.loopCount;
        }

        public final void setLoopCount(long l) {
            this.loopCount = l;
        }

        public final long getMaxLoopCount() {
            return this.maxLoopCount;
        }

        public final void setMaxLoopCount(long l) {
            this.maxLoopCount = l;
        }

        public final void updateMaxDuration(long durationMs) {
            this.slider.setMaximum((int)durationMs);
        }

        /*
         * WARNING - void declaration
         */
        public final void setClockTime(int newValue) {
            AnimationClock animationClock = AnimationInspectorPanel.this.getAnimationClock$intellij_android_compose_designer();
            if (animationClock == null) {
                return;
            }
            AnimationClock clock = animationClock;
            AnimationTab animationTab = this.selectedTab;
            if (animationTab == null) {
                return;
            }
            AnimationTab tab = animationTab;
            Ref.LongRef longRef = new Ref.LongRef();
            longRef.element = newValue;
            if (this.playInLoop) {
                clockTimeMs.element += (long)this.slider.getMaximum() * this.loopCount;
            }
            LayoutlibSceneManager layoutlibSceneManager = (LayoutlibSceneManager)SequencesKt.singleOrNull(RenderKt.getLayoutlibSceneManagers(AnimationInspectorPanel.this.getSurface$intellij_android_compose_designer()));
            if (layoutlibSceneManager != null) {
                void clockTimeMs;
                layoutlibSceneManager.executeCallbacksAndRequestRender(new Runnable(clock, (Ref.LongRef)clockTimeMs){
                    final /* synthetic */ AnimationClock $clock;
                    final /* synthetic */ Ref.LongRef $clockTimeMs;

                    public final void run() {
                        this.$clock.getSetClockTimeFunction().invoke(this.$clock.getClock(), this.$clockTimeMs.element);
                    }
                    {
                        this.$clock = animationClock;
                        this.$clockTimeMs = longRef;
                    }
                });
            }
            tab.updateProperties();
        }

        public final void incrementClockBy(int increment) {
            slider.1 v0 = this.slider;
            v0.setValue(v0.getValue() + (int)((float)increment * this.speed.getSpeedMultiplier()));
        }

        public final void jumpToStart() {
            this.slider.setValue(0);
        }

        public final void jumpToEnd() {
            this.slider.setValue(this.slider.getMaximum());
        }

        public final boolean isAtStart() {
            return this.slider.getValue() == 0;
        }

        public final boolean isAtEnd() {
            return this.slider.getValue() == this.slider.getMaximum();
        }

        private final Hashtable<Object, JBLabel> createMsLabelTable(Dictionary<?, ?> table2) {
            Enumeration<?> keys = table2.keys();
            Hashtable<Object, JBLabel> labelTable = new Hashtable<Object, JBLabel>();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                ((Map)labelTable).put(key, new JBLabel(key, key + " ms"){
                    final /* synthetic */ Object $key;

                    @NotNull
                    public Color getForeground() {
                        return UIUtil.getLabelDisabledForeground();
                    }
                    {
                        this.$key = $captured_local_variable$0;
                        super($super_call_param$1);
                    }
                });
            }
            return labelTable;
        }

        /*
         * WARNING - void declaration
         */
        public TransitionDurationTimeline() {
            void $this$apply;
            super(new BorderLayout());
            this.cachedVal = -1;
            this.speed = TimelineSpeed.X_1;
            this.maxLoopCount = 1L;
            JSlider jSlider = new JSlider(this, 0, 10000, 0){
                final /* synthetic */ TransitionDurationTimeline this$0;

                public void updateUI() {
                    this.setUI(this.this$0.new TimelineSliderUI());
                    this.updateLabelUIs();
                }

                public void setMaximum(int maximum) {
                    super.setMaximum(maximum);
                    this.updateMajorTicks();
                }

                public final void updateMajorTicks() {
                    int tickIncrement = this.getMaximum() / 5;
                    this.setMajorTickSpacing(tickIncrement);
                    if (tickIncrement == 0) {
                        this.setLabelTable(TransitionDurationTimeline.access$createMsLabelTable(this.this$0, this.getLabelTable()));
                    } else {
                        this.setLabelTable(TransitionDurationTimeline.access$createMsLabelTable(this.this$0, this.createStandardLabels(tickIncrement)));
                    }
                }
                {
                    this.this$0 = this$0;
                    super($super_call_param$1, $super_call_param$2, $super_call_param$3);
                }
            };
            boolean bl = false;
            boolean bl2 = false;
            JSlider jSlider2 = jSlider;
            TransitionDurationTimeline transitionDurationTimeline = this;
            boolean bl3 = false;
            $this$apply.setPaintTicks(true);
            $this$apply.setPaintLabels(true);
            $this$apply.updateMajorTicks();
            $this$apply.setUI(new TimelineSliderUI());
            Unit unit = Unit.INSTANCE;
            transitionDurationTimeline.slider = jSlider;
            this.setBorder(new MatteBorder(0, 1, 0, 0, JBColor.border()));
            this.add((Component)this.slider, "Center");
            this.slider.addChangeListener(new ChangeListener(){

                @Override
                public final void stateChanged(ChangeEvent it) {
                    if (slider.getValue() == this.getCachedVal()) {
                        return;
                    }
                    int newValue = slider.getValue();
                    this.setCachedVal(newValue);
                    this.setClockTime(newValue);
                }
            });
        }

        public static final /* synthetic */ Hashtable access$createMsLabelTable(TransitionDurationTimeline $this, Dictionary table2) {
            return $this.createMsLabelTable(table2);
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0014J\b\u0010\u0007\u001a\u00020\u0006H\u0014J\u001c\u0010\b\u001a\u000e0\tR\n0\u0000R\u00060\nR\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u0004H\u0002J\u0012\u0010\u0011\u001a\u00020\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0012\u0010\u0014\u001a\u00020\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J \u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0004H\u0014J\u0010\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/idea/compose/preview/animation/AnimationInspectorPanel$TransitionDurationTimeline$TimelineSliderUI;", "Ljavax/swing/plaf/basic/BasicSliderUI;", "(Lcom/android/tools/idea/compose/preview/animation/AnimationInspectorPanel$TransitionDurationTimeline;)V", "labelVerticalMargin", "", "calculateLabelRect", "", "calculateTickRect", "createTrackListener", "Lcom/android/tools/idea/compose/preview/animation/AnimationInspectorPanel$TransitionDurationTimeline$TimelineSliderUI$TimelineTrackListener;", "Lcom/android/tools/idea/compose/preview/animation/AnimationInspectorPanel$TransitionDurationTimeline;", "Lcom/android/tools/idea/compose/preview/animation/AnimationInspectorPanel;", "slider", "Ljavax/swing/JSlider;", "getThumbSize", "Ljava/awt/Dimension;", "labelsAndTicksHeight", "paintFocus", "g", "Ljava/awt/Graphics;", "paintLabels", "paintMajorTickForHorizSlider", "tickBounds", "Ljava/awt/Rectangle;", "x", "paintThumb", "paintTrack", "TimelineTrackListener", "intellij.android.compose-designer"})
        private final class TimelineSliderUI
        extends BasicSliderUI {
            private final int labelVerticalMargin;

            @Override
            @NotNull
            protected Dimension getThumbSize() {
                Dimension originalSize = super.getThumbSize();
                return this.slider.getParent() == null ? originalSize : new Dimension(originalSize.width, this.slider.getParent().getHeight() - this.labelsAndTicksHeight());
            }

            @Override
            protected void calculateTickRect() {
                this.tickRect.x = this.thumbRect.x;
                this.tickRect.y = this.thumbRect.y;
                this.tickRect.width = this.thumbRect.width;
                this.tickRect.height = this.thumbRect.height + this.labelsAndTicksHeight();
            }

            @Override
            protected void calculateLabelRect() {
                super.calculateLabelRect();
                this.labelRect.y = this.labelVerticalMargin;
            }

            @Override
            public void paintTrack(@NotNull Graphics g) {
            }

            @Override
            public void paintFocus(@Nullable Graphics g) {
            }

            @Override
            public void paintLabels(@Nullable Graphics g) {
                super.paintLabels(g);
                Graphics graphics = g;
                if (graphics == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.awt.Graphics2D");
                }
                Graphics2D cfr_ignored_0 = (Graphics2D)graphics;
                ((Graphics2D)g).setColor(JBColor.border());
                ((Graphics2D)g).setStroke(new BasicStroke(1.0f));
                int borderHeight = 24;
                g.drawLine(0, borderHeight, this.slider.getWidth(), borderHeight);
            }

            @Override
            public void paintThumb(@NotNull Graphics g) {
                Graphics graphics = g;
                if (graphics == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.awt.Graphics2D");
                }
                Graphics2D cfr_ignored_0 = (Graphics2D)graphics;
                ((Graphics2D)g).setColor((Color)new JBColor(4882943, 11851775));
                ((Graphics2D)g).setStroke(new BasicStroke(1.0f));
                int halfWidth = this.thumbRect.width / 2;
                int x = this.thumbRect.x + halfWidth;
                int y = this.thumbRect.y + 25;
                g.drawLine(x, y, this.thumbRect.x + halfWidth, this.thumbRect.height + this.labelsAndTicksHeight());
                int handleHeight = 10;
                int[] xPoints = new int[]{x, x - 5, x - 5, x + 5, x + 5};
                int[] yPoints = new int[]{y, y - 5, y - handleHeight, y - handleHeight, y - 5};
                g.fillPolygon(xPoints, yPoints, xPoints.length);
            }

            @Override
            protected void paintMajorTickForHorizSlider(@NotNull Graphics g, @NotNull Rectangle tickBounds, int x) {
                Graphics graphics = g;
                if (graphics == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.awt.Graphics2D");
                }
                Graphics2D cfr_ignored_0 = (Graphics2D)graphics;
                ((Graphics2D)g).setColor(JBColor.border());
                g.drawLine(x, this.tickRect.y + 25, x, this.tickRect.height);
            }

            @Override
            @NotNull
            protected TimelineTrackListener createTrackListener(@NotNull JSlider slider2) {
                return new TimelineTrackListener();
            }

            private final int labelsAndTicksHeight() {
                return this.getTickLength() + this.getHeightOfTallestLabel();
            }

            public TimelineSliderUI() {
                super(TransitionDurationTimeline.this.slider);
                this.labelVerticalMargin = 5;
            }

            public static final /* synthetic */ void access$setThumbRect$p(TimelineSliderUI $this, Rectangle rectangle) {
                $this.thumbRect = rectangle;
            }

            public static final /* synthetic */ void access$setSlider$p(TimelineSliderUI $this, JSlider jSlider) {
                $this.slider = jSlider;
            }

            @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\u000b\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0006\u0010\f\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/compose/preview/animation/AnimationInspectorPanel$TransitionDurationTimeline$TimelineSliderUI$TimelineTrackListener;", "Ljavax/swing/plaf/basic/BasicSliderUI$TrackListener;", "Ljavax/swing/plaf/basic/BasicSliderUI;", "(Lcom/android/tools/idea/compose/preview/animation/AnimationInspectorPanel$TransitionDurationTimeline$TimelineSliderUI;)V", "isDragging", "", "mouseDragged", "", "e", "Ljava/awt/event/MouseEvent;", "mousePressed", "mouseReleased", "updateThumbLocationAndSliderValue", "intellij.android.compose-designer"})
            private final class TimelineTrackListener
            extends BasicSliderUI.TrackListener {
                private boolean isDragging;

                @Override
                public void mousePressed(@NotNull MouseEvent e) {
                    this.currentMouseX = e.getX();
                    this.updateThumbLocationAndSliderValue();
                }

                @Override
                public void mouseDragged(@NotNull MouseEvent e) {
                    super.mouseDragged(e);
                    this.updateThumbLocationAndSliderValue();
                    this.isDragging = true;
                }

                @Override
                public void mouseReleased(@Nullable MouseEvent e) {
                    super.mouseReleased(e);
                    AnimationInspectorPanel.this.logAnimationInspectorEvent(this.isDragging ? ComposeAnimationToolingEvent.ComposeAnimationToolingEventType.DRAG_ANIMATION_INSPECTOR_TIMELINE : ComposeAnimationToolingEvent.ComposeAnimationToolingEventType.CLICK_ANIMATION_INSPECTOR_TIMELINE);
                    this.isDragging = false;
                }

                public final void updateThumbLocationAndSliderValue() {
                    int halfWidth = ((TimelineSliderUI)TimelineSliderUI.this).thumbRect.width / 2;
                    int thumbX = Math.min(Math.max(this.currentMouseX, TimelineSliderUI.this.xPositionForValue(TimelineSliderUI.this.slider.getMinimum())), TimelineSliderUI.this.xPositionForValue(TimelineSliderUI.this.slider.getMaximum())) - halfWidth;
                    TimelineSliderUI.this.setThumbLocation(thumbX, ((TimelineSliderUI)TimelineSliderUI.this).thumbRect.y);
                    TimelineSliderUI.this.slider.setValue(TimelineSliderUI.this.valueForXPosition(this.currentMouseX));
                }

                public TimelineTrackListener() {
                    super(TimelineSliderUI.this);
                }
            }
        }
    }
}

