/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.surface;

import com.android.tools.adtui.actions.ZoomType;
import com.android.tools.adtui.common.AdtUiCursorType;
import com.android.tools.adtui.common.AdtUiCursorsProvider;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.DesignSurfaceShortcut;
import com.android.tools.idea.common.surface.DragEnterEvent;
import com.android.tools.idea.common.surface.DragExistEvent;
import com.android.tools.idea.common.surface.DragOverEvent;
import com.android.tools.idea.common.surface.DropActionChangedEvent;
import com.android.tools.idea.common.surface.DropEvent;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.common.surface.InteractionEvent;
import com.android.tools.idea.common.surface.InteractionHandler;
import com.android.tools.idea.common.surface.InteractionInformation;
import com.android.tools.idea.common.surface.InteractionNonInputEvent;
import com.android.tools.idea.common.surface.KeyPressedEvent;
import com.android.tools.idea.common.surface.KeyReleasedEvent;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.common.surface.MouseDraggedEvent;
import com.android.tools.idea.common.surface.MouseMovedEvent;
import com.android.tools.idea.common.surface.MousePressedEvent;
import com.android.tools.idea.common.surface.MouseReleasedEvent;
import com.android.tools.idea.common.surface.MouseWheelMovedEvent;
import com.android.tools.idea.common.surface.MouseWheelStopEvent;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.common.surface.ScrollInteraction;
import com.android.tools.idea.uibuilder.model.NlDropEvent;
import com.android.tools.idea.uibuilder.surface.DragDropInteraction;
import com.android.tools.idea.uibuilder.surface.PanInteraction;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InteractionManager
implements Disposable {
    private static final int HOVER_DELAY_MS = Registry.intValue((String)"ide.tooltip.initialDelay");
    private static final int SCROLL_END_TIME_MS = 500;
    @NotNull
    private final DesignSurface mySurface;
    @NotNull
    private final InteractionHandler myInteractionHandler;
    @Nullable
    private Interaction myCurrentInteraction;
    @Nullable
    private List<Layer> myLayers;
    protected int myLastMouseX;
    protected int myLastMouseY;
    @JdkConstants.InputEventMask
    protected int myLastModifiersEx;
    private final Timer myHoverTimer;
    private final Timer myScrollEndTimer;
    private final ActionListener myScrollEndListener;
    private final Listener myListener;
    private DropTarget myDropTarget;
    private boolean myIsListening;
    private boolean myIsInteractionCanceled;

    public InteractionManager(@NotNull DesignSurface surface2, @NotNull InteractionHandler provider2) {
        this.mySurface = surface2;
        this.myInteractionHandler = provider2;
        Disposer.register((Disposable)surface2, (Disposable)this);
        this.myListener = new Listener();
        this.myHoverTimer = new Timer(HOVER_DELAY_MS, null);
        this.myHoverTimer.setRepeats(false);
        this.myScrollEndTimer = new Timer(500, null);
        this.myScrollEndTimer.setRepeats(false);
        this.myScrollEndListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InteractionManager.this.myScrollEndTimer.removeActionListener(this);
                if (InteractionManager.this.myCurrentInteraction instanceof ScrollInteraction) {
                    InteractionManager.this.finishInteraction(new MouseWheelStopEvent(e, InteractionManager.this.getInteractionInformation()), false);
                }
            }
        };
    }

    public void dispose() {
        this.myHoverTimer.stop();
        this.myScrollEndTimer.stop();
    }

    @NotNull
    public DesignSurface getSurface() {
        return this.mySurface;
    }

    public boolean isPanning() {
        return this.myCurrentInteraction instanceof PanInteraction;
    }

    public void startListening() {
        if (this.myIsListening) {
            return;
        }
        JComponent layeredPane = this.mySurface.getInteractionPane();
        layeredPane.addMouseMotionListener(this.myListener);
        layeredPane.addMouseWheelListener(this.myListener);
        layeredPane.addMouseListener(this.myListener);
        layeredPane.addKeyListener(this.myListener);
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            this.myDropTarget = new DropTarget(this.mySurface.getInteractionPane(), 3, this.myListener, true, null);
        }
        this.myHoverTimer.addActionListener(this.myListener);
        this.myIsListening = true;
    }

    public void stopListening() {
        if (!this.myIsListening) {
            return;
        }
        JComponent layeredPane = this.mySurface.getInteractionPane();
        layeredPane.removeMouseMotionListener(this.myListener);
        layeredPane.removeMouseWheelListener(this.myListener);
        layeredPane.removeMouseListener(this.myListener);
        layeredPane.removeKeyListener(this.myListener);
        if (this.myDropTarget != null) {
            this.myDropTarget.removeDropTargetListener(this.myListener);
        }
        this.myHoverTimer.removeActionListener(this.myListener);
        this.myHoverTimer.stop();
        this.myIsListening = false;
    }

    private void startInteraction(@NotNull InteractionEvent event, @Nullable Interaction interaction) {
        if (this.myCurrentInteraction != null) {
            this.finishInteraction(event, true);
            assert (this.myCurrentInteraction == null);
        }
        if (interaction != null) {
            this.myCurrentInteraction = interaction;
            this.myCurrentInteraction.begin(event);
            this.myLayers = interaction.createOverlays();
        }
    }

    @NotNull
    List<Layer> getLayers() {
        return this.myLayers != null ? this.myLayers : ImmutableList.of();
    }

    @JdkConstants.InputEventMask
    public int getLastModifiersEx() {
        return this.myLastModifiersEx;
    }

    public void setModifier(@JdkConstants.InputEventMask int modifier2) {
        this.myLastModifiersEx = modifier2;
    }

    private void updateMouseMoved(@NotNull MouseEvent event, int x, int y) {
        if (this.myCurrentInteraction != null) {
            this.myCurrentInteraction.update(new MouseMovedEvent(event, this.getInteractionInformation()));
        } else {
            this.myInteractionHandler.hoverWhenNoInteraction(x, y, this.myLastModifiersEx);
        }
    }

    private void finishInteraction(@NotNull InteractionEvent event, boolean canceled) {
        if (this.myCurrentInteraction != null) {
            if (canceled) {
                this.myCurrentInteraction.cancel(event);
            } else {
                this.myCurrentInteraction.commit(event);
            }
            if (this.myLayers != null) {
                for (Layer layer : this.myLayers) {
                    layer.dispose();
                }
                this.myLayers = null;
            }
            this.myCurrentInteraction = null;
            this.myLastModifiersEx = 0;
            this.myInteractionHandler.hoverWhenNoInteraction(this.myLastMouseX, this.myLastMouseY, this.myLastModifiersEx);
            this.updateCursor(this.myLastMouseX, this.myLastMouseY, this.myLastModifiersEx);
            this.mySurface.repaint();
        }
    }

    void updateCursor(int x, int y, @JdkConstants.InputEventMask int modifiersEx) {
        Cursor cursor = this.myCurrentInteraction == null ? this.myInteractionHandler.getCursorWhenNoInteraction(x, y, modifiersEx) : this.myCurrentInteraction.getCursor();
        this.mySurface.setCursor(cursor != Cursor.getDefaultCursor() ? cursor : null);
    }

    public boolean isInteractionInProgress() {
        return this.myCurrentInteraction != null;
    }

    void setPanning(boolean panning) {
        if (panning && !(this.myCurrentInteraction instanceof PanInteraction)) {
            this.startInteraction(new InteractionNonInputEvent(this.getInteractionInformation()), new PanInteraction(this.mySurface));
            this.updateCursor(this.myLastMouseX, this.myLastMouseY, this.myLastModifiersEx);
        } else if (!panning && this.myCurrentInteraction instanceof PanInteraction) {
            this.finishInteraction(new InteractionNonInputEvent(this.getInteractionInformation()), false);
            this.updateCursor(this.myLastMouseX, this.myLastMouseY, this.myLastModifiersEx);
        }
    }

    private void setPanning(@NotNull InteractionEvent event, boolean panning) {
        if (panning && !(this.myCurrentInteraction instanceof PanInteraction)) {
            this.startInteraction(event, new PanInteraction(this.mySurface));
            this.updateCursor(this.myLastMouseX, this.myLastMouseY, this.myLastModifiersEx);
        } else if (!panning && this.myCurrentInteraction instanceof PanInteraction) {
            this.finishInteraction(event, false);
            this.updateCursor(this.myLastMouseX, this.myLastMouseY, this.myLastModifiersEx);
        }
    }

    public boolean interceptPanInteraction(@NotNull MouseEvent event) {
        boolean wheelClickDown = SwingUtilities.isMiddleMouseButton(event);
        if (this.isPanning() || wheelClickDown) {
            boolean leftClickDown = SwingUtilities.isLeftMouseButton(event);
            this.mySurface.setCursor(AdtUiCursorsProvider.getInstance().getCursor(leftClickDown || wheelClickDown ? AdtUiCursorType.GRABBING : AdtUiCursorType.GRAB));
            return true;
        }
        return false;
    }

    public void cancelInteraction() {
        this.finishInteraction(new InteractionNonInputEvent(this.getInteractionInformation()), true);
    }

    @NotNull
    private InteractionInformation getInteractionInformation() {
        return new InteractionInformation(this.myLastMouseX, this.myLastMouseY, this.myLastModifiersEx);
    }

    @VisibleForTesting
    public Object getListener() {
        return this.myListener;
    }

    private class Listener
    implements MouseMotionListener,
    MouseListener,
    KeyListener,
    DropTargetListener,
    ActionListener,
    MouseWheelListener {
        private Listener() {
        }

        @Override
        public void mouseClicked(@NotNull MouseEvent event) {
            int x = event.getX();
            int y = event.getY();
            int clickCount = event.getClickCount();
            if (clickCount == 2 && event.getButton() == 1) {
                InteractionManager.this.myInteractionHandler.doubleClick(x, y, InteractionManager.this.myLastModifiersEx);
                return;
            }
            if (clickCount == 1 && event.getButton() == 1 && !event.isShiftDown() && !AdtUiUtils.isActionKeyDown((InputEvent)event)) {
                InteractionManager.this.myInteractionHandler.singleClick(x, y, InteractionManager.this.myLastModifiersEx);
            }
            if (event.isPopupTrigger()) {
                InteractionManager.this.myInteractionHandler.popupMenuTrigger(event);
            }
        }

        @Override
        public void mousePressed(@NotNull MouseEvent event) {
            if (event.getID() == 501) {
                InteractionManager.this.mySurface.getInteractionPane().requestFocusInWindow();
            }
            InteractionManager.this.myIsInteractionCanceled = false;
            InteractionManager.this.myLastMouseX = event.getX();
            InteractionManager.this.myLastMouseY = event.getY();
            InteractionManager.this.myLastModifiersEx = event.getModifiersEx();
            if (event.isPopupTrigger()) {
                InteractionManager.this.myInteractionHandler.popupMenuTrigger(event);
                event.consume();
                return;
            }
            if (SwingUtilities.isRightMouseButton(event)) {
                return;
            }
            if (InteractionManager.this.myCurrentInteraction instanceof PanInteraction) {
                InteractionManager.this.myCurrentInteraction.update(new MousePressedEvent(event, InteractionManager.this.getInteractionInformation()));
                InteractionManager.this.updateCursor(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY, InteractionManager.this.myLastModifiersEx);
                return;
            }
            if (SwingUtilities.isMiddleMouseButton(event)) {
                InteractionManager.this.startInteraction(new MousePressedEvent(event, InteractionManager.this.getInteractionInformation()), new PanInteraction(InteractionManager.this.mySurface));
                InteractionManager.this.updateCursor(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY, InteractionManager.this.myLastModifiersEx);
                return;
            }
            Interaction interaction = InteractionManager.this.myInteractionHandler.createInteractionOnPressed(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY, InteractionManager.this.myLastModifiersEx);
            if (interaction != null) {
                InteractionManager.this.startInteraction(new MousePressedEvent(event, InteractionManager.this.getInteractionInformation()), interaction);
            }
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent event) {
            if (InteractionManager.this.myIsInteractionCanceled) {
                return;
            }
            if (event.isPopupTrigger()) {
                InteractionManager.this.myInteractionHandler.popupMenuTrigger(event);
                return;
            }
            if (InteractionManager.this.myCurrentInteraction instanceof PanInteraction) {
                if (SwingUtilities.isMiddleMouseButton(event)) {
                    InteractionManager.this.finishInteraction(new MouseReleasedEvent(event, InteractionManager.this.getInteractionInformation()), true);
                } else {
                    InteractionManager.this.myCurrentInteraction.update(new MouseReleasedEvent(event, new InteractionInformation(event.getX(), event.getY(), event.getModifiersEx())));
                    InteractionManager.this.updateCursor(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY, InteractionManager.this.myLastModifiersEx);
                }
                return;
            }
            if (InteractionManager.this.interceptPanInteraction(event)) {
                if (SwingUtilities.isMiddleMouseButton(event)) {
                    InteractionManager.this.setPanning(false);
                }
                return;
            }
            if (event.getButton() > 1 || SystemInfo.isMac && event.isControlDown()) {
                return;
            }
            int x = event.getX();
            int y = event.getY();
            int modifiersEx = event.getModifiersEx();
            if (InteractionManager.this.myCurrentInteraction == null) {
                InteractionManager.this.myInteractionHandler.mouseReleaseWhenNoInteraction(x, y, modifiersEx);
                InteractionManager.this.updateCursor(x, y, modifiersEx);
            } else {
                InteractionManager.this.finishInteraction(new MouseReleasedEvent(event, InteractionManager.this.getInteractionInformation()), false);
                InteractionManager.this.myCurrentInteraction = null;
            }
            InteractionManager.this.mySurface.repaint();
        }

        @Override
        public void mouseEntered(@NotNull MouseEvent event) {
            InteractionManager.this.myHoverTimer.restart();
        }

        @Override
        public void mouseExited(@NotNull MouseEvent event) {
            InteractionManager.this.myHoverTimer.stop();
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            if (InteractionManager.this.myIsInteractionCanceled) {
                return;
            }
            int x = event.getX();
            int y = event.getY();
            if (InteractionManager.this.myCurrentInteraction instanceof PanInteraction) {
                InteractionManager.this.myCurrentInteraction.update(new MouseDraggedEvent(event, new InteractionInformation(x, y, event.getModifiersEx())));
                InteractionManager.this.updateCursor(x, y, event.getModifiersEx());
                return;
            }
            if (!SwingUtilities.isLeftMouseButton(event)) {
                return;
            }
            int modifiersEx = event.getModifiersEx();
            if (InteractionManager.this.myCurrentInteraction != null) {
                InteractionManager.this.myLastMouseX = x;
                InteractionManager.this.myLastMouseY = y;
                InteractionManager.this.myLastModifiersEx = modifiersEx;
                InteractionManager.this.myCurrentInteraction.update(new MouseDraggedEvent(event, InteractionManager.this.getInteractionInformation()));
                InteractionManager.this.updateCursor(x, y, modifiersEx);
                InteractionManager.this.mySurface.getInteractionPane().scrollRectToVisible(new Rectangle(x - 50, y - 50, 100, 100));
                InteractionManager.this.mySurface.repaint();
            } else {
                x = InteractionManager.this.myLastMouseX;
                y = InteractionManager.this.myLastMouseY;
                InteractionManager.this.myLastModifiersEx = modifiersEx;
                Interaction interaction = InteractionManager.this.myInteractionHandler.createInteractionOnDrag(x, y, InteractionManager.this.myLastModifiersEx);
                if (interaction != null) {
                    InteractionManager.this.startInteraction(new MouseDraggedEvent(event, InteractionManager.this.getInteractionInformation()), interaction);
                }
                InteractionManager.this.updateCursor(x, y, modifiersEx);
            }
            InteractionManager.this.myHoverTimer.restart();
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent event) {
            int x = event.getX();
            int y = event.getY();
            int modifiersEx = event.getModifiersEx();
            InteractionManager.this.myLastMouseX = x;
            InteractionManager.this.myLastMouseY = y;
            InteractionManager.this.myLastModifiersEx = modifiersEx;
            if (InteractionManager.this.myCurrentInteraction instanceof PanInteraction) {
                InteractionManager.this.myCurrentInteraction.update(new MouseMovedEvent(event, InteractionManager.this.getInteractionInformation()));
                InteractionManager.this.updateCursor(x, y, modifiersEx);
                return;
            }
            InteractionManager.this.updateMouseMoved(event, x, y);
            InteractionManager.this.updateCursor(x, y, modifiersEx);
            InteractionManager.this.mySurface.repaint();
            InteractionManager.this.myHoverTimer.restart();
        }

        @Override
        public void keyTyped(KeyEvent event) {
            InteractionManager.this.myLastModifiersEx = event.getModifiersEx();
        }

        @Override
        public void keyPressed(KeyEvent event) {
            int modifiersEx = event.getModifiersEx();
            int keyCode = event.getKeyCode();
            InteractionManager.this.myLastModifiersEx = modifiersEx;
            if (InteractionManager.this.myCurrentInteraction != null) {
                if (keyCode == 27) {
                    InteractionManager.this.finishInteraction(new KeyPressedEvent(event, InteractionManager.this.getInteractionInformation()), true);
                    InteractionManager.this.myIsInteractionCanceled = true;
                } else {
                    InteractionManager.this.myCurrentInteraction.update(new KeyPressedEvent(event, InteractionManager.this.getInteractionInformation()));
                }
                return;
            }
            Interaction interaction = InteractionManager.this.myInteractionHandler.keyPressedWithoutInteraction(event);
            if (interaction != null) {
                InteractionManager.this.startInteraction(new KeyPressedEvent(event, InteractionManager.this.getInteractionInformation()), interaction);
            }
        }

        @Override
        public void keyReleased(KeyEvent event) {
            InteractionManager.this.myLastModifiersEx = event.getModifiersEx();
            if (InteractionManager.this.myCurrentInteraction != null) {
                if (InteractionManager.this.myCurrentInteraction instanceof PanInteraction && event.getKeyCode() == DesignSurfaceShortcut.PAN.getKeyCode()) {
                    InteractionManager.this.setPanning(new KeyReleasedEvent(event, InteractionManager.this.getInteractionInformation()), false);
                    InteractionManager.this.updateCursor(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY, InteractionManager.this.myLastModifiersEx);
                } else {
                    InteractionManager.this.myCurrentInteraction.update(new KeyReleasedEvent(event, InteractionManager.this.getInteractionInformation()));
                }
                return;
            }
            InteractionManager.this.myInteractionHandler.keyReleasedWithoutInteraction(event);
        }

        @Override
        public void dragEnter(@NotNull DropTargetDragEvent dragEvent) {
            if (InteractionManager.this.myCurrentInteraction == null) {
                Point location = dragEvent.getLocation();
                InteractionManager.this.myLastMouseX = location.x;
                InteractionManager.this.myLastMouseY = location.y;
                Interaction interaction = InteractionManager.this.myInteractionHandler.createInteractionOnDragEnter(dragEvent);
                InteractionManager.this.startInteraction(new DragEnterEvent(dragEvent, InteractionManager.this.getInteractionInformation()), interaction);
            }
        }

        @Override
        public void dragOver(DropTargetDragEvent dragEvent) {
            Point location = dragEvent.getLocation();
            InteractionManager.this.myLastMouseX = location.x;
            InteractionManager.this.myLastMouseY = location.y;
            NlDropEvent event = new NlDropEvent(dragEvent);
            if (InteractionManager.this.myCurrentInteraction == null) {
                event.reject();
                return;
            }
            InteractionManager.this.myCurrentInteraction.update(new DragOverEvent(dragEvent, InteractionManager.this.getInteractionInformation()));
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent event) {
            if (InteractionManager.this.myCurrentInteraction != null) {
                InteractionManager.this.myCurrentInteraction.update(new DropActionChangedEvent(event, InteractionManager.this.getInteractionInformation()));
            }
        }

        @Override
        public void dragExit(DropTargetEvent event) {
            if (InteractionManager.this.myCurrentInteraction instanceof DragDropInteraction) {
                InteractionManager.this.finishInteraction(new DragExistEvent(event, InteractionManager.this.getInteractionInformation()), true);
            }
        }

        @Override
        public void drop(@NotNull DropTargetDropEvent dropEvent) {
            Point location = dropEvent.getLocation();
            InteractionManager.this.myLastMouseX = location.x;
            InteractionManager.this.myLastMouseY = location.y;
            NlDropEvent event = new NlDropEvent(dropEvent);
            if (!(InteractionManager.this.myCurrentInteraction instanceof DragDropInteraction)) {
                event.reject();
                return;
            }
            InteractionManager.this.finishInteraction(new DropEvent(dropEvent, InteractionManager.this.getInteractionInformation()), false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() != InteractionManager.this.myHoverTimer) {
                return;
            }
            int x = InteractionManager.this.myLastMouseX;
            int y = InteractionManager.this.myLastMouseY;
            for (SceneView sceneView : InteractionManager.this.mySurface.getSceneViews()) {
                sceneView.onHover(x, y);
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            int scrollAmount;
            int x = e.getX();
            int y = e.getY();
            if (e.getScrollType() == 0) {
                scrollAmount = e.getUnitsToScroll();
            } else {
                int n = scrollAmount = e.getWheelRotation() < 0 ? -1 : 1;
            }
            if (!e.isShiftDown() && (SystemInfo.isMac && e.isMetaDown() || e.isControlDown())) {
                if (scrollAmount < 0) {
                    InteractionManager.this.mySurface.zoom(ZoomType.IN, x, y);
                } else if (scrollAmount > 0) {
                    InteractionManager.this.mySurface.zoom(ZoomType.OUT, x, y);
                }
                return;
            }
            if (InteractionManager.this.myCurrentInteraction == null) {
                Interaction scrollInteraction = InteractionManager.this.myInteractionHandler.createInteractionOnMouseWheelMoved(e);
                if (scrollInteraction == null) {
                    e.getComponent().getParent().dispatchEvent(e);
                    return;
                }
                InteractionManager.this.startInteraction(new MouseWheelMovedEvent(e, InteractionManager.this.getInteractionInformation()), scrollInteraction);
                InteractionManager.this.myScrollEndTimer.addActionListener(InteractionManager.this.myScrollEndListener);
            }
            boolean isScrollInteraction = InteractionManager.this.myCurrentInteraction instanceof ScrollInteraction;
            InteractionManager.this.myCurrentInteraction.update(new MouseWheelMovedEvent(e, InteractionManager.this.getInteractionInformation()));
            if (isScrollInteraction) {
                InteractionManager.this.myScrollEndTimer.restart();
            }
        }
    }
}

