/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.surface;

import com.android.tools.idea.common.api.DragType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.model.DnDTransferItem;
import com.android.tools.idea.common.model.ItemTransferable;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.CutProvider;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.PasteProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.ide.CopyPasteManager;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DesignSurfaceActionHandler
implements DeleteProvider,
CutProvider,
CopyProvider,
PasteProvider {
    protected final DesignSurface mySurface;
    private CopyPasteManager myCopyPasteManager;

    public DesignSurfaceActionHandler(@NotNull DesignSurface surface2) {
        this(surface2, CopyPasteManager.getInstance());
    }

    @NotNull
    protected abstract DataFlavor getFlavor();

    protected DesignSurfaceActionHandler(@NotNull DesignSurface surface2, @NotNull CopyPasteManager copyPasteManager) {
        this.mySurface = surface2;
        this.myCopyPasteManager = copyPasteManager;
    }

    public void performCopy(@NotNull DataContext dataContext) {
        if (!this.mySurface.getSelectionModel().isEmpty()) {
            this.myCopyPasteManager.setContents((Transferable)this.mySurface.getSelectionAsTransferable());
        }
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        return this.hasNonEmptySelection();
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        return true;
    }

    public void performCut(@NotNull DataContext dataContext) {
        if (!this.mySurface.getSelectionModel().isEmpty()) {
            ItemTransferable transferable = this.mySurface.getSelectionAsTransferable();
            try {
                DnDTransferItem transferItem = (DnDTransferItem)transferable.getTransferData(this.getFlavor());
                transferItem.setIsCut();
                this.myCopyPasteManager.setContents((Transferable)transferable);
            }
            catch (UnsupportedFlavorException e) {
                this.performCopy(dataContext);
            }
            this.deleteElement(dataContext);
        }
    }

    public boolean isCutEnabled(@NotNull DataContext dataContext) {
        return this.hasNonEmptySelection();
    }

    public boolean isCutVisible(@NotNull DataContext dataContext) {
        return true;
    }

    public void deleteElement(@NotNull DataContext dataContext) {
        NlModel model2 = this.mySurface.getModel();
        if (model2 == null) {
            return;
        }
        SelectionModel selectionModel = this.mySurface.getSelectionModel();
        model2.delete(selectionModel.getSelection());
        selectionModel.clear();
    }

    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        return this.hasNonEmptySelection();
    }

    @Nullable
    @VisibleForTesting
    public abstract NlComponent getPasteTarget();

    @VisibleForTesting
    public abstract boolean canHandleChildren(@NotNull NlComponent var1, @NotNull List<NlComponent> var2);

    public void performPaste(@NotNull DataContext dataContext) {
        this.pasteOperation(false);
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        return this.getPasteTarget() != null && this.getClipboardData() != null;
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        return this.pasteOperation(true);
    }

    private boolean hasNonEmptySelection() {
        return !this.mySurface.getSelectionModel().isEmpty();
    }

    private boolean pasteOperation(boolean checkOnly) {
        NlComponent receiver = this.getPasteTarget();
        if (receiver == null) {
            return false;
        }
        NlModel model2 = receiver.getModel();
        DnDTransferItem transferItem = this.getClipboardData();
        if (transferItem == null) {
            return false;
        }
        DragType dragType = transferItem.isCut() ? DragType.MOVE : DragType.PASTE;
        InsertType insertType = model2.determineInsertType(dragType, transferItem, checkOnly);
        List<NlComponent> pasted = model2.createComponents(transferItem, insertType, this.mySurface);
        NlComponent before = null;
        if (this.canHandleChildren(receiver, pasted)) {
            before = receiver.getChild(0);
        } else {
            while (!this.canHandleChildren(receiver, pasted)) {
                before = receiver.getNextSibling();
                if ((receiver = receiver.getParent()) != null) continue;
                return false;
            }
        }
        if (!model2.canAddComponents(pasted, receiver, before, checkOnly)) {
            return false;
        }
        if (checkOnly) {
            return true;
        }
        transferItem.consumeCut();
        model2.addComponents(pasted, receiver, before, insertType, this.mySurface);
        if (insertType == InsertType.PASTE) {
            this.mySurface.getSelectionModel().setSelection(pasted);
        }
        return true;
    }

    @Nullable
    private DnDTransferItem getClipboardData() {
        CopyPasteManager instance = CopyPasteManager.getInstance();
        Transferable contents = instance.getContents();
        if (contents == null) {
            return null;
        }
        try {
            return (DnDTransferItem)contents.getTransferData(this.getFlavor());
        }
        catch (UnsupportedFlavorException | IOException e) {
            return null;
        }
    }
}

