/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene.draw;

import com.android.tools.idea.common.scene.draw.ColorSet;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\u001a^\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0018\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0006\u001a\n \u0007*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"SIZE_FONT", "", "SIZE_TIP_BACKGROUND_ARC", "SIZE_TIP_MARGIN", "SIZE_TIP_TEXT_BACKGROUND", "Ljava/awt/Color;", "SIZE_TIP_TEXT_COLOR", "kotlin.jvm.PlatformType", "SIZE_TIP_TO_MOUSE_DISTANCE", "drawLasso", "", "g", "Ljava/awt/Graphics2D;", "colorSet", "Lcom/android/tools/idea/common/scene/draw/ColorSet;", "x", "y", "width", "height", "mouseX", "mouseY", "dpWidth", "dpHeight", "showSize", "", "intellij.android.designer"})
@JvmName(name="DrawLassoUtil")
public final class DrawLassoUtil {
    private static final int SIZE_TIP_TO_MOUSE_DISTANCE = 5;
    private static final int SIZE_TIP_MARGIN = 6;
    private static final int SIZE_TIP_BACKGROUND_ARC = 5;
    private static final int SIZE_FONT = 12;
    private static final Color SIZE_TIP_TEXT_COLOR = Color.WHITE;
    private static final Color SIZE_TIP_TEXT_BACKGROUND = new Color(128, 128, 128, 176);

    public static final void drawLasso(@NotNull Graphics2D g, @NotNull ColorSet colorSet, int x, int y, int width, int height, int mouseX, int mouseY, int dpWidth, int dpHeight, boolean showSize) {
        Color originalColor = g.getColor();
        g.setColor(colorSet.getLassoSelectionBorder());
        g.drawRect(x, y, width, height);
        g.setColor(colorSet.getLassoSelectionFill());
        g.fillRect(x, y, width, height);
        if (showSize) {
            Font originalFont = g.getFont();
            g.setFont(new Font(originalFont.getName(), 0, (int)10.799999f));
            String sizeText = dpWidth + " x " + dpHeight;
            FontMetrics fm = g.getFontMetrics();
            Rectangle2D rect = fm.getStringBounds(sizeText, g);
            int sizeTipX = mouseX + 5;
            int sizeTipY = mouseY + 5;
            g.setColor(SIZE_TIP_TEXT_BACKGROUND);
            g.fillRoundRect(sizeTipX, sizeTipY, (int)rect.getWidth() + 12, (int)rect.getHeight() + 12, 5, 5);
            g.setColor(SIZE_TIP_TEXT_COLOR);
            g.drawString(sizeText, sizeTipX + 6, sizeTipY + fm.getAscent() + 6);
            g.setFont(originalFont);
        }
        g.setColor(originalColor);
    }
}

