/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene;

import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.DefaultHitProvider;
import com.android.tools.idea.common.scene.DefaultSceneManagerHierarchyProvider;
import com.android.tools.idea.common.scene.HitProvider;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.TemporarySceneComponent;
import com.android.tools.idea.common.scene.decorator.SceneDecoratorFactory;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.SceneView;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SceneManager
implements Disposable {
    public static final boolean SUPPORTS_LOCKING = false;
    @NotNull
    private final NlModel myModel;
    @NotNull
    private final DesignSurface myDesignSurface;
    @NotNull
    private final Scene myScene;
    @Nullable
    private SceneView mySceneView;
    @NotNull
    private final HitProvider myHitProvider = new DefaultHitProvider();
    @NotNull
    private final SceneComponentHierarchyProvider mySceneComponentProvider;
    @NotNull
    private final SceneUpdateListener mySceneUpdateListener;

    public SceneManager(@NotNull NlModel model2, @NotNull DesignSurface surface2, boolean useLiveRendering, @Nullable SceneComponentHierarchyProvider sceneComponentProvider, @Nullable SceneUpdateListener sceneUpdateListener) {
        this.myModel = model2;
        this.myDesignSurface = surface2;
        Disposer.register((Disposable)model2, (Disposable)this);
        this.mySceneComponentProvider = sceneComponentProvider == null ? new DefaultSceneManagerHierarchyProvider() : sceneComponentProvider;
        this.mySceneUpdateListener = sceneUpdateListener == null ? new DefaultSceneUpdateListener() : sceneUpdateListener;
        this.myScene = new Scene(this, this.myDesignSurface, useLiveRendering);
    }

    protected void createSceneView() {
        if (this.mySceneView != null) {
            this.mySceneView.dispose();
        }
        this.mySceneView = this.doCreateSceneView();
    }

    @NotNull
    protected abstract SceneView doCreateSceneView();

    public final void updateSceneView() {
        for (SceneView sceneView : this.getSceneViews()) {
            this.myDesignSurface.removeSceneView(sceneView);
        }
        this.createSceneView();
        for (SceneView sceneView : this.getSceneViews()) {
            this.myDesignSurface.addSceneView(sceneView);
        }
    }

    @Deprecated
    @NotNull
    public SceneView getSceneView() {
        assert (this.mySceneView != null) : "createSceneView was not called";
        return this.mySceneView;
    }

    @NotNull
    public List<SceneView> getSceneViews() {
        return ImmutableList.of((Object)this.getSceneView());
    }

    public abstract float getSceneScalingFactor();

    public void dispose() {
        for (SceneView sceneView : this.getSceneViews()) {
            this.myDesignSurface.removeSceneView(sceneView);
            sceneView.dispose();
        }
    }

    public void update() {
        ImmutableList<NlComponent> components = this.getModel().getComponents();
        Scene scene = this.getScene();
        if (components.isEmpty()) {
            scene.removeAllComponents();
            scene.setRoot(null);
            return;
        }
        HashSet<SceneComponent> usedComponents = new HashSet<SceneComponent>();
        HashSet<SceneComponent> oldComponents = new HashSet<SceneComponent>(scene.getSceneComponents());
        NlComponent rootComponent2 = this.getRoot();
        if (this.myScene.getRoot() != null && rootComponent2 != this.myScene.getRoot().getNlComponent()) {
            scene.removeAllComponents();
            scene.setRoot(null);
        }
        this.mySceneUpdateListener.onUpdate(rootComponent2, this.myDesignSurface);
        List<SceneComponent> hierarchy = this.mySceneComponentProvider.createHierarchy(this, rootComponent2);
        SceneComponent root2 = hierarchy.isEmpty() ? null : hierarchy.get(0);
        scene.setRoot(root2);
        if (root2 != null) {
            this.updateFromComponent(root2, usedComponents);
        }
        oldComponents.removeAll(usedComponents);
        oldComponents.removeIf(component -> component instanceof TemporarySceneComponent);
        oldComponents.forEach(scene::removeComponent);
        scene.needsRebuildList();
    }

    @NotNull
    protected NlComponent getRoot() {
        return ((NlComponent)this.getModel().getComponents().get(0)).getRoot();
    }

    public static boolean isComponentLocked(@NotNull NlComponent component) {
        return false;
    }

    protected final void updateFromComponent(@NotNull SceneComponent component, @NotNull Set<SceneComponent> seenComponents) {
        seenComponents.add(component);
        this.syncFromNlComponent(component);
        for (SceneComponent child : component.getChildren()) {
            this.updateFromComponent(child, seenComponents);
        }
    }

    @NotNull
    public abstract TemporarySceneComponent createTemporaryComponent(@NotNull NlComponent var1);

    protected final void syncFromNlComponent(SceneComponent sceneComponent) {
        this.mySceneComponentProvider.syncFromNlComponent(sceneComponent);
    }

    @NotNull
    protected DesignSurface getDesignSurface() {
        return this.myDesignSurface;
    }

    @NotNull
    public NlModel getModel() {
        return this.myModel;
    }

    @NotNull
    public Scene getScene() {
        return this.myScene;
    }

    @NotNull
    public abstract CompletableFuture<Void> requestRender();

    @NotNull
    public CompletableFuture<Void> requestLayoutAndRender(boolean animate) {
        return CompletableFuture.completedFuture(null);
    }

    @NotNull
    public abstract CompletableFuture<Void> requestLayout(boolean var1);

    public abstract void layout(boolean var1);

    @NotNull
    public abstract SceneDecoratorFactory getSceneDecoratorFactory();

    public abstract Map<Object, Map<ResourceReference, ResourceValue>> getDefaultProperties();

    public abstract Map<Object, ResourceReference> getDefaultStyles();

    @NotNull
    protected HitProvider getHitProvider(@NotNull NlComponent component) {
        return this.myHitProvider;
    }

    public boolean activate(@NotNull Object source) {
        return this.getModel().activate(source);
    }

    public boolean deactivate(@NotNull Object source) {
        return this.getModel().deactivate(source);
    }

    public static class DefaultSceneUpdateListener
    implements SceneUpdateListener {
        @Override
        public void onUpdate(@NotNull NlComponent component, @NotNull DesignSurface designSurface) {
        }
    }

    public static interface SceneUpdateListener {
        public void onUpdate(@NotNull NlComponent var1, @NotNull DesignSurface var2);
    }

    public static interface SceneComponentHierarchyProvider {
        @NotNull
        public List<SceneComponent> createHierarchy(@NotNull SceneManager var1, @NotNull NlComponent var2);

        public void syncFromNlComponent(@NotNull SceneComponent var1);
    }
}

