/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.assistant;

import com.android.tools.idea.common.assistant.AssistantPanelMetricsTracker;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.DesignEditorHelpPanelEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u00012\u00020\u0002:\u0001\u001bB\u000f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\b\u0010\u0016\u001a\u00020\u0014H\u0016J\u0018\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u0004\u0018\u00010\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u000fj\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/idea/common/assistant/HelpPanelToolWindowListener;", "Lcom/intellij/openapi/wm/ex/ToolWindowManagerListener;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "currActionId", "", "currMetric", "Lcom/android/tools/idea/common/assistant/AssistantPanelMetricsTracker;", "getCurrMetric", "()Lcom/android/tools/idea/common/assistant/AssistantPanelMetricsTracker;", "isOpen", "", "metrics", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "type", "Lcom/google/wireless/android/sdk/stats/DesignEditorHelpPanelEvent$HelpPanelType;", "closeAndRemove", "", "dispose", "stateChanged", "toolWindowUnregistered", "id", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "Companion", "intellij.android.designer"})
public final class HelpPanelToolWindowListener
implements ToolWindowManagerListener,
Disposable {
    private boolean isOpen;
    private DesignEditorHelpPanelEvent.HelpPanelType type;
    private String currActionId;
    private final HashMap<String, AssistantPanelMetricsTracker> metrics;
    private Project project;
    @NotNull
    private static final HashMap<String, DesignEditorHelpPanelEvent.HelpPanelType> map;
    @NotNull
    private static final HashMap<Project, HelpPanelToolWindowListener> projectToListener;
    public static final Companion Companion;

    private final AssistantPanelMetricsTracker getCurrMetric() {
        return this.metrics.get(this.currActionId);
    }

    public void dispose() {
        this.closeAndRemove();
    }

    public void toolWindowUnregistered(@NotNull String id, @NotNull ToolWindow toolWindow) {
        this.closeAndRemove();
    }

    private final void closeAndRemove() {
        if (this.isOpen) {
            AssistantPanelMetricsTracker assistantPanelMetricsTracker = this.getCurrMetric();
            if (assistantPanelMetricsTracker != null) {
                assistantPanelMetricsTracker.logClose();
            }
            this.isOpen = false;
        }
        projectToListener.remove(this.project);
    }

    public void stateChanged() {
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(this.project).getToolWindow("Assistant");
        if (toolWindow == null) {
            return;
        }
        ToolWindow window2 = toolWindow;
        String string = window2.getHelpId();
        if (string == null) {
            string = "";
        }
        this.currActionId = string;
        DesignEditorHelpPanelEvent.HelpPanelType helpPanelType = map.get(this.currActionId);
        if (helpPanelType == null) {
            return;
        }
        this.type = helpPanelType;
        if (this.type == DesignEditorHelpPanelEvent.HelpPanelType.UNKNOWN_PANEL_TYPE) {
            return;
        }
        this.metrics.putIfAbsent(this.currActionId, new AssistantPanelMetricsTracker(this.type));
        if (this.isOpen && !window2.isVisible()) {
            this.isOpen = false;
            AssistantPanelMetricsTracker assistantPanelMetricsTracker = this.getCurrMetric();
            if (assistantPanelMetricsTracker == null) {
                Intrinsics.throwNpe();
            }
            assistantPanelMetricsTracker.logClose();
            this.metrics.remove(this.currActionId);
        } else if (!this.isOpen && window2.isVisible()) {
            this.isOpen = true;
            AssistantPanelMetricsTracker assistantPanelMetricsTracker = this.getCurrMetric();
            if (assistantPanelMetricsTracker == null) {
                Intrinsics.throwNpe();
            }
            assistantPanelMetricsTracker.logOpen();
        }
    }

    private HelpPanelToolWindowListener(Project project) {
        this.project = project;
        this.type = DesignEditorHelpPanelEvent.HelpPanelType.UNKNOWN_PANEL_TYPE;
        this.currActionId = "";
        this.metrics = new HashMap();
        this.project.getMessageBus().connect((Disposable)this.project).subscribe(ToolWindowManagerListener.TOPIC, (Object)this);
        Disposer.register((Disposable)((Disposable)this.project), (Disposable)this);
    }

    static {
        Companion = new Companion(null);
        map = new HashMap();
        projectToListener = new HashMap();
    }

    public /* synthetic */ HelpPanelToolWindowListener(Project project, DefaultConstructorMarker $constructor_marker) {
        this(project);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000bR-\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR8\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u0004j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f`\u00078\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u0002\u001a\u0004\b\u000e\u0010\t\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/common/assistant/HelpPanelToolWindowListener$Companion;", "", "()V", "map", "Ljava/util/HashMap;", "", "Lcom/google/wireless/android/sdk/stats/DesignEditorHelpPanelEvent$HelpPanelType;", "Lkotlin/collections/HashMap;", "getMap", "()Ljava/util/HashMap;", "projectToListener", "Lcom/intellij/openapi/project/Project;", "Lcom/android/tools/idea/common/assistant/HelpPanelToolWindowListener;", "getProjectToListener$annotations", "getProjectToListener", "registerListener", "", "project", "intellij.android.designer"})
    public static final class Companion {
        @NotNull
        public final HashMap<String, DesignEditorHelpPanelEvent.HelpPanelType> getMap() {
            return map;
        }

        @VisibleForTesting
        public static /* synthetic */ void getProjectToListener$annotations() {
        }

        @NotNull
        public final HashMap<Project, HelpPanelToolWindowListener> getProjectToListener() {
            return projectToListener;
        }

        public final void registerListener(@NotNull Project project) {
            if (!this.getProjectToListener().containsKey(project)) {
                ((Map)this.getProjectToListener()).put(project, new HelpPanelToolWindowListener(project, null));
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

