/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.tools.adtui.util.FormScalingUtil;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.idea.avdmanager.AvdOptionsModel;
import com.android.tools.idea.avdmanager.ChooseSystemImagePanel;
import com.android.tools.idea.avdmanager.SystemImageDescription;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.ui.wizard.deprecated.StudioWizardStepPanel;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Consumer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Optional;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseSystemImageStep
extends ModelWizardStep<AvdOptionsModel> {
    @Nullable
    private final Project myProject;
    private JPanel myPanel;
    private ChooseSystemImagePanel myChooseImagePanel;
    private StudioWizardStepPanel myStudioWizardStepPanel;
    private ValidatorPanel myValidatorPanel;

    public ChooseSystemImageStep(@NotNull AvdOptionsModel model2, @Nullable Project project) {
        super(model2, "System Image");
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myValidatorPanel = new ValidatorPanel((Disposable)this, (JComponent)this.myPanel);
        this.myStudioWizardStepPanel = new StudioWizardStepPanel((JPanel)this.myValidatorPanel, "Select a system image");
        FormScalingUtil.scaleComponentTree(this.getClass(), (JComponent)this.myStudioWizardStepPanel);
        this.myChooseImagePanel.addSystemImageListener(new Consumer<SystemImageDescription>(){

            public void consume(SystemImageDescription systemImage) {
                ((AvdOptionsModel)ChooseSystemImageStep.this.getModel()).systemImage().setNullableValue(systemImage);
            }
        });
    }

    @Override
    protected void onWizardStarting(@NotNull ModelWizard.Facade wizard) {
        this.myValidatorPanel.registerValidator(((AvdOptionsModel)this.getModel()).systemImage(), (Validator)new Validator<Optional<SystemImageDescription>>(){

            @NotNull
            public Validator.Result validate(@NotNull Optional<SystemImageDescription> value2) {
                return value2.isPresent() ? Validator.Result.OK : new Validator.Result(Validator.Severity.ERROR, "A system image must be selected to continue.");
            }
        }, new ObservableValue[0]);
    }

    @Override
    protected void onEntering() {
        this.myChooseImagePanel.setDevice(((AvdOptionsModel)this.getModel()).device().getValueOrNull());
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        return this.myValidatorPanel.hasErrors().not();
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        return this.myStudioWizardStepPanel;
    }

    private void createUIComponents() {
        this.myChooseImagePanel = new ChooseSystemImagePanel(this.myProject, ((AvdOptionsModel)this.getModel()).device().getValueOrNull(), ((AvdOptionsModel)this.getModel()).systemImage().getValueOrNull());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ChooseSystemImagePanel chooseSystemImagePanel = this.myChooseImagePanel;
        JComponent jComponent = chooseSystemImagePanel.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

