/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.internal.avd.AvdInfo;
import com.google.common.collect.Maps;
import com.intellij.openapi.project.Project;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AvdUiAction
implements Action,
HyperlinkListener {
    @NotNull
    protected final AvdInfoProvider myAvdInfoProvider;
    @NotNull
    private final String myText;
    @NotNull
    private final String myDescription;
    @NotNull
    private final Icon myIcon;
    private Map<String, Object> myData = Maps.newHashMap();

    public AvdUiAction(@NotNull AvdInfoProvider avdInfoProvider, @NotNull String text2, @NotNull String description2, @NotNull Icon icon2) {
        this.myAvdInfoProvider = avdInfoProvider;
        this.myText = text2;
        this.myIcon = icon2;
        this.myDescription = description2;
        this.putValue("SwingLargeIconKey", icon2);
        this.putValue("Name", text2);
    }

    @Override
    public Object getValue(String key) {
        return this.myData.get(key);
    }

    @Override
    public void putValue(String key, Object value2) {
        this.myData.put(key, value2);
    }

    @Override
    public void setEnabled(boolean enabled) {
    }

    @Override
    public abstract boolean isEnabled();

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener2) {
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener2) {
    }

    @NotNull
    public String getDescription() {
        return this.myDescription;
    }

    @NotNull
    public String getText() {
        return this.myText;
    }

    @NotNull
    public Icon getIcon() {
        return this.myIcon;
    }

    @Nullable
    protected AvdInfo getAvdInfo() {
        return this.myAvdInfoProvider.getAvdInfo();
    }

    @Nullable
    protected Project getProject() {
        return this.myAvdInfoProvider.getProject();
    }

    protected void refreshAvds() {
        this.myAvdInfoProvider.refreshAvds();
    }

    protected void refreshAvdsAndSelect(@Nullable AvdInfo avdToSelect) {
        this.myAvdInfoProvider.refreshAvdsAndSelect(avdToSelect);
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (this.isEnabled()) {
            this.actionPerformed(null);
        }
    }

    public static interface AvdInfoProvider {
        @Nullable
        public AvdInfo getAvdInfo();

        public void refreshAvds();

        public void refreshAvdsAndSelect(@Nullable AvdInfo var1);

        @Nullable
        public Project getProject();

        @NotNull
        public JComponent getAvdProviderComponent();
    }
}

