/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.adb;

import com.android.ddmlib.AdbInitOptions;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.ddmlib.TimeoutRemainder;
import com.android.tools.idea.adb.AdbLogOutput;
import com.android.tools.idea.adb.AdbOptionsService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.Files;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import java.io.File;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdbService
implements Disposable,
AdbOptionsService.AdbOptionsListener {
    private static final Logger LOG = Logger.getInstance(AdbService.class);
    public static final int ADB_DEFAULT_TIMEOUT_MILLIS = (int)TimeUnit.MINUTES.toMillis(50L);
    private static final long ADB_TERMINATE_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(10L);
    @Nullable
    private ListenableFuture<AndroidDebugBridge> myFuture;
    private final AtomicReference<File> myAdb = new AtomicReference();
    private static final Object ADB_INIT_LOCK = new Object();

    public static AdbService getInstance() {
        return (AdbService)ServiceManager.getService(AdbService.class);
    }

    private AdbService() {
        String defaultLogLevel = AdbLogOutput.SystemLogRedirecter.getLogger().isTraceEnabled() ? Log.LogLevel.VERBOSE.getStringValue() : (AdbLogOutput.SystemLogRedirecter.getLogger().isDebugEnabled() ? Log.LogLevel.DEBUG.getStringValue() : Log.LogLevel.INFO.getStringValue());
        DdmPreferences.setLogLevel((String)defaultLogLevel);
        DdmPreferences.setTimeOut((int)ADB_DEFAULT_TIMEOUT_MILLIS);
        Log.addLogger((Log.ILogOutput)new AdbLogOutput.SystemLogRedirecter());
        final Application application = ApplicationManager.getApplication();
        AdbOptionsService.getInstance().addListener(this);
        application.getMessageBus().connect().subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectClosed(@NotNull Project project) {
                if (ProjectManager.getInstance().getOpenProjects().length == 0) {
                    LOG.info("Ddmlib can be terminated as all projects have been closed");
                    application.executeOnPooledThread(() -> {
                        try {
                            AdbService.this.terminateDdmlib();
                        }
                        catch (TimeoutException e) {
                            LOG.warn("Failed to terminate ADB", (Throwable)e);
                        }
                    });
                }
            }
        });
    }

    public void dispose() {
        try {
            this.terminateDdmlib();
        }
        catch (TimeoutException e) {
            LOG.warn("Failed to terminate ADB within specified timeout", (Throwable)e);
        }
        AdbOptionsService.getInstance().removeListener(this);
    }

    public synchronized ListenableFuture<AndroidDebugBridge> getDebugBridge(@NotNull File adb) {
        boolean terminateDdmlibFirst;
        this.myAdb.set(adb);
        if (this.myFuture != null && this.myFuture.isDone() && !AdbService.wasSuccessful(this.myFuture)) {
            LOG.info("Cancelling current future since it finished with a failure", AdbService.getFutureException(this.myFuture));
            this.cancelCurrentFuture();
            terminateDdmlibFirst = true;
        } else {
            terminateDdmlibFirst = false;
        }
        if (this.myFuture == null) {
            Future future2 = ApplicationManager.getApplication().executeOnPooledThread((Callable)new CreateBridgeTask(adb, () -> {
                if (terminateDdmlibFirst) {
                    try {
                        AdbService.shutdownAndroidDebugBridge(ADB_TERMINATE_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
                    }
                    catch (TimeoutException e) {
                        throw new RuntimeException(e);
                    }
                }
            }, 20000L, TimeUnit.MILLISECONDS));
            this.myFuture = AdbService.makeListenableFuture(future2);
        }
        return this.myFuture;
    }

    @Nullable
    private static <V> Throwable getFutureException(ListenableFuture<V> future2) {
        if (!future2.isDone()) {
            return null;
        }
        try {
            future2.get();
            return null;
        }
        catch (Exception e) {
            return e;
        }
    }

    public synchronized void terminateDdmlib() throws TimeoutException {
        this.cancelCurrentFuture();
        AdbService.shutdownAndroidDebugBridge(ADB_TERMINATE_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void shutdownAndroidDebugBridge(long timeout, @NotNull TimeUnit unit) throws TimeoutException {
        LOG.info("Terminating ADB connection");
        Object object = ADB_INIT_LOCK;
        synchronized (object) {
            if (!AndroidDebugBridge.disconnectBridge((long)timeout, (TimeUnit)unit)) {
                LOG.warn("ADB connection did not terminate within specified timeout");
                throw new TimeoutException("ADB did not terminate within the specified timeout");
            }
            AndroidDebugBridge.terminate();
            LOG.info("ADB connection successfully terminated");
        }
    }

    @VisibleForTesting
    synchronized void cancelFutureForTesting() {
        assert (this.myFuture != null);
        this.myFuture.cancel(true);
    }

    private synchronized void cancelCurrentFuture() {
        if (this.myFuture != null) {
            this.myFuture.cancel(true);
            this.myFuture = null;
        }
    }

    public static boolean isDdmsCorrupted(@NotNull AndroidDebugBridge bridge) {
        IDevice[] devices2 = bridge.getDevices();
        if (devices2.length > 0) {
            for (IDevice device : devices2) {
                Client[] clients = device.getClients();
                if (clients.length <= 0) continue;
                ClientData clientData = clients[0].getClientData();
                return clientData.getVmIdentifier() == null;
            }
        }
        return false;
    }

    private static boolean wasSuccessful(Future<AndroidDebugBridge> future2) {
        if (!future2.isDone()) {
            return false;
        }
        try {
            AndroidDebugBridge bridge = future2.get();
            return bridge != null && bridge.isConnected();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void optionsChanged() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            File adb = this.myAdb.get();
            if (adb != null) {
                try {
                    LOG.info("Terminating adb server");
                    this.terminateDdmlib();
                    LOG.info("Restart adb server");
                    this.getDebugBridge(adb).get();
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    LOG.warn("Error restarting ADB", (Throwable)e);
                }
            }
        });
    }

    @NotNull
    private static ListenableFuture<AndroidDebugBridge> makeListenableFuture(@NotNull Future<BridgeConnectionResult> delegate2) {
        SettableFuture future2 = SettableFuture.create();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                BridgeConnectionResult value2 = (BridgeConnectionResult)delegate2.get();
                if (value2.error != null) {
                    future2.setException((Throwable)new RuntimeException("Unable to create Debug Bridge: " + value2.error));
                } else {
                    future2.set((Object)value2.bridge);
                }
            }
            catch (ExecutionException e) {
                future2.setException(e.getCause());
            }
            catch (InterruptedException e) {
                delegate2.cancel(true);
                future2.setException((Throwable)e);
            }
        });
        return future2;
    }

    @NotNull
    public static String getDebugBridgeDiagnosticErrorMessage(@NotNull Throwable t, @NotNull File adb) {
        String msg = t.getMessage() != null ? t.getMessage() : String.format("Unable to establish a connection to adb.\n\nCheck the Event Log for possible issues.\nThis can happen if you have an incompatible version of adb running already,\nor if localhost is pointing to the wrong address.\nTry re-opening %1$s after killing any existing adb daemons and verifying that your\nlocalhost entry is pointing to 127.0.0.1 or ::1 for IPv4 or IPv6, respectively.\n\nIf this happens repeatedly, please file a bug at http://b.android.com including the following:\n  1. Output of the command: '%2$s devices'\n  2. Your idea.log file (Help | Show Log in Explorer)\n", ApplicationNamesInfo.getInstance().getProductName(), adb.getAbsolutePath());
        return msg;
    }

    private static class BridgeConnectionResult {
        @Nullable
        public final AndroidDebugBridge bridge;
        @Nullable
        public final String error;

        private BridgeConnectionResult(@Nullable AndroidDebugBridge bridge, @Nullable String error) {
            this.bridge = bridge;
            this.error = error;
        }

        @NotNull
        public static BridgeConnectionResult make(@NotNull AndroidDebugBridge bridge) {
            return new BridgeConnectionResult(bridge, null);
        }

        @NotNull
        public static BridgeConnectionResult make(@NotNull String error) {
            return new BridgeConnectionResult(null, error);
        }
    }

    private static class CreateBridgeTask
    implements Callable<BridgeConnectionResult> {
        private final File myAdb;
        private final Runnable myPreCreateAction;
        private final long myTimeout;
        private final TimeUnit myUnit;

        private CreateBridgeTask(@NotNull File adb, Runnable preCreateAction, long timeout, TimeUnit unit) {
            this.myAdb = adb;
            this.myPreCreateAction = preCreateAction;
            this.myTimeout = timeout;
            this.myUnit = unit;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BridgeConnectionResult call() {
            TimeoutRemainder rem = new TimeoutRemainder(this.myTimeout, this.myUnit);
            LOG.info("Initializing adb using: " + this.myAdb.getAbsolutePath());
            try {
                this.myPreCreateAction.run();
            }
            catch (Exception e) {
                return BridgeConnectionResult.make("Unable to prepare for adb server creation: " + e.getMessage());
            }
            AdbLogOutput.ToStringLogger toStringLogger = new AdbLogOutput.ToStringLogger();
            Log.addLogger((Log.ILogOutput)toStringLogger);
            try {
                AndroidDebugBridge bridge;
                AdbInitOptions.Builder options2 = AdbInitOptions.builder();
                options2.setClientSupportEnabled(true);
                options2.withEnv("ADB_LIBUSB", AdbOptionsService.getInstance().shouldUseLibusb() ? "1" : "0");
                if (ApplicationManager.getApplication() == null || ApplicationManager.getApplication().isUnitTestMode()) {
                    options2.withEnv("HOME", Files.createTempDir().getAbsolutePath());
                }
                if (AdbOptionsService.getInstance().shouldUseUserManagedAdb()) {
                    options2.enableUserManagedAdbMode(AdbOptionsService.getInstance().getUserManagedAdbPort());
                }
                Object object = ADB_INIT_LOCK;
                synchronized (object) {
                    AndroidDebugBridge.init((AdbInitOptions)options2.build());
                    bridge = AndroidDebugBridge.createBridge((String)this.myAdb.getPath(), (boolean)false, (long)rem.getRemainingUnits(), (TimeUnit)this.myUnit);
                }
                if (bridge == null) {
                    object = BridgeConnectionResult.make("Unable to start adb server: " + toStringLogger.getOutput());
                    return object;
                }
                while (!bridge.isConnected()) {
                    if (rem.getRemainingUnits() <= 0L) {
                        object = BridgeConnectionResult.make("Timed out attempting to connect to adb: " + toStringLogger.getOutput());
                        return object;
                    }
                    try {
                        TimeUnit.MILLISECONDS.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        BridgeConnectionResult bridgeConnectionResult = BridgeConnectionResult.make("Timed out attempting to connect to adb: " + toStringLogger.getOutput());
                        Log.removeLogger((Log.ILogOutput)toStringLogger);
                        return bridgeConnectionResult;
                    }
                }
                LOG.info("Successfully connected to adb");
                object = BridgeConnectionResult.make(bridge);
                return object;
            }
            finally {
                Log.removeLogger((Log.ILogOutput)toStringLogger);
            }
        }
    }
}

